/*============================================================================*
 *  FILE: 
 *     symbols.h
 *
 *  Description: 
 *     symbol definitions for NNsh.
 *
 *===========================================================================*/

//////////////////////////////////////////////////////////////////////////////
/***  DATABASE VERSIONS  ***/
#define SOFT_CREATOR_ID       'NNsj'
#define DATA_CREATOR_ID       'NNsi'
#define SOFT_DBTYPE_ID        'Data'

#define SOFT_PREFID           100
#define SOFT_PREFVERSION      100

#define NNSH_PREFERID         100
#define NNSH_PREFERTYPE       100

#define DBNAME_MACROSCRIPT     "Macro-NNsi"
#define DBVERSION_MACROSCRIPT  100

//////////////////////////////////////////////////////////////////////////////

#define DBNAME_SETTING        "NNsj-Setting"
#define DBVERSION_SETTING     100
#define DBSIZE_SETTING        32

//////////////////////////////////////////////////////////////////////////////

/** buffer size(small) **/
#define MINIBUF                     48
#define BUFSIZE                    128
#define BIGBUF                     640
#define PREVBUF                     12
#define MAX_URL                     80

#define NNSH_BUSYWIN_MAXLEN        32

/** ꎞmۗ̈̕(5120 < x < 61000) **/
#define NNSH_WORKBUF_MIN          5120
#define NNSH_WORKBUF_MAX         61000
#define NNSH_WORKBUF_DEFAULT     32750
#define MARGIN                       4
#define FREE_SPACE_MARGIN         2048

/** Ԓl **/
#define NNSH_NOT_EFFECTIVE           0
#define NNSH_UPDATE_DISPLAY          1
#define NNSH_SILK_CONTROL            1

#define NNSH_DISABLE                 0
#define NNSH_ENABLE                  1


/** foCX **/
#define NNSH_DEVICE_NORMAL          0
#define NNSH_DEVICE_HANDERA         1

/** VFS SETTINGS **/
#define NNSH_NOTSUPPORT_VFS         0xf000
#define NNSH_VFS_DISABLE            0x0000
#define NNSH_VFS_ENABLE             0x0001
#define NNSH_VFS_WORKAROUND         0x0002

// COPY type
#define NNSH_COPY_PALM_TO_VFS       0
#define NNSH_COPY_VFS_TO_VFS        1
#define NNSH_COPY_VFS_TO_PALM       2
#define NNSH_COPY_PALM_TO_PALM      4

#define NNSH_FILEMODE_CREATE        1
#define NNSH_FILEMODE_READWRITE     2
#define NNSH_FILEMODE_READONLY      4
#define NNSH_FILEMODE_TEMPFILE      8
#define NNSH_FILEMODE_APPEND        16

#define FILEMGR_STATE_DISABLED      0
#define FILEMGR_STATE_OPENED_VFS    1
#define FILEMGR_STATE_OPENED_STREAM 2


/** VFSt@C̍őTCY  **/
#define MAXLENGTH_FILENAME          256

// for FILE NAMEs
#define FILE_RECVMSG                "recv.txt"
#define FILE_SENDMSG                "send.txt"
#define DATAFILE_PREFIX             "/PALM/Programs/NNsh/"
#define DATAFILE_SUFFIX             ".dat"

/** default font ID **/
#define NNSH_DEFAULT_FONT           stdFont

/** f[^x[X̃L[^Cv() **/
#define NNSH_KEYTYPE_CHAR           0
#define NNSH_KEYTYPE_UINT32         1
#define NNSH_KEYTYPE_UINT16         2

/** HTTPbZ[W쐬Ɏw **/
#define HTTP_SENDTYPE_GET                10
#define HTTP_SENDTYPE_GET_NOTMONA        11
#define HTTP_SENDTYPE_POST               20
#define HTTP_SENDTYPE_POST_OTHERBBS      30
#define HTTP_SENDTYPE_POST_MACHIBBS      40
#define HTTP_SENDTYPE_POST_SHITARABAJBBS 80
#define HTTP_SENDTYPE_POST_SHITARABA     90
#define HTTP_RANGE_OMIT             0xffffffff
#define HTTP_GETSUBJECT_LEN         4096
#define HTTP_GETSUBJECT_START       0
#define HTTP_GETSUBJECT_PART        0

/**  **/
#define NNSH_SEARCH_FORWARD         1
#define NNSH_SEARCH_BACKWARD       -1

/** tH[ID(Ǘp) **/
#define NNSH_FRMID_MAIN             10
#define NNSH_FRMID_CONFIG_NNSH      20

/** _CAO\x **/
#define NNSH_LEVEL_ERROR            0x0000
#define NNSH_LEVEL_WARN             0x0001
#define NNSH_LEVEL_INFO             0x0002
#define NNSH_LEVEL_CONFIRM          0x0004
#define NNSH_LEVEL_DEBUG            0x0010



// _CAOȗݒ
#define NNSH_OMITDIALOG_NOTHING      0x00
#define NNSH_OMITDIALOG_CONFIRM      0x01
#define NNSH_OMITDIALOG_WARNING      0x02
#define NNSH_OMITDIALOG_INFORMATION  0x04
#define NNSH_OMITDIALOG_ALLOMIT      ((NNSH_OMITDIALOG_CONFIRM)|(NNSH_OMITDIALOG_WARNING)|(NNSH_OMITDIALOG_INFORMATION))

#define NNSH_ERRORCODE_FAILURECONNECT (~errNone -  5)

#define NNSH_NGSET_SEPARATOR        ','

// VFS(ύX)l
#define NNSH_VFS_UNMOUNTED   1
#define NNSH_VFS_MOUNTED     2

// C
#define NNSH_STEP_PAGEUP           -1
#define NNSH_STEP_PAGEDOWN          1
#define NNSH_STEP_REDRAW            0
#define NNSH_STEP_UPDATE           10
#define NNSH_STEP_TO_BOTTOM       100
#define NNSH_STEP_TO_TOP          NNSH_STEP_UPDATE

#define NNSH_DISP_NOTHING          0x0000   // Ȃ
#define NNSH_DISP_UPPERLIMIT       0x0001   // 
#define NNSH_DISP_HALFWAY          0x0002   // r
#define NNSH_DISP_ALL              0x0004   // S\
#define NNSH_DISP_LOWERLIMIT       0x0008   // 


// MOx
#define NNSH_MACROLOGLEVEL_FATAL    0
#define NNSH_MACROLOGLEVEL_ERROR    1
#define NNSH_MACROLOGLEVEL_WARN     2
#define NNSH_MACROLOGLEVEL_INFO     3
#define NNSH_MACROLOGLEVEL_DEBUG    9

// opR[h(\[XƈvKv)
#define NNSH_MACROCMD_MACROEND 0   // }NI
#define NNSH_MACROCMD_MOVE     1   // 
#define NNSH_MACROCMD_ADD      2   // Z
#define NNSH_MACROCMD_SUB      3   // Z
#define NNSH_MACROCMD_MESSAGE  4   // Oo
#define NNSH_MACROCMD_EXECUTE  5   // @\̎s
#define NNSH_MACROCMD_CMP      6   // l̔r
#define NNSH_MACROCMD_JMP      7   // Wv
#define NNSH_MACROCMD_JZ       8   // vꍇWv
#define NNSH_MACROCMD_JNZ      9   // vȂꍇWv
#define NNSH_MACROCMD_BEEP    10   // r[v炷
#define NNSH_MACROCMD_OPERATE 11   // NNsiݒ̒lݒ
#define NNSH_MACROCMD_BBSTYPE 12   // BBS^Cv
#define NNSH_MACROCMD_STRSTR  13   // 񂪊܂܂邩ǂ
#define NNSH_MACROCMD_STRCMP  14   // 񂪈v邩ǂ
#define NNSH_MACROCMD_SETTABNUM 15 // ^uɊ܂܂鐔
#define NNSH_MACROCMD_GETMESNUM 16 // XɊ܂܂郁bZ[W
#define NNSH_MACROCMD_MESSTATUS 17 // XԂ
#define NNSH_MACROCMD_AND     18   // _
#define NNSH_MACROCMD_OR      19   // _a
#define NNSH_MACROCMD_XOR     20   // rI_a
#define NNSH_MACROCMD_IMPORT  21   // NNsiݒC|[g
#define NNSH_MACROCMD_EXPORT  22   // NNsiݒGNX|[g
#define NNSH_MACROCMD_STATUS  23   // NNsiݒ̒l擾
#define NNSH_MACROCMD_LAUNCHDA 24  // DAN

// f[^̑֘Aw(NNsiݒ̕ύXƂ)
#define NNSH_MACROOPCMD_DISABLE            0xffff  // (}NȂ)
#define NNSH_MACROOPCMD_AUTOSTARTMACRO     0xfffe  // (}NsSET)
#define NNSH_MACROOPCMD_NEWARRIVAL_LINE    0xfffd  // (VmF̉ؒf)
#define NNSH_MACROOPCMD_NEWARRIVAL_DA      0xfffc  // (VmFDAN)
#define NNSH_MACROOPCMD_NEWARRIVAL_ROLOG   0xfffb  // (QƐpO擾x)
#define NNSH_MACROOPCMD_NEWARRIVAL_BEEP    0xfffa  // (VmF̃r[v)
#define NNSH_MACROOPCMD_COPY_AND_DELETE    0xfff9  // (QƃOɃRs[폜)

#define NNSH_MACROCMD_VIEWTITLE  "}Ne"
#define NNSH_MACROLOG_VIEWTITLE  "}Ns"

#define MAX_MACRO_STEP         256   // ҏW\ȃ}NTCY̍ő

#define MAX_HALT_OPERATION     100   // @\s̐
#define MAX_LOGVIEW_BUFFER      96   //
#define MAX_LOGOUTPUT_BUFFER    80   //
#define MAX_FUNCCHAR_BUF        20   //

#define MAX_LOGRECLEN               40
#define MAX_STRLEN                  32

#define FILE_XML_NNSISET            "NNsiSet.xml"

// }ÑWX^֘A
#define NOF_REGISTER             16  // WX^̐
#define NNSH_MACROOP_NOSPECIFY 0x00  // wȂ
#define NNSH_MACROOP_IMMEDIATE 0x01  // lw

#define NNSH_MACROOP_GR_OFFSET 0xe0  // WX^ItZbg
#define NNSH_MACROOP_GR0       0xe0  // GR0
#define NNSH_MACROOP_GR1       0xe1  // GR1
#define NNSH_MACROOP_GR2       0xe2  // GR2
#define NNSH_MACROOP_GR3       0xe3  // GR3
#define NNSH_MACROOP_GR4       0xe4  // GR4
#define NNSH_MACROOP_GR5       0xe5  // GR5
#define NNSH_MACROOP_GR6       0xe6  // GR6
#define NNSH_MACROOP_GR7       0xe7  // GR7
#define NNSH_MACROOP_GR8       0xe8  // GR8
#define NNSH_MACROOP_GR9       0xe9  // GR9
#define NNSH_MACROOP_GRa       0xea  // GRa
#define NNSH_MACROOP_GRb       0xeb  // GRb
#define NNSH_MACROOP_GRc       0xec  // GRc
#define NNSH_MACROOP_GRd       0xed  // GRd
#define NNSH_MACROOP_GRe       0xee  // GRe
#define NNSH_MACROOP_GRf       0xef  // GRf
#define NNSH_MACROOP_GR_MAX    0xef  // WX^ől
