/*============================================================================*
 *  FILE: 
 *     main.c
 *
 *  Description: 
 *     main source code for Palm application.
 *     (This file includes in "skeleton.c".)
 *
 *===========================================================================*/
#define MAIN_C

/********** Include Files **********/
#include "local.h"

// external functions
extern Err     OpenForm_MainForm    (FormType           *frm);
extern Err     OpenForm_NNshSetting (FormType           *frm);
extern Boolean Handler_MainForm     (EventType          *event);
extern Boolean Handler_NNshSetting  (EventType          *event);
extern Err     VFSUnmountNotify     (SysNotifyParamType *notifyParamsP);
extern Err     VFSMountNotify       (SysNotifyParamType *notifyParamsP);

/*=========================================================================*/
/*   Function :  MyGetFormID                                               */
/*                                        I[vtH[ID */
/*=========================================================================*/
UInt16 GetFormID_NNsh(UInt16 frmID)
{
    UInt16 formID;

    switch (frmID)
    {
#if 0
      case NNSH_FRMID_CONFIG_NNSH:
        formID = FRMID_CONFIG_NNSH;
        break;
#endif
      case NNSH_FRMID_MAIN:
      default:
        formID = FRMID_MAIN;
        break;
    }
    return (formID);
}

/*=========================================================================*/
/*   Function :   MyApplicationDispatchEvent                               */
/*                                                fBXpb`Cxg */
/*=========================================================================*/
Boolean MyApplicationDispatchEvent(EventType *event)
{
    //  "n[hL[䂷"@w肪AL[̓CxgȂ
    // tH[̏{
    if ((NNshParam->useHardKeyControl != 0)&&(event->eType == keyDownEvent))
    {
        if (event->data.keyDown.chr >= vchrHardKeyMin)
        {
            // n[hL[R[h̊mF
            switch (event->data.keyDown.chr)
            {
              case vchrHard1:
                // n[hL[P
                event->data.keyDown.chr = NNshParam->useKey.key1;
                break;

              case vchrHard2:
                // n[hL[Q
                event->data.keyDown.chr = NNshParam->useKey.key2;
                break;

              case vchrHard3:
                // n[hL[R
                event->data.keyDown.chr = NNshParam->useKey.key3;
                break;

              case vchrHard4:
                // n[hL[S
                event->data.keyDown.chr = NNshParam->useKey.key4;
                break;

              default:
                //  imȂjn[hL[͂sꂽƂAL[R[h
                // \
                NNsh_DebugMessage(ALTID_INFO, "Hard Key Event ", " chrID:",
                                  event->data.keyDown.chr);
                break;
            }
        }
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   MyApplicationHandleEvent                                 */
/*                                                                         */
/*=========================================================================*/
Boolean MyApplicationHandleEvent(EventType *event)
{
    FormType  *frm;
    UInt16     fieldFont, objFont;

    // SONYVNsꍇ̉ʍXV
#ifdef USE_CLIE
    if ((NNshGlobal->silkRef != 0)&&
        (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY))
    {
         // SILK}l[W̕\ɂ킹ʂ̍XVs
        frm = FrmGetActiveForm();
        FrmEraseForm(frm);
        NNsi_FrmDrawForm(frm, true);
        NNshGlobal->updateHR = NNSH_NOT_EFFECTIVE;
    }
#endif

    // ŁA(tH[[h)CxgM̏LqB
    switch (event->eType)
    {
      // tH[Jevent
      case frmLoadEvent:
        // gptHgݒ肷
        fieldFont = NNshParam->currentFont;
        FntSetFont(fieldFont);
        objFont   = NNshParam->currentFont;

        // tH[ 
        frm = FrmInitForm(event->data.frmLoad.formID);
#ifdef USE_HANDERA
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaFormModify(frm, vgaFormModify160To240);
        }
#endif
#ifdef USE_CLIE
        NNshGlobal->tempStatus = 0;
#endif
        // tH[JăCxgnhݒ肷
        FrmSetActiveForm(frm);
        switch (event->data.frmLoad.formID)
        {
          // CtH[
          case FRMID_MAIN:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);

            // tH[JāACxgnhݒ肷
            OpenForm_MainForm(frm);
            FrmSetEventHandler(frm, Handler_MainForm);
            break;
#if 0
          // NNsiݒ
          case FRMID_CONFIG_NNSH:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNshSetting(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;
#endif

          default:
            // "tH[JCxg"\Ă݂B(fobO)
            NNsh_DebugMessage(ALTID_INFO, "frmLoadEvent()", " formID:",
                              event->data.frmLoad.formID);
            break;
        }
        // ʂ`悷
        //@NNsi_FrmDrawForm(frm, true);
        break;
#if 0
      // tH[Jevent
      case frmOpenEvent:
        break;

      // tH[event
      case frmCloseEvent:
        break;
#endif
      default:
        // T|[gĂȂCxgMB
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   MyApplicationHandleNotifications                         */
/*                                Notification                         */
/*=========================================================================*/
UInt32  MyApplicationHandleNotifications(SysNotifyParamType *notifyParamsP)
{ 
  // PilotMainĂCode Resourcȅꍇ͂Notification
  // ̂ʓIAĂȂꍇSysNotifyRegisterfunction pointer
  // nĂ

  switch(notifyParamsP->notifyType)
  {
    case sysNotifyVolumeUnmountedEvent:
      VFSUnmountNotify(notifyParamsP);
      break;

    case sysNotifyVolumeMountedEvent:
      VFSMountNotify(notifyParamsP);
      break;     
  }
  return 0;
}

/*=========================================================================*/
/*   Function :   myStartApplication                                       */
/*                                 X^[g(vO)  */
/*=========================================================================*/
UInt16 MyStartApplication(void)
{
    Int16                   ret;
    UInt16                  size;
    NNshSoftwareVersionInfo verInfo;
#ifdef USE_ARMLET
    UInt32                  processorType;
#endif
    UInt32                  osVersion;

    // NNsiݒo[W̊mF
    //   (VersionmFpPreferencemFAύXȂΕ)
    size = sizeof(NNshSoftwareVersionInfo);
    MemSet(&verInfo, sizeof(NNshSoftwareVersionInfo), 0x00);
    ret  = PrefGetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, 
                                 &verInfo, &size, false);

    // NNsiݒpi[̈̊m
    size = sizeof(NNshSavedPref) + DBSIZE_SETTING;
    NNshParam = (NNshSavedPref *) MemPtrNew(size);
    if (NNshParam == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR,MSG_CANNOT_LAUNCH,"(Prm)\nsize:",size);
        return (0);
    }        
    MemSet(NNshParam, size, 0x00);

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR, MSG_CANNOT_LAUNCH,"(Gbl)\nsize:", size);
        return (0);
    }        
    MemSet(NNshGlobal, size, 0x00);

    // OSo[W̊mF
    if (FtrGet(sysFtrCreator, sysFtrNumROMVersion, &osVersion) == errNone)
    {
        NNshGlobal->palmOSVersion = osVersion;
    }

    // NNsiݒ𕜋
    (void) RestoreSetting_NNsh(ret, verInfo.prefSize, NNshParam);

    // fobO[h̏𕜋
    NNshParam->debugMessageON = verInfo.debugMode;

    // VFS@\Ȃݒ肾ꍇɂ́AUVFSp[^NAB
    if (NNshParam->useVFS == NNSH_NOTSUPPORT_VFS)
    {
        NNshParam->useVFS = NNSH_VFS_DISABLE;
    }
    // VFST|[g̐ݒ
    CheckVFSdevice_NNsh();

#ifdef USE_CLIE
    // CLIET|[g̐ݒ
    SetCLIESupport_NNsh();
#endif  // #ifdef USE_CLIE

#ifdef USE_HANDERA
    // HandEraT|[g̐ݒ
    SetHandEraSupport_NNsh();
#endif // #ifdef USE_HANDERA

#ifdef USE_HIGHDENSITY
    // 𑜓xT|[g/J[T|[g̃`FbN
    SetDoubleDensitySupport_NNsh();
#else
    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;
#endif    // #ifdef USE_HIGHDENSITY

#ifdef USE_TSPATCH
    // TsPatchΉR[h...(TsPatchKpǂ`FbN)
    if (NNshParam->notUseTsPatch == 0)
    {
        ret = FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT_SUPPORT, &fontVer);
        if (ret == errNone)
        {    
            // TsPatchKp...gptHgB
            switch (NNshParam->currentFont)
            {
              case stdFont:
                FtrGet(SmallFontAppCreator, SMF_FTR_TINY_FONT, &fontId);
                break;

              case boldFont:
                FtrGet(SmallFontAppCreator, SMF_FTR_TINY_BOLD_FONT, &fontId);
                break;

              case largeFont:
                FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT, &fontId);
                break;

              case largeBoldFont:
                FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_BOLD_FONT, &fontId);
                break;

              default:
                fontId = NNshParam->currentFont;
                break;
            }
            NNshParam->currentFont = fontId;
        }
    }
    else
    {
        // TsPatch@\gȂꍇ,,,
        switch (NNshParam->currentFont)
        {
          case stdFont:
          case boldFont:
          case largeFont:
          case largeBoldFont:
            // ̂܂܎g
            break;

          default:
            // WtHgɕύX
            NNshParam->currentFont = stdFont;
            break;
        }
    }
#endif  // #ifdef USE_TSPATCH

#ifdef USE_ARMLET
    // ARMletgpۂ̃`FbN
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMletgp\foCXB
        // NNshParam->useARMlet = NNSH_ENABLE;  // ARMlet͎gpݒɕύX
    }
    else
#endif
    {
        // ARMlet͎gpȂݒɂ
        NNshParam->useARMlet = NNSH_DISABLE;
    }

#if 0
    // VFSOFFꍇɂ́AmFbZ[W\B
    if (NNshParam->useVFS == NNSH_VFS_DISABLE)
    {
        NNsh_InformMessage(ALTID_INFO, MSG_USE_VFS_WARNING, "", 0);
    }
#endif

    // i[obt@̈擾
    NNshGlobal->maxScriptLine = MAX_MACRO_STEP;
    NNshGlobal->scriptArea    = AllocateMacroDBData(NNshGlobal->maxScriptLine);
    if (NNshGlobal->scriptArea != NULL)
    {
        // DBNNsiݒŋL^ĂXNvgĂяo
        ret = ReadMacroDBData(DBNAME_MACROSCRIPT, DBVERSION_MACROSCRIPT,
                              DATA_CREATOR_ID, 
                              &(NNshGlobal->currentScriptLine), 
                              NNshGlobal->maxScriptLine,
                              NNshGlobal->scriptArea);
    }
    NNshGlobal->editFlag = false;

    // ŏɃI[vtH[IDB
    return (GetFormID_NNsh(NNshParam->lastFrmID));
}

/*=========================================================================*/
/*   Function :   myStopApplication                                        */
/*                                 Xgbv(vO)  */
/*=========================================================================*/
void MyStopApplication(void)
{
    NNshSoftwareVersionInfo verInfo;
    UInt16                  savedParam;
    
    savedParam = NNshParam->confirmationDisable;
    if (NNshGlobal->editFlag == true)
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_OUTPUT_MACRO, "", 0) == 0)
        {
            // }Nݒf[^o͂
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            extractMacroData();
        }
    }
    NNshParam->confirmationDisable = savedParam;

    // XNvg̈̊J
    if (NNshGlobal->scriptArea != NULL)
    {
        ReleaseMacroDBData(NNshGlobal->scriptArea);
    }

#ifdef USE_CLIE
    // CLIET|[gJ
    ResetCLIESupport_NNsh();
#endif

    // NNsiݒVersionmFpPreference̕ۑ(Debug[h͂ŋL)
    verInfo.NNsiVersion = SOFT_PREFVERSION;
    verInfo.prefSize    = sizeof(NNshSavedPref);
    verInfo.prefType    = NNSH_PREFERTYPE;
    verInfo.debugMode   = (NNshParam != NULL) ? NNshParam->debugMessageON : 0;
    PrefSetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, SOFT_PREFVERSION,
                          &verInfo, sizeof(NNshSoftwareVersionInfo), false);

    // NNsiݒ̕ۑ(NNsi̋Nɐ̂)
    if (NNshParam != NULL)
    {
        SaveSetting_NNsh(NNSH_PREFERTYPE, sizeof(NNshSavedPref), NNshParam);
        MemPtrFree(NNshParam);
        NNshParam = NULL;
    }

    // NNsĩO[öJ
    if (NNshGlobal != NULL)
    {
        MemPtrFree(NNshGlobal);
        NNshGlobal = NULL;
    }
    return;
}
