//////////////////////////////////////////////////////////////////////////////
// $Id: a2da-defines.h,v 1.2 2003/09/16 13:04:15 itty Exp $
//
// a2da-defines.h
// A2DA Data structure definition file
//
// (C) 2003, NNsi project, all rights reserved.
//

#include <PalmOS.h>

// DA creator
#define A2DA_Creator 'a2DA'

// font width 
struct A2DAcharFontWidth
{
    UInt16        charCode;        // LN^R[h
    UInt16        fontWidth;       // tHg̕
};
typedef struct A2DAcharFontWidth A2DAcharFontWidth;

// A2DA AA view form globals
// structure:
struct A2DADataType
{
    UInt16        scale;           // \{
    UInt32        os5density;      // PalmOS5̉𑜓x
    RectangleType dimF;            // \̈̃TCY(coord̈)
    RectangleType area;            // \̈̃TCY(̈)
    UInt8        *areaP;           // \f[^̃|C^
    UInt16        length;          // \f[^
    UInt16        startX;          // `Jnꏊ
    UInt16        startY;          // `Iꏊ
    UInt16        maxX;            // `f[^ő(X)
    UInt16        maxY;            // `f[^ŏ(Y)
    UInt16       *singleWidth;     // VOoCg̕
    UInt16       *doubleWidth;     // _uoCg̕
    UInt16        singleDbSize;
    A2DAcharFontWidth *singleDB;
    UInt16        doubleDbSize;
    A2DAcharFontWidth *doubleDB;    
};
typedef struct A2DADataType  A2DADataType;

// global feature id:
#define ADT_FTRID       1
#define ADT_FTRID_MEM   2

// other definitions...
#define BUFSIZE   48
#define MARGIN    16

// NNsiƂ̘Ag@\p`
#define A2DA_NNSIEXT_AADATASTART  "<NNsi:NNsiExt type=\"AA\">"
#define A2DA_NNSIEXT_ENDDATA      "</NNsi:NNsiExt>"
#define A2DA_NNSIEXT_SRC_STREAM   "<NNsi:Source>stream</NNsi:Source>"
#define A2DA_NNSIEXT_DATANAME     "<NNsi:Name>"
#define A2DA_NNSIEXT_ENDDATANAME  "</NNsi:Name>"
#define A2DA_NNSIEXT_NNSICREATOR  "<NNsi:Creator>NNsi</NNsi:Creator>"

// from SonyChars.h
#ifndef vchrJogPushedDown
#define vchrJogPushedDown		(0x1704)
#endif
#ifndef vchrJogPushedUp
#define vchrJogPushedUp			(0x1703)
#endif
