/*============================================================================*
 *  FILE: 
 *     nnshdmmy.c
 *
 *  Description: 
 *     NNsh dummy Display.
 *
 *===========================================================================*/
#define NNSHDMMY_C
#include "local.h"

extern UInt16 ConvertFormID(UInt16 lastFrmID);

/*=========================================================================*/
/*   Function :   OpenForm_NNsiDummy                                       */
/*                                             NNsiN(DUMMY)ʃI[v */
/*=========================================================================*/
Err OpenForm_NNsiDummy(FormType *frm)
{
    Err          ret;
    Char         *osVer, buffer[BIGBUF];
    UInt8        remainPer;
    UInt32       useSize, totalSize, freeSize;

    // o̓obt@NA
    MemSet (buffer, sizeof(buffer), 0x00);

    // ݊JĂʂ_~[ʂƂ(OJĂʂwork1ɋL^)
    if (NNshParam->lastFrmID != NNSH_FRMID_DUMMY)
    {
        NNshGlobal->work1    = NNshParam->lastFrmID;
    }
    else
    {
        NNshGlobal->work1    = NNSH_FRMID_THREAD;
    }
    NNshParam->lastFrmID = NNSH_FRMID_DUMMY;

    // OS̃o[Wo͂
    osVer = SysGetOSVersionString();
    StrCat (buffer, "PalmOS ");
    StrCat (buffer, osVer);
    MemPtrFree(osVer);

    // ݂̃obecʂobt@ɏo͂
    remainPer      = 0;
    SysBatteryInfo(false, NULL, NULL, NULL, NULL, NULL, &remainPer);
    StrCat (buffer, "\n---\nBattery :");
    NUMCATI(buffer, (UInt16) remainPer); 
    StrCat (buffer, "%");

    // 󂫃̎擾
    freeSize = GetOSFreeMem(&totalSize, &useSize);
    {
        // VFS̗e(/ő)o͂
        StrCat (buffer, "\nMemory(Free/Total)\n    ");
        NUMCATI(buffer, ((freeSize)/1024));
        StrCat (buffer, "kB/");
        NUMCATI(buffer, ((totalSize/1024))); 
        StrCat (buffer, "kB");
    }

    // VFS̎擾
    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
    {
        // VFS̗eʂmF
        ret = VFSVolumeSize(NNshGlobal->vfsVol, &useSize, &totalSize);
        if (ret == errNone)
        {
            // VFS̗e(/ő)o͂
            StrCat (buffer, "\nVFS(Free/Total)\n    ");
            NUMCATI(buffer, ((totalSize - useSize)/1024));
            StrCat (buffer, "kB/");
            NUMCATI(buffer, ((totalSize/1024))); 
            StrCat (buffer, "kB");
        }
    }
    
    // foCX\
    NNshWinSetFieldText(frm, FLDID_DUMMYMSG, true, buffer, StrLen(buffer));

    return (errNone);
}

/*=========================================================================*/
/*   Function :   Hander_NNsiDummy                                         */
/*                                  NNsiN(DUMMY)ʂ̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_NNsiDummy(EventType *event)
{
    Err        ret;
    UInt16     itemId, len, savedParam;
    Char       kwBuf[BUFSIZE + MARGIN], *buffer;
    EventType *dummyEvent;

    buffer = NULL;
    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        itemId = event->data.menu.itemID;
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        itemId = event->data.ctlSelect.controlID;
        break;

      case keyDownEvent:
        // L[͂(Ȃ)
        return (true);
        break;

      default: 
        return (false);
        break;
    }

    switch (itemId)
    {
      case MNUID_NNSI_WELCOME:
      case SELTRID_NNSI_DUMMY:
        // NR[h
        MemSet(kwBuf, sizeof(kwBuf), 0x00);
        // NpX[hݒ
        if (DataInputDialog(NNSH_INPUTWIN_ENTPASS, kwBuf, PASSSIZE,
                            NNSH_DIALOG_USE_PASS, NULL) != false)
        {
            len = StrLen(NNshParam->launchPass);
            if (StrNCompare(NNshParam->launchPass, kwBuf, len) == 0)
            {
                // NpX[ḧvmF
                NNsh_InformMessage(ALTID_INFO, MSG_MATCH_LAUNCHWORD, "", 0);

                // OIʂJ
                FrmGotoForm(ConvertFormID(NNshGlobal->work1));
                goto FUNC_END;
            }
        }
        FrmDrawForm(FrmGetActiveForm());
        break;

      case MNUID_IPINFO:      
        // C^tF[X\
        buffer = MemPtrNew(NNshParam->bufferSize);
        if (buffer != NULL)
        {    
            // lbgCuI[vĂȂƂ̓I[vB
            ret = NNshNet_open(&(NNshGlobal->netRef));
            if (ret == errNone)
            {
                // m[hIP擾
                MemSet(buffer, NNshParam->bufferSize, 0x00);
                NNshNet_GetNetIFInfo(NNshGlobal->netRef, buffer);

                NNshNet_close(NNshGlobal->netRef);

                // ʂ\
                NNshWinSetFieldText(FrmGetActiveForm(), FLDID_DUMMYMSG,
                                    true, buffer, StrLen(buffer));
            }
            MemPtrFree(buffer);
        }
        FrmDrawForm(FrmGetActiveForm());
        break;

      case MNUID_RESOLVE:
        // zXg̊mF{
        buffer = MemPtrNew(NNshParam->bufferSize);
        MemSet(buffer, NNshParam->bufferSize, 0x00);
        if (buffer != NULL)
        {    
            // `FbNzXg...
            MemSet(kwBuf, sizeof(kwBuf), 0x00);
            if (DataInputDialog(NNSH_INPUTWIN_RESOLVE, kwBuf, BUFSIZE,
                                NNSH_DIALOG_USE_RESOLVE, NULL) != false)
            {
                // BUSYEBhEɊmF̃zXg\
                StrCopy(buffer, "Checking: ");
                StrCat (buffer, kwBuf);

                // lbgCuI[vĂȂƂ̓I[vB
                ret = NNshNet_open(&(NNshGlobal->netRef));
                if (ret == errNone)
                {
                    // BUSYEBhE̕\
                    Show_BusyForm(buffer);

                    // zXgmF
                    MemSet(buffer, NNshParam->bufferSize, 0x00);
                    NNshNet_CheckHostAlive(NNshGlobal->netRef, kwBuf, 3, buffer);            

                    Hide_BusyForm(false);

                    NNshNet_close(NNshGlobal->netRef);

                    // Oʁ{\
                    NNshWinSetFieldText(FrmGetActiveForm(), FLDID_DUMMYMSG,
                                        true, buffer, StrLen(buffer));
                }
            }
            MemPtrFree(buffer);
        }
        FrmDrawForm(FrmGetActiveForm());
        break;

      case MNUID_NNSI_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case MNUID_EDIT_UNDO:
      case MNUID_EDIT_CUT:
      case MNUID_EDIT_COPY:
      case MNUID_EDIT_PASTE:
      case MNUID_SELECT_ALL:
        // ҏWj[Ăяo
        return (NNsh_MenuEvt_Edit(event));
        break;

      case MNUID_NETPREF:
        // lbg[NݒJ
        OpenNetworkPreferences();
        break;

      case MNUID_DISCONNECT:
        // ؒf
        if (NNshGlobal->netRef != 0)
        {
            savedParam = NNshParam->confirmationDisable;
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            NNshNet_LineHangup();
            NNshParam->confirmationDisable = savedParam;
        }
        break;

      case BTNID_NNSI_DUMMY_OK:
      default:
        // LȊO(NNsiICxg𐶐)
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType = appStopEvent;
        EvtAddEventToQueue(dummyEvent);
        return (false);
        break; 
    }

FUNC_END:
    return (true);
}
