/*============================================================================*
 *  FILE: 
 *     nnshset.c
 *
 *  Description: 
 *     NNsh parameter setting functions for NNsh.
 *
 *===========================================================================*/
#define NNSHSET_C
#define GLOBAL_REAL
#include "local.h"

extern Err setOfflineLogDir(Char *fileName);

/*=========================================================================*/
/*   Function :   SetControlValue                                          */
/*                                       p[^ʂɔf鏈  */
/*=========================================================================*/
void SetControlValue(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    CtlSetValue(chkObj, (UInt16) *value);

    return;
}

/*=========================================================================*/
/*   Function :   UpdateParameter                                          */
/*                                       ʂp[^ɔf鏈  */
/*=========================================================================*/
void UpdateParameter(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    *value = CtlGetValue(chkObj);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting7                                       */
/*                              NNsiݒ-7(foCX֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting7(FormType *frm)
{
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3, *chkObjSub4;
    UInt16       butID;

    // ARMletgp
    UpdateParameter(frm, CHKID_USE_ARMLET, &(NNshParam->useARMlet));
    if (NNshParam->useARMlet != 0)
    {
        // ArmLetPalmOS5p̋@\Ȃ߁A{Ɏ{邩mF\)
        butID = NNsh_WarningMessage(ALTID_CONFIRM, MSG_WARNING_OS5, "", 0);
        if (butID != 0)
        {
            NNshParam->useARMlet = 0;
        }
    }

#ifdef USE_CLIE
    // SONYnC]@\gȂ
    UpdateParameter(frm, CHKID_NOTUSE_SONYHIRES, &(NNshParam->disableSonyHR));
    if (NNshGlobal->notUseHR != NNshParam->disableSonyHR)
    {
        // SONYnC]@\̎gpېݒ́ANLƂȂ
        NNsh_WarningMessage(ALTID_WARN, MSG_HR_NEXT_LAUNCH, "", 0);
    }

    // SilksȂ
    UpdateParameter(frm, CHKID_NOTUSE_SILK, &NNshGlobal->notUseSilk);
    if (NNshGlobal->notUseSilk != NNshParam->notUseSilk)
    {
        // SILK͍sȂƂ́Ax\
        NNsh_WarningMessage(ALTID_WARN, MSG_SILK_NEXT_LAUNCH, "", 0);
    }
#endif

    // VFS p\ɎIVFS ON
    UpdateParameter(frm, CHKID_VFSON_AUTOMATIC,&(NNshParam->vfsOnAutomatic));

    // VFS ONłDB`FbNȂ
    UpdateParameter(frm, CHKID_VFSON_NOTDBCHK, &(NNshParam->vfsOnNotDBCheck));

    // VFS̎gpƉtOAOFFLINEOgptO̐ݒ
    if (NNshParam->useVFS != NNSH_NOTSUPPORT_VFS)
    {
        chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
        chkObjSub1 = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
        chkObjSub2 = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
        chkObjSub3 =
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
        chkObjSub4 =
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
        NNshParam->useVFS = CtlGetValue(chkObj);
        if (CtlGetValue(chkObjSub1) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_WORKAROUND;
        }
        if (CtlGetValue(chkObjSub2) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_USEOFFLINE;
        }
        if (CtlGetValue(chkObjSub3) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_DBBACKUP;
        }
        if (CtlGetValue(chkObjSub4) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_DBIMPORT;
        }

        if (NNshParam->useVFS != 0)
        {
            //  VFS֘Ap[^̐ݒ肪ĂƂAN
            // LƂȂ邱Ƃ\B
            NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_VFSWARN, "", 0);
        }

        // logdir.txtǂ݁AOFFLINEOx[XfBNg擾
        (void) setOfflineLogDir(LOGDIR_FILE);
    }

    // DBXV邵
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting8                                       */
/*                                  NNsiݒ-8(ʐM֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting8(FormType *frm)
{
    FieldType   *fldP;
    UInt32       bufSize;
    UInt16       timeout;
    Char        *logBuf, *numP;
    MemHandle    txtH;

    // ʐM^CAEgl̕ύX
    timeout = SysTicksPerSecond();
    timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_COMM_TIMEOUT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);
        if (NNshParam->netTimeout != timeout * bufSize)
        {
            NNshParam->netTimeout = timeout * bufSize;

            // TIMEOUT̍XV\
            NNsh_DebugMessage(ALTID_INFO, MSG_TIMEOUT_UPDATED, 
                              "", NNshParam->netTimeout);
        }
    }

    // obt@TCY̕ύX
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_BUFFER_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);
        if ((bufSize < NNSH_WORKBUF_MIN)||(bufSize > NNSH_WORKBUF_MAX))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MemPtrNew(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE1);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE2);
                NUMCATI(logBuf, NNSH_WORKBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WORKBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WORKBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MemPtrFree(logBuf);
            }
            return (~errNone);
        }
        else
        {
            if (bufSize == NNshParam->bufferSize)
            {
                // obt@TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "buffer size:", NNshParam->bufferSize);
            }
            else
            {
                // obt@TCYύXďI
                NNshParam->bufferSize = bufSize;
                NNsh_DebugMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                  "buffer size:", NNshParam->bufferSize);
            }
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "0", 0);
    }

    // _E[hw擾
    UpdateParameter(frm, CHKID_DL_PART, &(NNshParam->enablePartGet));

    // BBSꗗ㏑
    UpdateParameter(frm, CHKID_BBS_OVERWRITE, &(NNshParam->bbsOverwrite));

    // _E[h̃TCY擾
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_DL_PARTSIZE));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        if (bufSize < NNSH_DOWNLOADSIZE_MIN)
        {
            // _E[hTCÝAobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_UNDER,
                              "", NNSH_DOWNLOADSIZE_MIN);
            return (~errNone);
        }
        if (bufSize > NNshParam->bufferSize)
        {
            // _E[hTCÝA[Nobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_OVER, "", 0);
            return (~errNone);
        }
        if (bufSize != NNshParam->partGetSize)
        {
            NNshParam->partGetSize = bufSize;

            // _E[hTCY̍XV\
            NNsh_DebugMessage(ALTID_INFO, MSG_DOWNLOADSIZE_UPDATE, "",
                              NNshParam->partGetSize);
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "1", 0);
    }

    // BBSꗗ擾̐ݒ
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_URL_BBS));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[hURL擾
        numP = MemHandleLock(txtH);
        MemSet  (NNshParam->bbs_URL, MAX_URL, 0x00);
        StrNCopy(NNshParam->bbs_URL, numP, (MAX_URL - 1));
        MemHandleUnlock(txtH);
    }

    // ProxyoRł̃ANZX
    UpdateParameter(frm, CHKID_USE_PROXY, &(NNshParam->useProxy));

    // Proxy URL
    fldP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, FLDID_USE_PROXY));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP = MemHandleLock(txtH);
        MemSet(NNshParam->proxyURL, MAX_URL, 0x00);
        if (*numP != '\0')
        {
            StrNCopy(NNshParam->proxyURL, numP, (MAX_URL - 1));
        }
        MemHandleUnlock(txtH);
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY URL", 0);
    }

    // Proxy Port #
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_PROXY_PORT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        NNshParam->proxyPort = bufSize;
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY PORT", 0);
    }

    // ʐM^CAEg̃gC
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_TIMEOUT_RETRY));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP     = MemHandleLock(txtH);
        timeout  = StrAToI(numP);
        MemHandleUnlock(txtH);

        // gC񐔂K傫΁AKlŊۂ߂
        timeout = (timeout > NNSH_LIMIT_RETRY)? NNSH_LIMIT_RETRY : timeout;
        NNshParam->nofRetry = timeout;
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "RETRY COUNT", 0);
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting5                                       */
/*                              NNsiݒ-5(݊֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting5(FormType *frm)
{
    UInt32       bufSize;
    FieldType   *fldP;
    Char        *nameP, *logBuf;
    MemHandle    txtH;

    // ݎobt@TCY̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_WRITEBUF_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[h珑݃obt@TCY擾
        nameP = MemHandleLock(txtH);
        if (nameP != NULL)
        {
            bufSize = StrAToI(nameP);
            MemHandleUnlock(txtH);
        }
        else
        {
            bufSize = NNSH_WRITEBUF_DEFAULT;
        }
        if ((bufSize > NNSH_WRITEBUF_MAX)||(bufSize < NNSH_WRITEBUF_MIN))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MemPtrNew(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL2);
                NUMCATI(logBuf, NNSH_WRITEBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WRITEBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WRITEBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MemPtrFree(logBuf);
            }
            return (~errNone);
        }
        else
        {
            // TCYmF
            if (bufSize == NNshParam->writeBufferSize)
            {
                // TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "writeBufferSize:", NNshParam->writeBufferSize);
            }
            else
            {
                NNshParam->writeBufferSize = bufSize;
                NNsh_DebugMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                  "writeBufferSize:", NNshParam->writeBufferSize);
            }
        }
    }

    // ݎPUSH{^𖳌
    UpdateParameter(frm, CHKID_WRITE_AUTOSAVE,
                                       &(NNshParam->writeMessageAutoSave));

    // ݎPUSH{^𖳌
    UpdateParameter(frm, CHKID_WRITEPUSH_DISABLE,
                                        &(NNshParam->writeJogPushDisable));

    // sage
    UpdateParameter(frm, CHKID_WRITE_SAGE,  &(NNshParam->writeAlwaysSage));

    // Ren@\gpݒ
    UpdateParameter(frm, CHKID_FIXED_HANDLE, &(NNshParam->useFixedHandle));

    // nh̐ݒ(nhݒłȂĂ퉞)
    MemSet(NNshParam->handleName, BUFSIZE, 0x00);
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_HANDLENAME));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        nameP = MemHandleLock(txtH);
        MemSet(NNshParam->handleName, BUFSIZE, 0x00);
        if (*nameP != '\0')
        {
            StrNCopy(NNshParam->handleName, nameP, (BUFSIZE - 1));
        }
        MemHandleUnlock(txtH);
    }

    // MCookiegpď
    UpdateParameter(frm, CHKID_WRITE_USE_COOKIE, &(NNshParam->useCookieWrite));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    UpdateParameter(frm, CHKID_NOT_AUTOFOCUSSET,&(NNshParam->notAutoFocus));

    // ݎAA_[COFFɂ
    UpdateParameter(frm, CHKID_UNDERLINE_WRITE, &(NNshParam->disableUnderlineWrite));

    // ݎQƃXԍ}
    UpdateParameter(frm, CHKID_INSERT_REPLYNUM, &(NNshParam->insertReplyNum));

    // ݃V[PXPART2
    UpdateParameter(frm, CHKID_WRITE_SEQUENCE2, &(NNshParam->writeSequence2));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting6                                       */
/*                                NNsiݒ-6(WO֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting6(FormType *frm)
{
    // QƎJumpListɁuꗗցv
    UpdateParameter(frm, CHKID_ADD_RTNTOLIST, &(NNshParam->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    UpdateParameter(frm, CHKID_ADD_BACKMESSAGE, &(NNshParam->addMenuBackRtnMsg));

    // QƎJumpListɃj[
    UpdateParameter(frm, CHKID_ADD_OPENMENU, &(NNshParam->addMenuMsg));

    // QƎJumpListɁu擾v
    UpdateParameter(frm, CHKID_ADD_GETPART, &(NNshParam->addLineGetPart));

    // QƎJumpListɁuؒfv
    UpdateParameter(frm, CHKID_ADD_LINEDISCONN, &(NNshParam->addLineDisconn));

    // QƎJumpListɐ擪
    UpdateParameter(frm, CHKID_ADD_JUMPTOP, &(NNshParam->addJumpTopMsg));

    // QƎJumpListɖ
    UpdateParameter(frm, CHKID_ADD_JUMPBOTTOM, &(NNshParam->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    UpdateParameter(frm, CHKID_ADD_OPENWEB, &(NNshParam->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    UpdateParameter(frm, CHKID_ADD_GRAPHVIEW, &(NNshParam->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    UpdateParameter(frm, CHKID_ADD_FAVORITE, &(NNshParam->addMenuFavorite));

    // QƎJumpListɃo
    UpdateParameter(frm, CHKID_ADD_OUTPUTMEMO, &(NNshParam->addMenuOutputMemo));

    // ꗗMenuɃj[\
    UpdateParameter(frm, CHKID_ADD_MENUOPEN, &NNshParam->addMenuTitle);

    // ꗗMenuɎQCOPY
    UpdateParameter(frm, CHKID_ADD_MENUCOPY, &NNshParam->addMenuCopyMsg);

    // ꗗMenuMSG폜
    UpdateParameter(frm, CHKID_ADD_MENUDELETE, &NNshParam->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    UpdateParameter(frm, CHKID_ADD_MENUGRAPHMODE, &NNshParam->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW1, &NNshParam->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW2, &NNshParam->addMenuMultiSW2);

    // ꗗMenuNNsiI
    UpdateParameter(frm, CHKID_ADD_NNSIEND, &NNshParam->addMenuNNsiEnd);

    // ꗗMenuɃfoCX
    UpdateParameter(frm, CHKID_ADD_MENUDEVICEINFO, &NNshParam->addMenuDeviceInfo);

    // QƎMenuɃfoCX
    UpdateParameter(frm, CHKID_ADD_DEVICEINFO, &NNshParam->addDeviceInfo);

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effect_NNshSetting                                       */
/*                   NNsiݒ(NNsi)p[^lɔf鏈  */
/*-------------------------------------------------------------------------*/
static Err effect_NNshSetting(FormType *frm)
{
    ListType *lstP;
    UInt16   item;

    /***  NNshݒ(O[oϐ)f  ***/

    // URL擾AL`FbNȂ
    UpdateParameter(frm, CHKID_NOTCHECK_BBSURL,&(NNshParam->notCheckBBSURL));

    // ړɖ擾X폜
    UpdateParameter(frm, CHKID_AUTODEL_NOT_YET,&(NNshParam->autoDeleteNotYet));

    // Ji𔼊pSpϊ
    UpdateParameter(frm,CHKID_CONVERT_HANZEN, &(NNshParam->convertHanZen));

    // OfflineXɃX{Ȃ
    UpdateParameter(frm, CHKID_NOT_DELOFFLINE, &(NNshParam->notDelOffline));

    // Cɓ\ŒXx̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    item  = LstGetSelection(lstP);
    switch (item)
    {
      case 1:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L2;
        break;

      case 2:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L3;
        break;

      case 3:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L4;
        break;

      case 4:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR;
        break;

      case 0:
      default:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L1;
        break;
    }

    // mFbZ[Wȗ
    item = 0;
    UpdateParameter(frm, CHKID_OMIT_DIALOG, &item);
    if (item == 0)
    {
        // mFbZ[WȗݒNA
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
    }
    if ((item != 0)&&(NNshParam->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }

    // ɁA啶ʂȂ
    UpdateParameter(frm, CHKID_SEARCH_CASELESS, &(NNshParam->searchCaseless));

    // NOfflineX
    UpdateParameter(frm, CHKID_OFFCHK_LAUNCH,   &(NNshParam->offChkLaunch));

    // QƐpփRs[ƂAɃX폜{
    UpdateParameter(frm, CHKID_COPYDEL_READONLY,
                    &(NNshParam->copyDelReadOnly));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting2                                       */
/*                                   NNsiݒ2(ꗗ)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting2(FormType *frm)
{

    // Xꗗ(subject.txt)S擾
    UpdateParameter(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

    // Xꗗʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TITLE,
                                     &(NNshParam->useSonyTinyFontTitle));

    // dmF
    UpdateParameter(frm, CHKID_CHECK_DUPLICATE,
                    &(NNshParam->checkDuplicateThread));

    // XꗗMSG
    UpdateParameter(frm, CHKID_PRINT_NOFMSG,&(NNshParam->printNofMessage));

    // 擾ςݑSĂ͎QƐpOɕ\Ȃ
    UpdateParameter(frm, CHKID_NOT_READONLY, &(NNshParam->notListReadOnly));

    // 擾ɃXQ
    UpdateParameter(frm, CHKID_OPEN_AUTO,   &(NNshParam->openAutomatic));

#ifdef USE_COLOR
    // ꗗ\ɃJ[
    UpdateParameter(frm, CHKID_USE_COLORMODE, &(NNshParam->useColor));
#endif

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting3                                       */
/*                                NNsiݒ-3(ꗗ{^)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting3(FormType *frm)
{
    Char      *txtP;
    FieldType *fldP;
    ListType  *lstP;
    UInt16     item;
    MemHandle  txtH;

    // ړIXCb`ݒP̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW1));
    item  = LstGetSelection(lstP);
    NNshParam->usageOfTitleMultiSwitch1 = item | NNSH_SWITCHUSAGE_TITLE;

    // ړIXCb`ݒQ̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW2));
    item  = LstGetSelection(lstP);
    NNshParam->usageOfTitleMultiSwitch2 = item | NNSH_SWITCHUSAGE_TITLE;

    if (NNshParam->usageOfTitleMultiSwitch1 ==
        NNshParam->usageOfTitleMultiSwitch2)
    {
        // ړIXCb`PƂQ̐ݒlꍇXCb`QgpȂ
        NNshParam->usageOfTitleMultiSwitch2 = NNSH_SWITCHUSAGE_TITLE;
    }

    // ړI{^P̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN1));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn1Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN1));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn1Feature = item | MULTIBTN_FEATURE;

    // ړI{^Q̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN2));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn2Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN2));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn2Feature = item | MULTIBTN_FEATURE;

    // ړI{^R̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN3));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn3Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN3));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn3Feature = item | MULTIBTN_FEATURE;

    // ړI{^S̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN4));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn4Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN4));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn4Feature = item | MULTIBTN_FEATURE;

    // ړI{^T̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN5));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn5Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN5));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn5Feature = item | MULTIBTN_FEATURE;

    // ړI{^U̐ݒ
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MULTIBTN6));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        StrNCopy (NNshParam->multiBtn6Caption, txtP, LIMIT_CAPTION);
        MemHandleUnlock(txtH);
    }
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIBTN6));
    item  = LstGetSelection(lstP);
    NNshParam->multiBtn6Feature = item | MULTIBTN_FEATURE;

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting9                                       */
/*                             NNsiݒ-9(V/֘A)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting9(FormType *frm)
{
    ListType  *lstP;
    UInt16     item;

    // NNsiIɉؒf
    UpdateParameter(frm, CHKID_END_OFFLINE, &(NNshParam->disconnectNNsiEnd));

    // uVmFvIɉؒf
    UpdateParameter(frm, CHKID_DISCONN_ARRIVAL, &(NNshParam->disconnArrivalEnd));

    // uVmFvIɖǈꗗ\
    UpdateParameter(frm, CHKID_ARRIVAL_NOTREAD, &(NNshParam->autoOpenNotRead));

    // ڑ͎擾\
    UpdateParameter(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // ڑʂĕ`
    UpdateParameter(frm,CHKID_REDRAW_CONNECT,&(NNshParam->redrawAfterConnect));

    // ܂BBS/@JBBSVmF
    UpdateParameter(frm, CHKID_HTMLBBS_ENABLE,
                                        &(NNshParam->enableNewArrivalHtml));
    if (NNshParam->enableNewArrivalHtml != 0)
    {
        //  ܂BBS/@JBBSŐVmFꍇ́A擾ł͂Ȃ
        // Ď擾{邱Ƃx
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNMACHINEW, "", 0);

    }

    // BBSꗗ̃XgԂ𔽉f
    lstP  = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,LSTID_CHECK_NEWARRIVAL));
    item  = LstGetSelection(lstP);
    NNshParam->newArrivalNotRead = item;

    // VG[ɂȂ΍Ď擾
    UpdateParameter(frm, CHKID_ALLUPDATE_ABORT, &(NNshParam->autoUpdateGetError));

    // WebBrowserJƂŐV50
    UpdateParameter(frm, CHKID_WEBBROWSE_LAST50, &item);
    if (item != 0)
    {
        NNshParam->browseMesNum = 50;
    }
    else
    {
        NNshParam->browseMesNum = 0;
    }

    // i-modepURLgp
    UpdateParameter(frm, CHKID_USE_IMODEURL, &(NNshParam->useImodeURL));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting4                                       */
/*                                  NNsiݒ-4(QƉ)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting4(FormType *frm)
{
    // Bookmark(ݒ)
    UpdateParameter(frm, CHKID_USE_BOOKMARK,&(NNshParam->useBookmark));

    // Xԍyzɂ
    UpdateParameter(frm, CHKID_BOLD_MSGNUM, &(NNshParam->boldMessageNum));

    // XQƉʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TINYFONT,
                                      &(NNshParam->useSonyTinyFont));

    // QƎA_[COFF
    UpdateParameter(frm, CHKID_MSG_LINEOFF, &(NNshParam->disableUnderline));

    // PUSH ON_CŁ}P
    UpdateParameter(frm, CHKID_NOT_CURSOR, &(NNshParam->notCursor));

    // XQƉʂŃJ[\\Ȃ
    UpdateParameter(frm,CHKID_NOT_FOCUSSET_NUM, &(NNshParam->notFocusNumField));

    // QƎOɈړőOX
    UpdateParameter(frm, CHKID_DISPLAY_BOTTOMMES, &(NNshParam->dispBottom));

    // QƎXA\
    UpdateParameter(frm,CHKID_BLOCK_DISP_MODE, &(NNshParam->blockDispMode));
    if (NNshParam->blockDispMode != 0)
    {
        // XA\Ƃ́AOɈړőOXnmɂ
        NNshParam->blockDispMode = NNSH_BLOCKDISP_NOFMSG;
        NNshParam->dispBottom    = 1;
    }

    // NGmF
    UpdateParameter(frm, CHKID_HIDE_MESSAGE, &(NNshParam->hideMessage));

    // NG[hݒŐK\gp
    UpdateParameter(frm, CHKID_USE_REGEXPRESS,
                                        &(NNshParam->useRegularExpression));
    if (NNshParam->useRegularExpression != 0)
    {
        //  K\gpꍇɂ́AptH[}Xۏ؂łȂƂ
        // x
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNREGEXP, "", 0);
    }

    // gꍇ̐ݒ
    if (NNshParam->useBookmark == 0)
    {
        // gȂꍇAݒ̃NA
        NNshParam->lastFrmID     = NNSH_FRMID_THREAD;
        NNshParam->bookMsgNumber = 0;
        NNshParam->bookMsgIndex  = 0;
        MEMFREE_PTR(NNshGlobal->bookmarkFileName);
        MEMFREE_PTR(NNshGlobal->bookmarkNick);
    }
    else
    {
        if (NNshGlobal->bookmarkFileName == NULL)
        {
            // ݒL̈mۂ
            NNshGlobal->bookmarkFileName = MemPtrNew(MAX_THREADFILENAME);
            if (NNshGlobal->bookmarkFileName != NULL)
            {
                NNshGlobal->bookmarkNick = MemPtrNew(MAX_NICKNAME);
                if (NNshGlobal->bookmarkNick == NULL)
                {
                    MemPtrFree(NNshGlobal->bookmarkFileName);
                    NNshGlobal->bookmarkFileName = NULL;
                }
            }
        }
    }

    // NGݒ12̕`FbN
    SeparateWordList(NNshParam->hideWord1, &(NNshGlobal->hide1));
    SeparateWordList(NNshParam->hideWord2, &(NNshGlobal->hide2));

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSettingA                                       */
/*                                        NNsiݒ(T)̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSettingA(FormType *frm)
{
    UInt16   item;

    // DEBUG[h̐ݒ
    UpdateParameter(frm, CHKID_DEBUG_DIALOG,&(NNshParam->debugMessageON));

    // Xꗗ(subject.txt)S擾
    UpdateParameter(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

#ifdef USE_COLOR
    // ꗗ\ɃJ[
    UpdateParameter(frm, CHKID_USE_TITLE_COLOR, &(NNshParam->useColor));
#endif

    // i-modepURLgp
    UpdateParameter(frm, CHKID_USE_IMODEURL, &(NNshParam->useImodeURL));

    // QƎXA\
    UpdateParameter(frm,CHKID_BLOCK_DISP_MODE, &(NNshParam->blockDispMode));
    if (NNshParam->blockDispMode != 0)
    {
        // XA\Ƃ́AOɈړőOXnmɂ
        NNshParam->blockDispMode = NNSH_BLOCKDISP_NOFMSG;
        NNshParam->dispBottom    = 1;
    }

    // ڑ͎擾\
    UpdateParameter(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // ܂BBS/@JBBSVmF
    UpdateParameter(frm, CHKID_HTMLBBS_ENABLE,
                                        &(NNshParam->enableNewArrivalHtml));
    if (NNshParam->enableNewArrivalHtml != 0)
    {
        //  ܂BBS/@JBBSŐVmFꍇ́A擾ł͂Ȃ
        // Ď擾{邱Ƃx
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_WARNMACHINEW, "", 0);

    }

    // mFbZ[Wȗ
    item = 0;
    UpdateParameter(frm, CHKID_OMIT_DIALOG, &item);
    if (item == 0)
    {
        // mFbZ[WȗݒNA
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
    }
    if ((item != 0)&&(NNshParam->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}


/*-------------------------------------------------------------------------*/
/*   Function :   clearFeatureList                                         */
/*                                            Xg̈NA */
/*-------------------------------------------------------------------------*/
static void clearFeatureList(void)
{
    if (NNshGlobal->featureList != NULL)
    {
        // ẍ̗惍bN͂B
        while (NNshGlobal->featureLockCnt != 0)
        {
            MemHandleUnlock((NNshGlobal->featureList)->wordmemH);
            (NNshGlobal->featureLockCnt)--;
        }

        // @\ݒ胊Xg`Ăꍇ͗̈
        ReleaseWordList(NNshGlobal->featureList);
        MEMFREE_PTR(NNshGlobal->featureList);
        NNshGlobal->featureList = NULL;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   closeForm_NNsiSettings                                   */
/*                                        NNsiݒnʂ̃tH[ */
/*-------------------------------------------------------------------------*/
static void closeForm_NNsiSettings(UInt16 nextFormID)
{
    // Xg̈NA
    clearFeatureList();

    // ʑJڂ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm (nextFormID);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   createFeatureListStrings                                 */
/*                              XgO\[XꗗXg𐶐 */
/*-------------------------------------------------------------------------*/
static Err createFeatureListStrings(NNshWordList **lst, UInt16 strRscId)
{
    Err        ret;
    MemHandle  memH;
    Char      *ptr;

    // @\ꗗXg쐬ς݂Ȃ瑦
    if (*lst != NULL)
    {
        return (errNone);
    }

    // @\ꗗXg̊Ǘ̈mۂ
    *lst = MemPtrNew(sizeof(NNshWordList));
    if (*lst == NULL)
    {
        // ̈mۂɎs
        return (errNone);
    }
    MemSet(*lst, sizeof(NNshWordList), 0x00);

    // ꗗ@\Xg̎擾iXgO\[X擾j
    memH = DmGetResource('tSTR', strRscId);
    if (memH == 0)
    {
        return (~errNone);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        return (~errNone);
    }

    // XgO\[XXg`ɕ
    ret = SeparateWordList(ptr, *lst);
    if (ret != errNone)
    {
        // ̕ɎsAǗ̈JB
        MEMFREE_PTR(*lst);
    }
    MemHandleUnlock(memH);
    DmReleaseResource(memH);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   keyDownEvt_NNshSetting                                   */
/*                                                        L[͎̏ */
/*-------------------------------------------------------------------------*/
static Boolean keyDownEvt_NNshSetting(EventType *event)
{
    FormType *frm;
    UInt16    formID;
    Int16     move;

    // ݂̃tH[ID擾
    formID = FrmGetActiveFormID();

    // 5way navigatorpL[R[hRo[gAL[R[h𔻒肷
    switch (KeyConvertFiveWayToJogChara(event))
    {
      // n[hL[̏
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
        move = 1;
        break;

      // n[hL[̏
      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
        move = -1;
        break;

      // obN{^/ESCL[/BSL[Ƃ̏
      // case chrBackspace:
      case vchrJogBack:
      case chrEscape:
        if (formID != FRMID_NNSI_SETTING_ABSTRACT)
        {
            // NNsiݒʂ֑Jڂ
            closeForm_NNsiSettings(FRMID_NNSI_SETTING_ABSTRACT);
        }
        return (false);
        break;

      default: 
        return (false);
        break;
    }

    // ݊JĂtH[hcAɊJtH[肷
    frm = FrmGetActiveForm();
    switch (formID)
    {
      case FRMID_CONFIG_NNSH:
        effect_NNshSetting(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING2 : FRMID_NNSI_SETTING9;
        break;
      case FRMID_NNSI_SETTING2:
        effectNNsiSetting2(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING3 : FRMID_CONFIG_NNSH;
        break;
      case FRMID_NNSI_SETTING3:
        effectNNsiSetting3(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING4 : FRMID_NNSI_SETTING2;
        break;
      case FRMID_NNSI_SETTING4:
        effectNNsiSetting4(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING5 : FRMID_NNSI_SETTING3;
        break;
      case FRMID_NNSI_SETTING5:
        effectNNsiSetting5(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING6 : FRMID_NNSI_SETTING4;
        break;
      case FRMID_NNSI_SETTING6:
        effectNNsiSetting6(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING7 : FRMID_NNSI_SETTING5;
        break;
      case FRMID_NNSI_SETTING7:
        effectNNsiSetting7(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING8 : FRMID_NNSI_SETTING6;
        break;

      case FRMID_NNSI_SETTING8:
        effectNNsiSetting8(frm);
        formID = (move > 0) ? FRMID_NNSI_SETTING9 : FRMID_NNSI_SETTING7;
        break;

      case FRMID_NNSI_SETTING9:
        effectNNsiSetting9(frm);
        formID = (move > 0) ? FRMID_CONFIG_NNSH   : FRMID_NNSI_SETTING8;
        break;

      case FRMID_NNSI_SETTING_ABSTRACT:
      default:
        return (false);
        break;
    }

    // ʑJڂ
    closeForm_NNsiSettings(formID);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   setTitleHardKey                                          */
/*                                                        n[hL[̐ݒ */
/*-------------------------------------------------------------------------*/
static Boolean setTitleHardKey(Char *title, UInt16 data, UInt16 mask,
                               NNshHardkeyControl *info)
{
    Boolean    ret = false;
    FormType  *frm, *prevFrm;
    ListType  *lstP;
    UInt16     items[MINIBUF], *dataP, item;
    Char      *ptr;

    NNshListItem popList[] = {
        { POPTRID_LIST_MULTIUP,   LSTID_MULTIUP   },
        { POPTRID_LIST_MULTIDOWN, LSTID_MULTIDOWN },
        { POPTRID_LIST_HKEY1,     LSTID_HKEY1     },
        { POPTRID_LIST_HKEY2,     LSTID_HKEY2     },
        { POPTRID_LIST_HKEY3,     LSTID_HKEY3     },
        { POPTRID_LIST_HKEY4,     LSTID_HKEY4     },
        { POPTRID_LIST_JOGPUSH,   LSTID_JOGPUSH   },
        { POPTRID_LIST_JOGBACK,   LSTID_JOGBACK   },
        { POPTRID_LIST_CAPTURE,   LSTID_CAPTURE   },
        { 0, 0 }
    };                 

    // ݂̃tH[擾
    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    frm = FrmInitForm(FRMID_HARDKEY_SETTING);
    FrmSetActiveForm(frm);

    // EBhE^Cg̐ݒ
    FrmCopyTitle(frm, title);

    // ݂̃L[@\ݒe[uɊi[
    MemSet(items, sizeof(items), 0x00);
    dataP = items;
    *dataP = (info->up)&(mask);            // n[hL[̐ݒ
    dataP++;
    *dataP = (info->down)&(mask);          // n[hL[̐ݒ
    dataP++;
    *dataP = (info->key1)&(mask);          // n[hL[P̐ݒ
    dataP++;
    *dataP = (info->key2)&(mask);          // n[hL[Q̐ݒ
    dataP++;
    *dataP = (info->key3)&(mask);          // n[hL[R̐ݒ
    dataP++;
    *dataP = (info->key4)&(mask);          // n[hL[S̐ݒ
    dataP++;
    *dataP = (info->jogPush)&(mask);       // JOG PUSH̐ݒ
    dataP++;
    *dataP = (info->jogBack)&(mask);       // JOG BACK̐ݒ
    dataP++;
    *dataP = (info->clieCapture)&(mask);   // CLIE NXLv`{^̐ݒ
    dataP++;

    // @\ꗗXgbN
    ptr = MemHandleLock((NNshGlobal->featureList)->wordmemH);
    NNshWinSetPopItemsWithListArray(frm, popList, ptr,
                                    (NNshGlobal->featureList)->nofWord, items);

    // _CAO̕\
    if (FrmDoDialog(frm) == BTNID_HARDKEY_OK)
    {
        // n[hL[̐ݒ
        lstP     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIUP));
        item     = LstGetSelection(lstP);
        info->up = item | data;

        // n[hL[̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_MULTIDOWN));
        item       = LstGetSelection(lstP);
        info->down = item | data;

        // n[hL[P̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY1));
        item       = LstGetSelection(lstP);
        info->key1 = item | data;

        // n[hL[Q̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY2));
        item       = LstGetSelection(lstP);
        info->key2 = item | data;

        // n[hL[R̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY3));
        item       = LstGetSelection(lstP);
        info->key3 = item | data;

        // n[hL[S̐ݒ
        lstP       = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_HKEY4));
        item       = LstGetSelection(lstP);
        info->key4 = item | data;

        // WO_CPush{^
        lstP          = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_JOGPUSH));
        item          = LstGetSelection(lstP);
        info->jogPush = item | data;

        // WO_CBack{^
        lstP          = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_JOGBACK));
        item          = LstGetSelection(lstP);
        info->jogBack = item | data;

        // NX Capture{^
        lstP              = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_CAPTURE));
        item              = LstGetSelection(lstP);
        info->clieCapture = item | data;

        // DBXV邵
        NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

        ret = true;
    }

    // @\ꗗXg̃bN
    MemHandleUnlock((NNshGlobal->featureList)->wordmemH);

    // _CAO
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(frm);
    FrmDrawForm(prevFrm);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   selectOmitDialog                                         */
/*                                          mF_CAȌȗ(ڍאݒ) */
/*-------------------------------------------------------------------------*/
static Boolean selectOmitDialog(void)
{
    Boolean   ret = false;
    FormType *frm, *prevFrm;
    UInt16    status;

    // ݂̃`FbN{bNXݒƁANNsiݒϐ̊mFs
    UpdateParameter(FrmGetActiveForm(), CHKID_OMIT_DIALOG, &status);
    if ((status != 0)&&(NNshParam->confirmationDisable == 0))
    {
        // mFbZ[WȗݒSĐݒ肷
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
    }


    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    frm = FrmInitForm(FRMID_OMITDIALOG_DETAIL);
    FrmSetActiveForm(frm);

    // mF_CAOȗ
    if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_CONFIRM)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_CONFIRM, &status);
    }

    // x_CAO\Ȃ
    if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_WARNING)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_WARNING, &status);
    }

    // _CAO\Ȃ
    if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_INFORMATION)) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_OMITDIALOG_INFORMATION, &status);
    }

    // ڍ׃_CAO\
    if (FrmDoDialog(frm) == BTNID_OMITDIALOG_OK)
    {
        NNshParam->confirmationDisable = 0;

        // mFbZ[Wȗ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_CONFIRM, &status);
        if (status != 0)
        {
            NNshParam->confirmationDisable = 
                     NNshParam->confirmationDisable | NNSH_OMITDIALOG_CONFIRM;
        }

        // xbZ[W\Ȃ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_WARNING, &status);
        if (status != 0)
        {
            NNshParam->confirmationDisable = 
                     NNshParam->confirmationDisable | NNSH_OMITDIALOG_WARNING;
        }

        // 񃁃bZ[W\Ȃ
        status = 0;
        UpdateParameter(frm, CHKID_OMITDIALOG_INFORMATION, &status);
        if (status != 0)
        {
            NNshParam->confirmationDisable = 
                 NNshParam->confirmationDisable | NNSH_OMITDIALOG_INFORMATION;
        }
        ret = true;
    }

    // _CAO
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(frm);
    FrmDrawForm(prevFrm);

    return (ret);
}

/*=========================================================================*/
/*   Function :   Hander_NNshSetting                                       */
/*                                     NNsiݒn()Cxgnh  */
/*=========================================================================*/
Boolean Handler_NNshSetting(EventType *event)
{
    FormType    *frm;
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3, *chkObjSub4;
#ifdef USE_COLOR
    IndexedColorType color;
#endif
#ifdef USE_XML_OUTPUT
    Char        *locP;
#endif
    UInt16       formID;
    Err          ret;
    void        *effectFunc;

    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        return (NNsh_MenuEvt_Edit(event));
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        break;

      case keyDownEvent:
        // L[͂
        return (keyDownEvt_NNshSetting(event));
        break;

      default: 
        return (false);
        break;
    }

    effectFunc = NULL;
    formID     = FRMID_NNSI_SETTING_ABSTRACT;
    frm        = FrmGetActiveForm();

    // ɊJtH[ID̐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // "OK"{^ꂽƂ(NNsiݒʂɖ߂)
      case BTNID_CONFIG_NNSH_OK:
      case BTNID_NNSI_SET_OK:
      case BTNID_NNSISET3_OK:
      case BTNID_NNSISET4_OK:
      case BTNID_NNSISET5_OK:
      case BTNID_NNSISET6_OK:
      case BTNID_NNSISET7_OK:
      case BTNID_NNSISET8_OK:
      case BTNID_NNSISET9_OK:
        formID     = FRMID_NNSI_SETTING_ABSTRACT;
        break;

      // NNsiݒʂŁA"OK"/"Cancel"{^ꂽƂ(ꗗʂɖ߂)
      case BTNID_NNSISETA_OK:
      case BTNID_NNSISETA_CANCEL:
        formID     = FRMID_THREAD;
        break;

      // "1"{^ꂽƂ
      case NNSHSET2_1:
      case NNSHSET3_1:
      case NNSHSET4_1:
      case NNSHSET5_1:
      case NNSHSET6_1:
      case NNSHSET7_1:
      case NNSHSET8_1:
      case NNSHSET9_1:
      case SELTRID_NNSISET_NNSI:
        formID     = FRMID_CONFIG_NNSH;
        break;

      // "2"{^ꂽƂ
      case NNSHSET_2:
      case NNSHSET3_2:
      case NNSHSET4_2:
      case NNSHSET5_2:
      case NNSHSET6_2:
      case NNSHSET7_2:
      case NNSHSET8_2:
      case NNSHSET9_2:
      case SELTRID_NNSISET_THREAD:
        formID     = FRMID_NNSI_SETTING2; 
        break;

      // "3"{^ꂽƂ
      case NNSHSET_3:
      case NNSHSET2_3:
      case NNSHSET4_3:
      case NNSHSET5_3:
      case NNSHSET6_3:
      case NNSHSET7_3:
      case NNSHSET8_3:
      case NNSHSET9_3:
      case SELTRID_NNSISET_BUTTON:
        formID     = FRMID_NNSI_SETTING3; 
        break;

      // "4"{^ꂽƂ
      case NNSHSET_4:
      case NNSHSET2_4:
      case NNSHSET3_4:
      case NNSHSET5_4:
      case NNSHSET6_4:
      case NNSHSET7_4:
      case NNSHSET8_4:
      case NNSHSET9_4:
      case SELTRID_NNSISET_MESSAGE:
        formID     = FRMID_NNSI_SETTING4; 
        break;

      // "5"{^ꂽƂ
      case NNSHSET_5:
      case NNSHSET2_5:
      case NNSHSET3_5:
      case NNSHSET4_5:
      case NNSHSET6_5:
      case NNSHSET7_5:
      case NNSHSET8_5:
      case NNSHSET9_5:
      case SELTRID_NNSISET_WRITE:
        formID     = FRMID_NNSI_SETTING5;
        break;

      // "6"{^ꂽƂ
      case NNSHSET_6:
      case NNSHSET2_6:
      case NNSHSET3_6:
      case NNSHSET4_6:
      case NNSHSET5_6:
      case NNSHSET7_6:
      case NNSHSET8_6:
      case NNSHSET9_6:
      case SELTRID_NNSISET_JOG:
        formID     = FRMID_NNSI_SETTING6;
        break;

      // "7"{^ꂽƂ
      case NNSHSET_7:
      case NNSHSET2_7:
      case NNSHSET3_7:
      case NNSHSET4_7:
      case NNSHSET5_7:
      case NNSHSET6_7:
      case NNSHSET8_7:
      case NNSHSET9_7:
      case SELTRID_NNSISET_DEVICE:
        formID     = FRMID_NNSI_SETTING7;
        break;

      // "8"{^ꂽƂ
      case NNSHSET_8:
      case NNSHSET2_8:
      case NNSHSET3_8:
      case NNSHSET4_8:
      case NNSHSET5_8:
      case NNSHSET6_8:
      case NNSHSET7_8:
      case NNSHSET9_8:
      case SELTRID_NNSISET_LINE:
        formID     = FRMID_NNSI_SETTING8;
        break;

      // "9"{^ꂽƂ
      case NNSHSET_9:
      case NNSHSET2_9:
      case NNSHSET3_9:
      case NNSHSET4_9:
      case NNSHSET5_9:
      case NNSHSET6_9:
      case NNSHSET7_9:
      case NNSHSET8_9:
      case SELTRID_NNSISET_COMM:
        formID     = FRMID_NNSI_SETTING9;
        break;

#ifdef USE_COLOR
      case  SELTRID_COLOR_UNKNOWN:
        color = NNshParam->colorUnknown;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorUnknown = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_BACKGROUND:
        color = NNshParam->colorBackGround;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorBackGround = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_OVER:
        color = NNshParam->colorOver;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorOver = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NEW:
        color = NNshParam->colorNew;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorNew = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_UPDATE:
        color = NNshParam->colorUpdate;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorUpdate = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_REMAIN:
        color = NNshParam->colorRemain;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorRemain = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ALREADY:
        color = NNshParam->colorAlready;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorAlready = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NOTYET:
        color = NNshParam->colorNotYet;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorNotYet = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ERROR:
        color = NNshParam->colorError;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorError = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_UPDOWN:
        color = NNshParam->colorButton;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorButton = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_VIEW_COLOR_FG:
        // QƉʂ̕F
        color = NNshParam->colorViewFG;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorViewFG = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_VIEW_COLOR_BG:
        // QƉʂ̔wiF
        color = NNshParam->colorViewBG;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorViewBG = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

#endif

      // mF_CAOȗ
      case SELTRID_OMIT_DIALOG:
        // ڍאݒ
        if (selectOmitDialog() == true)
        {
	    if (NNshParam->confirmationDisable != 0)
            {
                formID = 1;
            }
            else
            {
                formID = 0;
            }
            SetControlValue(FrmGetActiveForm(), CHKID_OMIT_DIALOG, &formID);
            FrmDrawForm(FrmGetActiveForm());
        }
        return (false);
        break;

      case SELTRID_HIDE1_WORDSET:
        // NG[hPݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD1,
                        NNshParam->hideWord1, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_HIDE2_WORDSET:
        // NG[hQݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD2,
                        NNshParam->hideWord2, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_SET_LAUNCH_WORD:
        // NpX[hݒ
        DataInputDialog(NNSH_INPUTWIN_SETPASS, NNshParam->launchPass, PASSSIZE,
                        NNSH_DIALOG_USE_PASS, NULL);
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case SELTRID_NNSISET_IMPORT:
#ifdef USE_XML_OUTPUT
        // XMLt@C`NNsiݒt@C͂
        if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
        {
            // ǍVFS
            locP = "VFS";
        }
        else
        {
            // ǍPalm
            locP = "Palm";
        }
        // {Ɏ荞ނmFsB
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_IMPORT_XML, locP, 0) == 0)
        {
            // 荞݂̎s
            (void) Input_NNsiSet_XML(FILE_XML_NNSISET);
            NNsh_InformMessage(ALTID_INFO, MSG_INPUT_XML_DONE, "", 0);
        }
#endif
        // ʂJȂ
        break;

      case SELTRID_NNSISET_EXPORT:
#ifdef USE_XML_OUTPUT
        // XMLt@C`NNsiݒt@Co͂
        if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
        {
            // o͐VFS
            locP = "VFS";
        }
        else
        {
            // o͐Palm
            locP = "Palm";
        }
        // {ɏo͂邩mFsB
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_EXPORT_XML, locP, 0) == 0)
        {
            // o͂̎s
            ret = Output_NNsiSet_XML(FILE_XML_NNSISET);
            if (ret == errNone)
            {
                // o͏Iʒm
                NNsh_InformMessage(ALTID_INFO, MSG_OUTPUT_XML_DONE, "", 0);
            }
            else
            {
                // G[ʒm
                NNsh_InformMessage(ALTID_ERROR, MSG_OUTPUT_XML_ERROR, " Code:", ret);
            }
        }
#endif
        return (false);
        break;

      case SELTRID_USE_HARDKEY_VIEW:
        // Xg̃NA
        clearFeatureList();
      
        // ꗗʋ@\Xg̐ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREVIEWMSG_STRINGS);

        // ꗗʃn[hL[ڍאݒ
        (void) setTitleHardKey(NNSH_TITLE_HARDKEYVIEW_TITLE, MULTIVIEWBTN_FEATURE, 
                                MULTIVIEWBTN_FEATURE_MASK, &(NNshParam->viewFtr));

        //  ꕔn[hL[̐́ANNsiݒ̃n[hL[ݒ肪Kv
        // ƂxB
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_SETTING_HARDKEY, "", 0);
        return (true);
        break;

      case SELTRID_USE_HARDKEY_DETAIL:
        // Xg̃NA
        clearFeatureList();
      
        // ꗗʋ@\Xg̐ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREMSG_STRINGS);

        // ꗗʃn[hL[ڍאݒ
        (void) setTitleHardKey(NNSH_TITLE_HARDKEYSET_TITLE, MULTIBTN_FEATURE, 
                                MULTIBTN_FEATURE_MASK, &(NNshParam->ttlFtr));

        //  ꕔn[hL[̐́ANNsiݒ̃n[hL[ݒ肪Kv
        // ƂxB
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_SETTING_HARDKEY, "", 0);
        return (true);
        break;

      case SELTRID_HARDKEY_CONTROL:
        // Xg̃NA
        clearFeatureList();

        // n[hL[ݒ
        createFeatureListStrings(&(NNshGlobal->featureList), HARDKEY_CONTROL_STRINGS);

        (void) setTitleHardKey(NNSH_HARDKEYCONTROL_TITLE, HARDKEY_FEATURE, 
                               HARDKEY_FEATURE_MASK, &(NNshParam->useKey));
        if ((NNshParam->useKey.up      != 0)||
            (NNshParam->useKey.down    != 0)||
            (NNshParam->useKey.jogPush != 0)||
            (NNshParam->useKey.jogBack != 0))
        {
            // ݒs\ȍڂnmɂȂĂ̂ł̓NA
            NNsh_WarningMessage(ALTID_WARN, MSG_NOTSET_KEYITEM, "", 0);

            // Sf[^NA
            NNshParam->useKey.up      = 0;
            NNshParam->useKey.down    = 0;
            NNshParam->useKey.jogPush = 0;
            NNshParam->useKey.jogBack = 0;
        }

        // S̓IɃn[hL[̐̂Ȃ̂f
        if ((NNshParam->useKey.key1 != 0)||(NNshParam->useKey.key2 != 0)||
            (NNshParam->useKey.key3 != 0)||(NNshParam->useKey.key4 != 0)||
            (NNshParam->useKey.clieCapture != 0))
        {
            // n[hL[{ݒɕύX
            NNshParam->useHardKeyControl = 1;
        }
        else
        {
            // n[hL[{ȂݒɕύX
            NNshParam->useHardKeyControl = 0;
        }
        // DBXVꂽ
        NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
        return (true);
        break;

      // tH[JڂȂƂ
      default:
        // ȂɂȂ
        break;
    }

    // f֐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // NNsiݒ̊m
      case BTNID_CONFIG_NNSH_OK:
      case NNSHSET_2:
      case NNSHSET_3:
      case NNSHSET_4:
      case NNSHSET_5:
      case NNSHSET_6:
      case NNSHSET_7:
      case NNSHSET_8:
      case NNSHSET_9:
        effectFunc = &effect_NNshSetting;
        break;

      // NNsiݒ-2̊m
      case BTNID_NNSI_SET_OK:
      case NNSHSET2_1:
      case NNSHSET2_3:
      case NNSHSET2_4:
      case NNSHSET2_5:
      case NNSHSET2_6:
      case NNSHSET2_7:
      case NNSHSET2_8:
      case NNSHSET2_9:
        effectFunc = &effectNNsiSetting2;
        break;

      // NNsiݒ-3̊m
      case BTNID_NNSISET3_OK:
      case NNSHSET3_1:
      case NNSHSET3_2:
      case NNSHSET3_4:
      case NNSHSET3_5:
      case NNSHSET3_6:
      case NNSHSET3_7:
      case NNSHSET3_8:
      case NNSHSET3_9:
        effectFunc = &effectNNsiSetting3;
        break;

      // NNsiݒ-4̊m
      case BTNID_NNSISET4_OK:
      case NNSHSET4_1:
      case NNSHSET4_2:
      case NNSHSET4_3:
      case NNSHSET4_5:
      case NNSHSET4_6:
      case NNSHSET4_7:
      case NNSHSET4_8:
      case NNSHSET4_9:
        effectFunc = &effectNNsiSetting4;
        break;

      // NNsiݒ-5̊m
      case BTNID_NNSISET5_OK:
      case NNSHSET5_1:
      case NNSHSET5_2:
      case NNSHSET5_3:
      case NNSHSET5_4:
      case NNSHSET5_6:
      case NNSHSET5_7:
      case NNSHSET5_8:
      case NNSHSET5_9:
        effectFunc = &effectNNsiSetting5;
        break;

      // NNsiݒ-6̊m
      case BTNID_NNSISET6_OK:
      case NNSHSET6_1:
      case NNSHSET6_2:
      case NNSHSET6_3:
      case NNSHSET6_4:
      case NNSHSET6_5:
      case NNSHSET6_7:
      case NNSHSET6_8:
      case NNSHSET6_9:
        effectFunc = &effectNNsiSetting6;
        break;

      // NNsiݒ-7̊m
      case BTNID_NNSISET7_OK:
      case NNSHSET7_1:
      case NNSHSET7_2:
      case NNSHSET7_3:
      case NNSHSET7_4:
      case NNSHSET7_5:
      case NNSHSET7_6:
      case NNSHSET7_8:
      case NNSHSET7_9:
        effectFunc = &effectNNsiSetting7;
        break;

      // NNsiݒ-8̊m
      case BTNID_NNSISET8_OK:
      case NNSHSET8_1:
      case NNSHSET8_2:
      case NNSHSET8_3:
      case NNSHSET8_4:
      case NNSHSET8_5:
      case NNSHSET8_6:
      case NNSHSET8_7:
      case NNSHSET8_9:
        effectFunc = &effectNNsiSetting8;
        break;

      // NNsiݒ-9̊m
      case BTNID_NNSISET9_OK:
      case NNSHSET9_1:
      case NNSHSET9_2:
      case NNSHSET9_3:
      case NNSHSET9_4:
      case NNSHSET9_5:
      case NNSHSET9_6:
      case NNSHSET9_7:
      case NNSHSET9_8:
        effectFunc = &effectNNsiSetting9;
        break;

      // NNsiݒ(T)̊m
      case BTNID_NNSISETA_OK:
      case SELTRID_NNSISET_COMM:
      case SELTRID_NNSISET_LINE:
      case SELTRID_NNSISET_DEVICE:
      case SELTRID_NNSISET_JOG:
      case SELTRID_NNSISET_WRITE:
      case SELTRID_NNSISET_MESSAGE:
      case SELTRID_NNSISET_BUTTON:
      case SELTRID_NNSISET_THREAD:
      case SELTRID_NNSISET_NNSI:
        effectFunc = &effectNNsiSettingA;
        break;

      // "Cancel"{^ꂽƂ
      case BTNID_CONFIG_NNSH_CANCEL:
      case BTNID_NNSI_SET_CANCEL:
      case BTNID_NNSISET3_CANCEL:
      case BTNID_NNSISET4_CANCEL:
      case BTNID_NNSISET5_CANCEL:
      case BTNID_NNSISET6_CANCEL:
      case BTNID_NNSISET7_CANCEL:
      case BTNID_NNSISET8_CANCEL:
      case BTNID_NNSISET9_CANCEL:
      case BTNID_NNSISETA_CANCEL:
        effectFunc = NULL;
        break;

      case CHKID_USE_VFS:
        // VFS؂ւݒ𔽉f
        if (NNshParam->useVFS != NNSH_NOTSUPPORT_VFS)
        {
            // VFS  ON/OFF؂ւAʏVFSACeXVB
            chkObj   = FrmGetObjectPtr(frm,
                                       FrmGetObjectIndex(frm, CHKID_USE_VFS));
            chkObjSub1 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
            chkObjSub2 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
            chkObjSub3 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
            chkObjSub4 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
            if (CtlGetValue(chkObj) == 0)
            {
                CtlSetValue  (chkObjSub1, 0);
                CtlSetEnabled(chkObjSub1, false);
                CtlSetUsable (chkObjSub1, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetValue  (chkObjSub2, 0);
                CtlSetEnabled(chkObjSub2, false);
                CtlSetUsable (chkObjSub2, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetValue  (chkObjSub3, 0);
                CtlSetEnabled(chkObjSub3, false);
                CtlSetUsable (chkObjSub3, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));

                CtlSetValue  (chkObjSub4, 0);
                CtlSetEnabled(chkObjSub4, false);
                CtlSetUsable (chkObjSub4, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
		
                FrmEraseForm (frm);
            }
            else
            {
                CtlSetEnabled(chkObjSub1, true);
                CtlSetUsable (chkObjSub1, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetEnabled(chkObjSub2, true);
                CtlSetUsable (chkObjSub2, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetEnabled(chkObjSub3, true);
                CtlSetUsable (chkObjSub3, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));

                CtlSetEnabled(chkObjSub4, true);
                CtlSetUsable (chkObjSub4, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
            }
            FrmDrawForm(frm);
        }
        return (false);
        break;

      case CHKID_USE_BBS_NEWURL:
        // WURL`FbN{bNXꂽABBSꗗ擾WURLɕύX
        NNshWinSetFieldText(frm, FLDID_URL_BBS, true, URL_BBSTABLE, MAX_URL);
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_NEW, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_NEWURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      case CHKID_USE_BBS_OLDURL:
        // URL`FbN{bNXꂽƂABBSꗗ擾URLɕύX
        NNshWinSetFieldText(frm,FLDID_URL_BBS,true,URL_BBSTABLE_OLD, MAX_URL);
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_OLD, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_OLDURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      default:
        // LȊO(Ȃ)
        return (false);
        break;
    }

    // ݒ肳ꂽf[^𔽉f鏈
    if (effectFunc != NULL)
    {
        ret =  ((Err (*)())effectFunc)(frm);
        if (ret != errNone)
        {
            // ݒG[(ʂ͂̂܂)
            return (false);
        }
    }

    // ʑJڂ
    closeForm_NNsiSettings(formID);
    return (false);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting7                                    */
/*                                NNsiݒ-7(foCX֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting7(FormType  *frm)
{
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3, *chkObjSub4;
#ifdef USE_CLIE
    UInt16       dum;
#endif

#ifdef USE_ARMLET
    UInt32       processorType;

    // PalmOS5p@\gp
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMlet̎gp
        SetControlValue(frm, CHKID_USE_ARMLET, &(NNshParam->useARMlet));
    }
    else
#endif
    {
        // ARMlet̎gpɂāAݒ荀ڎ̂ʂɕ\Ȃ
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_USE_ARMLET));
        CtlSetUsable(chkObjSub1, false);

        NNshParam->useARMlet           = 0;
    }

#ifdef USE_CLIE
    // SilksȂ̕\ۃ`FbN
    if (NNshGlobal->silkVer != 0)
    {
        if (NNshGlobal->notUseSilk != 0)
        {
            dum = 1;
            SetControlValue(frm, CHKID_NOTUSE_SILK, &dum);
        }
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_NOTUSE_SILK));
        CtlSetUsable(chkObjSub1, false);
    }

    // SONYnC]sȂ
#ifdef USE_CLIE
    if ((NNshGlobal->notUseHR != 0)||(NNshGlobal->hrRef != 0))
    {
        if (NNshParam->disableSonyHR != 0)
        {
            dum = 1;
        }
        else
        {
            dum = 0;
        }
        SetControlValue(frm, CHKID_NOTUSE_SONYHIRES, &dum);
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, 
                                                  CHKID_NOTUSE_SONYHIRES));
        CtlSetUsable(chkObjSub1, false);
    }

    // VFS p\ɎIVFS ON
    SetControlValue(frm, CHKID_VFSON_AUTOMATIC,&(NNshParam->vfsOnAutomatic));

    // IVFS ONłDB`FbNȂ
    SetControlValue(frm, CHKID_VFSON_NOTDBCHK,&(NNshParam->vfsOnNotDBCheck));

    // uVFS̎gpv͂P̃p[^ŕ̈ӖLĂ邽
    chkObj     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
    chkObjSub1 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
    chkObjSub2 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
    chkObjSub3 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
    chkObjSub4 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DBIMPORT));
    switch (NNshParam->useVFS)
    {
      // VFST|[g@̏ꍇAuVFS̎gpvݒ͕\ȂB
      case NNSH_NOTSUPPORT_VFS:
        CtlSetUsable(chkObj,     false);
        CtlSetUsable(chkObjSub1, false);
        CtlSetUsable(chkObjSub2, false);
        CtlSetUsable(chkObjSub3, false);
        CtlSetUsable(chkObjSub4, false);
        break;

      // VFS̃`FbN
      case NNSH_VFS_DISABLE:
        CtlSetValue  (chkObj,     NNSH_VFS_DISABLE);
        CtlSetValue  (chkObjSub1, 0);
        CtlSetUsable (chkObjSub1, false);

        CtlSetValue  (chkObjSub2, 0);
        CtlSetUsable (chkObjSub2, false);

        CtlSetValue  (chkObjSub3, 0);
        CtlSetUsable (chkObjSub3, false);

        CtlSetValue  (chkObjSub4, 0);
        CtlSetUsable (chkObjSub4, false);
        break;

      case NNSH_VFS_ENABLE:
      default:
        CtlSetValue  (chkObj,     NNSH_VFS_ENABLE);
        CtlSetUsable (chkObjSub1, true);
        CtlSetValue  (chkObjSub1, (NNSH_VFS_WORKAROUND & NNshParam->useVFS));

        CtlSetUsable (chkObjSub2, true);
        CtlSetValue  (chkObjSub2, (NNSH_VFS_USEOFFLINE & NNshParam->useVFS));

        CtlSetUsable (chkObjSub3, true);
        CtlSetValue  (chkObjSub3, (NNSH_VFS_DBBACKUP & NNshParam->useVFS));

        CtlSetUsable (chkObjSub4, true);
        CtlSetValue  (chkObjSub4, (NNSH_VFS_DBIMPORT & NNshParam->useVFS));
        break;
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting8                                    */
/*                                    NNsiݒ-8(ʐM֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting8(FormType  *frm)
{
    UInt16       timeout;
    Char         numBuf[TINYBUF];

    // ProxyoRł̃ANZX
    SetControlValue(frm, CHKID_USE_PROXY, &(NNshParam->useProxy));

    // Proxy URL
    if (NNshParam->proxyURL[0] != '\0')
    { 
        NNshWinSetFieldText(frm, FLDID_USE_PROXY, false,
                            NNshParam->proxyURL, MAX_URL);
    }

    // Proxy Port #
    if (NNshParam->proxyPort != 0)
    {
        MemSet (numBuf, sizeof(numBuf), 0x00);
        StrIToA(numBuf, NNshParam->proxyPort);
        NNshWinSetFieldText(frm,FLDID_PROXY_PORT, false, numBuf, TINYBUF);
    }

    // tB[hɌ݂̃^CAEgl𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    timeout = SysTicksPerSecond();
    timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
    StrIToA(numBuf, (NNshParam->netTimeout / timeout));
    NNshWinSetFieldText(frm,FLDID_COMM_TIMEOUT, false, numBuf, TINYBUF);

    // tB[hɌ݂̃obt@TCY𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, NNshParam->bufferSize);
    NNshWinSetFieldText(frm,FLDID_BUFFER_SIZE,false,numBuf, TINYBUF);

    // tB[hɌ݂̕擾TCY𔽉f
    MemSet(numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, NNshParam->partGetSize);
    NNshWinSetFieldText(frm,FLDID_DL_PARTSIZE,false,numBuf, TINYBUF);


    // tB[hɒʐM^CAEggC񐔂𔽉f
    MemSet (numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, NNshParam->nofRetry);
    NNshWinSetFieldText(frm,FLDID_TIMEOUT_RETRY,false,numBuf,sizeof(numBuf));

    // _E[hwʂɔf
    SetControlValue(frm, CHKID_DL_PART, &(NNshParam->enablePartGet));

    // BBSꗗ㏑
    SetControlValue(frm, CHKID_BBS_OVERWRITE, &(NNshParam->bbsOverwrite));

    // BBSꗗ擾URL̐ݒ
    NNshWinSetFieldText(frm, FLDID_URL_BBS, true, NNshParam->bbs_URL, MAX_URL);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting5                                    */
/*                                NNsiݒ-5(݉)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting5(FormType  *frm)
{
    Char         numBuf[TINYBUF];

    // ݉ʏIXŕۑ
    SetControlValue(frm, CHKID_WRITE_AUTOSAVE,
                                       &(NNshParam->writeMessageAutoSave));

    // ݎPUSH{^𖳌
    SetControlValue(frm, CHKID_WRITEPUSH_DISABLE,
                                        &(NNshParam->writeJogPushDisable));

    // MCookiegpď
    SetControlValue(frm, CHKID_WRITE_USE_COOKIE, &(NNshParam->useCookieWrite));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    SetControlValue(frm, CHKID_NOT_AUTOFOCUSSET,&(NNshParam->notAutoFocus));

    // ݎAA_[COFFɂ
    SetControlValue(frm, CHKID_UNDERLINE_WRITE,
                    &(NNshParam->disableUnderlineWrite));

    // ݎQƃXԍ}
    SetControlValue(frm, CHKID_INSERT_REPLYNUM, &(NNshParam->insertReplyNum));

    // ݃V[PXPART2
    SetControlValue(frm, CHKID_WRITE_SEQUENCE2, &(NNshParam->writeSequence2));

    // sage
    SetControlValue(frm, CHKID_WRITE_SAGE,  &(NNshParam->writeAlwaysSage));

    // Ren@\gpݒʂɔf
    SetControlValue(frm, CHKID_FIXED_HANDLE, &(NNshParam->useFixedHandle));

    // nh̐ݒ
    if (NNshParam->handleName[0] != '\0')
    { 
      NNshWinSetFieldText(frm, FLDID_HANDLENAME, false,
                            NNshParam->handleName, BUFSIZE);
    }

    // tB[hɏ݃obt@TCY
    MemSet (numBuf, sizeof(numBuf), 0x00);
    StrIToA(numBuf, NNshParam->writeBufferSize);
    NNshWinSetFieldText(frm,FLDID_WRITEBUF_SIZE, true, numBuf, TINYBUF);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting6                                    */
/*                                  NNsiݒ-6(WO֘A)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting6(FormType  *frm)
{

    // QƎJumpListɁuꗗցv
    SetControlValue(frm, CHKID_ADD_RTNTOLIST, &(NNshParam->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    SetControlValue(frm,CHKID_ADD_BACKMESSAGE,&(NNshParam->addMenuBackRtnMsg));

    // QƎJumpListɁuj[v
    SetControlValue(frm, CHKID_ADD_OPENMENU, &(NNshParam->addMenuMsg));

    // QƎJumpListɁu擾v
    SetControlValue(frm, CHKID_ADD_GETPART, &(NNshParam->addLineGetPart));

    // QƎJumpListɁuؒfv
    SetControlValue(frm, CHKID_ADD_LINEDISCONN, &(NNshParam->addLineDisconn));

    // QƎJumpListɐ擪
    SetControlValue(frm, CHKID_ADD_JUMPTOP, &(NNshParam->addJumpTopMsg));

    // QƎJumpListɖ
    SetControlValue(frm, CHKID_ADD_JUMPBOTTOM, &(NNshParam->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    SetControlValue(frm, CHKID_ADD_OPENWEB, &(NNshParam->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    SetControlValue(frm, CHKID_ADD_GRAPHVIEW, &(NNshParam->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    SetControlValue(frm, CHKID_ADD_FAVORITE, &(NNshParam->addMenuFavorite));

    // QƎJumpListɃo
    SetControlValue(frm,CHKID_ADD_OUTPUTMEMO,&(NNshParam->addMenuOutputMemo));

    // ꗗMenuɃj[ǉ
    SetControlValue(frm, CHKID_ADD_MENUOPEN, &NNshParam->addMenuTitle);

    // ꗗMenuɎQCOPY
    SetControlValue(frm, CHKID_ADD_MENUCOPY, &NNshParam->addMenuCopyMsg);

    // ꗗMenuMSG폜
    SetControlValue(frm, CHKID_ADD_MENUDELETE, &NNshParam->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    SetControlValue(frm,CHKID_ADD_MENUGRAPHMODE,&NNshParam->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    SetControlValue(frm, CHKID_ADD_MENUMULTISW1, &NNshParam->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    SetControlValue(frm, CHKID_ADD_MENUMULTISW2, &NNshParam->addMenuMultiSW2);

    // ꗗMenuNNsiI
    SetControlValue(frm, CHKID_ADD_NNSIEND, &NNshParam->addMenuNNsiEnd);

    // ꗗMenuɃfoCX
    SetControlValue(frm, CHKID_ADD_MENUDEVICEINFO, &NNshParam->addMenuDeviceInfo);

    // QƎMenuɃfoCX
    SetControlValue(frm, CHKID_ADD_DEVICEINFO, &NNshParam->addDeviceInfo);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNshSetting                                     */
/*                                      NNsiݒ(NNsi)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNshSetting(FormType *frm)
{
    ControlType *ctlObj;
    ListType    *lstP;
    UInt16       item;
    Char        *ptr;

    // QƐpփRs[ƂAɃX폜{
    SetControlValue(frm, CHKID_COPYDEL_READONLY,&(NNshParam->copyDelReadOnly));


    // URL擾AL`FbNȂ
    SetControlValue(frm, CHKID_NOTCHECK_BBSURL,&(NNshParam->notCheckBBSURL));

    // ړɖ擾X폜
    SetControlValue(frm, CHKID_AUTODEL_NOT_YET,&(NNshParam->autoDeleteNotYet));

    // Ji𔼊pSpϊ
    SetControlValue(frm,CHKID_CONVERT_HANZEN, &(NNshParam->convertHanZen));

    // OfflineXɃX{Ȃ
    SetControlValue(frm, CHKID_NOT_DELOFFLINE, &(NNshParam->notDelOffline));

    // Cɓ\ŒXx̃xݒ(ƃXgACeݒ)
    switch (NNshParam->displayFavorLevel)
    {
      case NNSH_MSGATTR_FAVOR_L2:
        item = 1;
        ptr  = NNSH_ATTRLABEL_FAVOR_L2;
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        item = 2;
        ptr  = NNSH_ATTRLABEL_FAVOR_L3;
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        item = 3;
        ptr  = NNSH_ATTRLABEL_FAVOR_L4;
        break;

      case NNSH_MSGATTR_FAVOR:
        item = 4;
        ptr  = NNSH_ATTRLABEL_FAVOR;
        break;

      case NNSH_MSGATTR_FAVOR_L1:
      default:
        item = 0;
        ptr  = NNSH_ATTRLABEL_FAVOR_L1;
        break;
    }

    ctlObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_FAVOR_LEVEL));
    CtlSetLabel(ctlObj, ptr);

    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    LstSetSelection(lstP, item);
    LstSetTopItem  (lstP, item);


    /***  NNshݒ(O[oϐ)f  ***/

    // mFbZ[Wȗ
    SetControlValue(frm, CHKID_OMIT_DIALOG, &(NNshParam->confirmationDisable));

    // ɁA啶ʂȂ
    SetControlValue(frm, CHKID_SEARCH_CASELESS, &(NNshParam->searchCaseless));

    // NOfflineX
    SetControlValue(frm, CHKID_OFFCHK_LAUNCH,   &(NNshParam->offChkLaunch));

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting2                                    */
/*                                    NNsiݒ-2(ꗗ)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting2(FormType  *frm)
{
    ControlType *ctlObj;

    // Xꗗ(subject.txt)S擾
    SetControlValue(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

    // Xꗗʂtiny/smalltHggp
    SetControlValue(frm,CHKID_CLIE_USE_TITLE,
                                     &(NNshParam->useSonyTinyFontTitle));

    // X^CgdȂ
    SetControlValue(frm, CHKID_CHECK_DUPLICATE,&(NNshParam->checkDuplicateThread));

    // XꗗMSG
    SetControlValue(frm, CHKID_PRINT_NOFMSG,&(NNshParam->printNofMessage));


    // 擾ςݑSĂ͎QƐpOɕ\Ȃ
    SetControlValue(frm, CHKID_NOT_READONLY, &(NNshParam->notListReadOnly));

    // X擾ɃXQ
    SetControlValue(frm, CHKID_OPEN_AUTO,   &(NNshParam->openAutomatic));


#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        SetControlValue(frm, CHKID_USE_COLORMODE, &(NNshParam->useColor));

        // {́AZN^gK̃LvVɐF...
        // i悭킩̂ŏȗj
    }
    else
#endif
    {
        NNshParam->useColor = 0;

        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        FrmCopyLabel(frm, LBL_SEL_COLOR, "  ");

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_COLORMODE));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, SELTRID_COLOR_UNKNOWN));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                            FrmGetObjectIndex(frm, SELTRID_COLOR_BACKGROUND));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_OVER));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NEW));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_UPDATE));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_REMAIN));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, SELTRID_COLOR_ALREADY));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NOTYET));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_ERROR));
        CtlSetUsable(ctlObj, false);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting3                                    */
/*                                  NNsiݒ-3(ꗗ{^)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting3(FormType  *frm)
{
    UInt16       selItem;

    // ꗗʋ@\Xg̐ݒ
    createFeatureListStrings(&(NNshGlobal->featureList), MULTIBTN_FEATUREMSG_STRINGS);

    // ݂̃tH[ւ̃|C^擾
    frm = FrmGetActiveForm();

    // ړIXCb`P(ꗗ)̃xݒ(ƃXgACeݒ)
    selItem = 
             NNshParam->usageOfTitleMultiSwitch1 & (NNSH_SWITCHUSAGE_FUNCMASK);
    NNshWinSetPopItems(frm, POPTRID_LIST_FUNCSW1, LSTID_TITLE_FUNCSW1, selItem);

    // ړIXCb`Q(ꗗ)̃xݒ(ƃXgACeݒ)
    selItem = 
             NNshParam->usageOfTitleMultiSwitch2 & (NNSH_SWITCHUSAGE_FUNCMASK);
    NNshWinSetPopItems(frm, POPTRID_LIST_FUNCSW2,LSTID_TITLE_FUNCSW2,selItem);

    // ړI{^P̐ݒʂɔf
    selItem = (NNshParam->multiBtn1Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN1, LSTID_MULTIBTN1,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN1, false,
                        NNshParam->multiBtn1Caption, MAX_CAPTION);

    // ړI{^Q̐ݒʂɔf
    selItem = (NNshParam->multiBtn2Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN2, LSTID_MULTIBTN2,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN2, false,
                        NNshParam->multiBtn2Caption, MAX_CAPTION);

    // ړI{^R̐ݒʂɔf
    selItem = (NNshParam->multiBtn3Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN3, LSTID_MULTIBTN3,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN3, false,
                        NNshParam->multiBtn3Caption, MAX_CAPTION);

    // ړI{^S̐ݒʂɔf
    selItem = (NNshParam->multiBtn4Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN4, LSTID_MULTIBTN4,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN4, false,
                        NNshParam->multiBtn4Caption, MAX_CAPTION);

    // ړI{^T̐ݒʂɔf
    selItem = (NNshParam->multiBtn5Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN5, LSTID_MULTIBTN5,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN5, false,
                        NNshParam->multiBtn5Caption, MAX_CAPTION);

    // ړI{^U̐ݒʂɔf
    selItem = (NNshParam->multiBtn6Feature)&(MULTIBTN_FEATURE_MASK);
    NNshWinSetPopItemsWithList(frm, POPTRID_LIST_MULTIBTN6, LSTID_MULTIBTN6,
                               NNshGlobal->featureList, selItem);
    (NNshGlobal->featureLockCnt)++;

    NNshWinSetFieldText(frm, FLDID_MULTIBTN6, true,
                        NNshParam->multiBtn6Caption, MAX_CAPTION);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting9                                    */
/*                                   NNsiݒ-9(V/)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting9(FormType  *frm)
{
    Err          ret;
    UInt16       lp;
    ControlType *chkObj;

    // NNsiIɉؒf
    SetControlValue(frm, CHKID_END_OFFLINE, &(NNshParam->disconnectNNsiEnd));

    // uVmFvIɉؒf
    SetControlValue(frm,CHKID_DISCONN_ARRIVAL,&(NNshParam->disconnArrivalEnd));

    // uVmFvIɖǈꗗ\
    SetControlValue(frm, CHKID_ARRIVAL_NOTREAD, &(NNshParam->autoOpenNotRead));

    // ڑ͎擾\
    SetControlValue(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // ڑʂĕ`
    SetControlValue(frm,CHKID_REDRAW_CONNECT,&(NNshParam->redrawAfterConnect));

    // ܂BBS/@JBBSVmF
    SetControlValue(frm, CHKID_HTMLBBS_ENABLE,
                                        &(NNshParam->enableNewArrivalHtml));

    // VG[ɂȂ΍Ď擾
    SetControlValue(frm, CHKID_ALLUPDATE_ABORT,
                                             &(NNshParam->autoUpdateGetError));

    // BBSꗗ̍쐬
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret == errNone)
    {
        // BBSꗗ̃XgԂ𔽉fB
        NNshWinSetListItems(frm, LSTID_CHECK_NEWARRIVAL,
                            NNshGlobal->bbsTitles, lp,
                            NNshParam->newArrivalNotRead,
                            &(NNshGlobal->bbsTitleH), NULL);

        // |bvAbvgK̃x(XgԂɍ킹)XV
        NNshWinSetPopItems(frm, POPTRID_NEWARRIVAL, LSTID_CHECK_NEWARRIVAL,
                           NNshParam->newArrivalNotRead);
    }

    // i-modepURLgp
    SetControlValue(frm, CHKID_USE_IMODEURL, &(NNshParam->useImodeURL));

    // WebBrowserJƂŐV50
    if (NNshGlobal->browserCreator != 0)
    {
        if (NNshParam->browseMesNum != 0)
        {
            lp = 1;
            SetControlValue(frm, CHKID_WEBBROWSE_LAST50, &lp);
        }
    }
    else
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObj = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_WEBBROWSE_LAST50));
        CtlSetUsable(chkObj, false);
    }

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting4                                    */
/*                                    NNsiݒ-4(QƉ)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting4(FormType  *frm)
{
    ControlType *ctlObj;

    // ݒ@\gp
    SetControlValue(frm, CHKID_USE_BOOKMARK,&(NNshParam->useBookmark));

    // Xԍyzɂ
    SetControlValue(frm, CHKID_BOLD_MSGNUM, &(NNshParam->boldMessageNum));

    // QƎOtBbN`惂[hgp
    SetControlValue(frm,CHKID_CLIE_USE_TINYFONT,&(NNshParam->useSonyTinyFont));

    // QƎA_[COFF
    SetControlValue(frm, CHKID_MSG_LINEOFF, &(NNshParam->disableUnderline));

    // PUSH ON_CŁ}P
    SetControlValue(frm, CHKID_NOT_CURSOR, &(NNshParam->notCursor));

    // XQƉʂŃJ[\\Ȃ
    SetControlValue(frm, CHKID_NOT_FOCUSSET_NUM,
                                               &(NNshParam->notFocusNumField));

    // QƎX][ŕ\
    SetControlValue(frm,CHKID_BLOCK_DISP_MODE, &(NNshParam->blockDispMode));

    // QƎOɈړőOX
    SetControlValue(frm, CHKID_DISPLAY_BOTTOMMES, &(NNshParam->dispBottom));

    // NGmF
    SetControlValue(frm, CHKID_HIDE_MESSAGE, &(NNshParam->hideMessage));

    // NG[hݒŐK\gp
    SetControlValue(frm, CHKID_USE_REGEXPRESS,
                                        &(NNshParam->useRegularExpression));

#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        // SetControlValue(frm, CHKID_USE_COLORMODE, &(NNshParam->useColor));

        // {́AZN^gK̃LvVɐF...
        // i悭킩̂ŏȗj
    }
    else
#endif
    {
        NNshParam->useColor = 0;

        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        FrmCopyLabel(frm, LBL_SEL_VIEW_COLOR, "  ");

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_VIEW_COLOR_FG));
        CtlSetUsable(ctlObj, false);

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_VIEW_COLOR_BG));
        CtlSetUsable(ctlObj, false);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSettingA                                    */
/*                                          NNsiݒ(T)̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSettingA(FormType  *frm)
{
    ControlType *ctlObj;

#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        SetControlValue(frm, CHKID_USE_TITLE_COLOR, &(NNshParam->useColor));
    }
    else
#endif
    {
        // J[̐ݒ͕\Ȃ
        NNshParam->useColor = 0;
        ctlObj = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_USE_TITLE_COLOR));
        CtlSetUsable(ctlObj, false);
    }

#ifdef USE_XML_OUTPUT
#else
    // XML`o͂Ȃꍇ́ANNsiݒ Import/Exportw͕\ȂB
    FrmHideObject(frm, FrmGetObjectIndex(frm, LBL_NNSISET_XML));

    ctlObj = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm, SELTRID_NNSISET_IMPORT));
    CtlSetUsable(ctlObj, false);

    ctlObj = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm, SELTRID_NNSISET_EXPORT));
    CtlSetUsable(ctlObj, false);
#endif

    // DEBUG
    SetControlValue(frm, CHKID_DEBUG_DIALOG,&(NNshParam->debugMessageON));

    // Xꗗ(subject.txt)S擾
    SetControlValue(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

    // i-modepURLgp
    SetControlValue(frm, CHKID_USE_IMODEURL, &(NNshParam->useImodeURL));

    // QƎX][ŕ\
    SetControlValue(frm,CHKID_BLOCK_DISP_MODE, &(NNshParam->blockDispMode));

    // ڑ͎擾\
    SetControlValue(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // ܂BBS/@JBBSVmF
    SetControlValue(frm, CHKID_HTMLBBS_ENABLE,
                                        &(NNshParam->enableNewArrivalHtml));

    // mFbZ[Wȗ
    SetControlValue(frm, CHKID_OMIT_DIALOG, &(NNshParam->confirmationDisable));

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   closeForm_FavorTabSet                                    */
/*                                    Cɓݒ̃tH[ */
/*-------------------------------------------------------------------------*/
static void closeForm_FavorTabSet(UInt16 nextForm)
{
    if (NNshGlobal->listHandle != 0)
    {
        MemHandleUnlock(NNshGlobal->listHandle);
        MemHandleFree  (NNshGlobal->listHandle);
        NNshGlobal->listHandle = 0;
    }
    FrmGotoForm(nextForm);
    return;
}

/*=========================================================================*/
/*   Function :   OpenForm_FavorTabSet                                     */
/*                                      Cɓݒ̃tH[J */
/*=========================================================================*/
Err OpenForm_FavorTabSet(FormType *frm)
{
    Err            ret;
    Char          *ptr;
    UInt16         status, lp, bbsCond, thLevel, thrCond, allCond;
    NNshCustomTab *customTab;

    status = 1;
    if (NNshGlobal->jumpSelection != MULTIBTN_FEATURE_USER2TAB)
    {
        // [U^uPݒ
        SetControlValue(frm, PBTNID_FAVORSET_TAB1, &status);
        customTab = &(NNshParam->custom1);
    }
    else
    {
        // [U^uQݒ
        SetControlValue(frm, PBTNID_FAVORSET_TAB2, &status);
        customTab = &(NNshParam->custom2);
    }
    thLevel = customTab->threadLevel & NNSH_THREADLEVEL_MASK;
    thrCond = 
      (customTab->threadLevel & NNSH_THREADCOND_MASK) >> NNSH_THREADCOND_SHIFT;
    allCond = customTab->condition & NNSH_CONDITION_ALL;
    bbsCond = customTab->boardCondition;

    // QƐpO͏O
    status  = customTab->condition & NNSH_CONDITION_NOTREADONLY;
    if (status != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_NOT_READONLY, &status);
    }

    // [U^utB[hɔf
    NNshWinSetFieldText(frm, FLDID_FAVORSET_TABTITLE, false,
                        customTab->tabName, StrLen(customTab->tabName));

    // BBSꗗ̍쐬
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret == errNone)
    {
        // BBSꗗ̃XgԂ𔽉fB(VmF{^u)
        NNshWinSetListItems(frm, LSTID_FAVORSET_CHECKNEW,
                            NNshGlobal->bbsTitles, lp,
                            customTab->newArrival, 
                            &(NNshGlobal->listHandle),
                            &ptr);

        NNshWinSetPopItems(frm, POPTRID_FAVORSET_CHECKNEW,
                           LSTID_FAVORSET_CHECKNEW, customTab->newArrival);

        // BBSꗗ̃XgԂ𔽉fB(ꗗ擾^u)
        NNshWinUpdateListItems(frm, LSTID_FAVORSET_GETLIST, ptr, lp,
                               customTab->getList);

	NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETLIST,
                           LSTID_FAVORSET_GETLIST, customTab->getList);


        // BBSꗗ̃XgԂ𔽉fB(ݒ^u)
        NNshWinUpdateListItems(frm, LSTID_FAVORSET_BBSNICK, ptr, lp,
                               customTab->boardNick);

	NNshWinSetPopItems(frm, POPTRID_FAVORSET_BBSNICK,
                           LSTID_FAVORSET_BBSNICK, customTab->boardNick);
    }

    // ݒ̏l𔽉f
    if (bbsCond != 0)
    {
        // ݒ̃`FbN߂
        SetControlValue(frm, CHKID_FAVORSET_BBSNICK, &(bbsCond));
        bbsCond--;
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_BBSNICK_SET,
                           LSTID_FAVORSET_BBSNICK_SET, bbsCond);
    }

    status = 1;
    if (thrCond != 0)
    {
        // Xx̃`FbN{bNXf
        SetControlValue(frm, CHKID_FAVORSET_LEVEL, &(status));

        // Xx̏f
        thrCond--;
	NNshWinSetPopItems(frm, POPTRID_FAVORSET_LVL_SET, 
                           LSTID_FAVORSET_LVL_SET, thrCond);
    }

    // Xx̔f
    switch (thLevel)
    {
      case NNSH_MSGATTR_FAVOR_L1:
        SetControlValue(frm, PBTNID_FAVORSET_LVL1, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L2:
        SetControlValue(frm, PBTNID_FAVORSET_LVL2, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        SetControlValue(frm, PBTNID_FAVORSET_LVL3, &(status));
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        SetControlValue(frm, PBTNID_FAVORSET_LVL4, &(status));
        break;

      case NNSH_MSGATTR_FAVOR:
        SetControlValue(frm, PBTNID_FAVORSET_LVL5, &(status));
        break;

      case NNSH_MSGATTR_NOTFAVOR:
      default:
        // wȂ
        SetControlValue(frm, PBTNID_FAVORSET_LVL0, &(status));
        break;
    }

    // AND/ORݒ
    NNshWinSetPopItems(frm, POPTRID_FAVORSET_CONDITIONSET,
                       LSTID_FAVORSET_CONDITIONSET, allCond);

    // Oʒu̎w
    status = (customTab->condition & NNSH_CONDITION_LOGLOC_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_LOGLOC_PALM)
        {
            // Palm
            allCond = 0;
        }
        else
        {
            // VFS
            allCond = 1;
        }

        // Oʒũ`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_LOGLOC, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_LOGLOC_SET,
                           LSTID_FAVORSET_LOGLOC_SET, allCond);
    }

    // 擾G[̐ݒ
    status = (customTab->condition & NNSH_CONDITION_GETERR_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_GETERR_NONE)
        {
            // G[Ȃ
            allCond = 0;
        }
        else
        {
            // G[
            allCond = 1;
        }

        // Oʒũ`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETERROR, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETERROR_SET,
                           LSTID_FAVORSET_GETERROR_SET, allCond);
    }

    // 擾ۗ̐ݒ
    status = (customTab->condition & NNSH_CONDITION_GETRSV_ALL);
    if (status != 0)
    {

        if (status == NNSH_CONDITION_GETRSV_RSV)
        {
            // 擾ۗX
            allCond = 0;
        }
        else
        {
            // 擾ۗX
            allCond = 1;
        }

        // 擾ۗ̃`FbN{bNX𔽉f
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETRESERVE, &(status));

        // XgXV
        NNshWinSetPopItems(frm, POPTRID_FAVORSET_GETRESERVE_SET,
                           LSTID_FAVORSET_GETRESERVE_SET, allCond);
    }

    // XԂ̃`FbN{bNXݒ
    if ((customTab->threadStatus != 0)||(customTab->threadCreate))
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_GETSTATUS, &(status));
    }
    // XԂ̃`FbN{bNXݒ
    if ((customTab->stringSet & NNSH_STRING_SELECTION) != 0)
    {
        status = 1;
        SetControlValue(frm, CHKID_FAVORSET_TITLESET, &(status));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   Hander_FavorTabSet                                       */
/*                                     CɓݒCxgnh  */
/*=========================================================================*/
Boolean Handler_FavorTabSet(EventType *event)
{
    UInt16         btnId, status;
    MemHandle      txtH;
    Char          *ptr, numBuf[TINYBUF];
    FormType      *frm, *diagFrm;
    NNshCustomTab *custom;
    ListType      *lstP;
    FieldType     *fldP;

    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case ctlSelectEvent:
        // {^ꂽ(֐i)
        break;

      case menuEvent:
        // j[Jꂽ
      default: 
        return (false);
        break;
    }

    frm = FrmGetActiveForm();
    switch (event->data.ctlSelect.controlID)
    {
      // 擾Ԃ̐ݒ
      case SELTRID_FAVORSET_GETSTATUS:
        if (NNshGlobal->jumpSelection == MULTIBTN_FEATURE_USER1TAB)
        {
            custom = &(NNshParam->custom1);
        }
        else
        {
            custom = &(NNshParam->custom2);
        }
        diagFrm  = FrmInitForm(FRMID_FAVORSET_THREADSTATE);
        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_NEW) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NEWGET,     &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_UPDATE) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_PARTGET,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_REMAIN) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NOTREAD,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_ALREADY) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ALREADY,    &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_OVER) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_UPPERLIMIT, &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_NOT_YET) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_NOTYET,     &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_GETERROR) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ERROR,      &status);

        status = ((custom->threadStatus >> NNSH_SUBJSTATUS_UNKNOWN) & 1);
        SetControlValue(diagFrm, CHKID_FAVORSET_ST_ETC,        &status);

        // Xē n ȍ~̃f[^f
        status = custom->threadCreate;
        SetControlValue(diagFrm, CHKID_THREAD_DATE, &status);
		if (status != 0)
		{
            MemSet (numBuf, TINYBUF, 0x00);
            NUMCATI(numBuf, status);
            NNshWinSetFieldText(diagFrm, 
                                FLDID_THREAD_DATE, false, numBuf, TINYBUF);
		}

        FrmSetActiveForm(diagFrm);
        btnId = FrmDoDialog(diagFrm);
        if (btnId == BTNID_FAVORSET_ST_OK)
        {
            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NEWGET,     &status);
            custom->threadStatus = (status << NNSH_SUBJSTATUS_NEW);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_PARTGET,    &status);
            custom->threadStatus = 
                       custom->threadStatus|(status << NNSH_SUBJSTATUS_UPDATE);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NOTREAD,    &status);
            custom->threadStatus =
                       custom->threadStatus|(status << NNSH_SUBJSTATUS_REMAIN);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ALREADY,    &status);
            custom->threadStatus = 
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_ALREADY);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_UPPERLIMIT, &status);
            custom->threadStatus = 
                         custom->threadStatus|(status << NNSH_SUBJSTATUS_OVER);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_NOTYET,     &status);
            custom->threadStatus = 
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_NOT_YET);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ERROR,      &status);
            custom->threadStatus =
                     custom->threadStatus|(status << NNSH_SUBJSTATUS_GETERROR);

            UpdateParameter(diagFrm, CHKID_FAVORSET_ST_ETC,        &status);
            custom->threadStatus =
                      custom->threadStatus|(status << NNSH_SUBJSTATUS_UNKNOWN);

            // Xē̎擾
            custom->threadCreate = 0;
            fldP    = FrmGetObjectPtr(diagFrm, 
                                FrmGetObjectIndex(diagFrm, FLDID_THREAD_DATE));
            txtH = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr    = MemHandleLock(txtH);
                if (StrLen(ptr) != 0)
                {
                    custom->threadCreate = StrAToI(ptr);
                }
                MemHandleUnlock(txtH);
            }
        }
        FrmSetActiveForm(frm);
        FrmDeleteForm(diagFrm);

        // ԐݒXV
        status = ((custom->threadStatus != 0)||(custom->threadCreate)) ? 1 : 0;
        SetControlValue(frm, CHKID_FAVORSET_GETSTATUS, &(status));
        break;

      // ^Cg̏ڍאݒ
      case SELTRID_FAVORSET_TITLESET:
        if (NNshGlobal->jumpSelection == MULTIBTN_FEATURE_USER1TAB)
        {
            custom = &(NNshParam->custom1);
        }
        else
        {
            custom = &(NNshParam->custom2);
        }
        diagFrm  = FrmInitForm(FRMID_FAVORSET_THREADTITLE);
        FrmSetActiveForm(diagFrm);
        if (custom->string1[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR1, false,
                                custom->string1, sizeof(custom->string1));
        }
        if (custom->string2[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR2, false,
                                custom->string2, sizeof(custom->string2));
        }
        if (custom->string3[0] != '\0')
        {
            NNshWinSetFieldText(diagFrm, FLDID_FAVORSET_TTL_STR3, false, 
                                custom->string3, sizeof(custom->string2));
        }

        // ̏ݒ
        status = custom->stringSet & NNSH_STRING_SETMASK;
        NNshWinSetPopItems(diagFrm, 
                           POPTRID_FAVORSET_TTL_CONDSET,
                           LSTID_FAVORSET_TTL_CONDSET, status);

        btnId    = FrmDoDialog(diagFrm);
        if (btnId == BTNID_FAVORSET_TTL_OK)
        {
            // P̎擾
            fldP    = FrmGetObjectPtr(diagFrm, 
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR1));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string1, MINIBUF, 0x00);
                StrNCopy(custom->string1, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }

            // Q̎擾
            fldP    = FrmGetObjectPtr(diagFrm,
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR2));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string2, MINIBUF, 0x00);
                StrNCopy(custom->string2, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }

            // R̎擾
            fldP    =  FrmGetObjectPtr(diagFrm,
                          FrmGetObjectIndex(diagFrm, FLDID_FAVORSET_TTL_STR3));
            txtH    = FldGetTextHandle(fldP);
            if (txtH != 0)
            {
                ptr = MemHandleLock(txtH);
                MemSet(custom->string3, MINIBUF, 0x00);
                StrNCopy(custom->string3, ptr, (MINIBUF - 1));
                MemHandleUnlock(txtH);
            }
            lstP  = FrmGetObjectPtr(diagFrm,
                       FrmGetObjectIndex(diagFrm, LSTID_FAVORSET_TTL_CONDSET));
            custom->stringSet = custom->stringSet & NNSH_STRING_SELECTION;
            custom->stringSet = custom->stringSet | LstGetSelection(lstP);
        }
        FrmSetActiveForm(frm);
        FrmDeleteForm(diagFrm);
        break;

      // "Cancel"{^ꂽƂ
      case BTNID_FAVORSET_CANCEL:
        // ljAꗗʂɉʑJڂ
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_THREAD);
        break;

      // "OK"{^ꂽƂ
      case BTNID_FAVORSET_OK:
        // l𔽉fAꗗʂɉʑJڂ
        if (NNshGlobal->jumpSelection != MULTIBTN_FEATURE_USER2TAB)
        {
            effect_FavorTabSet(frm, &(NNshParam->custom1));
        }
        else
        {
            effect_FavorTabSet(frm, &(NNshParam->custom2));
        }
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_THREAD);
        break;

      case PBTNID_FAVORSET_TAB1:
        // ʏ̒lۑAʑJ
        if (NNshGlobal->jumpSelection == MULTIBTN_FEATURE_USER2TAB)
        {
            effect_FavorTabSet(frm, &(NNshParam->custom2));
        }
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER1TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      case PBTNID_FAVORSET_TAB2:
        // ʏ̒lۑAʑJ
        if (NNshGlobal->jumpSelection == MULTIBTN_FEATURE_USER1TAB)
        {
            effect_FavorTabSet(frm, &(NNshParam->custom1));
        }
        NNshGlobal->jumpSelection = MULTIBTN_FEATURE_USER2TAB;
        FrmEraseForm(frm);
        closeForm_FavorTabSet(FRMID_FAVORSET_DETAIL);
        break;

      default:
        // LȊOiȂj
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effect_FavorTabSet                                       */
/*                         Cɓݒp[^lɔf鏈  */
/*-------------------------------------------------------------------------*/
static Err effect_FavorTabSet(FormType *frm, NNshCustomTab *custom)
{
    UInt16     status;
    ListType  *lstP;
    FieldType *fldP;
    MemHandle  txtH;
    Char      *txtP;

    // ^u^Cg̎擾
    fldP    = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, FLDID_FAVORSET_TABTITLE));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        MemSet(custom->tabName, MAX_BOARDNAME, 0x00);
        StrNCopy(custom->tabName, txtP, (MAX_BOARDNAME - 1));
        MemHandleUnlock(txtH);

        // BBS^CgCfbNXp̗̈
        if (NNshGlobal->boardIdxH != 0)
        {
            MemHandleFree(NNshGlobal->boardIdxH);
            NNshGlobal->boardIdxH = 0;
        }
        if ((NNshGlobal->bbsTitles) != NULL)
        {
            MemPtrFree((NNshGlobal->bbsTitles));
            (NNshGlobal->bbsTitles) = NULL;
        }
    }

    // VmF{^u
    lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_CHECKNEW));
    custom->newArrival = LstGetSelection(lstP);

    // ꗗ擾{^u
    lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_GETLIST));
    custom->getList = LstGetSelection(lstP);

    /////////////////////////////////////////////////////////////////////////

    // `FbN
    lstP   = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_CONDITIONSET));
    status = LstGetSelection(lstP);
    if (status != 0)
    {
        // ǂꂩv
        custom->condition = NNSH_CONDITION_OR;
    }
    else
    {
        // SĈv
        custom->condition = NNSH_CONDITION_AND;
    }

    // QƐpO͏O
    UpdateParameter(frm, CHKID_FAVORSET_NOT_READONLY, &status);
    if (status != 0)
    {
        custom->condition = custom->condition | NNSH_CONDITION_NOTREADONLY;
    }

    // Xx̃`FbN
    UpdateParameter(frm, CHKID_FAVORSET_LEVEL, &(status));
    if (status != 0)
    {
        // Xx𔽉f
        lstP = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, LSTID_FAVORSET_LVL_SET));
        custom->threadLevel =
                          (LstGetSelection(lstP) + 1) << NNSH_THREADCOND_SHIFT;
        UpdateParameter(frm, PBTNID_FAVORSET_LVL1, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L1;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL2, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L2;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL3, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L3;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL4, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR_L4;
            goto SET_CONDITION;
        }
        UpdateParameter(frm, PBTNID_FAVORSET_LVL5, &status);
        if (status != 0)
        {
            status = NNSH_MSGATTR_FAVOR;
            goto SET_CONDITION;
        }
#if 0
        UpdateParameter(frm, PBTNID_FAVORSET_LVL0, &status);
        if (status != 0)
        {
            status = 0;
            goto SET_CONDITION;
        }
        status = 0;
#endif

SET_CONDITION:
        custom->threadLevel = custom->threadLevel|(status);
    }
    else
    {
        custom->threadLevel = 0;
    }
     
    // ݒ̃`FbN
    UpdateParameter(frm, CHKID_FAVORSET_BBSNICK, &(status));
    if (status != 0)
    {
        // ݒ𔽉f
        lstP = FrmGetObjectPtr(frm,
                               FrmGetObjectIndex(frm, LSTID_FAVORSET_BBSNICK));
        custom->boardNick = LstGetSelection(lstP);
        if (custom->boardNick < NNSH_NOF_SPECIAL_BBS)
        {
            // ݒ́Aʏ̔w肳Ă邱
            NNsh_WarningMessage(ALTID_WARN, MSG_WARN_NOTEFFECT_BBS, "", 0);

            // ݒNA
            custom->boardCondition = 0;
            goto FUNC_END;
        }
        lstP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, LSTID_FAVORSET_BBSNICK_SET));
        custom->boardCondition = LstGetSelection(lstP) + 1;
    }
    else
    {
        custom->boardCondition = 0;
    }

    // Oʒu̎w
    UpdateParameter(frm, CHKID_FAVORSET_LOGLOC, &(status));
    if (status != 0)
    {
        // Oʒuf[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_LOGLOC_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition | NNSH_CONDITION_LOGLOC_PALM;
        }
        else
        {
            custom->condition = custom->condition | NNSH_CONDITION_LOGLOC_VFS;
        }
    }

    // 擾G[̎w
    UpdateParameter(frm, CHKID_FAVORSET_GETERROR, &(status));
    if (status != 0)
    {
        // 擾G[f[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_GETERROR_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition|NNSH_CONDITION_GETERR_NONE;
        }
        else
        {
            custom->condition = custom->condition|NNSH_CONDITION_GETERR_ERROR;
        }
    }

    // 擾ۗ̎w
    UpdateParameter(frm, CHKID_FAVORSET_GETRESERVE, &(status));
    if (status != 0)
    {
        // 擾ۗf[^𔽉f
        lstP = FrmGetObjectPtr(frm,
                        FrmGetObjectIndex(frm, LSTID_FAVORSET_GETRESERVE_SET));
        status = LstGetSelection(lstP);
        if (status == 0)
        {
            custom->condition = custom->condition | NNSH_CONDITION_GETRSV_RSV;
        }
        else
        {
            custom->condition = custom->condition | NNSH_CONDITION_GETRSV_NONE;
        }
    }

    // XԂ̊mF 
    UpdateParameter(frm, CHKID_FAVORSET_GETSTATUS, &(status));
    if (status == 0)
    {
        // XԂNA
        custom->threadStatus = 0;    
    }

    // ̐ݒ
    UpdateParameter(frm, CHKID_FAVORSET_TITLESET, &(status));
    if (status != 0)
    {
        custom->stringSet = custom->stringSet | NNSH_STRING_SELECTION;
    }
    else
    {
        custom->stringSet = custom->stringSet & NNSH_STRING_SETMASK;
    }

FUNC_END:
    return (errNone);
}
