#include <QDir>
#include <QFileInfo>
#include <QMessageBox>
#include "janeBrowserParser.h"
#include "bbsTableParser.h"
#include "datFileUtil.h"

/*!
 *  RXgN^
 * 
 */
janeBrowserParser::janeBrowserParser()
 : mpBbsTableParser(0), mBbsTable(0), mLogPath(0)
{
    // ł͉Ȃ
}


/*!
 *  fXgN^
 * 
 */
janeBrowserParser::~janeBrowserParser()
{
    // ł͉Ȃ
}

/*!
 *   uEÛ̖
 * 
 */
QString janeBrowserParser::getBrowserName(void)
{
    QString name = "jane";
    return (name);
}

/*!
 *   ǗpX̎w...
 * 
 */
void janeBrowserParser::setPath(QString &arPath)
{
    mLogPath = arPath;
}

/*!
 *   bbstable.html̎w...
 * 
 */
void janeBrowserParser::setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable)
{
    // BBS̓NX
    mpBbsTableParser = apBbsTable;

    // bbstable.html
    mBbsTable = arBbsTable;
}

/*!
 *   ͂̏...
 * 
 */    
bool janeBrowserParser::prepare(void)
{
    // ϐNA
    clearVariables();

    // ꗗ
    mBbsParser.prepare(mLogPath, "jane2ch.brd");

    bool ret = checkDirectory(mLogPath);
    return (ret);
}

/*!
 *   ͂̏(fBNg@...)
 * 
 */    
bool janeBrowserParser::checkDirectory(QString &arPath)
{
    QDir targetDir(arPath);
    QFileInfoList fileList = targetDir.entryInfoList();
    for (QFileInfoList::const_iterator ite = fileList.constBegin(); ite != fileList.constEnd(); ite++)
    {
        QFileInfo fileInfo = (*ite);
        if (fileInfo.isDir() == true)
        {
            QString filePath = fileInfo.absoluteFilePath();
            if (filePath.endsWith(".") != true)
            {
                checkDirectory(filePath);
            }
        }
        if (fileInfo.isFile() == true)
        {
            QString filePath = fileInfo.absolutePath();
            QString fileName = fileInfo.fileName();
            QString suffix   = fileInfo.suffix();
            if (suffix == "dat")
            {
                QString idxFile = fileName;
                idxFile.replace(QRegExp("dat$"), "idx");
                if (QFile::exists(filePath + "/" + idxFile) == true)
                {
                    // Ǘdatt@C
                    // (CfbNXt@C̉͂s)
                    parseIndexFile(filePath, idxFile);
                }
            }
        }
    }
    return (true);
}

/*!
 *  jane̖ǈʒuǗt@C̓ǂݏo...
 * 
 * 
 */
void janeBrowserParser::parseIndexFile(QString &arPath, QString &arFileName)
{
    // bbsmenu.idx  bbsmenu.dat ͑Ă̂Ŕr...
    if (arFileName == "bbsmenu.idx")
    {
        return;
    }
    mIndexParser.parseFile(arPath, arFileName);
    return;
}

/*!
 *  datt@C̐
 * 
 */
int janeBrowserParser::datFileCount(void)
{
    return (mIndexParser.count());
}

/*!
 *   ǗOdatt@C`FbN
 *    (janeł͓ʑΉȂ̂0)
 * 
 */
int  janeBrowserParser::checkUnmanagedDatFile(void)
{
    return (0);
}

/*!
 *   ǗOdatt@C擾
 *    (janeł͓ʑΉȂ)
 * 
 */
QString janeBrowserParser::getUnmanagedDatFileName(int aIndex)
{
    return ("");
}

/*!
 *   ǗOdatNick擾
 *    (janeł͓ʑΉȂ)
 * 
 */
QString janeBrowserParser::getUnmanagedDatNickName(int aIndex)
{
    return ("");
}

/*!
 *   datt@C(full path)𐶐
 * 
 */
QString janeBrowserParser::getFullPathDatFileName(QString &arNick, QString &arFileName)
{
    QString datName = mBbsParser.getPath(arNick) + arFileName;
    return (datName);
}

/*!
 *   datt@C(full path)𐶐
 * 
 */
QString janeBrowserParser::getReceiveDatFileName(QString &arNick, QString &arFileName)
{
    QString pathName = mBbsParser.getPath(arNick);

    QDir path(mLogPath);
    path.mkpath(pathName);

    QString fileName = arFileName;
    int pos = arFileName.indexOf(".");
    fileName = arFileName.left(pos);

    QString datName = pathName + fileName + ".dat";

    return (datName);
}

/*!
 *  datt@C擾
 * 
 */
QString janeBrowserParser::getDatFileName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mIndexParser.count()))
    {
        return ("");
    }
    return (mIndexParser.getDatFileName(aIndex));    
}

/*!
 *  Nick擾
 * 
 */
QString janeBrowserParser::getBoardNick(int aIndex)
{
    if ((aIndex < 0)||(aIndex >=  mIndexParser.count()))
    {
        return ("");
    }
    return (mIndexParser.getNickName(aIndex));
}

/*!
 *  ǈʒu̎擾
 * 
 */
int  janeBrowserParser::getReadPoint(int aIndex)
{
    if ((aIndex < 0)||(aIndex >=  mIndexParser.count()))
    {
        return (1);
    }
    return (mIndexParser.getCurrentMessage(aIndex));
}

/*!
 *  ŏIXVԂ̎擾
 * 
 */
qint64 janeBrowserParser::getLastUpdate(int aIndex)
{
    if ((aIndex < 0)||(aIndex >=  mIndexParser.count()))
    {
        return (0);
    }
    QString str = mIndexParser.getLastUpdate(aIndex);

//////////// TODO :   lϊKv!!
    return (0);
}

/*
 *   subject.txt̃t@C(full path)擾
 * 
 */
QString janeBrowserParser::getSubjectTxtFilePath(QString &arNick)
{
    QString pathName = mBbsParser.getPath(arNick) + "subject.txt";
    return (pathName);
}

/*!
 *   datt@CM
 * 
 */
bool janeBrowserParser::receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(entry File)", arNick + " | " + arFile, QMessageBox::Ok);

    // t@Cړ
    datFileUtil util;
    util.moveDatFile(arSrc, isSame, arDst, true);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/*!
 *   datt@CRs[
 * 
 */
bool janeBrowserParser::copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(copy File)", arSrc + " -> " + arDst + " ", QMessageBox::Ok);

    // t@CRs[
    datFileUtil util;
    util.copyDatFile(arSrc, isSame, arDst, true);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/*!
 *   ǗXV
 * 
 */
bool janeBrowserParser::updateInformations(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{

    // t@C擾
    datFileUtil datFileUtility;
    QString path = getReceiveDatFileName(arNick, arFile);
    QString target = "/" + arFile;
    path.replace(target, "");
    QString title = datFileUtility.pickupDatFileTitle(path, arFile);
    int    nofMsg = datFileUtility.checkResCount(path, arFile);
    int    curMsg = aReadPoint;
    if (curMsg == nofMsg)
    {
        curMsg--;
    }
    int index = mIndexParser.exists(arFile);
    if (index >= 0)
    {
        // o^ς...XV
        mIndexParser.setCurrentMessage(index, curMsg);
        mIndexParser.setNofMessage(index, nofMsg);
    }

    QString nick = arNick;
    nick.replace("/", "");
    QString url = mpBbsTableParser->getUrl(nick);
    int pos = url.lastIndexOf("/");
    url = url.left(pos);

    QString pathName = mBbsParser.getPath(arNick);
    pos = pathName.lastIndexOf("/");
    pathName = pathName.left(pos);
    
    // ACeǉo^
    mIndexParser.appendData(arNick, url, pathName, arFile, title, nofMsg, curMsg);
    return (true);
}

/*!
 *   Ƃ܂s (idxt@Co͂...)
 * 
 */
bool janeBrowserParser::finalize(void)
{
    mIndexParser.outputFile();
    clearVariables();
    return (true);
}

/*!
 *   ϐNA
 * 
 */
void janeBrowserParser::clearVariables(void)
{
    //
    //
    //   
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
