/*!
 *   a2BCbbsTableTrim
 * 
 *   F
 *       a2Bgbbstable.htmlɁua2BCvJeSAURLǉ
 * 
 *      a2BCJeSɒǉURĹA45őƂA𒴂ꍇɂ́A
 *       (a2BC-XXAXXCNg)̃JeSɒǉB
 *       (̋EĺAmaxBbsDatasInCategoryŐݒ肷B)
 * 
 *      {NXŉHs̖ɂ́A"<!--a2BC-->" ƂǉB
 * 
 */
#include <QList>
#include <QDir>
#include <QFile>
#include <QTextStream>
#include <QTextCodec>
#include <QTextCodecPlugin>
#include <QMessageBox>
#include "a2BCbbsTableTrim.h"
#include "a2BcConstants.h"
#include "a2BCfavoriteBbsData.h"
#include "bbsTableParser.h"

/*!
 *  RXgN^
 * 
 */
a2BCbbsTableTrim::a2BCbbsTableTrim(QWidget *parent) : QWidget(parent)
{
    // ɉȂ
}

/*!
 *  fXgN^
 * 
 */
a2BCbbsTableTrim::~a2BCbbsTableTrim()
{
    // ɉȂ
}

/*!
 *  f[^̃Zbg
 * 
 */
void a2BCbbsTableTrim::resetTrimmer()
{
    // ǉf[^
    mBbsTableAppend.clear();
}

/*!
 *  ꗗf[^̉H
 *    (true : OKA false : s)
 */
bool a2BCbbsTableTrim::prepareTrimmer(QString &arFileName)
{
    mBbsTableFileName = "";
    if (QFile::exists(arFileName) != true)
    {
        // t@C݂ȂꍇAG[
        return (false);
    }

    mBbsTableFileName = arFileName;

    QFile bbsTableFile(arFileName);
    if (!bbsTableFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        // t@C̃I[vsAAAI
        return (false);
    }

    // HOt@Cɂꍇ폜
    if (QFile::exists(arFileName + ".back") == true)
    {
        if (QFile::remove(arFileName + ".back") == false)
        {
            // HOt@Cs...I
            bbsTableFile.close();
            return (false);
        }
    }

    // HOt@C̃I[v
    QFile bbsTableBakFile(arFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableFile.close();
        return (false);
    }

    // ǉꂽf[^NA
    clearLogBoardData();

    // a2BCHs𔲂sHOt@Cɏo͂
    QTextStream in(&bbsTableFile);
    QTextStream out(&bbsTableBakFile);
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // f[^o͂
            out << line << endl;
        }
        else
        {
            if (line.contains("http://") == true)
            {
                // f[^sL
                appendBoardUrlData(line);
            }
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();

    return (true);
}

void a2BCbbsTableTrim::clearLogBoardData()
{
    mItemModel.clear();

    int limit = mFavoriteBbsData.size();
    for (int loop = limit - 1; loop >= 0; loop--)
    {
        delete mFavoriteBbsData[loop];
    }
    mFavoriteBbsData.clear();
}

void a2BCbbsTableTrim::appendBoardUrlData(const QString &lineData)
{
    QString boardName(lineData.section('>',1,1));
    QString boardUrl(lineData.section('>',0,0));

    boardName.replace(QRegExp("</[Aa]"),"");
    boardUrl.replace(QRegExp("< *[Aa] +[Hh][Rr][Ee][Ff]="),"");

    a2BCfavoriteBbsData *bbsData = new a2BCfavoriteBbsData();
    bbsData->setData(boardName, boardUrl, "");    
    mFavoriteBbsData.append(bbsData);

    // f[^
    QList<QStandardItem *> itemList;
    itemList << bbsData->getName() << bbsData->getUrl() << bbsData->getSortKey();
    mItemModel.appendRow(itemList);
}

/*!
 *  bbstable.html̉HC
 * 
 */
bool a2BCbbsTableTrim::outputTrimmer(void)
{
    // HOt@C̃I[v
    QFile bbsTableBakFile(mBbsTableFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        return (false);
    }

    // o̓t@C̃I[v
    QFile bbsTableFile(mBbsTableFileName);
    if (!bbsTableFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableBakFile.close();
        return (false);
    }
 
    // eLXgXg[̏(eLXgR[fbN̐ݒs)
    QTextStream out(&bbsTableFile);
    QTextStream in(&bbsTableBakFile);
    QTextCodec *codec = setCodec(out);

    // a2BCJeSf[^̃t@Co
    outputA2BCcategory(out, codec);

    // HOf[^t@C̓eRs[
    out.setCodec(QTextCodec::codecForLocale());
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // ǂݍ񂾂̂̂܂܃f[^o͂
            out << line << endl;
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();
    
    // HOt@C̍폜
    QFile::remove(mBbsTableFileName + ".back");
    return (true);
}

/*!
 *  f[^̒ǉ
 * 
 */
void a2BCbbsTableTrim::appendTrimmer(QByteArray &arData)
{
    mBbsTableAppend.append(arData);
    return;
}

/*!
 *   codec̏...
 * 
 */
QTextCodec *a2BCbbsTableTrim::setCodec(QTextStream &arOutputStream)
{
    // codecNX܂...
    QTextCodec  *codec = QTextCodec::codecForName("Shift_JIS");
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("MS_Kanji");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("sjis");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("SJIS");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("System");
    }

    // ostreamɃR[fbNݒ肷B
    if (codec == 0)
    {
        arOutputStream.setCodec(QTextCodec::codecForLocale());
        return (QTextCodec::codecForLocale());
    }
    arOutputStream.setCodec(codec);
    return (codec);
}

/*!
 *   a2BCJeS̏o
 * 
 * 
 */
void a2BCbbsTableTrim::outputA2BCcategory(QTextStream &arOutputStream, QTextCodec *codec)
{
    // codec == 0̂Ƃɂ́Aa2BJeS͏o͂Ȃ悤ɂ
    if (codec == 0)
    {
        outputA2Bcategory_noCodec(arOutputStream);
        return;
    }

    // 1a2BCJeSɓ̍ől (̒l𒴂ƕ)
    int maxBbsDatasInCategory = 45;

    // O...
    arOutputStream << "<!--a2BC-->" << endl;

    // JeSf[^o͂̃C
    int count = 0;
    for (QVector<QByteArray>::ConstIterator it = mBbsTableAppend.begin(); it != mBbsTableAppend.end(); it++)
    {
        ///// ŃJeS (ya2B-xxz) o͂
        if ((count % maxBbsDatasInCategory) == 0)
        {
            arOutputStream << codec->toUnicode("y<B>a2B");

            // "-xx"̏o(Kvȏꍇɂ...
            if ((count / maxBbsDatasInCategory) != 0)
            {
                QString num;
                num.setNum(count / maxBbsDatasInCategory);
                arOutputStream << "-" << num;
            }
            arOutputStream << codec->toUnicode("</B>z") << "<!--a2BC-->" << endl;
        }

        // (URL)1o͂
        arOutputStream << "<A HREF=" << codec->toUnicode(*it) << "</A>" << "<!--a2BC-->" << endl;
        count++;
    }

    // ㏈...
    arOutputStream << codec->toUnicode("y<B>-----</B>z") << "<!--a2BC-->" << endl;
    arOutputStream << "<!--a2BC-->" << endl;
    
    return;
}

/*!
 *   a2BCJeS̏o(R[fbNgp)
 * 
 * 
 */
void a2BCbbsTableTrim::outputA2Bcategory_noCodec(QTextStream &arOutputStream)
{
    // 1a2BCJeSɓ̍ől (̒l𒴂ƕ)
    int maxBbsDatasInCategory = 45;

    // O...
    arOutputStream << "<!--a2BC--><!--(NO CODEC)-->" << endl;

    // JeSf[^o͂̃C
    int count = 0;
    for (QVector<QByteArray>::ConstIterator it = mBbsTableAppend.begin(); it != mBbsTableAppend.end(); it++)
    {
        ///// ŃJeS (ya2B-xxz) o͂
        if ((count % maxBbsDatasInCategory) == 0)
        {
            arOutputStream << "y<B>a2B";

            // "-xx"̏o(Kvȏꍇɂ...
            if ((count / maxBbsDatasInCategory) != 0)
            {
                QString num;
                num.setNum(count / maxBbsDatasInCategory);
                arOutputStream << "-" << num;
            }
            arOutputStream << "</B>z" << "<!--a2BC-->" << endl;
        }

        // (URL)1o͂
        arOutputStream << "<A HREF=" << (*it) << "</A>" << "<!--a2BC-->" << endl;
        count++;
    }

    // ㏈...
    arOutputStream << "y<B>-----</B>z" << "<!--a2BC-->" << endl;
    arOutputStream << "<!--a2BC--><!--(NO CODEC)-->" << endl;

    return;
}

/**
 *   a2B̃OfBNgF
 * 
 * 
 */
bool a2BCbbsTableTrim::readA2BLogBoards(const QString &arFileName)
{
    bbsTableParser bbsTable;
    QString fileName = arFileName;

    // ꗗf[^̓ǂݍ...
    bool readyBbs = bbsTable.prepare(fileName);
    if (readyBbs == false)
    {
        // ꗗ͎̉s...I
        return (false);
    }

    // pfBNgm肷
    QString baseDirectory = fileName;
    baseDirectory.replace(QRegExp("bbstable.html$"), "");

    // Oi[fBNg̈ꗗ擾
    QDir baseDir(baseDirectory);
    QFileInfoList list = baseDir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
        QFileInfo fileInfo = list.at(i);
        if (fileInfo.isDir() == true)
        {
            QString dirName = fileInfo.fileName();
            if (dirName.startsWith(".") != true)
            {
                // OfBNgoAAA
                QString    url  = bbsTable.getUrl(dirName);
                QByteArray data = bbsTable.getData(dirName);

                // codecNX܂...
                QTextCodec  *codec = QTextCodec::codecForName("Shift_JIS");
                if (codec == 0)
                {
                    codec = QTextCodec::codecForName("MS_Kanji");
                }
                if (codec == 0)
                {
                    codec = QTextCodec::codecForName("sjis");
                }
                if (codec == 0)
                {
                    codec = QTextCodec::codecForName("SJIS");
                }
                if (codec == 0)
                {
                    codec = QTextCodec::codecForName("System");
                }
                if (url.isEmpty() != true)
                {
                    QString lineData;
                    if (codec != 0)
                    {
                        lineData = "<A HREF=" + codec->toUnicode(data) + "</A>";                        
                    }
                    else
                    {
                        lineData = "<A HREF=" + data + "</A>";
                    }
                    appendBoardUrlData(lineData);
                }
            }
        }
    }    
    return (true);
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
