/*============================================================================*
 *  FILE: 
 *     netent.c
 *
 *  Description: 
 *     lbg[NʐMق̃Gg|Cg
 *
 *===========================================================================*/
#define NETENT_C
#include "local.h"

/*==========================================================================*/
/*  NNshHttp_comm() : HTTPʐM                                              */
/*                                                                          */
/*==========================================================================*/
Err NNshHttp_comm(UInt16 type, Char *url, Char *cookie, Char *appendData,
                  UInt32 range, UInt32 endRange, Char *message)
{
    UInt16  lp;
    Err     ret;

    // gCJE^[NA
    lp = 0;
    do
    {
        if (NNshParam->useProxy != 0)
        {
             // Proxygp
            ret = NNshHttp_commMain(type, url, cookie, appendData,
                                    range, endRange,
                                    NNshParam->proxyPort, NNshParam->proxyURL,
                                    message);
        }
        else
        {
            // Proxygp
            ret = NNshHttp_commMain(type, url, cookie, appendData,
                                    range, endRange, 80, NULL, message);
        }
        lp++;
    } while ((lp <= NNshParam->nofRetry)&&(ret == netErrTimeout));
    return (ret);
}

/*==========================================================================*/
/*  NNshNet_LineHangup() : ؒf                                         */
/*                                                                          */
/*==========================================================================*/
void NNshNet_LineHangup(void)
{
    UInt16         netRef;

    if (NNshGlobal->netRef == 0)
    {
        // lbgCũI[v
        (void) SysLibFind("Net.lib", &(netRef));
    }
    else
    {
        netRef = NNshGlobal->netRef;
    }

    // ؒf̊mF
    if ((netRef != 0)&&
        (NNsh_ConfirmMessage(ALTID_CONFIRM,
                             MSG_MESSAGE_DISCONNECT, "", 0) == 0))
    {
        Show_BusyForm(MSG_DISCONNECT_WAIT);
        (void) NetLibClose(netRef, true);           // N[Y
        (void) NetLibFinishCloseWait(netRef);       // ڑ҂ؒf
        NNshGlobal->netRef = 0;

        Hide_BusyForm(false);

        // Xꗗʂĕ`
        NNsi_RedrawThreadList(); 
    }
    return;
}

/*==========================================================================*/
/*  WebBrowserCommand() : WebBrowserĂяo֐                            */
/*                                               Ă邩ȁH     */
/*==========================================================================*/
Err WebBrowserCommand(UInt32 creator, Boolean subLaunch, UInt16 flags,
                      UInt16 cmd, Char *parameterP, UInt32 *resultP)
{
    Char             *newParamP;
    UInt32            result;
    UInt16            cardNo, size;
    LocalID           dbID;
    DmSearchStateType searchState;
    Err               ret;

    if (resultP != NULL)
    {
        *resultP = errNone;
    }
    // WebBrowserCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, creator, 
                                         true, &cardNo, &dbID);
    if (ret != errNone)
    {
        // WebBrowser(NetFront)CXg[ĂȂ
        NNsh_InformMessage(ALTID_ERROR, MSG_CANNOTFIND_BROWSER, "", ret);
        return (ret);
    }
    
    // childfork邩AIfork邩subLaunchŔ
    if (subLaunch != true)
    {
        // (NNsi)UIWebBrowserNꍇ
        if (parameterP != NULL)
        {
            // itqkj̈mۂ
            size = StrLen(parameterP);
            newParamP = MemPtrNew(size + MARGIN);
            if (newParamP == NULL)
            {
                // \ȃmۂłȂAG[
                return (memErrNotEnoughSpace);
            }
            MemSet  (newParamP, (size + MARGIN), 0x00);
            StrNCopy(newParamP, parameterP, size);

            // AvIĂ͎̈c悤ɂ
            MemPtrSetOwner(newParamP, 0);

            // AvP[VN
            ret = SysUIAppSwitch(cardNo, dbID, cmd, newParamP);
        }
    }
    else
    { 
        // AvP[Vfork(SubLaunch̏ꍇ)
        ret = SysAppLaunch(cardNo, dbID, flags, cmd, parameterP, &result);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "SysAppLaunch()", "", ret);
            // ͌p //
        }
        if (resultP != NULL)
        {
            *resultP = result;
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  OpenNetworkPreferences() : lbg[NݒʌĂяo֐             */
/*                                                  Ă邩ȁH  */
/*==========================================================================*/
void OpenNetworkPreferences(void)
{
    Err                  ret;
    UInt16               cardNo;
    LocalID              dbID;
    DmSearchStateType    state;

    // ϐ̏
    cardNo = 0;
    MemSet(&state, sizeof(state), 0x00);

    // lbg[Nݒʂ̃\[XƂĂB
    ret = DmGetNextDatabaseByTypeCreator(true, &state, sysFileTPanel,
                                         sysFileCNetworkPanel,
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // \[XƂɂ́AݒʂJ
        SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdPanelCalledFromApp, NULL);
    }
    return;
}
