/*============================================================================*
 *  FILE: 
 *     fileMgr.c
 *
 *  Description: 
 *     t@C}l[W
 *===========================================================================*/
#define FILEMGR_C
#include "local.h"

static void SetFullPathFileName_NNsh(Char *file, Char *fullPath, UInt16 size);
static Err openFile_VFSFile(Char *fileName, UInt16 fileMode, NNshFileRef *ref);
static Err openFile_FileStream(Char *name, UInt16 fileMode, NNshFileRef *ref);

/*==========================================================================*/
/*  closeFile_NNsh() : t@CN[Y                                     */
/*                                                                          */
/*==========================================================================*/
Err CloseFile_NNsh(NNshFileRef *fileRef)
{
    Err ret = errNone;

    if (fileRef->fileLocation == NNSH_VFS_ENABLE)
    {
        ret = VFSFileClose(fileRef->vfsRef);
        NNsh_DebugMessage(ALTID_INFO, "VFS file close ", "", ret);
    }
    else
    {
        ret = FileClose(fileRef->streamRef);
        NNsh_DebugMessage(ALTID_INFO, "stream file close ", "", ret);
    }

    // t@CgȂ悤ɂB
    fileRef->streamRef = 0;
    fileRef->vfsRef    = 0;
    return (ret);
}

/*==========================================================================*/
/*  openFile_NNsh() : t@CI[v                                      */
/*                                                                          */
/*==========================================================================*/
Err OpenFile_NNsh(Char *fileName, UInt16 fileMode, NNshFileRef *fileRef)
{
    Err ret;
    MemSet(fileRef, sizeof(NNshFileRef), 0x00);

    // t@CI[v̊mF
    if (((fileMode & NNSH_FILEMODE_TEMPFILE) == 0)&&
        ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0))
    {
        // VFS t@CI[vv
        NNsh_DebugMessage(ALTID_INFO, "VFS file Open:", fileName, 0);
        fileRef->fileLocation = NNSH_VFS_ENABLE;
        ret = openFile_VFSFile(fileName, fileMode, fileRef);
    }
    else
    {
        // stream t@CI[vv
        NNsh_DebugMessage(ALTID_INFO, "Stream file Open :", fileName, 0);
        fileRef->fileLocation = NNSH_VFS_DISABLE;
        ret = openFile_FileStream(fileName, fileMode, fileRef);
    }
    return (ret);
}

/*==========================================================================*/
/*  GetFileSize_NNsh() : t@CTCY̎擾                               */
/*                                                                          */
/*==========================================================================*/
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize)
{
    Int32 size;
    Err   ret;

    *fileSize = 0;

    if (fileRef->fileLocation == NNSH_VFS_ENABLE)
    {
        ret =  VFSFileSize(fileRef->vfsRef, fileSize);
    }
    else
    {
        size = 0;
        if (FileTell(fileRef->streamRef, &size, &ret) != -1)
        {
            *fileSize = size;
        }
        else
        {
            ret = errNone;
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  ReadFile_NNsh() : t@Cf[^̓ǂݏo                          */
/*                                                                          */
/*==========================================================================*/
Err ReadFile_NNsh(NNshFileRef *fileRef, UInt32 offset, UInt32 size, 
                  void *ptr, UInt32 *readSize)
{
    Err ret = errNone;

    *readSize = 0;

    if (fileRef->fileLocation == NNSH_VFS_ENABLE)
    {
        if (fileRef->vfsRef == 0)
        {
            return (~errNone);
        }
        (void) VFSFileSeek(fileRef->vfsRef, vfsOriginBeginning, offset);
        ret = VFSFileRead(fileRef->vfsRef, size, ptr, readSize);
    }
    else
    {
        if (fileRef->streamRef == 0)
        {
            return (~errNone);
        }
        (void) FileSeek(fileRef->streamRef, offset, fileOriginBeginning);
        *readSize = FileRead(fileRef->streamRef, ptr, 1, size, &ret);
    }
    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  SetFullPathFileName_NNsh() : t@ĈtpXwɊg           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
static void SetFullPathFileName_NNsh(Char *file, Char *fullPath, UInt16 size)
{
    MemSet (fullPath, size, 0x00);
    if (*file != '/')
    {
        // ΃pXw肾ꍇɂ́Ax[XfBNg𓪂ɂ
        StrCopy(fullPath, DATAFILE_PREFIX);
        StrCat (fullPath, file);
    }
    else
    {
        // ΃pXw肳Ăꍇɂ́Â܂܃Rs[
        StrCopy(fullPath, file);
    }
    return;    
}

/*--------------------------------------------------------------------------*/
/*  openFile_VFSFile() : t@CI[v(VFS Filep)                       */
/*                                                                          */
/*--------------------------------------------------------------------------*/
static Err openFile_VFSFile(Char *fileName, UInt16 fileMode, NNshFileRef *ref)
{
    Err     ret;
    UInt16  mode;
    Char    fullPath[MAXLENGTH_FILENAME];

    // t@CI[v[h̃`FbN
    switch (fileMode)
    {
      case NNSH_FILEMODE_READONLY:
      case (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE):
        mode = vfsModeRead;
        break;

      case NNSH_FILEMODE_CREATE:
      case (NNSH_FILEMODE_CREATE|NNSH_FILEMODE_TEMPFILE):
        // VK쐬w̏ꍇɂ́At@CĂI[v
        (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
        mode = vfsModeReadWrite;
        break;

      case NNSH_FILEMODE_APPEND:
      case (NNSH_FILEMODE_APPEND|NNSH_FILEMODE_TEMPFILE):
      case NNSH_FILEMODE_READWRITE:
      case (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE):
      default:
        mode = vfsModeReadWrite;
        break;
    }

    // FULL PATHwɊg
    SetFullPathFileName_NNsh(fileName, fullPath, sizeof(fullPath));
    ret = VFSFileOpen(NNshGlobal->vfsVol, fullPath, mode, &(ref->vfsRef));
    if (ret == vfsErrFileNotFound)
    {
        // t@C݂Ȃꍇ́AVK쐬Ă
        (void) CreateFile_NNsh(fullPath);
        ret = VFSFileOpen(NNshGlobal->vfsVol, fullPath, mode, &(ref->vfsRef));
    }
    if (ret != errNone)
    {
        ref->vfsRef = 0;
    }
    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  openFile_FileStream() : t@CI[v(File Streamp)                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/
static Err openFile_FileStream(Char *name, UInt16 fileMode, NNshFileRef *ref)
{
    Err    err;
    UInt32 openMode;

    // t@CI[v[h̃`FbN
    switch (fileMode)
    {
      case NNSH_FILEMODE_READONLY:
      case (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE):
        openMode = fileModeReadOnly;
        break;

      case NNSH_FILEMODE_APPEND:
      case (NNSH_FILEMODE_APPEND|NNSH_FILEMODE_TEMPFILE):
        openMode = fileModeAppend;
        break;

      case NNSH_FILEMODE_CREATE:
      case (NNSH_FILEMODE_CREATE|NNSH_FILEMODE_TEMPFILE):
      case NNSH_FILEMODE_READWRITE:
      case (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE):
      default:
        openMode = fileModeReadWrite;
        break;
    }

    ref->streamRef = FileOpen(0, name, 0, 0, openMode, &err);
    if (ref->streamRef == 0)
    {
        return (err);
    }
    return (errNone);
}

/*==========================================================================*/
/*  DeleteFile_NNsh() : t@Cf[g                                    */
/*                                                                          */
/*==========================================================================*/
Err DeleteFile_NNsh(Char *fileName, UInt16 location)
{
    Err  ret;
    Char fullPath[MAXLENGTH_FILENAME];

    if ((location != NNSH_VFS_DISABLE)&&
        ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0))
    {
        // VFS̃t@C폜
        SetFullPathFileName_NNsh(fileName, fullPath, sizeof(fullPath));
        ret = VFSFileDelete(NNshGlobal->vfsVol, fullPath);
    }
    else
    {
        // File Stream̃t@C폜
        ret = FileDelete(0, fileName);
    }
    return (ret);
}

/*==========================================================================*/
/*  createFile_NNsh() : t@C쐬 (VFS Only)                             */
/*                                                                          */
/*==========================================================================*/
Err CreateFile_NNsh(Char *fileName)
{
    Err  ret = errNone;
    Char fullPath[MAXLENGTH_FILENAME];

    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
    {
        // VFSɃt@C쐬
        SetFullPathFileName_NNsh(fileName, fullPath, sizeof(fullPath));
        ret = VFSFileCreate(NNshGlobal->vfsVol, fullPath);
    }
    return (ret);
}

/*==========================================================================*/
/*  renameFile_NNsh() : t@Cl[(VFS Only)                          */
/*                                                                          */
/*==========================================================================*/
Err RenameFile_NNsh(Char *oldFileName, Char *newFileName)
{
    Err  ret = errNone;
    Char oldFullPath[MAXLENGTH_FILENAME];
    Char newFullPath[MAXLENGTH_FILENAME];

    if (NNshParam->useVFS & NNSH_VFS_ENABLE)
    {
        // VFS̃t@CύX
        SetFullPathFileName_NNsh(oldFileName,oldFullPath,sizeof(oldFullPath));
        SetFullPathFileName_NNsh(newFileName,newFullPath,sizeof(newFullPath));
        ret = VFSFileRename(NNshGlobal->vfsVol, oldFullPath, newFullPath);
    }
    return (ret);
}

/*==========================================================================*/
/*  CreateDir_NNsh() : fBNg̍쐬(VFS Only)                         */
/*                                                                          */
/*==========================================================================*/
Err CreateDir_NNsh(Char *dirName)
{
    Err  ret = errNone;
    Char fullPath[MAXLENGTH_FILENAME];

    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
    {
        // VFSɃfBNg쐬
        SetFullPathFileName_NNsh(dirName, fullPath, sizeof(fullPath));
        ret = VFSDirCreate(NNshGlobal->vfsVol, fullPath);
    }
    return (ret);
}


/*==========================================================================*/
/*  CopyFile_NNsh() : t@C̃Rs[(VFS Only)                            */
/*                                                                          */
/*==========================================================================*/
Err CopyFile_NNsh(Char *destFile, Char *sourceFile, UInt16 location)
{
    NNshFileRef srcRef, destRef;
    UInt16      limit, fileMode;
    UInt32      offset, readSize, dummy;
    Err         ret = errNone;
    Char       *buffer;

    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
    {
        // Rs[t@Ĉ肩ɂ킹ăt@CI[vύX
        if (location != NNSH_VFS_DISABLE)
        {
            fileMode = NNSH_FILEMODE_READONLY;
        }
        else
        {
            fileMode = NNSH_FILEMODE_READONLY | NNSH_FILEMODE_TEMPFILE;
        }

        // 茳t@C̃I[v
        ret = OpenFile_NNsh(sourceFile, fileMode, &srcRef);
        if (ret != errNone)
        {
            return (ret);
        }

        // t@C̃I[v
        ret = OpenFile_NNsh(destFile, NNSH_FILEMODE_CREATE, &destRef);
        if (ret != errNone)
        {
            return (ret);
        }

        // Rs[p[N̈mۂ
        limit = NNshParam->bufferSize - NNshParam->bufferSize % 2;
        do
        {
            limit  = limit - 8;
            buffer = (Char *) MemPtrNew(limit + 4);
        } while (buffer == NULL);

        offset = 0;
        ret    = errNone;

        // ɓǂݍ߂Ƃ́At@CRs[
        while (ret == errNone)
        {
            readSize = 0;
            MemSet(buffer, limit, 0x00);
            ret  = ReadFile_NNsh (&srcRef, offset, limit, buffer, &readSize);
            (void) WriteFile_NNsh(&destRef,offset, readSize, buffer, &dummy);
            offset = offset + readSize;
        }

        // [N̈J
        MemPtrFree(buffer);

        // t@CN[Y
        CloseFile_NNsh(&srcRef);
        CloseFile_NNsh(&destRef);

        // t@C̍Ō܂ŃRs[errNoneŉ
        if ((ret == vfsErrFileEOF)||(ret == fileErrEOF))
        {
            ret = errNone;
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  WriteFile_NNsh() : t@Cփf[^̏o                           */
/*                                                                          */
/*==========================================================================*/
Err WriteFile_NNsh(NNshFileRef *fileRef, UInt32 offset, UInt32 size,
                                                void *ptr, UInt32 *writeSize)
{
    Err  ret = errNone;

    *writeSize = 0;

    if (fileRef->fileLocation == NNSH_VFS_ENABLE)
    {
        if (fileRef->vfsRef == 0)
        {
            return (~errNone);
        }

        //  ꕔ@VFSFileWrite肪݂邽߁At@Co
        // ̏ɍvꍇAWARNING\B(΍͂ȂB)
        if ((offset % 2) == 1)
        {
            NNsh_DebugMessage(ALTID_WARN, "OFFSET is odd number! ","", offset);
        }
        if ((size % 2) == 1)
        {
            NNsh_DebugMessage(ALTID_WARN, "SIZE is odd number! ", "", size);
        }
        (void) VFSFileSeek (fileRef->vfsRef, vfsOriginBeginning, offset);
        ret  = VFSFileWrite(fileRef->vfsRef, size, ptr, writeSize);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "VFSFileWrite() ", "ret:", ret);
            *writeSize = 0;
        }
    }
    else
    {
        if (fileRef->streamRef == 0)
        {
            return (~errNone);
        }
        (void) FileSeek(fileRef->streamRef, offset, fileOriginBeginning);
        *writeSize = FileWrite(fileRef->streamRef, ptr, 1, size, &ret);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "FileWrite() ", " ret:", ret);
            *writeSize = 0;
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  appendFile() : t@C̖ɏo                                 */
/*                                                                          */
/*==========================================================================*/
Err AppendFile_NNsh(NNshFileRef *fileRef, UInt32 size, 
                    void *ptr, UInt32 *writeSize)
{
    Err  ret = errNone;

    *writeSize = 0;
    if (fileRef->fileLocation == NNSH_VFS_ENABLE)
    {
        if (fileRef->vfsRef == 0)
        {
            return (~errNone);
        }

        //  ꕔ@VFSFileWrite肪݂邽߁At@Co
        // ̏ɍvꍇAWARNING\B(΍͂ȂB)
        if ((size % 2) == 1)
        {
            NNsh_DebugMessage(ALTID_WARN, "SIZE is odd number! ", "", size);
        }

        (void) VFSFileSeek (fileRef->vfsRef, vfsOriginEnd, 0);
        ret  = VFSFileWrite(fileRef->vfsRef, size, ptr, writeSize);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "VFSFileWrite() ", "ret:", ret);
            *writeSize = 0;
        }
    }
    else
    {
        if (fileRef->streamRef == 0)
        {
            return (~errNone);
        }
        // (void) FileSeek (fileRef->streamRef, 0, fileOriginEnd);
        *writeSize = FileWrite(fileRef->streamRef, ptr, 1, size, &ret);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "FileWrite() ", " ret:", ret);
            *writeSize = 0;
        }
    }
    return (ret);
}

/*==========================================================================*/
/*  appendFileAsURLEncode() : t@C̖ɏo(URLGR[h{)   */
/*                                                                          */
/*==========================================================================*/
Err AppendFileAsURLEncode_NNsh(NNshFileRef *fileRef, UInt32  size,
                               void        *ptr,     UInt32 *writeSize)
{
    Char   *data, *buffer, *locP, logBuf[MINIBUF];
    UInt32  current, num, limit;
    Err     ret;

    // f[^Ro[gɊi[Af[^i[̈pӂ
    buffer  = NULL;
    limit   = size * 6 + 8;
    do
    {
        limit  = limit - 8;
        buffer = (Char *) MemPtrNew(limit);
    } while (buffer == NULL);
    NNsh_DebugMessage(ALTID_INFO,"ALLOCATED URLENCODE BUFFER"," size:",limit);
    MemSet(buffer, limit, 0x00);

    current  = 0;
    data     = buffer;
    locP     = (Char *) ptr;

    while ((data < (buffer + limit - 6))&&(current < size))
    {
        // Xy[X́{ɕϊ
        if (*locP == ' ')
        {
            *data = '+';
            data++;
            locP++;
            current++;
            continue;
        }

        // śACR + LFɕϊ
        if (*locP == '\n')
        {
            StrCopy(data, "%0D%0A");
            data = data + 6; // 6 == StrLen("%0D%0A");
            locP++;
            current++;
            continue;
        }

        // ̂܂܏o(̂P)
        if ((*locP == '.')||(*locP == '_')||(*locP == '-')||(*locP == '*'))
        {
            *data = *locP;
            data++;
            locP++;
            current++;
            continue;
        }

        // ̂܂܏o(̂Q)
        if (((*locP >= '0')&&(*locP <= '9'))||
            ((*locP >= 'A')&&(*locP <= 'Z'))||
            ((*locP >= 'a')&&(*locP <= 'z')))
        {
            *data = *locP;
            data++;
            locP++;
            current++;
            continue;
        }

        // ̏̂ǂɂĂ͂܂Ȃꍇɂ́ARo[gB
        *data = '%';
        data++;
        
        num = (UInt32) *locP;
        MemSet(logBuf, sizeof(logBuf), 0x00);
        StrIToH(logBuf, num);

        // l̉Q~̂...
        StrCat(data, &logBuf[6]);
        data = data + 2; // 2 == StrLen(data);
        locP++;
        current++;
    }

    // t@C֏(AppendFile_NNsh()gp)
    ret = AppendFile_NNsh(fileRef, (data - buffer), buffer, writeSize);

    MemPtrFree(buffer);
    return (ret);
}

/*==========================================================================*/
/*  BackupDatabaseToVFS : f[^x[XVFSɃobNAbv               */
/*                                                                          */
/*==========================================================================*/
Err BackupDatabaseToVFS_NNsh(Char *dbName)
{
    LocalID dbId;
    Char    fileName[MAXLENGTH_FILENAME];

    // t@C̈
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(fileName, DATAFILE_PREFIX);
    StrCat (fileName, dbName);
    StrCat (fileName, ".pdb");

    // ݂f[^x[X
    dbId = DmFindDatabase(0, dbName);
    if (dbId == 0)
    {
        return (~errNone);
    }

    // (݂Ă)t@C폜AVFSt@Cɏo͂
    (void) VFSFileDelete(NNshGlobal->vfsVol, fileName);
    return (VFSExportDatabaseToFile(NNshGlobal->vfsVol, fileName, 0, dbId));
}

/*==========================================================================*/
/*  RestoreDatabaseFromVFS : VFSf[^x[X𕜋                  */
/*                                                                          */
/*==========================================================================*/
Err RestoreDatabaseFromVFS_NNsh(Char *dbName)
{
    Err     ret;
    LocalID dbId;
    UInt16  cardNo;
    Char    fileName[MAXLENGTH_FILENAME];

    // t@C̈
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(fileName, DATAFILE_PREFIX);
    StrCat (fileName, dbName);
    StrCat (fileName, ".pdb");

    // f[^x[X݂邩
    dbId = DmFindDatabase(0, dbName);
    if (dbId != 0)
    {
        // ݂ĂꍇADB폜
        (void) DmDeleteDatabase(0, dbId);
        dbId = 0;
    }

    // VFSt@Cf[^x[XC|[g
    ret = VFSImportDatabaseFromFile(NNshGlobal->vfsVol, 
                                    fileName, &cardNo, &dbId);
    return (ret);
}
