/*============================================================================*
 *  FILE: 
 *     subjmgr.c
 *
 *  Description: 
 *     Xꗗ擾Tu
 *===========================================================================*/
#define  SUBJMGR_C
#include "local.h"

/*=========================================================================*/
/*   Function :   DeleteSubjectList                                        */
/*                                                  YXꗗ폜 */
/*=========================================================================*/
Err DeleteSubjectList(Char *boardNick, UInt16 delState, UInt16 *thrCnt)
{
    UInt16              cnt, loop;
    DmOpenRef           dbRef;
    NNshSubjectDatabase tmpDb;
    Char                fileName[MAXLENGTH_FILENAME];

    // DBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }
    GetDBCount_NNsh(dbRef, &cnt);

    Show_BusyForm(MSG_DELETE_LIST_WAIT);
    *thrCnt  = 0;
    for (loop = cnt; loop > 0; loop--)
    {
        MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
        GetRecord_NNsh(dbRef, (loop - 1), sizeof(NNshSubjectDatabase), &tmpDb);

        // w肳ꂽBoardID烌R[h폜
        if (StrCompare(tmpDb.boardNick, boardNick) == 0)
        {
            if ((delState == NNSH_SUBJSTATUS_DELETE)||
                (tmpDb.state == NNSH_SUBJSTATUS_NOT_YET))
            {
                // f[^t@C΁A킹č폜
                if (tmpDb.state != NNSH_SUBJSTATUS_NOT_YET)
                {
                    MemSet (fileName, sizeof(fileName), 0x00);
                    StrCopy(fileName, tmpDb.boardNick);
                    StrCat (fileName, tmpDb.threadFileName);
                    (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
                }
                (void) DeleteRecordIDX_NNsh(dbRef, (loop - 1));
            }
            else
            {
                // 폜ȂƂ́AJEgAbv
                (*thrCnt)++;
            }
        }
    }
    Hide_BusyForm(true);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));
    return (errNone);
}

/*==========================================================================*/
/*  SortSubjectList : SUBJECTf[^x[X\[g㏑               */
/*                                                                          */
/*==========================================================================*/
void SortSubjectList(void)
{
    DmOpenRef            dbRef;

    // XǗDBI[vA\[g
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    QsortRecord_NNsh(dbRef, NNSH_KEYTYPE_SUBJECT, 0);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   parse_SubjectList                                        */
/*                                                    XꗗDB荞 */
/*-------------------------------------------------------------------------*/
static Err parse_SubjectList(Char *buffer, UInt32 readSize, Char *boardNick,
                             Char *fieldSeparator, UInt16 sepaLen, UInt16 *cnt)
{
    UInt16              size;
    Char               *ptr, *dataEnd, *dataSepa, *ppp;
    DmOpenRef           dbRef;
    NNshSubjectDatabase tmpDb;

    // DBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }
    *cnt = 0;

    // X̂̉߃C(HTTPwb_ǂݔ΂)
    ptr = StrStr(buffer, "\x0d\x0a\x0d\0a");
    if (ptr == NULL)
    {
        // f[^ُ
        NNsh_InformMessage(ALTID_ERROR, "ERR>Wrong data(not found separator,",
                           "(\x0d\x0a\x0d\x0a))", 0);
        CloseDatabase_NNsh(dbRef);
        return (~errNone);
    }
    ptr = ptr + 4;

    // uXgo^v̕\s
    Show_BusyForm(MSG_THREADLIST_CREATE);

    while (ptr < buffer + readSize)
    {
        dataEnd = StrStr(ptr, NNSH_RECORD_SEPARATOR);
        if (dataEnd == NULL)
        {
            break;
        }

        dataSepa = StrStr(ptr, fieldSeparator);
        if ((dataSepa == NULL)||(dataSepa > dataEnd))
        {
            break;
        }
        /** Xi[폜(łxȂȁ[) **/
        ppp = dataEnd;
        while (*ppp != ')')
        {
            ppp--;
        }
        *ppp = '\0';
        while (*ppp != '(')
        {
            ppp--;
        }
        *ppp = '\0';
        MemSet  (&tmpDb, sizeof(tmpDb), 0x00);
        tmpDb.maxLoc = (UInt16) StrAToI(ppp + 1);
        StrNCopy(tmpDb.threadFileName, ptr, (dataSepa - ptr));
        size = ((dataEnd - (dataSepa + 2)) > MAX_THREADNAME) ? 
                             (MAX_THREADNAME - 1) : (dataEnd - (dataSepa + 2));
        StrNCopy(tmpDb.threadTitle, (dataSepa + sepaLen), size);
        StrCopy (tmpDb.boardNick, boardNick);
        (void) EntryRecord_NNsh(dbRef, sizeof(NNshSubjectDatabase), &tmpDb);

        // f[^̐擪ֈړ
        ptr = dataEnd + 1;
        (*cnt)++;
    }
    Hide_BusyForm(true);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return (errNone);
}

/*=========================================================================*/
/*   Function :   convertListIndexToMsgIndex                               */
/*                                   XgԍXindexԍɕϊ */
/*=========================================================================*/
UInt16 convertListIndexToMsgIndex(UInt16 listIdx)
{
    // XgԍDB̃R[hԍɕϊĉ
    return (NNshGlobal->msgListIndex[listIdx]);
}

/*=========================================================================*/
/*   Function :   NNsh_GetSubjectList                                      */
/*                                                         Xꗗ̎擾  */
/*=========================================================================*/
Err NNsh_GetSubjectList(UInt16 index)
{
    Err                 ret;
    UInt16              cnt, cnt2;
    UInt32              fileSize, readSize;
    Char                getURL[MAX_URL + MAX_URL], *buffer;
    NNshFileRef         fileRef;
    NNshBoardDatabase   bbsData;

    // BBS-DBBBS擾
    ret = Get_BBS_Info(index, &bbsData);
    if (ret != errNone)
    {
        // G[
        NNsh_DebugMessage(ALTID_ERROR,  "Get_BBS_Info() ", "", ret);
        return (ret);
    }

    // f[^擾̐ݒ
    MemSet (getURL, sizeof(getURL), 0x00);
    StrCopy(getURL, bbsData.boardURL);
    if (bbsData.bbsType == NNSH_BBSTYPE_MACHIBBS)
    {
        StrCat(getURL, bbsData.boardNick);
    }
    StrCat (getURL, FILE_THREADLIST);

    // fobO\
    NNsh_DebugMessage(ALTID_INFO, bbsData.boardNick, getURL, 0);

    // zXgXꗗf[^擾
    if (NNshParam->getAllThread == HTTP_GETSUBJECT_PART)
    {
        // ꕔ擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, getURL, NULL, NULL,
                            HTTP_GETSUBJECT_START, HTTP_GETSUBJECT_LEN, NULL);
    }
    else
    {
        // S擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, getURL, NULL, NULL,
                            HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    }
    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[SUBJ]", ret);
            return (ret);
        }

        // ʐM^CAEg(MĂƂ܂ŁAIɉ߂s)
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[SUBJ]", ret);
    }

    // f[^x[XA(擾)Xf[^𖢓ǂ̂̂̂ݏ
    DeleteSubjectList(bbsData.boardNick, NNSH_SUBJSTATUS_NOT_YET, &cnt);

    ////////// Xꗗ̉ /////////

    // Mf[^i[pobt@̊l
    buffer = (Char *) MemPtrNew(NNshParam->bufferSize + MARGIN);
    if (buffer == NULL)
    {
        NNsh_InformMessage(ALTID_ERROR,
                           "MemPtrNew()", " size:", NNshParam->bufferSize);
        return (~errNone);
    }
    MemSet(buffer, (NNshParam->bufferSize + MARGIN), 0x00);

    OpenFile_NNsh(FILE_RECVMSG, 
                  (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                  &fileRef);
    GetFileSize_NNsh(&fileRef, &fileSize);
    if (fileSize > NNshParam->bufferSize)
    {
        // Xꗗ傫Ƃ(obt@TCY)ۂ߂
        fileSize = NNshParam->bufferSize;
    }

    // Xꗗ̓ǂ݂
    ret = ReadFile_NNsh(&fileRef, 0, fileSize, buffer, &readSize);
    CloseFile_NNsh(&fileRef);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {        
        // t@Cǂ݂݃G[
        NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh :", FILE_RECVMSG, ret);
    }
    else
    {
        // f[^x[X̍XV(X̓o^)
        switch (bbsData.bbsType)
        {
          case NNSH_BBSTYPE_MACHIBBS:
            ret = parse_SubjectList(buffer, readSize, bbsData.boardNick,
                                    NNSH_FIELD_SEPARATOR_MACHI, 
                                    StrLen(NNSH_FIELD_SEPARATOR_MACHI), &cnt2);
            break;
          case NNSH_BBSTYPE_2ch:
          default:
            ret = parse_SubjectList(buffer, readSize, bbsData.boardNick, 
                                    NNSH_FIELD_SEPARATOR,
                                    StrLen(NNSH_FIELD_SEPARATOR), &cnt2);
            break;
        }
        cnt = cnt + cnt2;

        // fobO\
        NNsh_DebugMessage(ALTID_INFO, "parsed thread :", "", cnt);
    }
    MemPtrFree(buffer);
    return (ret);   
}

/*=========================================================================*/
/*   Function :   Check_same_thread                                        */
/*                                      XDBɊ܂܂Ă邩ׂ */
/*=========================================================================*/
Err Check_same_thread(UInt16 selMES, NNshSubjectDatabase *data, 
                      NNshSubjectDatabase *matchedData, UInt16 *idx)
{
    Err                  err = ~errNone;
    Int16                step;
    UInt16               lp, index, count;
    DmOpenRef            dbRef;
    NNshSubjectDatabase *subj;

    // 擾f[^x[X̏i[̈m
    subj = MemPtrNew(sizeof(NNshSubjectDatabase));
    if (subj == NULL)
    {
        NNsh_DebugMessage(ALTID_INFO, "MemPtrNew()", "", 
                          sizeof(NNshSubjectDatabase));
        return (~errNone);
    }

    // udX̃`FbN...v\
    Show_BusyForm(MSG_CHECK_SAME_THREAD);

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // DBI[vs(肦Ȃ͂...)
        goto FUNC_END;
    }
    GetDBCount_NNsh(dbRef, &count);

    // 擾\̔ԍ擾
    if (selMES != NNSH_NOTENTRY_THREAD)
    {
        index = convertListIndexToMsgIndex(selMES);
        step  = 1;
        lp    = index + 1;
    }
    else
    {
        index = count;
        step  = -1;
        lp    = count - 1;
    }
    *idx  = index;

    // dXǂ
    for (;((lp >= 0)&&(lp < count)); lp = lp + step)
    {
        // Xf[^擾
        if ((GetRecord_NNsh(dbRef, lp,
                            sizeof(NNshSubjectDatabase), subj)) != errNone)
        {
            // G[
            err = ~errNone;
            break;
        }
        if ((StrCompare(subj->boardNick,      data->boardNick)      == 0)&&
            (StrCompare(subj->threadFileName, data->threadFileName) == 0))
        {
            // ̃X݂I
            err  = errNone;
            if (matchedData != NULL)
            {
                // Yf[^Rs[ĉ
	        MemSet(matchedData, sizeof(NNshSubjectDatabase), 0x00);
                StrCopy(matchedData->threadFileName, subj->threadFileName);
                StrCopy(matchedData->threadTitle,    subj->threadTitle);
                StrCopy(matchedData->boardNick,      subj->boardNick);
                matchedData->dirIndex     = subj->dirIndex;
                matchedData->reserved     = subj->reserved;
                matchedData->state        = subj->state;
                matchedData->msgAttribute = subj->msgAttribute;
                matchedData->msgState     = subj->msgState;
                matchedData->bbsType      = subj->bbsType;
                matchedData->maxLoc       = subj->maxLoc;
                matchedData->currentLoc   = subj->currentLoc;
                matchedData->fileSize     = subj->fileSize;
            }
            *idx = lp;
            break;
        }
    }
    CloseDatabase_NNsh(dbRef);

    // udX̃`FbN...v\
    Hide_BusyForm(false);

FUNC_END:
    MemPtrFree(subj);
    return (err);
}
