/*============================================================================*
 *  FILE: 
 *     nnshset.c
 *
 *  Description: 
 *     NNsh parameter setting functions for NNsh.
 *
 *===========================================================================*/
#define NNSHSET_C
#define GLOBAL_REAL
#include "local.h"

extern Err setOfflineLogDir(Char *fileName);
/*=========================================================================*/
/*   Function :   SetControlValue                                          */
/*                                       p[^ʂɔf鏈  */
/*=========================================================================*/
void SetControlValue(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    CtlSetValue(chkObj, (UInt16) *value);

    return;
}

/*=========================================================================*/
/*   Function :   UpdateParameter                                          */
/*                                       ʂp[^ɔf鏈  */
/*=========================================================================*/
void UpdateParameter(FormType *frm, UInt16 objID, UInt16 *value)
{
    ControlType *chkObj;

    chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    *value = CtlGetValue(chkObj);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   effect_NNshSetting                                       */
/*                             NNsiݒʂp[^lɔf鏈  */
/*-------------------------------------------------------------------------*/
static Err effect_NNshSetting(FormType *frm)
{
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3;

    /***  NNshݒ(O[oϐ)f  ***/

    // Xꗗ(subject.txt)S擾
    UpdateParameter(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

    // mFbZ[Wȗ
    UpdateParameter(frm, CHKID_OMIT_DIALOG, &(NNshParam->confirmationDisable));

    // 擾ɃXQ
    UpdateParameter(frm, CHKID_OPEN_AUTO,   &(NNshParam->openAutomatic));

    // sage
    UpdateParameter(frm, CHKID_WRITE_SAGE,  &(NNshParam->writeAlwaysSage));

    // ɁA啶ʂȂ
    UpdateParameter(frm, CHKID_SEARCH_CASELESS, &(NNshParam->searchCaseless));

    // NOfflineX
    UpdateParameter(frm, CHKID_OFFCHK_LAUNCH,   &(NNshParam->offChkLaunch));

    // A_[COFF
    UpdateParameter(frm, CHKID_MSG_LINEOFF, &(NNshParam->disableUnderline));

    // DEBUG
    UpdateParameter(frm, CHKID_DEBUG_DIALOG,&(NNshParam->debugMessageON));

    // XꗗMSG
    UpdateParameter(frm, CHKID_PRINT_NOFMSG,&(NNshParam->printNofMessage));

    // VFS p\ɎIVFS ON
    UpdateParameter(frm, CHKID_VFSON_AUTOMATIC,&(NNshParam->vfsOnAutomatic));

    // Xԍyzɂ
    UpdateParameter(frm, CHKID_BOLD_MSGNUM, &(NNshParam->boldMessageNum));

    // VFS̎gpƉtOAOFFLINEOgptO̐ݒ
    if (NNshParam->useVFS != NNSH_NOTSUPPORT_VFS)
    {
        chkObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
        chkObjSub1 = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
        chkObjSub2 = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
        chkObjSub3 = 
           FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
        NNshParam->useVFS = CtlGetValue(chkObj);
        if (CtlGetValue(chkObjSub1) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_WORKAROUND;
        }
        if (CtlGetValue(chkObjSub2) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_USEOFFLINE;
        }
        if (CtlGetValue(chkObjSub3) != 0)
        {
            NNshParam->useVFS = NNshParam->useVFS | NNSH_VFS_DBBACKUP;
        }

        if (NNshParam->useVFS != 0)
        {
            //  VFS֘Ap[^̐ݒ肪ĂƂAN
            // LƂȂ邱Ƃ\B
            NNsh_InformMessage(ALTID_WARN, MSG_NNSISET_VFSWARN, "", 0);
        }

        // logdir.txtǂ݁AOFFLINEOx[XfBNg擾
        (void) setOfflineLogDir(LOGDIR_FILE);
    }

    // gꍇ̐ݒ
    if (NNshParam->useBookmark == 0)
    {
        // gȂꍇAݒ̃NA
        NNshParam->lastFrmID     = FRMID_THREAD;
        NNshParam->bookMsgNumber = 0;
        NNshParam->bookMsgIndex  = 0;
    }
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting2                                       */
/*                                             NNsiݒ2̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting2(FormType *frm)
{
    FieldType   *fldP;
    UInt32       bufSize;
    UInt16       timeout;
    Char        *logBuf, *numP;
    MemHandle    txtH;

    // ʐM^CAEgl̕ύX
    timeout = SysTicksPerSecond();
    timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_COMM_TIMEOUT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);
        if (NNshParam->netTimeout != timeout * bufSize)
        {
            NNshParam->netTimeout = timeout * bufSize;

            // TIMEOUT̍XV\
            NNsh_DebugMessage(ALTID_INFO, MSG_TIMEOUT_UPDATED, 
                              "", NNshParam->netTimeout);
        }
    }

    // obt@TCY̕ύX
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_BUFFER_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);
        if ((bufSize < NNSH_WORKBUF_MIN)||(bufSize > NNSH_WORKBUF_MAX))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MemPtrNew(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE1);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE2);
                NUMCATI(logBuf, NNSH_WORKBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WORKBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WORKBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MemPtrFree(logBuf);
            }
            return (~errNone);
        }
        else
        {
            if (bufSize == NNshParam->bufferSize)
            {
                // obt@TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "buffer size:", NNshParam->bufferSize);
            }
            else
            {
                // obt@TCYύXďI
                NNshParam->bufferSize = bufSize;
                NNsh_InformMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                   "buffer size:", NNshParam->bufferSize);
            }
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "0", 0);
    }

    // _E[hw擾
    UpdateParameter(frm, CHKID_DL_PART, &(NNshParam->enablePartGet));

    // _E[h̃TCY擾
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_DL_PARTSIZE));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        bufSize = StrAToI(numP);
        MemHandleUnlock(txtH);

        if (bufSize < NNSH_DOWNLOADSIZE_MIN)
        {
            // _E[hTCÝAobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_UNDER,
                              "", NNSH_DOWNLOADSIZE_MIN);
            return (~errNone);
        }
        if (bufSize > NNshParam->bufferSize)
        {
            // _E[hTCÝA[Nobt@TCY
            NNsh_ErrorMessage(ALTID_WARN, MSG_DOWNLOADSIZE_OVER, "", 0);
            return (~errNone);
        }
        if (bufSize != NNshParam->partGetSize)
        {
            NNshParam->partGetSize = bufSize;

            // _E[hTCY̍XV\
            NNsh_DebugMessage(ALTID_INFO, MSG_DOWNLOADSIZE_UPDATE, "",
                              NNshParam->partGetSize);
        }
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "1", 0);
    }

    // Ren@\gpݒ
    UpdateParameter(frm, CHKID_FIXED_HANDLE, &(NNshParam->useFixedHandle));

    // nh̐ݒ(nhݒłȂĂ퉞)
    MemSet(NNshParam->handleName, BUFSIZE, 0x00);
    fldP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, FLDID_HANDLENAME));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        numP    = MemHandleLock(txtH);
        MemSet(NNshParam->handleName, BUFSIZE, 0x00);
        if (*numP != '\0')
        {
            StrNCopy(NNshParam->handleName, numP, (BUFSIZE - 1));
        }
        MemHandleUnlock(txtH);
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "3", 0);
    }

    // BBSꗗ擾̐ݒ
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_URL_BBS));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[hURL擾
        numP = MemHandleLock(txtH);
        MemSet  (NNshParam->bbs_URL, MAX_URL, 0x00);
        StrNCopy(NNshParam->bbs_URL, numP, (MAX_URL - 1));
        MemHandleUnlock(txtH);
    }

    // ݎobt@TCY̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_WRITEBUF_SIZE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        // tB[h珑݃obt@TCY擾
        numP = MemHandleLock(txtH);
        if (numP != NULL)
        {
            bufSize = StrAToI(numP);
            MemHandleUnlock(txtH);
        }
        else
        {
            bufSize = NNSH_WRITEBUF_DEFAULT;
        }
        if ((bufSize > NNSH_WRITEBUF_MAX)||(bufSize < NNSH_WRITEBUF_MIN))
        {
            // f[^lُAُ͔͈͈\Čɖ߂
            logBuf = MemPtrNew(BUFSIZE);
            if (logBuf != NULL)
            {
                MemSet (logBuf, BUFSIZE, 0x00);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL);
                NUMCATI(logBuf, bufSize);
                StrCat (logBuf, MSG_WRITEBUF_ILLEGAL2);
                NUMCATI(logBuf, NNSH_WRITEBUF_MIN);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE3);
                NUMCATI(logBuf, NNSH_WRITEBUF_MAX);
                StrCat (logBuf, MSG_ERROR_BUFFER_SIZE4);
                NUMCATI(logBuf, NNSH_WRITEBUF_DEFAULT);
                NNsh_ErrorMessage(ALTID_ERROR, logBuf, "", 0);
                MemPtrFree(logBuf);
            }
            return (~errNone);
        }
        else
        {
            // TCYmF
            if (bufSize == NNshParam->writeBufferSize)
            {
                // TCY͕ύXȂ|񍐂AI
                NNsh_DebugMessage(ALTID_INFO, MSG_WARN_NOTMODIFIED,
                                  "writeBufferSize:", NNshParam->writeBufferSize);
            }
            else
            {
                NNshParam->writeBufferSize = bufSize;
                NNsh_InformMessage(ALTID_INFO, MSG_INFO_MODIFIED,
                                   "writeBufferSize:", NNshParam->writeBufferSize);
            }
        }
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting3                                       */
/*                                             NNsiݒ3̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting3(FormType *frm)
{
    FieldType   *fldP;
    UInt32       portNum;
    Char        *proxyP;
    MemHandle    txtH;

    // NNsiIɉؒf
    UpdateParameter(frm, CHKID_END_OFFLINE, &(NNshParam->disconnectNNsiEnd));

    // uVmFvIɉؒf
    UpdateParameter(frm, CHKID_DISCONN_ARRIVAL, &(NNshParam->disconnArrivalEnd));

    // uVmFvIɖǈꗗ\
    UpdateParameter(frm, CHKID_ARRIVAL_NOTREAD, &(NNshParam->autoOpenNotRead));

    // ڑ͎擾\
    UpdateParameter(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // MCookiegpď
    UpdateParameter(frm, CHKID_WRITE_USE_COOKIE, &(NNshParam->useCookieWrite));

    // ڑʂĕ`
    UpdateParameter(frm,CHKID_REDRAW_CONNECT,&(NNshParam->redrawAfterConnect));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    UpdateParameter(frm, CHKID_NOT_AUTOFOCUSSET,&(NNshParam->notAutoFocus));

    // ݎAA_[COFFɂ
    UpdateParameter(frm, CHKID_UNDERLINE_WRITE, &(NNshParam->disableUnderlineWrite));

    // ݎQƃXԍ}
    UpdateParameter(frm, CHKID_INSERT_REPLYNUM, &(NNshParam->insertReplyNum));

    // ݃V[PXPART2
    UpdateParameter(frm, CHKID_WRITE_SEQUENCE2, &(NNshParam->writeSequence2));

    // ProxyoRł̃ANZX
    UpdateParameter(frm, CHKID_USE_PROXY, &(NNshParam->useProxy));

    // Proxy URL
    fldP = FrmGetObjectPtr(frm,
                           FrmGetObjectIndex(frm, FLDID_USE_PROXY));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        proxyP    = MemHandleLock(txtH);
        MemSet(NNshParam->proxyURL, MAX_URL, 0x00);
        if (*proxyP != '\0')
        {
            StrNCopy(NNshParam->proxyURL, proxyP, (MAX_URL - 1));
        }
        MemHandleUnlock(txtH);
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY URL", 0);
    }

    // Proxy Port #
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_PROXY_PORT));
    txtH    = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        proxyP  = MemHandleLock(txtH);
        portNum = StrAToI(proxyP);
        MemHandleUnlock(txtH);

        NNshParam->proxyPort = portNum;
    }
    else
    {
        NNsh_DebugMessage(ALTID_ERROR, "FldGetTextHandle()", "PROXY PORT", 0);
    }

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting4                                       */
/*                                             NNsiݒ4̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting4(FormType *frm)
{
    // QƎBack{^JumpList
    UpdateParameter(frm, CHKID_BACKBTN_JUMP, &(NNshParam->jogBackBtnAsGo));

    // QƎPush{^JumpList
    UpdateParameter(frm, CHKID_PUSHBTN_JUMP, &(NNshParam->jogPushBtnAsGo));

    // QƎJumpListɁuꗗցv
    UpdateParameter(frm, CHKID_ADD_RTNTOLIST, &(NNshParam->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    UpdateParameter(frm, CHKID_ADD_BACKMESSAGE, &(NNshParam->addMenuBackRtnMsg));

    // QƎJumpListɃj[
    UpdateParameter(frm, CHKID_ADD_OPENMENU, &(NNshParam->addMenuMsg));

    // QƎJumpListɁu擾v
    UpdateParameter(frm, CHKID_ADD_GETPART, &(NNshParam->addLineGetPart));

    // QƎJumpListɁuؒfv
    UpdateParameter(frm, CHKID_ADD_LINEDISCONN, &(NNshParam->addLineDisconn));

    // QƎJumpListɐ擪
    UpdateParameter(frm, CHKID_ADD_JUMPTOP, &(NNshParam->addJumpTopMsg));

    // QƎJumpListɖ
    UpdateParameter(frm, CHKID_ADD_JUMPBOTTOM, &(NNshParam->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    UpdateParameter(frm, CHKID_ADD_OPENWEB, &(NNshParam->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    UpdateParameter(frm, CHKID_ADD_GRAPHVIEW, &(NNshParam->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    UpdateParameter(frm, CHKID_ADD_FAVORITE, &(NNshParam->addMenuFavorite));

    // ꗗBack{^Ńj[\
    UpdateParameter(frm, CHKID_BACKBTN_LIST, &NNshParam->jogBackBtnAsMenu);

    // ꗗPush{^Ńj[\
    UpdateParameter(frm, CHKID_PUSHBTN_LIST, &NNshParam->jogPushBtnAsMenu);

    // ꗗMenuɃj[\
    UpdateParameter(frm, CHKID_ADD_MENUOPEN, &NNshParam->addMenuTitle);

    // ꗗMenuɎQCOPY
    UpdateParameter(frm, CHKID_ADD_MENUCOPY, &NNshParam->addMenuCopyMsg);

    // ꗗMenuMSG폜
    UpdateParameter(frm, CHKID_ADD_MENUDELETE, &NNshParam->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    UpdateParameter(frm, CHKID_ADD_MENUGRAPHMODE, &NNshParam->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW1, &NNshParam->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    UpdateParameter(frm, CHKID_ADD_MENUMULTISW2, &NNshParam->addMenuMultiSW2);

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting5                                       */
/*                                            NNsiݒ-5̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting5(FormType *frm)
{
    UInt16 butID;

    // PalmOS5p@\gp
    UpdateParameter(frm, CHKID_USE_ARMLET, &(NNshParam->useARMlet));

    // ArmLetgp(PalmOS5p̋@\Ȃ߁A{Ɏ{邩mF\)
    if (NNshParam->useARMlet != 0)
    {
        butID = NNsh_ErrorMessage(ALTID_CONFIRM, MSG_WARNING_OS5, "", 0);
        if (butID != 0)
        {
            NNshParam->useARMlet = 0;
        }
    }

    // Bookmark(ݒ)
    UpdateParameter(frm, CHKID_USE_BOOKMARK,&(NNshParam->useBookmark));

    // WebBrowserJƂŐV50
    UpdateParameter(frm, CHKID_WEBBROWSE_LAST50, &butID);
    if (butID != 0)
    {
        NNshParam->browseMesNum = 50;
    }
    else
    {
        NNshParam->browseMesNum = 0;
    }

    // QƎJi𔼊pSpϊ
    UpdateParameter(frm,CHKID_CONVERT_HANZEN, &(NNshParam->convertHanZen));

    // Xꗗʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TITLE,
                                     &(NNshParam->useSonyTinyFontTitle));

    // XQƉʂtiny/smalltHggp
    UpdateParameter(frm,CHKID_CLIE_USE_TINYFONT,
                                      &(NNshParam->useSonyTinyFont));

    // XQƉʂŃJ[\\Ȃ
    UpdateParameter(frm,CHKID_NOT_FOCUSSET_NUM, &(NNshParam->notFocusNumField));

    // PUSH ON_CŁ}P
    UpdateParameter(frm, CHKID_NOT_CURSOR, &(NNshParam->notCursor));

    // 擾ςݑSĂ͎QƐpOɕ\Ȃ
    UpdateParameter(frm, CHKID_NOT_READONLY, &(NNshParam->notListReadOnly));

#ifdef USE_CLIE
    // SilksȂ
    UpdateParameter(frm, CHKID_NOTUSE_SILK, &NNshGlobal->notUseSilk);

    // SILK͍sȂƂ́Ax\
    if (NNshGlobal->notUseSilk != NNshParam->notUseSilk)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_SILK_NEXT_LAUNCH, "", 0);
    }

    // SONYnC]@\gȂ
    UpdateParameter(frm, CHKID_NOTUSE_SONYHIRES, &(NNshParam->disableSonyHR));
    if (NNshGlobal->notUseHR != NNshParam->disableSonyHR)
    {
        // SONYnC]@\̎gpېݒ́ANLƂȂ
        NNsh_InformMessage(ALTID_WARN, MSG_HR_NEXT_LAUNCH, "", 0);
    }
#endif

    // DBXVꂽ
    NNshGlobal->updateDatabaseInfo 
               = (NNshGlobal->updateDatabaseInfo)|(NNSH_DB_UPDATE_SETTING);

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting6                                       */
/*                                            NNsiݒ-6̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting6(FormType *frm)
{
    ListType *lstP;
    UInt16   item;

    // URL擾AL`FbNȂ
    UpdateParameter(frm, CHKID_NOTCHECK_BBSURL,&(NNshParam->notCheckBBSURL));

    // ړɖ擾X폜
    UpdateParameter(frm, CHKID_AUTODEL_NOT_YET,&(NNshParam->autoDeleteNotYet));

    // OfflineXɃX{Ȃ
    UpdateParameter(frm, CHKID_NOT_DELOFFLINE, &(NNshParam->notDelOffline));

    // QƐpփRs[ƂAɃX폜{
    UpdateParameter(frm, CHKID_COPYDEL_READONLY,
                    &(NNshParam->copyDelReadOnly));

#ifdef USE_COLOR
    // ꗗ\ɃJ[
    UpdateParameter(frm, CHKID_USE_COLORMODE, &(NNshParam->useColor));
#endif

    // ړIXCb`ݒP̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW1));
    item  = LstGetSelection(lstP);
    NNshParam->usageOfTitleMultiSwitch1 = item | NNSH_SWITCHUSAGE_TITLE;

    // ړIXCb`ݒQ̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW2));
    item  = LstGetSelection(lstP);
    NNshParam->usageOfTitleMultiSwitch2 = item | NNSH_SWITCHUSAGE_TITLE;

    // BBSꗗ̃XgԂ𔽉f
    lstP  = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,LSTID_CHECK_NEWARRIVAL));
    item  = LstGetSelection(lstP);
    NNshParam->newArrivalNotRead = item;

    // Cɓ\ŒXx̐ݒp[^֔f
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    item  = LstGetSelection(lstP);
    switch (item)
    {
      case 1:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L2;
        break;

      case 2:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L3;
        break;

      case 3:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L4;
        break;

      case 4:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR;
        break;

      case 0:
      default:
        NNshParam->displayFavorLevel = NNSH_MSGATTR_FAVOR_L1;
        break;
    }

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectNNsiSetting7                                       */
/*                                            NNsiݒ-7̏𔽉f */
/*-------------------------------------------------------------------------*/
static Err effectNNsiSetting7(FormType *frm)
{

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   setMultiPurposeTitleLabel                                */
/*                                              ړIXCb`̃xݒ */
/*-------------------------------------------------------------------------*/
static void setMultiPurposeTitleLabel(FormType *frm, UInt16 objID, UInt16 selItem)
{
    ControlType *ctlP;
    Char *ptr;

    // ݒ肷镶I
    switch (selItem)
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        ptr = NNSH_SWITCHMSG_GETPART;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        ptr = NNSH_SWITCHMSG_HANZEN;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        ptr = NNSH_SWITCHMSG_USEPROXY;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        // mFȗ
        ptr = NNSH_SWITCHMSG_CONFIRM;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        ptr = NNSH_SWITCHMSG_SUBJECT;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        ptr = NNSH_SWITCHMSG_TITLEDISP;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        ptr = NNSH_SWITCHMSG_MSGNUMBER;
        break;

      case NNSH_SWITCHUSAGE_GETRESERVE:
        // ꗗɔԍ
        ptr = NNSH_SWITCHMSG_GETRESERVE;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ
        ptr = NNSH_SWITCHMSG_NOUSE;
        break;
    }

    // xɕݒ肷
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, objID));
    CtlSetLabel(ctlP, ptr);

    return;
}

/*=========================================================================*/
/*   Function :   Hander_NNshSetting                                       */
/*                                     NNsiݒn()Cxgnh  */
/*=========================================================================*/
Boolean Handler_NNshSetting(EventType *event)
{
    FormType    *frm;
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3;
#ifdef USE_COLOR
    IndexedColorType color;
#endif
    UInt16       formID;
    Err          ret;
    void        *effectFunc;

    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        return (NNsh_MenuEvt_Edit(event));
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        break;

      default: 
        return (false);
        break;
    }

    effectFunc = NULL;
    formID     = FRMID_THREAD;
    frm        = FrmGetActiveForm();

    // ɊJtH[ID̐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // "OK"{^ꂽƂ(NNsiݒ)
      case BTNID_CONFIG_NNSH_OK:
      case BTNID_NNSI_SET_OK:
      case BTNID_NNSISET3_OK:
      case BTNID_NNSISET4_OK:
      case BTNID_NNSISET5_OK:
      case BTNID_NNSISET6_OK:
      case BTNID_NNSISET7_OK:
        formID     = FRMID_THREAD;
        break;

      // "1"{^ꂽƂ
      case NNSHSET2_1:
      case NNSHSET3_1:
      case NNSHSET4_1:
      case NNSHSET5_1:
      case NNSHSET6_1:
      case NNSHSET7_1:
        formID     = FRMID_CONFIG_NNSH;
        break;

      // "2"{^ꂽƂ
      case NNSHSET_2:
      case NNSHSET3_2:
      case NNSHSET4_2:
      case NNSHSET5_2:
      case NNSHSET6_2:
      case NNSHSET7_2:
        formID     = FRMID_NNSI_SETTING2; 
        break;

      // "3"{^ꂽƂ
      case NNSHSET_3:
      case NNSHSET2_3:
      case NNSHSET4_3:
      case NNSHSET5_3:
      case NNSHSET6_3:
      case NNSHSET7_3:
        formID     = FRMID_NNSI_SETTING3; 
        break;

      // "4"{^ꂽƂ
      case NNSHSET_4:
      case NNSHSET2_4:
      case NNSHSET3_4:
      case NNSHSET5_4:
      case NNSHSET6_4:
      case NNSHSET7_4:
        formID     = FRMID_NNSI_SETTING4; 
        break;

      // "5"{^ꂽƂ
      case NNSHSET_5:
      case NNSHSET2_5:
      case NNSHSET3_5:
      case NNSHSET4_5:
      case NNSHSET6_5:
      case NNSHSET7_5:
        formID     = FRMID_NNSI_SETTING5;
        break;

      // "6"{^ꂽƂ
      case NNSHSET_6:
      case NNSHSET2_6:
      case NNSHSET3_6:
      case NNSHSET4_6:
      case NNSHSET5_6:
      case NNSHSET7_6:
        formID     = FRMID_NNSI_SETTING6;
        break;

      // "7"{^ꂽƂ
      case NNSHSET_7:
      case NNSHSET2_7:
      case NNSHSET3_7:
      case NNSHSET4_7:
      case NNSHSET5_7:
      case NNSHSET6_7:
        formID     = FRMID_NNSI_SETTING7;
        break;

#ifdef USE_COLOR
      case  SELTRID_COLOR_UNKNOWN:
        color = NNshParam->colorUnknown;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorUnknown = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_OVER:
        color = NNshParam->colorOver;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorOver = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NEW:
        color = NNshParam->colorNew;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorNew = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_UPDATE:
        color = NNshParam->colorUpdate;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorUpdate = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_REMAIN:
        color = NNshParam->colorRemain;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorRemain = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ALREADY:
        color = NNshParam->colorAlready;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorAlready = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_NOTYET:
        color = NNshParam->colorNotYet;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorNotYet = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;

      case  SELTRID_COLOR_ERROR:
        color = NNshParam->colorError;

        // FI
        if (UIPickColor(&color, NULL, UIPickColorStartPalette, NULL, NULL)
                                                                      == true)
        {
            NNshParam->colorError = color;
        }
        FrmDrawForm(FrmGetActiveForm());
        return (false);
        break;
#endif

      // tH[JڂȂƂ
      default:
        // ȂɂȂ
        break;
    }

    // f֐ݒ
    switch (event->data.ctlSelect.controlID)
    {
      // NNsiݒ̊m
      case BTNID_CONFIG_NNSH_OK:
      case NNSHSET_2:
      case NNSHSET_3:
      case NNSHSET_4:
      case NNSHSET_5:
      case NNSHSET_6:
      case NNSHSET_7:
        effectFunc = &effect_NNshSetting;
        break;

      // NNsiݒ-2̊m
      case BTNID_NNSI_SET_OK:
      case NNSHSET2_1:
      case NNSHSET2_3:
      case NNSHSET2_4:
      case NNSHSET2_5:
      case NNSHSET2_6:
      case NNSHSET2_7:
        effectFunc = &effectNNsiSetting2;
        break;

      // NNsiݒ-3̊m
      case BTNID_NNSISET3_OK:
      case NNSHSET3_1:
      case NNSHSET3_2:
      case NNSHSET3_4:
      case NNSHSET3_5:
      case NNSHSET3_6:
      case NNSHSET3_7:
        effectFunc = &effectNNsiSetting3;
        break;

      // NNsiݒ-4̊m
      case BTNID_NNSISET4_OK:
      case NNSHSET4_1:
      case NNSHSET4_2:
      case NNSHSET4_3:
      case NNSHSET4_5:
      case NNSHSET4_6:
      case NNSHSET4_7:
        effectFunc = &effectNNsiSetting4;
        break;

      // NNsiݒ-5̊m
      case BTNID_NNSISET5_OK:
      case NNSHSET5_1:
      case NNSHSET5_2:
      case NNSHSET5_3:
      case NNSHSET5_4:
      case NNSHSET5_6:
      case NNSHSET5_7:
        effectFunc = &effectNNsiSetting5;
        break;

      // NNsiݒ-6̊m
      case BTNID_NNSISET6_OK:
      case NNSHSET6_1:
      case NNSHSET6_2:
      case NNSHSET6_3:
      case NNSHSET6_4:
      case NNSHSET6_5:
      case NNSHSET6_7:
        effectFunc = &effectNNsiSetting6;
        break;

      // NNsiݒ-7̊m
      case BTNID_NNSISET7_OK:
      case NNSHSET7_1:
      case NNSHSET7_2:
      case NNSHSET7_3:
      case NNSHSET7_4:
      case NNSHSET7_5:
      case NNSHSET7_6:
        effectFunc = &effectNNsiSetting7;
        break;

      // "Cancel"{^ꂽƂ
      case BTNID_CONFIG_NNSH_CANCEL:
      case BTNID_NNSI_SET_CANCEL:
      case BTNID_NNSISET3_CANCEL:
      case BTNID_NNSISET4_CANCEL:
      case BTNID_NNSISET5_CANCEL:
      case BTNID_NNSISET6_CANCEL:
      case BTNID_NNSISET7_CANCEL:
        effectFunc = NULL;
        break;

      case CHKID_USE_VFS:
        // VFS؂ւݒ𔽉f
        if (NNshParam->useVFS != NNSH_NOTSUPPORT_VFS)
        {
            // VFS  ON/OFF؂ւAʏVFSACeXVB
            chkObj   = FrmGetObjectPtr(frm,
                                       FrmGetObjectIndex(frm, CHKID_USE_VFS));
            chkObjSub1 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
            chkObjSub2 = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
            chkObjSub3 = FrmGetObjectPtr(frm,
                                FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
            if (CtlGetValue(chkObj) == 0)
            {
                CtlSetValue  (chkObjSub1, 0);
                CtlSetEnabled(chkObjSub1, false);
                CtlSetUsable (chkObjSub1, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetValue  (chkObjSub2, 0);
                CtlSetEnabled(chkObjSub2, false);
                CtlSetUsable (chkObjSub2, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetValue  (chkObjSub3, 0);
                CtlSetEnabled(chkObjSub3, false);
                CtlSetUsable (chkObjSub3, false);
                FrmHideObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));

                FrmEraseForm (frm);
            }
            else
            {
                CtlSetEnabled(chkObjSub1, true);
                CtlSetUsable (chkObjSub1, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));

                CtlSetEnabled(chkObjSub2, true);
                CtlSetUsable (chkObjSub2, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));

                CtlSetEnabled(chkObjSub3, true);
                CtlSetUsable (chkObjSub3, true);
                FrmShowObject(frm,
                              FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
            }
            FrmDrawForm(frm);
        }
        return (false);
        break;

      case CHKID_USE_BBS_NEWURL:
        // WURL`FbN{bNXꂽABBSꗗ擾WURLɕύX
        NNshWinSetFieldText(frm, FLDID_URL_BBS, true, URL_BBSTABLE,
                                                        StrLen(URL_BBSTABLE));
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_NEW, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_NEWURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      case CHKID_USE_BBS_OLDURL:
        // URL`FbN{bNXꂽƂABBSꗗ擾URLɕύX
        NNshWinSetFieldText(frm, FLDID_URL_BBS, true, URL_BBSTABLE_OLD,
                                                    StrLen(URL_BBSTABLE_OLD));
        NNsh_InformMessage(ALTID_INFO, MSG_CHANGED_URL_OLD, "", 0);
        chkObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_BBS_OLDURL));
        CtlSetValue(chkObj, 0);
        return (false);
        break;

      default:
        // LȊO(Ȃ)
        return (false);
        break;
    }

    // ݒ肳ꂽf[^𔽉f鏈
    if (effectFunc != NULL)
    {
        ret =  ((Err (*)())effectFunc)(frm);
        if (ret != errNone)
        {
            // ݒG[(ʂ͂̂܂)
            return (false);
        }
    }

    // ʑJڂ
    FrmEraseForm(frm);
    FrmGotoForm(formID);
    return (false);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNshSetting                                     */
/*                                                NNsiݒ̃tH[J */
/*=========================================================================*/
Err OpenForm_NNshSetting(FormType *frm)
{
    ControlType *chkObj, *chkObjSub1, *chkObjSub2, *chkObjSub3;

    /***  NNshݒ(O[oϐ)f  ***/

    // Xꗗ(subject.txt)S擾
    SetControlValue(frm, CHKID_SUBJECT_ALL, &(NNshParam->getAllThread));

    // mFbZ[Wȗ
    SetControlValue(frm, CHKID_OMIT_DIALOG, &(NNshParam->confirmationDisable));

    // 擾ɃXQ
    SetControlValue(frm, CHKID_OPEN_AUTO,   &(NNshParam->openAutomatic));

    // sage
    SetControlValue(frm, CHKID_WRITE_SAGE,  &(NNshParam->writeAlwaysSage));

    // ɁA啶ʂȂ
    SetControlValue(frm, CHKID_SEARCH_CASELESS, &(NNshParam->searchCaseless));

    // NOfflineX
    SetControlValue(frm, CHKID_OFFCHK_LAUNCH,   &(NNshParam->offChkLaunch));

    // VFS p\ɎIVFS ON
    SetControlValue(frm, CHKID_VFSON_AUTOMATIC,&(NNshParam->vfsOnAutomatic));

    // A_[COFF
    SetControlValue(frm, CHKID_MSG_LINEOFF, &(NNshParam->disableUnderline));

    // DEBUG
    SetControlValue(frm, CHKID_DEBUG_DIALOG,&(NNshParam->debugMessageON));

    // XꗗMSG
    SetControlValue(frm, CHKID_PRINT_NOFMSG,&(NNshParam->printNofMessage));

    // Xԍyzɂ
    SetControlValue(frm, CHKID_BOLD_MSGNUM, &(NNshParam->boldMessageNum));

    // uVFS̎gpv͂P̃p[^ŕ̈ӖLĂ邽
    chkObj     = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, CHKID_USE_VFS));
    chkObjSub1 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFS_WORKAROUND));
    chkObjSub2 = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_OFFLINE));
    chkObjSub3 = 
                 FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_VFSUSE_DBBACKUP));
    switch (NNshParam->useVFS)
    {
      // VFST|[g@̏ꍇAuVFS̎gpvݒ͕\ȂB
      case NNSH_NOTSUPPORT_VFS:
        CtlSetUsable(chkObj,     false);
        CtlSetUsable(chkObjSub1, false);
        CtlSetUsable(chkObjSub2, false);
        CtlSetUsable(chkObjSub3, false);
        break;

      // VFS̃`FbN
      case NNSH_VFS_DISABLE:
        CtlSetValue  (chkObj,     NNSH_VFS_DISABLE);
        CtlSetValue  (chkObjSub1, 0);
        CtlSetUsable (chkObjSub1, false);

        CtlSetValue  (chkObjSub2, 0);
        CtlSetUsable (chkObjSub2, false);

        CtlSetValue  (chkObjSub3, 0);
        CtlSetUsable (chkObjSub3, false);
        break;

      case NNSH_VFS_ENABLE:
      default:
        CtlSetValue  (chkObj,     NNSH_VFS_ENABLE);
        CtlSetUsable (chkObjSub1, true);
        CtlSetValue  (chkObjSub1, (NNSH_VFS_WORKAROUND & NNshParam->useVFS));

        CtlSetUsable (chkObjSub2, true);
        CtlSetValue  (chkObjSub2, (NNSH_VFS_USEOFFLINE & NNshParam->useVFS));

        CtlSetUsable (chkObjSub3, true);
        CtlSetValue  (chkObjSub3, (NNSH_VFS_DBBACKUP & NNshParam->useVFS));
        break;
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting2                                    */
/*                                               NNsiݒ2̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting2(FormType  *frm)
{
    UInt16       fieldIndex, timeout;
    Char         bufSize[MINIBUF];

    // tB[hɌ݂̃^CAEgl𔽉f
    MemSet(bufSize, sizeof(bufSize), 0x00);
    timeout = SysTicksPerSecond();
    timeout = (timeout == 0) ? 1 : timeout;  // [Z̉(ی)
    StrIToA(bufSize, (NNshParam->netTimeout / timeout));
    NNshWinSetFieldText(frm,FLDID_COMM_TIMEOUT,false,bufSize,StrLen(bufSize));

    // tB[hɌ݂̃obt@TCY𔽉f
    MemSet(bufSize, sizeof(bufSize), 0x00);
    StrIToA(bufSize, NNshParam->bufferSize);
    NNshWinSetFieldText(frm,FLDID_BUFFER_SIZE,false,bufSize,StrLen(bufSize));

    // tB[hɌ݂̕擾TCY𔽉f
    MemSet(bufSize, sizeof(bufSize), 0x00);
    StrIToA(bufSize, NNshParam->partGetSize);
    NNshWinSetFieldText(frm,FLDID_DL_PARTSIZE,false,bufSize,StrLen(bufSize));

    // tB[hɌ݂̃X^Cg𔽉f
    MemSet(bufSize, sizeof(bufSize), 0x00);
    StrIToA(bufSize, NNshParam->writeBufferSize);
    NNshWinSetFieldText(frm,FLDID_WRITEBUF_SIZE,false,bufSize,StrLen(bufSize));

    // _E[hwʂɔf
    SetControlValue(frm, CHKID_DL_PART, &(NNshParam->enablePartGet));

    // BBSꗗ擾URL̐ݒ
    NNshWinSetFieldText(frm, FLDID_URL_BBS, true, NNshParam->bbs_URL, MAX_URL);

    // Ren@\gpݒʂɔf
    SetControlValue(frm, CHKID_FIXED_HANDLE, &(NNshParam->useFixedHandle));

    // nh̐ݒ
    if (NNshParam->handleName[0] != '\0')
    { 
      NNshWinSetFieldText(frm, FLDID_HANDLENAME, true,
                            NNshParam->handleName, BUFSIZE);
    }

    // tH[JXobt@TCY͂ֈړ
    fieldIndex = FrmGetObjectIndex(frm, FLDID_BUFFER_SIZE);
    FrmSetFocus(frm, fieldIndex);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting3                                    */
/*                                               NNsiݒ3̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting3(FormType  *frm)
{
    Char         bufSize[MINIBUF];

    // NNsiIɉؒf
    SetControlValue(frm, CHKID_END_OFFLINE, &(NNshParam->disconnectNNsiEnd));

    // uVmFvIɉؒf
    SetControlValue(frm, CHKID_DISCONN_ARRIVAL, &(NNshParam->disconnArrivalEnd));

    // uVmFvIɖǈꗗ\
    SetControlValue(frm, CHKID_ARRIVAL_NOTREAD, &(NNshParam->autoOpenNotRead));

    // ڑ͎擾\
    SetControlValue(frm,CHKID_GETRESERVEFEATURE,&NNshParam->getReserveFeature);

    // MCookiegpď
    SetControlValue(frm, CHKID_WRITE_USE_COOKIE, &(NNshParam->useCookieWrite));

    // ڑʂĕ`
    SetControlValue(frm,CHKID_REDRAW_CONNECT,&(NNshParam->redrawAfterConnect));

    // ݎA݃tB[hɎIɃtH[JXړȂ
    SetControlValue(frm, CHKID_NOT_AUTOFOCUSSET,&(NNshParam->notAutoFocus));

    // ݎAA_[COFFɂ
    SetControlValue(frm, CHKID_UNDERLINE_WRITE, &(NNshParam->disableUnderlineWrite));

    // ݎQƃXԍ}
    SetControlValue(frm, CHKID_INSERT_REPLYNUM, &(NNshParam->insertReplyNum));

    // ݃V[PXPART2
    SetControlValue(frm, CHKID_WRITE_SEQUENCE2, &(NNshParam->writeSequence2));

    // ProxyoRł̃ANZX
    SetControlValue(frm, CHKID_USE_PROXY, &(NNshParam->useProxy));

    // Proxy URL
    if (NNshParam->proxyURL[0] != '\0')
    { 
        NNshWinSetFieldText(frm, FLDID_USE_PROXY, true,
                            NNshParam->proxyURL, MAX_URL);
    }

    // Proxy Port #
    if (NNshParam->proxyPort != 0)
    {
        MemSet (bufSize, sizeof(bufSize), 0x00);
        StrIToA(bufSize, NNshParam->proxyPort);
        NNshWinSetFieldText(frm,FLDID_PROXY_PORT,true,bufSize,StrLen(bufSize));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting4                                    */
/*                                               NNsiݒ4̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting4(FormType  *frm)
{

    // QƎBack{^JumpList
    SetControlValue(frm, CHKID_BACKBTN_JUMP, &(NNshParam->jogBackBtnAsGo));

    // QƎPush{^JumpList
    SetControlValue(frm, CHKID_PUSHBTN_JUMP, &(NNshParam->jogPushBtnAsGo));

    // QƎJumpListɁuꗗցv
    SetControlValue(frm, CHKID_ADD_RTNTOLIST, &(NNshParam->addReturnToList));

    // QƎJumpListɁuЂƂ߂v
    SetControlValue(frm, CHKID_ADD_BACKMESSAGE, &(NNshParam->addMenuBackRtnMsg));

    // QƎJumpListɁuj[v
    SetControlValue(frm, CHKID_ADD_OPENMENU, &(NNshParam->addMenuMsg));

    // QƎJumpListɁu擾v
    SetControlValue(frm, CHKID_ADD_GETPART, &(NNshParam->addLineGetPart));

    // QƎJumpListɁuؒfv
    SetControlValue(frm, CHKID_ADD_LINEDISCONN, &(NNshParam->addLineDisconn));

    // QƎJumpListɐ擪
    SetControlValue(frm, CHKID_ADD_JUMPTOP, &(NNshParam->addJumpTopMsg));

    // QƎJumpListɖ
    SetControlValue(frm, CHKID_ADD_JUMPBOTTOM, &(NNshParam->addJumpBottomMsg));

    // QƎJumpListɑSI+WebuEUŊJ
    SetControlValue(frm, CHKID_ADD_OPENWEB, &(NNshParam->addMenuSelAndWeb));

    // QƎJumpListɕ`惂[hؑ
    SetControlValue(frm, CHKID_ADD_GRAPHVIEW, &(NNshParam->addMenuGraphView));

    // QƎJumpListɂCɓݒ؂ւ
    SetControlValue(frm, CHKID_ADD_FAVORITE, &(NNshParam->addMenuFavorite));

    // ꗗBack{^Ńj[\
    SetControlValue(frm, CHKID_BACKBTN_LIST, &NNshParam->jogBackBtnAsMenu);

    // ꗗPush{^Ńj[\
    SetControlValue(frm, CHKID_PUSHBTN_LIST, &NNshParam->jogPushBtnAsMenu);

    // ꗗMenuɃj[ǉ
    SetControlValue(frm, CHKID_ADD_MENUOPEN, &NNshParam->addMenuTitle);

    // ꗗMenuɎQCOPY
    SetControlValue(frm, CHKID_ADD_MENUCOPY, &NNshParam->addMenuCopyMsg);

    // ꗗMenuMSG폜
    SetControlValue(frm, CHKID_ADD_MENUDELETE, &NNshParam->addMenuDeleteMsg);

    // ꗗMenuɕ`惂[hύX
    SetControlValue(frm, CHKID_ADD_MENUGRAPHMODE, &NNshParam->addMenuGraphTitle);

    // ꗗMenuɑړIXCb`P
    SetControlValue(frm, CHKID_ADD_MENUMULTISW1, &NNshParam->addMenuMultiSW1);

    // ꗗMenuɑړIXCb`Q
    SetControlValue(frm, CHKID_ADD_MENUMULTISW2, &NNshParam->addMenuMultiSW2);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting5                                    */
/*                                              NNsiݒ-5̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting5(FormType  *frm)
{
    ControlType *chkObjSub1;
    UInt16       dum;
#ifdef USE_ARMLET
    UInt32       processorType;

    // PalmOS5p@\gp
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMlet̎gp
        SetControlValue(frm, CHKID_USE_ARMLET, &(NNshParam->useARMlet));
    }
    else
#endif
    {
        // ARMlet̎gpɂāAݒ荀ڎ̂ʂɕ\Ȃ
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_USE_ARMLET));
        CtlSetUsable(chkObjSub1, false);

        NNshParam->useARMlet           = 0;
    }

    // ݒ@\gp
    SetControlValue(frm, CHKID_USE_BOOKMARK,&(NNshParam->useBookmark));

    // Ji𔼊pSpϊ
    SetControlValue(frm,CHKID_CONVERT_HANZEN, &(NNshParam->convertHanZen));

    // Xꗗʂtiny/smalltHggp
    SetControlValue(frm,CHKID_CLIE_USE_TITLE,
                                     &(NNshParam->useSonyTinyFontTitle));

    // OtBbN`惂[hgp
    SetControlValue(frm, CHKID_CLIE_USE_TINYFONT,
                                              &(NNshParam->useSonyTinyFont));

    // XQƉʂŃJ[\\Ȃ
    SetControlValue(frm, CHKID_NOT_FOCUSSET_NUM,
                                             &(NNshParam->notFocusNumField));

    // PUSH ON_CŁ}P
    SetControlValue(frm, CHKID_NOT_CURSOR, &(NNshParam->notCursor));

    // 擾ςݑSĂ͎QƐpOɕ\Ȃ
    SetControlValue(frm, CHKID_NOT_READONLY, &(NNshParam->notListReadOnly));

    // WebBrowserJƂŐV50
    if (NNshGlobal->browserCreator != 0)
    {
        if (NNshParam->browseMesNum != 0)
        {
            dum = 1;
            SetControlValue(frm, CHKID_WEBBROWSE_LAST50, &dum);
        }
    }
    else
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_WEBBROWSE_LAST50));
        CtlSetUsable(chkObjSub1, false);
    }

#ifdef USE_CLIE
    // SilksȂ̕\ۃ`FbN
    if (NNshGlobal->silkVer != 0)
    {
        if (NNshGlobal->notUseSilk != 0)
        {
            dum = 1;
            SetControlValue(frm, CHKID_NOTUSE_SILK, &dum);
        }
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm,
                              FrmGetObjectIndex(frm, CHKID_NOTUSE_SILK));
        CtlSetUsable(chkObjSub1, false);
    }

    // SONYnC]sȂ
#ifdef USE_CLIE
    if ((NNshGlobal->notUseHR != 0)||(NNshGlobal->hrRef != 0))
    {
        if (NNshParam->disableSonyHR != 0)
        {
            dum = 1;
        }
        else
        {
            dum = 0;
        }
        SetControlValue(frm, CHKID_NOTUSE_SONYHIRES, &dum);
    }
    else
#endif
    {
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObjSub1 = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, 
                                                  CHKID_NOTUSE_SONYHIRES));
        CtlSetUsable(chkObjSub1, false);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting6                                    */
/*                                              NNsiݒ-6̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting6(FormType  *frm)
{
    ControlType *ctlObj;
    ListType    *lstP;
    UInt16      item, lp;
    Char        *ptr, *bbsLbl;
    Err         ret;

    // URL擾AL`FbNȂ
    SetControlValue(frm, CHKID_NOTCHECK_BBSURL,&(NNshParam->notCheckBBSURL));

    // ړɖ擾X폜
    SetControlValue(frm, CHKID_AUTODEL_NOT_YET,&(NNshParam->autoDeleteNotYet));

    // OfflineXɃX{Ȃ
    SetControlValue(frm, CHKID_NOT_DELOFFLINE, &(NNshParam->notDelOffline));

    // QƐpփRs[ƂAɃX폜{
    SetControlValue(frm, CHKID_COPYDEL_READONLY,&(NNshParam->copyDelReadOnly));

    // ړIXCb`P(ꗗ)̃xݒ(ƃXgACeݒ)
    item = NNshParam->usageOfTitleMultiSwitch1 & (NNSH_SWITCHUSAGE_FUNCMASK);
    setMultiPurposeTitleLabel(frm, POPTRID_LIST_FUNCSW1, item);
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW1));
    LstSetSelection(lstP, item);

    // ړIXCb`Q(ꗗ)̃xݒ(ƃXgACeݒ)
    item = NNshParam->usageOfTitleMultiSwitch2 & (NNSH_SWITCHUSAGE_FUNCMASK);
    setMultiPurposeTitleLabel(frm, POPTRID_LIST_FUNCSW2, item);
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_TITLE_FUNCSW2));
    LstSetSelection(lstP, item);

    // Cɓ\ŒXx̃xݒ(ƃXgACeݒ)
    switch (NNshParam->displayFavorLevel)
    {
      case NNSH_MSGATTR_FAVOR_L2:
        item = 1;
        ptr  = NNSH_ATTRLABEL_FAVOR_L2;
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        item = 2;
        ptr  = NNSH_ATTRLABEL_FAVOR_L3;
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        item = 3;
        ptr  = NNSH_ATTRLABEL_FAVOR_L4;
        break;

      case NNSH_MSGATTR_FAVOR:
        item = 4;
        ptr  = NNSH_ATTRLABEL_FAVOR;
        break;

      case NNSH_MSGATTR_FAVOR_L1:
      default:
        item = 0;
        ptr  = NNSH_ATTRLABEL_FAVOR_L1;
        break;
    }
    ctlObj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_FAVOR_LEVEL));
    CtlSetLabel(ctlObj, ptr);
    lstP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_FAVOR_LEVEL));
    LstSetSelection(lstP, item);

    // BBSꗗ̍쐬
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret == errNone)
    {
        // BBSꗗ̃XgԂ𔽉fB
        NNshWinSetListItems(frm, LSTID_CHECK_NEWARRIVAL,
                            NNshGlobal->bbsTitles, lp,
                            NNshParam->newArrivalNotRead,
                            &(NNshGlobal->bbsTitleH));

        // |bvAbvgK̃x(XgԂɍ킹)XV
        bbsLbl = NNshGlobal->bbsTitles;
        for (lp = 0; lp < NNshParam->newArrivalNotRead; lp++)
        {
            bbsLbl = bbsLbl + StrLen(bbsLbl) + 1;
        }
        if (bbsLbl != NULL)
        {
            ctlObj = FrmGetObjectPtr(frm,
                                   FrmGetObjectIndex(frm, POPTRID_NEWARRIVAL));
            CtlSetLabel(ctlObj, bbsLbl);
        }
    }

#ifdef USE_COLOR
    // ꗗ\ɃJ[(OS3.5ȏŐݒ荀ڂLɂ)
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // J[̎gpݒ
        SetControlValue(frm, CHKID_USE_COLORMODE, &(NNshParam->useColor));

        // {́AZN^gK̃LvVɐF...

    }
    else
#endif
    {
        NNshParam->useColor = 0;

        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        FrmCopyLabel(frm, LBL_SEL_COLOR, "  ");

        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, CHKID_USE_COLORMODE));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_UNKNOWN));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_OVER));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NEW));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_UPDATE));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_REMAIN));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_ALREADY));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_NOTYET));
        CtlSetUsable(ctlObj, false);
        ctlObj = FrmGetObjectPtr(frm,
                                 FrmGetObjectIndex(frm, SELTRID_COLOR_ERROR));
        CtlSetUsable(ctlObj, false);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiSetting7                                    */
/*                                              NNsiݒ-7̃tH[J */
/*=========================================================================*/
Err OpenForm_NNsiSetting7(FormType  *frm)
{

    return (errNone);
}
