/*============================================================================*
 *  FILE: 
 *     msgview.c
 *
 *  Description: 
 *     Message(Thread) Viewer for NNsh. 
 *
 *===========================================================================*/
#define MSGVIEW_C
#include "local.h"
#include "Clipboard.h"

static Err PartReceiveMessage_View(void);


/*-------------------------------------------------------------------------*/
/*   Function : setFavoriteLabel                                           */
/*                                            Cɓݒ̃xݒ */
/*-------------------------------------------------------------------------*/
static void setFavoriteLabel(FormType *frm, UInt16 attribute)
{
    ControlType *selP;

    // Cɓݒ̃ZN^gKIuWFNg擾
    selP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SELTRID_FAVOR_THREAD));
    if (selP == NULL)
    {
        // IuWFNg̎擾s
        return;
    }

    switch (attribute & NNSH_MSGATTR_FAVOR)
    {
      case NNSH_MSGATTR_FAVOR_L1:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L1);
        break;

      case NNSH_MSGATTR_FAVOR_L2:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L2);
        break;

      case NNSH_MSGATTR_FAVOR_L3:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L3);
        break;

      case NNSH_MSGATTR_FAVOR_L4:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR_L4);
        break;

      case NNSH_MSGATTR_FAVOR:
        // Cɓ背x()
        CtlSetLabel(selP, NNSH_ATTRLABEL_FAVOR);
        break;

      default:
        // Cɓł͂Ȃ
        CtlSetLabel(selP, NNSH_ATTRLABEL_NOTFAVOR);
        break;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openWebBrowser                                             */
/*                                                       WebuEUŊJ */
/*-------------------------------------------------------------------------*/
static void openWebBrowser(UInt16 confirmation, Char *buffer, UInt16 size)
{
    MemHandle  memH;
    UInt16     len, savedParam;
    Char      *urlP, *ptr, *dest;

    // Nbv{[hɂf[^擾
    MemSet(buffer, size, 0x00);
    memH = ClipboardGetItem(clipboardText, &len);
    if ((len != 0)&&(memH != 0))
    {
        urlP = MemHandleLock(memH);
        if (urlP != NULL)
        {
            ptr = StrStr(urlP, "tp://");
            if (ptr != NULL)
            {
                // URL擾("http://")
                ptr = ptr + StrLen("tp://");
                StrCopy(buffer, "http://");
                dest = &buffer[StrLen(buffer)];

                // Nbv{[hURL̕(ASCII)𒊏o
                while ((dest < buffer + size)&&(*ptr > ' ')&&(*ptr < 0x7f))
                {
                    *dest = *ptr;
                    dest++;
                    ptr++;
                }
            }
            MemHandleUnlock(memH);                
        }
    }
    if (buffer[0] != 0x00)
    {
        // NetFrontw肳ꂽURLŋN邩mF
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = confirmation;
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, buffer,
                                MSG_WEBLAUNCH_CONFIRM, 0) == 0)
        {
            NNshParam->confirmationDisable = savedParam;

            // NetFrontN(NNsiIɋN)
            (void) WebBrowserCommand(NNshGlobal->browserCreator,
                                     false, 0, 
                                     NNshGlobal->browserLaunchCode,
                                     buffer, NULL);
        }
        NNshParam->confirmationDisable = savedParam;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : jumpPrevious                                               */
/*                                                PÕbZ[W֖߂ */
/*-------------------------------------------------------------------------*/
static void jumpPrevious(void)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;
 
    // 1łWvĂΖ߂
    if (idxP->prevMsg[idxP->histIdx] != 0)
    {
        idxP->openMsg = idxP->prevMsg[idxP->histIdx];
        idxP->histIdx = (idxP->histIdx != 0) ?
                                       (idxP->histIdx - 1) : (PREVBUF - 1);
    }
    (void) displayMessage(NNshGlobal->msgIndex);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : jumpEdge                                                   */
/*                                             bZ[Ẅړ(擪/) */
/*-------------------------------------------------------------------------*/
static void jumpEdge(Boolean loc)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;

    idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ? (idxP->histIdx + 1) : 0;
    idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
    if (loc == false)
    {
        // X̐擪
        idxP->openMsg    = 1;
    }
    else
    {
        // X̖
        idxP->openMsg    = idxP->nofMsg;
    }
    (void) displayMessage(NNshGlobal->msgIndex);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : parseMessage                                               */
/*                                                  (bZ[W̐`) */
/*-------------------------------------------------------------------------*/
static void parseMessage(Char *buf, Char *source, UInt32 size,
                         UInt16 *nofJmp, UInt16 *jmpBuf)
{
    UInt32 dataStatus, jmp;
    Char *ptr, *dst, *num;

    dataStatus = MSGSTATUS_NAME;

    // x߃[`... (PÂp[X)
    dst  = buf;
    ptr  = source;
    while (ptr < (source + size))
    {
        if (*ptr == '&')
	{
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&
		(*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                if ((*ptr <= '9')&&(*ptr >= '0'))
                {
                    // XԂ擾
                    num = ptr;
                    jmp = 0;
                    while ((*num <= '9')&&(*num >= '0'))
                    {
                        jmp = jmp * 10 + (*num - '0');
                        num++;
                    }
                    if ((*nofJmp < JUMPBUF)&&(jmp != 0))
                    {
                        // XԂobt@ɒǉ
                        jmpBuf[*nofJmp] = jmp;
                        (*nofJmp)++;
                    }
                }
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&
		(*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
		(*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&
		(*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
		(*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&
		(*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
		(*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                // MR̂ەϊ΍... ()
                if ((*(ptr + 5) == 'g')&&(*(ptr + 6) == 't')&&
                    (*(ptr + 7) == ';'))
                {
                    *dst++ = '>';
                    ptr = ptr + 8;    // StrLen(TAG_AMP)+ 'g' + 't' + ';';
                    if ((*ptr <= '9')&&(*ptr >= '0'))
                    {
                        // XԂ擾
                        num = ptr;
                        jmp = 0;
                        while ((jmp < NNSH_MESSAGE_LIMIT)&&
                               (*num <= '9')&&(*num >= '0'))
                        {
                            jmp = jmp * 10 + (*num - '0');
                            num++;
                        }
                        if ((*nofJmp < JUMPBUF)&&(jmp != 0))
                        {
                            // XԂobt@ɒǉ
                            jmpBuf[*nofJmp] = jmp;
                            (*nofJmp)++;
                        }
                    }
                    continue;
                }
                // MR̂ەϊ΍... (܂)

                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }
        if (*ptr == '<')
	{
            //  "<>" ́AZp[^(Ԃɂĕς)
            if (*(ptr + 1) == '>')
            {
                ptr = ptr + 2;   // StrLen(DATA_SEPARATOR);
                switch (dataStatus)
                {
                  case MSGSTATUS_NAME:
                    // Ő؂
                    *dst++ = ' ';
                    *dst++ = ' ';
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_EMAIL;
                    break;

                  case MSGSTATUS_EMAIL:
                    // e-mail̋؂
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_DATE;
                    *dst++ = '\n';
                    break;

                  case MSGSTATUS_DATE:
                    // NEԂтhc̋؂
                    *dst++ = '\n';
                    *dst++ = '\n';
                    dataStatus = MSGSTATUS_NORMAL;
                    break;

                  case MSGSTATUS_NORMAL:
                  default:
                    // bZ[W̏I[
                    *dst++ = ' ';
                    *dst++ = '\0';
                    return;
                    break;
                }
                continue;
            }
            //  "<br>" ́Asɒu
            if ((*(ptr + 1) == 'b')&&(*(ptr + 2) == 'r')&&
		(*(ptr + 3) == '>'))
            {
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }
            // ^O͓ǂݔ΂
#ifdef USE_STRSTR
            ptr = StrStr(ptr, ">");
#else
            while ((*ptr != '>')&&(*ptr != '\0'))
            {
                ptr++;
            }
#endif
            ptr++;
            *dst++ = ' ';
            continue;
        }
        if (NNshParam->convertHanZen != 0)
        {
            if (((UInt8) *ptr >= 0x81)&&((UInt8) *ptr <= 0x9f))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            if (((UInt8) *ptr >= 0xe0)&&((UInt8) *ptr <= 0xef))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            // pJiSpϊ
            if (ConvertHanZen((UInt8 *) dst, (UInt8 *) ptr) == true)
            {
                dst = dst + 2;
                ptr++;
                continue;
            }
        }

        // NULL͖
        if (*ptr != '\0')
        {
            // ʂ̈ꕶ]
            *dst++ = *ptr;
        }
	ptr++;
    }
    *dst++ = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : changeFont                                                 */
/*                                                          tHg̕ύX */
/*-------------------------------------------------------------------------*/
static void changeFont(void)
{
    FormType  *frm;

    frm = FrmGetActiveForm();

    // tHgID̑I
    if (NNshParam->useSonyTinyFont != 0)
    {
        // SONYnC]tHgύX
        NNshParam->sonyHRFont = FontSelect(NNshParam->sonyHRFont);

        // tB[h̕`(nC])
        NNsi_HRFldDrawField(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, FLDID_MESSAGE)));
        // XN[o[̍XV
        NNsi_HRSclUpdate(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, SCLID_MESSAGE)));
    }
    else
    {
        // ʏtHgύX
        NNshParam->currentFont = FontSelect(NNshParam->currentFont);

        // tB[h̕`(ʏ)
        FldSetFont(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE)),
                                   NNshParam->currentFont);

        // XN[o[XVāAʏ̉ʕ`s
        NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);
        FrmDrawForm(frm);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : ReadMessage_Close                                          */
/*                                                      QƉʂ̃N[Y */
/*-------------------------------------------------------------------------*/
static void ReadMessage_Close(UInt16 nextFormID)
{
    NNshMessageIndex *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;
    if (idxP != NULL)
    {
        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(NNshGlobal->msgIndex);
    }

    // nC]pf[^lNA
    NNshGlobal->totalLine   = 0;
    NNshGlobal->nofPage     = 0;
    NNshGlobal->currentPage = 0;
    NNshGlobal->prevHRLines = 0;

    // XIʂJ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(nextFormID);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : displayMessageSub                                          */
/*                                                   bZ[W\C  */
/*-------------------------------------------------------------------------*/
static void displayMessageSub(UInt16 bbsType, Char *topP, UInt32 mesNum,
                              UInt32 offset, UInt32 size)
{
    FormType    *frm;
    MemHandle    oldTxtH, txtH;
    Char        *buf, *ptr;
    UInt32       msgSize, allocSize;
    void        *fldP;
#ifdef USE_ARMLET
    UInt32       armArgs[8], nofJump, lp, jmpMsg[JUMPBUF], hanzen;
    MemHandle    armH;
    void        *armP;
#endif
    NNshMessageIndex *idxP;
    idxP = NNshGlobal->msgIndex;

    // \obt@쐬
    //  (X^CgƔpSpϊpƂđ߂ɗ̈mۂ)
    allocSize = (size + size + (MARGIN + MARGIN + MARGIN));
    allocSize = (allocSize > NNshParam->bufferSize) ? 
                                            NNshParam->bufferSize : allocSize;
    txtH = MemHandleNew(allocSize);
    if (txtH == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_SUBJECT_LISTFAIL,
                           " size:", allocSize);
        return;
    }
    buf  = MemHandleLock(txtH);
    if (buf == NULL)
    {
        MemHandleFree(txtH);
        NNsh_InformMessage(ALTID_WARN, "MemHandleLock()", " ", 0);
        return;
    }

    // bZ[W̐`
    if (bbsType == NNSH_BBSTYPE_MACHIBBS)
    {
        ptr = StrStr((topP + offset), NNSH_MACHITOKEN_MSGSTART);
        if (ptr == NULL)
        {
            ptr = topP + offset;
        }
        else
        {
            ptr = ptr + StrLen(NNSH_MACHITOKEN_MSGSTART);
        }
        // bZ[WTCY̌킹...
        msgSize = size - (ptr - (topP + offset)) - 2;
    }
    else
    {
        ptr     = (topP + offset);
        msgSize = size;
    }

    // \̈A擪ɃbZ[Wԍ\
    MemSet(buf, msgSize, 0x00);
    if (NNshParam->boldMessageNum != 0)
    {
        StrCopy(buf, "y");
        NUMCATI(buf, mesNum);
        StrCat (buf, "z");
    }
    else
    {
        StrCopy(buf, "[");
        NUMCATI(buf, mesNum);
        StrCat (buf, "] ");
    }

    // WvQƐ
    idxP->nofJump = 0;

// ARMletgpăbZ[W̉͂sB(łAȂ񂩖ʂȏ...)
#ifdef USE_ARMLET
    // ARMlet̊֐|C^擾
    if (NNshParam->useARMlet != 0)
    {
        armH = DmGetResource('armc', RSCID_parseMessage_ARM);
        if (armH != 0)
        {
            armP = MemHandleLock(armH);
            if (armP != NULL)
            {
                // ARMletgpẴCfbNX͏
                hanzen     = NNshParam->convertHanZen;
                MemSet(armArgs, sizeof(armArgs), 0x00);
                armArgs[0] = (UInt32) (buf + StrLen(buf));
                armArgs[1] = (UInt32) ptr;
                armArgs[2] = (UInt32) msgSize;
                armArgs[3] = (UInt32) &(nofJump);
                armArgs[4] = (UInt32) &(jmpMsg[0]);
                armArgs[5] = (UInt32) hanzen;
                armArgs[6] = (UInt32) &Han2ZenTable[0];
                (void) PceNativeCall(armP, armArgs);
                MemHandleUnlock(armH);
                idxP->nofJump = (UInt16) nofJump;

                // ȏA(68k)ĂX|CȂ...
                for (lp = 0; lp < idxP->nofJump; lp++)
                {
                    idxP->jumpMsg[lp] = (UInt16) jmpMsg[lp];
                }
            }
            else
            {
                // (W)CfbNX͏
                parseMessage((buf + StrLen(buf)), ptr, msgSize,
                             &(idxP->nofJump), &(idxP->jumpMsg[0]));
            }
            DmReleaseResource(armH);
        }
        else
        {
            // (W)CfbNX͏
            parseMessage((buf + StrLen(buf)), ptr, msgSize,
                         &(idxP->nofJump), &(idxP->jumpMsg[0]));
        }
    }
    else
#endif
    {
        // (W)CfbNX͏
        parseMessage((buf + StrLen(buf)), ptr, msgSize,
                     &(idxP->nofJump), &(idxP->jumpMsg[0]));
    }
    (void) MemHandleUnlock(txtH);

    // tB[h̍XV
    frm     = FrmGetActiveForm();
    fldP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
    oldTxtH = FldGetTextHandle(fldP);
    FldSetTextHandle(fldP, NULL);
    FldSetTextHandle(fldP, txtH);
    if (oldTxtH != 0)
    {
        (void) MemHandleFree(oldTxtH);
    }

    // tB[h̕\
    if (NNshParam->useSonyTinyFont != 0)
    {
        // tB[h̕\nϐNA
        NNshGlobal->totalLine   = 0;
        NNshGlobal->nofPage     = 0;
        NNshGlobal->currentPage = 0;
        NNshGlobal->prevHRLines = 0;

        // tB[h̕`(nC])
        NNsi_HRFldDrawField(fldP);

        // XN[o[̍XV
        NNsi_HRSclUpdate(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, SCLID_MESSAGE)));
    }
    else
    {
        // tB[h̕`(ʏ)
        FldDrawField(fldP);

        // XN[o[̕\XV
        NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);

        FrmDrawForm(frm);
    }

#if 0
    // WvQƐ炠邩\(̃fobO\)
    if (idxP->nofJump != 0)
    {
        if ((buf = MemPtrNew(BUFSIZE)) != NULL)
        {
            MemSet(buf, BUFSIZE, 0x00);
            StrCopy(buf, "nofJump:");
            NUMCATI(buf, idxP->nofJump);
            StrCat (buf, "\n----\n");
            for (msgSize = 0; msgSize < idxP->nofJump; msgSize++)
            {
                StrCat(buf, "  >>");
                NUMCATI(buf, idxP->jumpMsg[msgSize]);
            }
            StrCat (buf, "\n");
            NNsh_DebugMessage(ALTID_INFO, buf, "", 0);
            MemPtrFree(buf);
        }
    }
#endif

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : displayMessage                                             */
/*                                                   bZ[W\  */
/*-------------------------------------------------------------------------*/
static Err displayMessage(NNshMessageIndex *idxP)
{
    Err          ret = errNone;
    UInt16       msg;
    UInt32       readSize, offset, setMsg, backMsg;

    msg    = idxP->openMsg;
    offset = 0;

    //  w肳ꂽbZ[WԍÓ`FbNB
    if ((msg < 1)||(msg > idxP->nofMsg))
    {
        return (~errNone);
    }

    // f[^͍ǂݍ܂Ă̈ɂ邩`FbNB(킹...)
    if ((idxP->msgOffset[msg - 1]  < idxP->fileOffset)||
        (idxP->msgOffset[msg] - 1  > idxP->fileOffset + idxP->fileReadSize))
    {
        // ݁Aǂݍ܂Ăobt@ɂ̓f[^ȂꍇBBB
        if (idxP->msgOffset[msg] < NNshParam->bufferSize)
        {
            // t@C̐擪ǂݍ
            offset = 0;
	}
        else if (idxP->msgOffset[msg - 1] >
                                     (idxP->fileSize - NNshParam->bufferSize))
        {
            // t@C̖ǂݍ
            offset = idxP->fileSize - NNshParam->bufferSize;
	}
        else
        {
            // ߂郁bZ[W肷B
            backMsg = NNshParam->bufferSize / 1200;

            // (CfbNX̐擪 - backMsg)ǂݍ
            setMsg = ((msg - backMsg) < 1) ? 1: (msg - backMsg);
	    offset = idxP->msgOffset[setMsg] - 10;  // 10̓}[W(ӖȂ)
            if ((offset + NNshParam->bufferSize) < idxP->msgOffset[msg + 1])
            {
                // backMsgbZ[WOǂݍݔ͈͊Oꍇ͂̏ꏊ
                offset = idxP->msgOffset[msg] - 10; // 10̓}[W(ӖȂ)
            }
        }

        // u҂āv\ (hideBusyForm()܂)
        Show_BusyForm(MSG_READ_MESSAGE_WAIT);

        // f[^obt@ɓǂݍށB
        ret = ReadFile_NNsh(&(idxP->fileRef), offset, NNshParam->bufferSize,
                            &(idxP->buffer[0]), &readSize);
        if ((ret == errNone)||(ret == vfsErrFileEOF)||(ret == fileErrEOF))
        {
            idxP->fileOffset   = offset;
            idxP->fileReadSize = readSize;
        }
        Hide_BusyForm(true);
    }
    if ((ret == errNone)||(ret == vfsErrFileEOF)||(ret == fileErrEOF))
    {
        // bZ[W\B
        offset = (idxP->msgOffset[msg - 1] - (idxP->fileOffset));

        displayMessageSub(idxP->bbsType, idxP->buffer, msg, offset,
                          idxP->msgOffset[msg] - idxP->msgOffset[msg - 1]);
    }

    // ǂ񂾃bZ[Wԍ(ƂCɓ)L
    MarkMessageIndex(NNshParam->openMsgIndex, NNSH_MSGATTR_NOTSPECIFY);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : moveMessageNext                                            */
/*                                           ЂƂ̃bZ[W\  */
/*-------------------------------------------------------------------------*/
static Boolean moveMessageNext(Boolean chkScroll)
{
    Boolean           ret = false;
    NNshMessageIndex *idxP;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // bZ[W̃XN[`FbN
    if (chkScroll == true)
    {
        ret = NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0, winDown); 
    }
    if ((ret != true)&&(idxP->openMsg < idxP->nofMsg))
    {
         // bZ[WԍЂƂ₵Aʕ\B
         (idxP->openMsg)++;
         (void) displayMessage(NNshGlobal->msgIndex);
         ret = true;
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : moveMessagePrev                                            */
/*                                             ЂƂÕbZ[W\  */
/*-------------------------------------------------------------------------*/
static Boolean moveMessagePrev(Boolean chkScroll)
{
    Boolean ret = false;
    NNshMessageIndex *idxP;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // bZ[W̃XN[`FbN
    if (chkScroll == true)
    {
        ret = NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0,  winUp);
    }
    if ((ret != true)&&(idxP->openMsg > 1))
    {
         // bZ[WԍЂƂ炵Aʕ\B
         (idxP->openMsg)--;
         (void) displayMessage(NNshGlobal->msgIndex);
         ret = true;
    }
    return (ret);
}
/*-------------------------------------------------------------------------*/
/*   Function : jumpMessage                                                */
/*                                                (bZ[WWv) */
/*-------------------------------------------------------------------------*/
static Boolean jumpMessage(FormType *frm, NNshMessageIndex *idxP)
{
    UInt16     tempMsg, num, btnId, size, nofItems, savedParam;
    UInt16     jumpList[NNSH_NOF_JUMPMSG_EXT + JUMPBUF + 2];
    UInt16     msgAttribute;
    EventType *dummyEvent;
    FieldType *fldP;
    Char      *numP, buffer[BUFSIZE * 2];
    MemHandle  txtH;

    // ͂ꂽl擾
    tempMsg = idxP->openMsg;
    fldP    = FrmGetObjectPtr(frm, 
                              FrmGetObjectIndex(frm, FLDID_MESSAGE_NUMBER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != NULL)
    {
        numP = MemHandleLock(txtH);
        num = StrAToI(numP);

        // lÓȂ̂`FbN
        if ((num > 0)&&(num <= idxP->nofMsg))
        {
            tempMsg = num;
        }
        MemHandleUnlock(txtH);
    }

    // tB[hɓ͂ĂȂꍇ
    if (tempMsg == idxP->openMsg)
    {
        //  Go{^ꂽƂA͂ĂȂꍇA
        //  ߂XԍXgIuWFNgƂĕ\B
        size = (idxP->nofJump + NNSH_NOF_JUMPMSG_EXT + 1) * NNSH_JUMPMSG_LEN;
        idxP->jumpListTitles = MemPtrNew(size);
        if (idxP != NULL)
        {
            // Xgɕ\^CgXg쐬
            nofItems = 0; 
            MemSet(jumpList, sizeof(jumpList), 0x00);
            MemSet(idxP->jumpListTitles, 0x00, size);
            numP = idxP->jumpListTitles;

            if (NNshParam->addReturnToList != 0)
            {
                // XgɁuꗗցvǉ
                StrCopy(numP, NNSH_JUMPMSG_TO_LIST);
                numP = numP + sizeof(NNSH_JUMPMSG_TO_LIST);
                jumpList[nofItems] = (NNSH_JUMPSEL_TO_LIST);
                nofItems++;
            }

            // Wvԍݒ肷
            for (num = 0; num < idxP->nofJump; num++)
            {
                // Wvԍ͈͊Ȏ傫Ȓl̂Ƃ͕\Ȃ
                if (idxP->jumpMsg[num] <= idxP->nofMsg)
                {
                    StrCopy(numP, NNSH_JUMPMSG_HEAD);
                    NUMCATI(numP, idxP->jumpMsg[num]);
                    numP = numP + StrLen(numP) + 1;
                    jumpList[nofItems] = idxP->jumpMsg[num];
                    nofItems++;
                }
            }

            if (NNshParam->addMenuBackRtnMsg != 0)
            {
                // XgɁuP߂vǉ
                StrCopy(numP, NNSH_JUMPMSG_BACK);
                numP = numP + sizeof(NNSH_JUMPMSG_BACK);
                jumpList[nofItems] = (NNSH_JUMPSEL_BACK);
                nofItems++;
            }

            if (NNshParam->addJumpTopMsg != 0)
            {
                // XgɁu擪ցvǉ
                StrCopy(numP, NNSH_JUMPMSG_TOP);
                numP = numP + sizeof(NNSH_JUMPMSG_TOP);
                jumpList[nofItems] = (NNSH_JUMPSEL_TOP);
                nofItems++;
            }

            if (NNshParam->addJumpBottomMsg != 0)
            {
                // XgɁuցvǉ
                StrCopy(numP, NNSH_JUMPMSG_BOTTOM);
                numP = numP + sizeof(NNSH_JUMPMSG_BOTTOM);
                jumpList[nofItems] = (NNSH_JUMPSEL_BOTTOM);
                nofItems++;
            }

            if (NNshParam->addMenuMsg != 0)
            {
                // XgɁuj[vǉ
                StrCopy(numP, NNSH_JUMPMSG_OPEN_MENU);
                numP = numP + sizeof(NNSH_JUMPMSG_OPEN_MENU);
                jumpList[nofItems] = (NNSH_JUMPSEL_OPEN_MENU);
                nofItems++;
            }

            if (NNshParam->addLineGetPart != 0)
            {
                // XgɁu擾vǉ
                StrCopy(numP, NNSH_JUMPMSG_UPDATE);
                numP = numP + sizeof(NNSH_JUMPMSG_UPDATE);
                jumpList[nofItems] = (NNSH_JUMPSEL_UPDATE);
                nofItems++;
            }

            if (NNshParam->addLineDisconn != 0)
            {
                // XgɁuؒfvǉ
                StrCopy(numP, NNSH_JUMPMSG_HANGUP);
                numP = numP + sizeof(NNSH_JUMPMSG_HANGUP);
                jumpList[nofItems] = (NNSH_JUMPSEL_HANGUP);
                nofItems++;
            }

            if (NNshParam->addMenuSelAndWeb != 0)
            {
                // XgɁuI+Webvǉ
                StrCopy(numP, NNSH_JUMPMSG_OPENWEB);
                numP = numP + sizeof(NNSH_JUMPMSG_OPENWEB);
                jumpList[nofItems] = (NNSH_JUMPSEL_OPENWEB);
                nofItems++;
            }

            if (NNshParam->addMenuGraphView != 0)
            {
                // XgɁu`惂[hύXvǉ
                StrCopy(numP, NNSH_JUMPMSG_CHANGEVIEW);
                numP = numP + sizeof(NNSH_JUMPMSG_CHANGEVIEW);
                jumpList[nofItems] = (NNSH_JUMPSEL_CHANGEVIEW);
                nofItems++;
            }

            if (NNshParam->addMenuFavorite != 0)
            {
                // XgɁuCɓݒύXvǉ
                StrCopy(numP, NNSH_JUMPMSG_FAVORITE);
                numP = numP + sizeof(NNSH_JUMPMSG_FAVORITE);
                jumpList[nofItems] = (NNSH_JUMPSEL_FAVORITE);
                nofItems++;
            }

            // IEBhE\
            btnId = NNshWinSelectionWindow(idxP->jumpListTitles, nofItems);
            if (btnId != BTNID_JUMPCANCEL)
            {
                // IXgԍR}h擾
                switch (jumpList[NNshGlobal->jumpSelection])
                {
                  case NNSH_JUMPSEL_BACK:
                    // POɔ񂾃bZ[Wɖ߂
                    jumpPrevious();
                    return (false);
                    break;

                  case NNSH_JUMPSEL_TO_LIST:
                    // XIʂɖ߂
                    ReadMessage_Close(FRMID_THREAD);
                    return (false);
                    break;

                  case NNSH_JUMPSEL_OPEN_MENU:
                    // j[J
                    // (_~[ō㕔penDownEvent𐶐)
                    dummyEvent = &(NNshGlobal->dummyEvent);
                    MemSet(dummyEvent, sizeof(EventType), 0x00);
                    dummyEvent->eType    = penDownEvent;
                    dummyEvent->penDown  = true;
                    dummyEvent->tapCount = 1;
                    dummyEvent->screenX  = 5;
                    dummyEvent->screenY  = 5;
                    EvtAddEventToQueue(dummyEvent);

                    // bZ[W()ĕ\
                    (void) displayMessage(idxP);
                    return (false);
                    break;

                  case NNSH_JUMPSEL_UPDATE:
                    // 擾
                    (void) PartReceiveMessage_View();
                    return (false);
                    break;

                  case NNSH_JUMPSEL_HANGUP:
                    // ؒf
                    savedParam = NNshParam->confirmationDisable;
                    NNshParam->confirmationDisable = 1;
                    NNshNet_LineHangup();
                    NNshParam->confirmationDisable = savedParam;

                    // bZ[W\
                    (void) displayMessage(idxP);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_OPENWEB:
                    // SI{WebuEUŊJ
                    frm  = FrmGetActiveForm();
                    fldP = FrmGetObjectPtr(frm, 
                                       FrmGetObjectIndex(frm, FLDID_MESSAGE));
                    savedParam = FldGetTextLength(fldP);

                    // I𕶎̏ݒ肷
                    savedParam = (savedParam > NNSH_LIMIT_COPYBUFFER) ?
                                           NNSH_LIMIT_COPYBUFFER : savedParam;
                    FldSetSelection(fldP, 0, savedParam);
                    FldCopy(fldP);
                    if (NNshGlobal->browserCreator != 0)
                    {
                        // WebBrowserŊJ(̂ƂAmFMSGȂ)
                        openWebBrowser(1, buffer, sizeof(buffer));
                    }
                    return (false);
                    break;

                  case NNSH_JUMPSEL_TOP:
                    // 擪
                    tempMsg = 1;
                    break;

                  case NNSH_JUMPSEL_BOTTOM:
                    // 
                    tempMsg = idxP->nofMsg;
                    break;

                  case NNSH_JUMPSEL_CHANGEVIEW:
                    // `惂[hύX
                    if (NNshParam->useSonyTinyFont == 0)
                    {
                        // nC][h֕ύX
                        NNshParam->useSonyTinyFont = 1;
                    }
                    else
                    {
                        // ʏ탂[h֕ύX
                        NNshParam->useSonyTinyFont = 0;
                    }
                    MemPtrFree(idxP->jumpListTitles);

                    // ʂxĂxJ
                    ReadMessage_Close(FRMID_MESSAGE);
                    return (true);
                    break;

                  case NNSH_JUMPSEL_FAVORITE:
                    // X\
                    DisplayMessageInformations(NNshParam->openMsgIndex, 
                                               &msgAttribute);

                    // Cɓ񃉃xXV
                    setFavoriteLabel(FrmGetActiveForm(), msgAttribute);

                    // \XV(OS3.1foCXł͐^ɂȂ邽)
                    (void) displayMessage(idxP);
                    break;

                  default:
                    // wԍ̃bZ[WփWv
                    tempMsg = jumpList[NNshGlobal->jumpSelection];
                    break;
                }
            }
            MemPtrFree(idxP->jumpListTitles);
        }
        else
        {
            NNsh_DebugMessage(ALTID_ERROR, "Jump LIST Create Failure.", "", 0);
        }
    }

    // tB[hNA
    NNshWinSetFieldText(frm, FLDID_MESSAGE_NUMBER, true, "", 0); 

    // bZ[WړăWvAbZ[W\
    if (tempMsg != idxP->openMsg)
    {
        idxP->histIdx = 
                  (idxP->histIdx < (PREVBUF - 1)) ? (idxP->histIdx + 1) : 0;
        idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
        idxP->openMsg = tempMsg;

        // bZ[W\
        (void) displayMessage(idxP);
        return (true);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : selectScrollEvent                                          */
/*                                       XN[o[XVCxg̏  */
/*-------------------------------------------------------------------------*/
static Boolean sclRepEvt_DispMessage(EventType *event)
{
    Int16   lines;

    lines = event->data.sclExit.newValue - event->data.sclExit.value;
    if (lines < 0)
    {
      (void)
           NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0, winUp);
    }
    else
    {
      (void)
           NNshWinViewPageScroll(FLDID_MESSAGE, SCLID_MESSAGE, 0, winDown);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : selectKeyDownEvent                                         */
/*                                                 L[ꂽ̏  */
/*                                (WOAVXgneẽWOǉ) */
/*-------------------------------------------------------------------------*/
static Boolean selEvt_KeyDown_DispMessage(EventType *event)
{
    Boolean           ret = false;
    FormType         *frm;
    FieldType        *fld;
    NNshMessageIndex *idxP;
    UInt16            keyCode;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // CfbNXȂꍇɂ́Areturn
    if (NNshGlobal->msgIndex == NULL)
    {
        return (false);
    }

    //tungsten T 5way navigator (281AӁI)
    if (event->data.keyDown.chr == vchrNavChange)
    {
        keyCode = KeyConvertFiveWayToJogChara(event);
    }
    else
    {
        keyCode = event->data.keyDown.chr;
    }
    switch (keyCode)
    {
      // uv(WO_C)̏
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
        (void) moveMessageNext(true);
        ret = true;
        break;

      case chrCapital_N:  // NL[̓
      case chrSmall_N:
        // ЂƂ̃bZ[WɈړ 
        (void) moveMessageNext(false);
        ret = true;
        break;

      // uv(WO_C)̏
      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
        (void) moveMessagePrev(true);
        ret = true;
        break;

      case chrCapital_P:  // PL[̓
      case chrSmall_P:
        // ЂƂÕbZ[WɈړ 
        (void) moveMessagePrev(false);
        ret = true;
        break;

      // WO_C()̏
      case vchrJogPushedUp:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGUP;
#endif
        /** not break!!  **/

      // J[\L[()̏
      case chrRecordSeparator:
      case chrCapital_R:  // RL[̓
      case chrSmall_R:
        ret = true;
        // 񂵂łPÂÏグH
        if (NNshParam->notCursor != 0)
        {
            // ̃bZ[W\ďI
            (void) moveMessagePrev(false);
            break;
        }
        if (idxP->openMsg > 1)
        {
            // bZ[Wԍ10炵Aʕ\B
            idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ?
                                                 (idxP->histIdx + 1) : 0;
            idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
            idxP->openMsg = (idxP->openMsg > 11) ? (idxP->openMsg - 10) : 1;
            (void) displayMessage(NNshGlobal->msgIndex);
        }
        break;

      // WO_C()̏
      case vchrJogPushedDown:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGDOWN;
#endif
        /** not break!!  **/

      // J[\L[()̏
      case chrUnitSeparator:
      case chrCapital_F:  // FL[̓
      case chrSmall_F:
        ret = true;
        // 񂵂łPÂÉH
        if (NNshParam->notCursor != 0)
        {
            // ̃bZ[W\ďI
            (void) moveMessageNext(false);
            break;
        }

        if (idxP->openMsg < idxP->nofMsg)
        {
            // bZ[Wԍ10₵Aʕ\B
            idxP->histIdx = (idxP->histIdx < (PREVBUF - 1)) ?
                                                 (idxP->histIdx + 1) : 0;
            idxP->prevMsg[idxP->histIdx] = idxP->openMsg;
            idxP->openMsg    = (idxP->openMsg < idxP->nofMsg - 10) ?
                                          (idxP->openMsg + 10) : idxP->nofMsg;
            (void) displayMessage(NNshGlobal->msgIndex);
        }
        break;

      // JOG Push̏(萳mɂ̓{^𗣂Ƃ)
      case vchrJogRelease:
#ifdef USE_CLIE
        ret = true;
        if (NNshGlobal->tempStatus == NNSH_TEMPTYPE_CLEARSTATE)
        {
            if (NNshParam->jogPushBtnAsGo != 0)
            {
                // Go{^Ɠȏɂ
                jumpMessage(FrmGetActiveForm(), NNshGlobal->msgIndex);
                return (true);
            }
            // X擾
            (void) PartReceiveMessage_View();
        }
        // ꎞԂNA
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
#endif
        break;

      // Sony obN{^/HandEra obN{^/ESCL[/XL[̏
      case vchrJogBack:
      case chrEscape:
      case chrCapital_X:  // XL[̓
      case chrSmall_X:
        if (NNshParam->jogBackBtnAsGo != 0)
        {
            // Go{^Ɠȏɂ
            jumpMessage(FrmGetActiveForm(), NNshGlobal->msgIndex);
            return (true);
        }
        // XIʂɖ߂
        ReadMessage_Close(FRMID_THREAD);
        return(true);
        break;

      //  HandEra Jog-Push/EnterL[Ƃ̏
      case chrCarriageReturn:
      case chrLineFeed:
        if (NNshParam->jogPushBtnAsGo != 0)
        {
            // Go{^Ɠȏɂ
            jumpMessage(FrmGetActiveForm(), NNshGlobal->msgIndex);
            return (true);
        }
        // (擾)
        PartReceiveMessage_View();
        return (true);
        break;

      // ÕWvXɖ߂(Back{^Ɠ)
      case chrCapital_Z:  // ZL[̓
      case chrSmall_Z:
        jumpPrevious();
        return (true);
        break;

      // LL[
      case chrCapital_L:
      case chrSmall_L:
        ret = true;
        // tHgύX
        changeFont();
        break;

      case chrCapital_J:  // JL[̓
      case chrSmall_J:
        // XԎw̃bZ[W擾
        (void) Get_MessageFromMesNum(&ret);
        if (ret == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);
        }
        ret = true;
        break;

      // DL[
      case chrCapital_D:
      case chrSmall_D:
        if (NNshParam->useSonyTinyFont == 0)
        {
            // nC][h֕ύX
            NNshParam->useSonyTinyFont = 1;

            // ʂ`悷
            (void) displayMessage(NNshGlobal->msgIndex);
        }
        else
        {
            // ʏ탂[h֕ύX
            NNshParam->useSonyTinyFont = 0;
            frm  = FrmGetActiveForm();

            // tB[ḧgpł悤ɕύX
            fld = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm, FLDID_MESSAGE));
            FldSetUsable(fld, true);

            // XN[o[̍XV
            NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);

            // tH[ĕ\Ȃ
            FrmEraseForm(frm);
            FrmDrawForm(frm);
        }
        ret = true;
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        ret = true;
        // ؒf
        NNshNet_LineHangup();
        break;

        // BL[
      case chrCapital_B:
      case chrSmall_B:
        ret = true;
        // X̖
        jumpEdge(true);
        break;

        // TL[
      case chrCapital_T:
      case chrSmall_T:
        // X̐擪
        ret = true;
        jumpEdge(false);
        break;

        // Xy[XL[EGL[̓(bZ[WJUMP)
      case chrSpace:
      case chrCapital_G:
      case chrSmall_G:
        ret = true;
        jumpMessage(FrmGetActiveForm(), NNshGlobal->msgIndex);
        break;

      case chrCapital_W:  // WL[̓
      case chrSmall_W:
        // Xɏ(OFFLINEXɂ͏݂Ȃ)
        if (StrCompare(idxP->boardNick, OFFLINE_THREAD_NICK) != 0)
        {
            ReadMessage_Close(FRMID_WRITE_MESSAGE);
            ret = true;
        }
        break;

      default:
        // L[R[h\
        NNsh_DebugMessage(ALTID_INFO, "Pushed a key  code:", "",
                          event->data.keyDown.chr);
        break;
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlSelEvt_DispMessage                                    */
/*                                                      {^̏ */
/*-------------------------------------------------------------------------*/
Boolean ctlSelEvt_DispMessage(EventType *event)
{
    FormType         *frm;
    NNshMessageIndex *idxP;
    UInt16            msgAttribute;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    // CfbNXȂꍇɂ́Areturn
    if (idxP == NULL)
    {
        return (false);
    }

    // ݃ANeBuȃtH[擾
    frm = FrmGetActiveForm();

    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_TOP:
        // X̐擪
        jumpEdge(false);
        break;

        // O{^ 
      case BTNID_PREV_MESSAGE:
        moveMessagePrev(false);
        break;

        // {^ 
      case BTNID_NEXT_MESSAGE:
        moveMessageNext(false);
        break;

        // {^(X̖)
      case BTNID_BOTTOM:
        jumpEdge(true);
        break;

        // ߂{^ 
      case BTNID_BACK_MESSAGE:
        jumpPrevious();
        break;

        // GO{^
      case BTNID_JUMP:
        jumpMessage(frm, NNshGlobal->msgIndex);
        break;

        // {^
      case BTNID_WRITE_MESSAGE:
        // Xɏ(OFFLINEXɂ͏݂Ȃ)
        if (StrCompare(idxP->boardNick, OFFLINE_THREAD_NICK) != 0)
        {
            ReadMessage_Close(FRMID_WRITE_MESSAGE);
        }
        break;

        // {^
      case BTNID_BOOKMARK:
        if (NNshParam->useBookmark != 0)
        {
            NNshParam->lastFrmID     = FRMID_MESSAGE;
            NNshParam->bookMsgIndex  = NNshParam->openMsgIndex;
            NNshParam->bookMsgNumber = idxP->openMsg;
            NNsh_InformMessage(ALTID_INFO, MSG_SET_BOOKMARK, "", 0);
        }
        break;

      case SELTRID_THREAD_TITLE:  
        // ^Cg{^(ꗗʂɖ߂)
        ReadMessage_Close(FRMID_THREAD);
        break;

      case SELTRID_FAVOR_THREAD:
        // X\
        msgAttribute = 0;
        DisplayMessageInformations(NNshParam->openMsgIndex, &msgAttribute);

        // Cɓ񃉃xXV
        setFavoriteLabel(FrmGetActiveForm(), msgAttribute);

        // \XV(OS3.1foCXł͐^ɂȂ邽)
        (void) displayMessage(idxP);
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   MenuEvt_DispMessage                                      */
/*                                                    j[Ȉ */
/*-------------------------------------------------------------------------*/
Boolean menuEvt_DispMessage(EventType *event)
{
    Boolean    err;
    Char       logMsg[BUFSIZE * 2];
    FormType  *frm;
    FieldType *fld;
#ifdef USE_HANDERA
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h
#endif
    NNshMessageIndex *idxP;
    UInt16            frmId, msgAttribute;

    // indexϐɓ
    idxP = NNshGlobal->msgIndex;

    switch (event->data.menu.itemID)
    {
      case MNUID_THREAD_SELECTION:
        // XIʂɖ߂
        ReadMessage_Close(FRMID_THREAD);
        break;

      case MNUID_THREAD_INFO:
        // X\B 
        msgAttribute = 0;
        DisplayMessageInformations(NNshParam->openMsgIndex, &msgAttribute);

        // Cɓ񃉃xXV
        setFavoriteLabel(FrmGetActiveForm(), msgAttribute);

        // \XV(OS3.1foCXł͐^ɂȂ邽)
        (void) displayMessage(idxP);
        break;

      case MNUID_TOP_MESSAGE:
        // X̐擪ɃWv
        jumpEdge(false);
        break;

      case MNUID_BOTTOM_MESSAGE:
        // X̖ɃWv
        jumpEdge(true);
        break;

      case MNUID_WRITE_MESSAGE:
        // Xɏ(OFFLINEXɂ͏݂Ȃ)
        if (StrCompare(idxP->boardNick, OFFLINE_THREAD_NICK) != 0)
        {
            ReadMessage_Close(FRMID_WRITE_MESSAGE);
        }
        break;

      case MNUID_GET_PART:
        // X擾
        (void) PartReceiveMessage_View();
        break;

      case MNUID_GET_MESNUM:
        // XԎw̃bZ[W擾
        (void) Get_MessageFromMesNum(&err);
        if (err == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);
        }
        break;

      case MNUID_NET_DISCONN:
        // ؒf
        NNshNet_LineHangup();
        break;

      case MNUID_FONT_MSGVIEW:
        // tHgύX
        changeFont();
        break;

#ifdef USE_HANDERA
      case MNUID_HANDERA_ROTATE_MSGVIEW:
        // HandEra ʉ] //
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
            VgaSetScreenMode(screenMode1To1, 
                             VgaRotateSelect(handEraRotateMode));

            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
	}
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;
#endif // #ifdef USE_HANDERA

      case MNUID_CLIE_DRAW_MODE: 
        if (NNshParam->useSonyTinyFont == 0)
        {
            // nC][h֕ύX
            NNshParam->useSonyTinyFont = 1;
        }
        else
        {
            // ʏ탂[h֕ύX
            NNshParam->useSonyTinyFont = 0;
        }
        ReadMessage_Close(FRMID_MESSAGE);
        return (true);
        break;

      case MNUID_OS5_LAUNCH_WEB:
        if (NNshGlobal->browserCreator == 0)
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
            break;
        }

        // I𕶎gāANetFrontŊJ
        frm   = FrmGetActiveForm();
        frmId = FrmGetFocus(frm);
        if (frmId == noFocus)
        {        
           // tH[JX擾łȂAI
            break;
        }
        if (FrmGetObjectType(frm, frmId) == frmFieldObj)
        {
            // IĂ镶UNbv{[hɃRs[
            FldCopy(FrmGetObjectPtr(frm, frmId));

            // WebuEUŊJ
            openWebBrowser(NNshParam->confirmationDisable, logMsg, sizeof(logMsg));
        }
        break;

      case MNUID_EDIT_COPY:
        // Rs[
        frm   = FrmGetActiveForm();
        frmId = FrmGetFocus(frm);
        if (frmId == noFocus)
        {        
           // tH[JX擾łȂAI
            break;
        }
        if (FrmGetObjectType(frm, frmId) == frmFieldObj)
        {
            FldCopy(FrmGetObjectPtr(frm, frmId));
            if (NNshParam->useSonyTinyFont != 0)
            {
                // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
                NNsi_HRFldDrawField(FrmGetObjectPtr(frm, frmId));
            }
        }
        break;

      case MNUID_SELECT_ALL:
        // ̑SI
        frm = FrmGetActiveForm();
        fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        FldSetSelection(fld, 0, FldGetTextLength(fld));
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        if (NNshParam->useSonyTinyFont != 0)
        {
            // nC]tHgݒ蒆̎ɂ́AtB[h̍ĕ`s
            NNsi_HRFldDrawField(fld);
        }
        break;

      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        OpenNetworkPreferences();
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Hander_NNshMessage                                       */
/*                                                       Cxgnh  */
/*-------------------------------------------------------------------------*/
Boolean Handler_NNshMessage(EventType *event)
{
    Boolean   ret = false;
#ifdef USE_HANDERA
    FormType *frm;
#endif

    switch (event->eType)
    {
      case keyDownEvent:
        return (selEvt_KeyDown_DispMessage(event));
        break;

      case ctlSelectEvent:
        return (ctlSelEvt_DispMessage(event));
        break;

      case fldChangedEvent:
        NNshWinViewUpdateScrollBar(FLDID_MESSAGE, SCLID_MESSAGE);
        return (false);
        break;

      case menuEvent:
        return (menuEvt_DispMessage(event));
        break;

      case sclRepeatEvent:
        return (sclRepEvt_DispMessage(event));
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent:
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
        }
        break;
#endif

      case menuOpenEvent:
      case fldEnterEvent:
      case frmOpenEvent:
      case popSelectEvent:
      case lstSelectEvent:
      case lstEnterEvent:
      case lstExitEvent:
      case sclExitEvent:
      default:
       break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function : OpenForm_NNshMessage                                       */
/*                              (XbhVKǂݏoFbZ[W\ȊO) */
/*=========================================================================*/
Err OpenForm_NNshMessage(FormType *frm)
{
    Err                  ret;
    UInt16               bufferSize, fileMode;
    Char                 title   [NNSH_MSGTITLE_BUFSIZE];
    Char                 fileName[MAXLENGTH_FILENAME], *area;
    NNshSubjectDatabase  subjDB;
    ControlType         *selP;
    FieldAttrType        attr;
    FieldType           *fldP;
    NNshMessageIndex    *idxP;

    // @\gEgȂłݒ{^\邩؂ւ
    if (NNshParam->useBookmark != 0)
    {
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_BOOKMARK));
    }
    else
    {
        selP= FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BOOKMARK));
        CtlSetUsable(selP, false);
    }

    // X܂擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (ret != errNone)
    {
        // subjectf[^x[Xf[^擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        goto FUNC_END;
    }

    // ꎞobt@̈悪łɊmۂĂAēxƂȂB
    if (NNshGlobal->msgIndex != NULL)
    {
        idxP = NNshGlobal->msgIndex;
        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(NNshGlobal->msgIndex);
    }
    bufferSize = sizeof(NNshMessageIndex) + NNshParam->bufferSize + MARGIN * 2;
    NNshGlobal->msgIndex = MemPtrNew(bufferSize);
    if (NNshGlobal->msgIndex == NULL)
    {
        NNsh_InformMessage(ALTID_ERROR, "ERR>MemPtrNew(MsgIndex)",
                       " size:", bufferSize);
        ret = ~errNone;
        goto FUNC_END;
    }
    MemSet(NNshGlobal->msgIndex, bufferSize, 0x00);

    // BBS^Cv[N̈ɃRs[
    idxP = NNshGlobal->msgIndex;
    idxP->bbsType = (UInt16) subjDB.bbsType;

    // ^Cgƃ{[hjbNl[[N̈ɃRs[
    StrNCopy(idxP->threadTitle, subjDB.threadTitle, MAX_THREADNAME - 1);
    StrNCopy(idxP->boardNick,   subjDB.boardNick,   MAX_NICKNAME - 1);

    // ǂݍރt@C̏
    MemSet (fileName, sizeof(fileName), 0x00);

    // OFFLINEX̂Ƃ́AboardNicktȂ悤ɂ
    if (StrCompare(subjDB.boardNick, OFFLINE_THREAD_NICK) != 0)
    {
        StrCopy(fileName, subjDB.boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNgt
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            // ɃTufBNgĕt
            GetSubDirectoryName(subjDB.dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, subjDB.threadFileName);

    // t@Ĉ肩ŁAJ[h؂ւ
    if (subjDB.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        fileMode = ((NNSH_FILEMODE_TEMPFILE)|(NNSH_FILEMODE_READONLY));
    }
    else
    {
        fileMode = (NNSH_FILEMODE_READONLY);
    }
    ret = OpenFile_NNsh(fileName,fileMode,&(idxP->fileRef));
    if (ret != errNone)
    {
        MemPtrFree(idxP);
        idxP = NULL;
        NNsh_InformMessage(ALTID_ERROR, "Message File Open :", fileName, ret);
        goto FUNC_END;
    }
    GetFileSize_NNsh(&(idxP->fileRef), &(idxP->fileSize));

    //  bZ[WXbh̃CfbNX쐬
    ret = CreateMessageThreadIndex(idxP, &(idxP->nofMsg), idxP->msgOffset,
                                   (UInt16) subjDB.bbsType);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, "ERR>index creation failure", "", ret);
        goto FUNC_END;
    }

    // A_[C̕\ݒ
    MemSet(&attr, sizeof(FieldAttrType), 0x00);
    fldP  = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
    FldGetAttributes(fldP, &attr);
    if (NNshParam->disableUnderline != 0)
    {
        attr.underlined = noUnderline;
    }
    else
    {
        attr.underlined = grayUnderline;
    }
    FldSetAttributes(fldP, &attr);

    // tH[^Cg̍XV(bZ[Wi[)
    StrCopy(title, "1:");
    NUMCATI(title, idxP->nofMsg);
    FrmCopyTitle(frm, title);

    // X^Cg̕\
    selP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, SELTRID_THREAD_TITLE));
    if (selP != NULL)
    {
        CtlSetLabel(selP, idxP->threadTitle);
    }

    // ǂݏoӏ̊mF(ُȂ擪)
    if ((subjDB.currentLoc < 1)||(subjDB.currentLoc > idxP->nofMsg))
    {
        idxP->openMsg = 1;
    }
    else
    {
        idxP->openMsg = subjDB.currentLoc;
    }
    idxP->prevMsg[0] = idxP->openMsg;
    idxP->histIdx    = 0;

    // Ƃ肠t@C̐擪f[^ǂݍł
    switch (ret)
    {
        case errNone:
        case vfsErrFileEOF:
        case fileErrEOF:
          // read OK, create Index!
          ret = errNone;
          break;

        default:
          goto FUNC_END;
          break;
    }

    // 肪ݒ肳Ăꍇ́A̒l߂B
    if ((NNshParam->useBookmark != 0)&&(NNshParam->bookMsgNumber != 0))
    {
        if (NNshParam->bookMsgIndex == NNshParam->openMsgIndex)
        {
            (NNshGlobal->msgIndex)->openMsg = NNshParam->bookMsgNumber;
        }
    }

    // uCɓvݒZN^gK̃xɐݒ肷
    setFavoriteLabel(frm, subjDB.msgAttribute);

    // uXQƉʂŃtH[JXړȂvɃ`FbNȂꍇ
    if (NNshParam->notFocusNumField == 0)
    {
        // tH[JXbZ[WԍtB[hɐݒ
        FrmSetFocus(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE_NUMBER));
    }

    // ʕ\
    (void) displayMessage(NNshGlobal->msgIndex);
    NNshParam->lastFrmID = FRMID_MESSAGE;
    return (errNone);

FUNC_END:
    // G[I
    ReadMessage_Close(FRMID_THREAD);
    return (ret);
}

/*=========================================================================*/
/*   Function : GetSubDirectoryName                                        */
/*                                                  TufBNg̎擾 */
/*=========================================================================*/
Err GetSubDirectoryName(UInt16 index, Char *dirName)
{
    DmOpenRef              dirRef;
    UInt16                 size, nextIndex;
    Int16                  depth, saveDepth;
    Err                    ret;
    Char                  *buffer;
    NNshDirectoryDatabase  dirDb;

    if (index == 0)
    {
        // wINDEXُ
        NNsh_DebugMessage(ALTID_INFO,
                          "There is not any sub-directory.", "", index);
        return (~errNone - 2);
    }

    OpenDatabase_NNsh(DBNAME_DIRINDEX, DBVERSION_DIRINDEX, &dirRef);

    // TufBNggbv擾
    MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
    ret = SearchRecord_NNsh(dirRef, &index, NNSH_KEYTYPE_UINT16, 0,
                            sizeof(NNshDirectoryDatabase), &dirDb, &saveDepth);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_INFO, "SearchRecord_NNsh() ret:", "",   ret);
        NNsh_DebugMessage(ALTID_INFO, "SearchRecord_NNsh() index:", "", index);

        GetDBCount_NNsh(dirRef, &size);
        for (nextIndex = 0; nextIndex < size; nextIndex++)
        {
            MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
            ret = GetRecord_NNsh(dirRef, nextIndex,
                                 sizeof(NNshDirectoryDatabase), &dirDb);
            NNsh_DebugMessage(ALTID_INFO, "GetRecord_NNsh() ret:", "", ret);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " INDEX:", nextIndex);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " dirIdx:", dirDb.dirIndex);
            NNsh_DebugMessage(ALTID_INFO, dirDb.dirName, " prevdx:", dirDb.previousIndex);
        }

        // DBR[hmۃG[
        CloseDatabase_NNsh(dirRef);
        return (ret);
    }
    NNsh_DebugMessage(ALTID_INFO, "depth:", dirDb.dirName, dirDb.depth);

    // ꎞIɗ̈mۂ
    size = (dirDb.depth + 1) * sizeof(Char) * MAX_DIRNAME + MARGIN;
    buffer = MemPtrNew(size);
    if (buffer == NULL)
    {
        // ̈mۃG[
        CloseDatabase_NNsh(dirRef);
        return (~errNone);
    }
    MemSet(buffer, size, 0x00);

    // TufBNgdirDB猟
    saveDepth = dirDb.depth - 1;
    for (depth = saveDepth; depth >= 0; depth--)
    {
        NNsh_DebugMessage(ALTID_INFO, "copy ", dirDb.dirName, depth);

        // fBNgRs[
        StrNCopy(&buffer[depth * sizeof(Char) * MAX_DIRNAME],
                 dirDb.dirName, (MAX_DIRNAME - 1));
        if (dirDb.previousIndex == 0)
        {
            // I
            break;
        }

        // fBNg
        nextIndex = dirDb.previousIndex;
        MemSet(&dirDb, sizeof(NNshDirectoryDatabase), 0x00);
        ret = SearchRecord_NNsh(dirRef, &(nextIndex), NNSH_KEYTYPE_UINT16, 0,
                                sizeof(NNshDirectoryDatabase), &dirDb, &index);
        if (ret != errNone)
        {
            // sAɂ
            NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh()", "", ret);
            break;
	}
    }

    // fBNgRs[
    for (depth = 0; depth <= saveDepth; depth++)
    {
        StrCat(dirName, &buffer[depth * sizeof(Char) * MAX_DIRNAME]);
    }
    NNsh_DebugMessage(ALTID_INFO, "SubDirectory:", dirName, depth);

    // Ƃ܂
    MemPtrFree(buffer);
    CloseDatabase_NNsh(dirRef);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : PartReceiveMessage_View                                    */
/*                                                            X擾 */
/*-------------------------------------------------------------------------*/
static Err PartReceiveMessage_View(void)
{
    Err                  ret;
    Char                 url[BUFSIZE];
    UInt16               index;
    NNshSubjectDatabase  subjDB;
    NNshBoardDatabase    bbsData;
    NNshMessageIndex    *idxP;

    // bZ[WCfbNX
    idxP = NNshGlobal->msgIndex;

    // bZ[Wf[^x[X擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, &subjDB);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()", "", ret);
        return (ret);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(subjDB.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           idxP->threadTitle, 0);
        return (~errNone);
    }
    
    ret = Get_BBS_Database(subjDB.boardNick, &bbsData, &index);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "Get_BBS_Database() nick:", 
                          subjDB.boardNick, ret);
        return (ret);
    }

    if (subjDB.bbsType == NNSH_BBSTYPE_MACHIBBS)
    {
        // ܂BBSɑ΂č擾IA݃T|[gȂ(Ƃ肠?)
        NNsh_ErrorMessage(ALTID_WARN, MSG_NOTSUPPORT_MACHI, "", 0);
        return (~errNone);
    }

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if ((NNshParam->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // V\񎞂Ɏ擾\ݒ肵ďI
            subjDB.msgAttribute
                     = subjDB.msgAttribute | NNSH_MSGATTR_GETRESERVE;

            (void) update_subject_database(NNshParam->openMsgIndex, &subjDB);
            return (errNone);
        }
    }

    // ݎQƒ̃t@CUN[YĂ
    CloseFile_NNsh(&(idxP->fileRef));

    // X擾s
    MemSet (url, sizeof(url), 0x00);
    StrCopy(url, bbsData.boardURL);
    StrCat (url, "dat/");
    StrCat (url, subjDB.threadFileName);

    (void) Get_PartMessage(url, bbsData.boardNick, &subjDB, 
                           NNshParam->openMsgIndex, NULL);

    // \Ȃ
    return (OpenForm_NNshMessage(FrmGetActiveForm()));
}
