/*============================================================================*
 *  FILE: 
 *     symbols.h
 *
 *  Description: 
 *     symbol definitions for NNsh.
 *
 *===========================================================================*/

//////////////////////////////////////////////////////////////////////////////
/***  DATABASE VERSIONS  ***/
#define SOFT_PREFID           100
#define SOFT_PREFVERSION      204

#define NNSH_PREFERID         200
#define NNSH_PREFERTYPE       105

#define SOFT_DBTYPE_ID        'Data'
#define OFFLINE_DBTYPE_ID     'GIKO'

#define DBNAME_BBSLIST        "BBS-NNsi"
#define DBVERSION_BBSLIST     160

#define DBNAME_SUBJECT        "Subject-NNsi"
#define DBVERSION_SUBJECT     160

#define DBNAME_SETTING        "Settings-NNsi"
#define DBVERSION_SETTING     111
#define DBSIZE_SETTING        32

#define DBNAME_DIRINDEX       "DirIndex-NNsi"
#define DBVERSION_DIRINDEX    100

//////////////////////////////////////////////////////////////////////////////

#define RSCID_createThreadIndexSub_ARM     1     // ARMlet֐ԍ̂P
#define RSCID_parseMessage_ARM             2     // ARMlet֐ԍ̂Q

//////////////////////////////////////////////////////////////////////////////

/** buffer size(small) **/
#define MINIBUF                     48
#define BUFSIZE                    128
#define BIGBUF                     640
#define PREVBUF                     12

// JUMPBUF̒lύXꍇɂ́AARMlet̓V{ύX邱
#define JUMPBUF                     12  // ӁFARMletɓV{`

/** ꎞmۗ̈̕(5120 < x < 61000) **/
#define NNSH_WORKBUF_MIN          5120
#define NNSH_WORKBUF_MAX         61000
#define NNSH_WORKBUF_DEFAULT     32750
#define MARGIN                       4

/** ݎɊmۂobt@TCY **/
#define NNSH_WRITEBUF_MIN         4096
#define NNSH_WRITEBUF_MAX        61000
#define NNSH_WRITEBUF_DEFAULT     6144

/** BBS-DB̕TCY **/
#define MAX_URL                     80
#define MAX_BOARDNAME               40
#define MAX_NICKNAME                16
#define LIMIT_BOARDNAME             20

/** Thread-DB ̕TCY **/
#define MAX_THREADFILENAME          32
#define MAX_THREADNAME              72
#define MAX_DIRNAME                 40
#define LIMIT_TITLENAME_DEFAULT     72
#define LIMIT_TITLENAME_MINIMUM     12

/** ^Cgуẍ̗TCY **/
#define BBSSEL_PAGEINFO             12
#define NNSH_MSGTITLE_BUFSIZE       10

/** VFSt@C̍őTCY  **/
#define MAXLENGTH_FILENAME          256

/** _E[hɑz肷HTTPwb_TCY **/
#define NNSH_HTTPGET_HEADERMAX      400
#define NNSH_DOWNLOADSIZE_MIN      2048

/** ʐM^CAEgl(tick) **/
#define NNSH_NET_TIMEOUT           2500

/** bZ[W̍ő僌Xԍ **/
#define NNSH_MESSAGE_MAXNUMBER     1005
#define NNSH_MESSAGE_LIMIT         1000

/** BBS URL **/
#define URL_BBSTABLE_OLD            "http://www6.ocn.ne.jp/~mirv/bbstable.html"
#define URL_BBSTABLE                "http://www.ff.iij4u.or.jp/~ch2/bbstable.html"
#define URL_PREFIX                  "test/read.cgi/"
#define URL_PREFIX_MACHIBBS         "bbs/read.pl?BBS="
#define FILE_THREADLIST             "subject.txt"

/** default font ID **/
#define NNSH_DEFAULT_FONT           stdFont

#define NNSH_NOTENTRY_THREAD        0xffff

/** OFFLINE LOG(for GIKO Shippo) **/
#define OFFLINE_THREAD_NAME         "QƐpO"
#define OFFLINE_THREAD_NICK         "!GikoShippo/"
#define OFFLINE_THREAD_URL          "file://"

#define FAVORITE_THREAD_NAME        "Cɓ"
#define GETALL_THREAD_NAME          "擾ςݑS"
#define NOTREAD_THREAD_NAME         "ǂ"

#define NNSH_NOF_SPECIAL_BBS        4   // Ȕ̐
#define NNSH_SELBBS_FAVORITE        0   // CɓX
#define NNSH_SELBBS_GETALL          1   // 擾ςݑS
#define NNSH_SELBBS_NOTREAD         2   // ǂ
#define NNSH_SELBBS_OFFLINE         3   // OFFLINEX

// for NaNaShi FILE NAMEs
#define FILE_WRITEMSG               "write.txt"
#define FILE_WRITENAME              "writeName.txt"
#define FILE_WRITEMAIL              "writeMail.txt"
#define FILE_RECVMSG                "recv.txt"
#define FILE_SENDMSG                "send.txt"
#define DATAFILE_PREFIX             "/PALM/Programs/NNsh/"
#define LOGDATAFILE_PREFIX          "/PALM/Programs/2ch/"
#define LOGDIR_FILE                 "/PALM/Programs/2ch/logdir.txt"
#define DATAFILE_SUFFIX             ".dat"

//  time diference between from 'Jan/01/1904' to 'Jan/01/1970'.
#define TIME_CONVERT_1904_1970      (2082844800 - 32400)
#define TIME_CONVERT_1904_1970_UTC  (2082844800)

/** VFS SETTINGS **/
#define NNSH_NOTSUPPORT_VFS         0xf000
#define NNSH_VFS_DISABLE            0x0000
#define NNSH_VFS_ENABLE             0x0001
#define NNSH_VFS_WORKAROUND         0x0002
#define NNSH_VFS_USEOFFLINE         0x0004
#define NNSH_VFS_DBBACKUP           0x0008

#define NNSH_FILEMODE_CREATE        1
#define NNSH_FILEMODE_READWRITE     2
#define NNSH_FILEMODE_READONLY      4
#define NNSH_FILEMODE_TEMPFILE      8
#define NNSH_FILEMODE_APPEND        16

#define FILEMGR_STATE_DISABLED      0
#define FILEMGR_STATE_OPENED_VFS    1
#define FILEMGR_STATE_OPENED_STREAM 2

/** BBS-DB̕\(Iʂŕ\邩/Ȃ) **/
#define NNSH_BBSSTATE_VISIBLE       1            // \
#define NNSH_BBSSTATE_INVISIBLE     0            // \

/** BBS-DB̃{[h^Cv **/
#define NNSH_BBSTYPE_2ch            0x00         // 2ch(ʏ탂[h)
#define NNSH_BBSTYPE_MACHIBBS       0x01         // ܂BBS(ꃂ[h)
#define NNSH_BBSTYPE_ERROR          0xff         // {[h^CvG[

/** ꗗ\BBSꗗCɓ肩 **/
#define NNSH_FAVORLIST_MODE         1
#define NNSH_BBSLIST_MODE           0 


// f[^x[X̃L[^Cv()
#define NNSH_KEYTYPE_CHAR           0
#define NNSH_KEYTYPE_UINT32         1
#define NNSH_KEYTYPE_UINT16         2
#define NNSH_KEYTYPE_SUBJECT        3

// HTTPbZ[W쐬Ɏw
#define HTTP_SENDTYPE_GET           10
#define HTTP_SENDTYPE_GET_NOTMONA   11
#define HTTP_SENDTYPE_POST          20
#define HTTP_SENDTYPE_POST_MACHIBBS 40
#define HTTP_RANGE_OMIT             0xffffffff
#define HTTP_GETSUBJECT_LEN         4096
#define HTTP_GETSUBJECT_START       0
#define HTTP_GETSUBJECT_PART        0

// 
#define NNSH_SEARCH_ALL             0
#define NNSH_SEARCH_FORWARD         1
#define NNSH_SEARCH_BACKWARD       -1

// ݃bZ[WmFR}h
#define NNSH_WRITECHK_SPID          0
#define NNSH_WRITECHK_REPLY         1

// bZ[W̑
#define NNSH_MSGATTR_NOTSPECIFY    0xff   // uCɓvw͎w肵Ȃ
#define NNSH_MSGATTR_NOTFAVOR      0x4f   // uCɓvXłȂ(MASKl)
#define NNSH_MSGATTR_FAVOR_L1      0x10   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L2      0x20   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L3      0x30   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L4      0x80   // uCɓvx()
#define NNSH_MSGATTR_FAVOR         0xb0   // uCɓvX()
#define NNSH_MSGATTR_NOTERROR      0xbf   // uG[vXłȂ(MASKl)
#define NNSH_MSGATTR_ERROR         0x40   // uG[vXł
#define NNSH_MSGATTR_GETRESERVE    0x08   // u擾\vXł
#define NNSH_MSGATTR_NOTRESERVE    0xf7   // u擾\vXNA(MASK)

#define NNSH_ATTRLABEL_TITLE       ", Level:" 
#define NNSH_ATTRLABEL_NOTFAVOR    "-"    // uCɓvł͂Ȃ
#define NNSH_ATTRLABEL_FAVOR_L1    "L"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L2    "1"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L3    "2"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L4    "3"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR       "H"    // uCɓvx()


// ꎞ(݁AWO񂵏ԂL)
#define NNSH_TEMPTYPE_PUSHEDJOGUP   16
#define NNSH_TEMPTYPE_PUSHEDJOGDOWN  8
#define NNSH_TEMPTYPE_CLEARSTATE     0

//  ̑̏Ԓl
#define NNSH_NOT_EFFECTIVE          0
#define NNSH_UPDATE_DISPLAY         1
#define NNSH_SILK_CONTROL           1

#define NNSH_DISABLE                0
#define NNSH_ENABLE                 1

// NNsĩf[^x[XXV
#define NNSH_DB_UPDATE_BBS          0x0001
#define NNSH_DB_UPDATE_SUBJECT      0x0002
#define NNSH_DB_UPDATE_SETTING      0x0004
#define NNSH_DB_UPDATE_DIRINDEX     0x0008

#define NNSH_DB_MASK_BBS            0xfffe
#define NNSH_DB_MASK_SUBJECT        0xfffd
#define NNSH_DB_MASK_SETTING        0xfffb
#define NNSH_DB_MASK_DIRINDEX       0xfff7

//////////////////////////////////////////////////////////////////////////////

/********** HTMLԉ͗p ********/
#define HTTP_ANCHORSTATE_NORMAL     101
#define HTTP_ANCHORSTATE_ANCHOR     102
#define HTTP_ANCHORSTATE_LABEL      103

/**********  Xǂݏoԗp  *********/
#define NNSH_SUBJSTATUS_NOT_YET      0
#define NNSH_SUBJSTATUS_NEW          1
#define NNSH_SUBJSTATUS_UPDATE       2
#define NNSH_SUBJSTATUS_REMAIN       3
#define NNSH_SUBJSTATUS_ALREADY      4
#define NNSH_SUBJSTATUS_DELETE       5
#define NNSH_SUBJSTATUS_UNKNOWN      6
#define NNSH_SUBJSTATUS_GETERROR     7
#define NNSH_SUBJSTATUS_OVER         8

#define NNSH_MSGSTATE_NOTMODIFIED   10
#define NNSH_MSGSTATE_ERROR         20

/**********  bZ[Wp[Xp  *********/
#define MSGSTATUS_NAME              1
#define MSGSTATUS_EMAIL             2
#define MSGSTATUS_DATE              3
#define MSGSTATUS_NORMAL            4

/**********  BBSLX  **************/
#define NNSH_BBSLIST_AGAIN         -1            // XēxmF

///////////////////////////////////////////////////////////////////////////////

/*** DATA TOKENS ***/
#define DATA_SEPARATOR              "<>"
#define DATA_NEWLINE                "<br>"

/** for BBS NAME PARSER **/
#define HTTP_TOKEN_ST_ANCHOR        "<A"
#define HTTP_TOKEN_ED_ANCHOR        "</A>"
#define HTTP_TOKEN_END              ">"

#define NNSH_FIELD_SEPARATOR        "<>"
#define NNSH_FIELD_SEPARATOR_MACHI  ","
#define NNSH_RECORD_SEPARATOR       "\x0a"
#define NNSH_SUBJTITLE_END          "("

#define NNSH_MACHITOKEN_START       "\x0d\x0a<dt>"
#define NNSH_MACHITOKEN_END         "<br><br>\x0a\x0d\x0a"
#define NNSH_MACHITOKEN_MSGSTART    "OF"
#define NNSH_MACHINAME_SUFFIX       "[܂BBS]"

/** **/
#define NNSH_SYMBOL_WRITE_DONE      "݂܂B"
#define NNSH_SYMBOL_WRITE_NG        "dqqnq"

#define NNSH_DEVICE_NORMAL          0
#define NNSH_DEVICE_HANDERA         1

#define NNSH_JUMPMSG_LEN            10
#define NNSH_JUMPMSG_HEAD           ">>"

#define NNSH_JUMPMSG_BACK           "P߂"
#define NNSH_JUMPMSG_TO_LIST        "ꗗ"
#define NNSH_JUMPMSG_OPEN_MENU      "j["
#define NNSH_JUMPMSG_UPDATE         "擾"
#define NNSH_JUMPMSG_HANGUP         "ؒf"
#define NNSH_JUMPMSG_TOP            "擪"
#define NNSH_JUMPMSG_BOTTOM         ""
#define NNSH_JUMPMSG_OPENWEB        "I+Web"
#define NNSH_JUMPMSG_CHANGEVIEW     "`MODE"
#define NNSH_JUMPMSG_FAVORITE       "X"

#define NNSH_NOF_JUMPMSG_EXT        10
#define NNSH_JUMPSEL_BACK           0x8001
#define NNSH_JUMPSEL_TO_LIST        0x8002
#define NNSH_JUMPSEL_OPEN_MENU      0x8003
#define NNSH_JUMPSEL_UPDATE         0x8004
#define NNSH_JUMPSEL_HANGUP         0x8005
#define NNSH_JUMPSEL_TOP            0x8006
#define NNSH_JUMPSEL_BOTTOM         0x8007
#define NNSH_JUMPSEL_OPENWEB        0x8008
#define NNSH_JUMPSEL_CHANGEVIEW     0x8009
#define NNSH_JUMPSEL_FAVORITE       0x800a

#define NNSH_JUMPMSG_OPENBBS        "I"
#define NNSH_JUMPMSG_OPENMENU       "j["
#define NNSH_JUMPMSG_OPENNEW        "VmF"
#define NNSH_JUMPMSG_OPENLIST       "ꗗ擾"
#define NNSH_JUMPMSG_OPENGET        "X擾"
#define NNSH_JUMPMSG_OPENINFO       "X"
#define NNSH_JUMPMSG_OPENMES        "XQ"
#define NNSH_JUMPMSG_DISCONNECT     "ؒf"
#define NNSH_JUMPMSG_COPYMSG        "QƂCOPY"
#define NNSH_JUMPMSG_DELMSG         "X폜"
#define NNSH_JUMPMSG_GRAPHMODE      "`MODEύX"
#define NNSH_JUMPMSG_MULTISW1       "ړISW1"
#define NNSH_JUMPMSG_MULTISW2       "ړISW2"
#define NNSH_ITEMLEN_JUMPLIST       14      // XgACe
#define NNSH_JUMPSEL_NUMLIST        13      // XgACe
#define NNSH_JUMPSEL_OPENBBS        0x9000  // I
#define NNSH_JUMPSEL_OPENMENU       0x9001  // j[
#define NNSH_JUMPSEL_DISCONNECT     0x9002  // ؒf
#define NNSH_JUMPSEL_OPENNEW        0x9003  // VmF
#define NNSH_JUMPSEL_OPENLIST       0x9004  // ꗗ擾
#define NNSH_JUMPSEL_OPENGET        0x9005  // X擾
#define NNSH_JUMPSEL_OPENMES        0x9006  // XQ
#define NNSH_JUMPSEL_OPENINFO       0x9007  // X
#define NNSH_JUMPSEL_COPYMSG        0x9008  // QƂփRs[
#define NNSH_JUMPSEL_DELMSG         0x9009  // X폜
#define NNSH_JUMPSEL_GRAPHMODE      0x900a  // `惂[hύX
#define NNSH_JUMPSEL_MULTISW1       0x900b  // ړISW1
#define NNSH_JUMPSEL_MULTISW2       0x900c  // ړISW2

#define NNSH_STEP_PAGEUP           -1
#define NNSH_STEP_PAGEDOWN          1
#define NNSH_STEP_REDRAW            0
#define NNSH_STEP_UPDATE           10

#define NNSH_ITEM_LASTITEM         0xffff

#define NNSH_DISP_NOTHING          0x0000   // Ȃ
#define NNSH_DISP_UPPERLIMIT       0x0001   // 
#define NNSH_DISP_HALFWAY          0x0002   // r
#define NNSH_DISP_ALL              0x0004   // S\
#define NNSH_DISP_LOWERLIMIT       0x0008   // 

#define NNSH_DISPMSG_NOTHING       "Ȃ"
#define NNSH_DISPMSG_UPPERLIMIT    ""
#define NNSH_DISPMSG_HALFWAY       "r"
#define NNSH_DISPMSG_ALL           "S\"
#define NNSH_DISPMSG_LOWERLIMIT    ""
#define NNSH_DISPMSG_UNKNOWN       "?????"

#define NNSH_MSGNUM_UNKNOWN        0xffff
#define NNSH_MSGNUM_NOTDISPLAY     0x0000

#define NNSH_LIMIT_COPYBUFFER      2047

#define NNSH_BUSYWIN_MAXLEN        32

#define NNSH_WRITE_DELAYTIME       7

#define NNSH_INPUTWIN_SEARCH       "TITLE"
#define NNSH_INPUTWIN_GETMESNUM    "X擾(XԎw)"
#define NNSH_INPUTWIN_MODIFYTITLE  "X^CgύX"

#define NNSH_DIALOG_USE_SEARCH      10
#define NNSH_DIALOG_USE_GETMESNUM   20
#define NNSH_DIALOG_USE_MODIFYTITLE 40



// ړI{^֘A̐ݒ
#define NNSH_SWITCHUSAGE_FORMMASK   0x3f00
#define NNSH_SWITCHUSAGE_FUNCMASK   0x00ff

#define NNSH_SWITCHUSAGE_TITLE      0x2100

#define NNSH_SWITCHUSAGE_NOUSE      0x00  // ړIXCb`gpȂ
#define NNSH_SWITCHUSAGE_GETPART    0x01  // X擾[h(ꊇ/)
#define NNSH_SWITCHUSAGE_HANZEN     0x02  // pJiSpJiϊ
#define NNSH_SWITCHUSAGE_USEPROXY   0x03  // ProxyoRŃANZX
#define NNSH_SWITCHUSAGE_CONFIRM    0x04  // mF_CAȌȗ

#define NNSH_SWITCHUSAGE_SUBJECT    0x05  // XꗗS擾؂ւ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_TITLEDISP  0x06  // Xꗗ`惂[hؑ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_MSGNUMBER  0x07  // XꗗMSGԍ       (ꗗʗp)
#define NNSH_SWITCHUSAGE_GETRESERVE 0x08  // X擾ۗ[h      (ꗗʗp)

#define NNSH_SWITCHMSG_NOUSE        "(gpȂ)"   // ړIXCb`gpȂ
#define NNSH_SWITCHMSG_GETPART      "/ꊇ"      // X擾[h(ꊇ/)
#define NNSH_SWITCHMSG_HANZEN       "pJiϊ"   // pJiSpJiϊ
#define NNSH_SWITCHMSG_USEPROXY     "Proxygp"      // ProxyoRŃANZX
#define NNSH_SWITCHMSG_CONFIRM      "mFȗ"     // mF_CAȌȗ

#define NNSH_SWITCHMSG_SUBJECT      "ꗗS擾"     // XꗗS擾؂ւ
#define NNSH_SWITCHMSG_TITLEDISP    "`惂[h"     // Xꗗ`惂[hؑ
#define NNSH_SWITCHMSG_MSGNUMBER    "ꗗɔԍ"     // XꗗMSGԍ
#define NNSH_SWITCHMSG_GETRESERVE   "擾ۗ"       // X擾ۗ

#define NNSH_SUBJSTATUSMSG_NOT_YET  "擾"
#define NNSH_SUBJSTATUSMSG_NEW      "VK擾"
#define NNSH_SUBJSTATUSMSG_UPDATE   "XV擾"
#define NNSH_SUBJSTATUSMSG_REMAIN   "ǂ"
#define NNSH_SUBJSTATUSMSG_ALREADY  ""
#define NNSH_SUBJSTATUSMSG_UNKNOWN  "ԕs"
