/*============================================================================*
 *  FILE: 
 *     macroview.c
 *
 *  Description: 
 *     }Nf[^̕\pH
 *
 *===========================================================================*/
#define MACROVIEW_C
#include "local.h"

/*=========================================================================*/
/*   Function : setSourceDataDisplay                                       */
/*                                        \[Xf[^eobt@ɏo */
/*=========================================================================*/
static UInt16 setSourceDataDisplay(Char *buffer, NNshMacroRecord *lineData)
{
    if ((lineData->src >= NNSH_MACROOP_GR_OFFSET)&&
         (lineData->src <= NNSH_MACROOP_GR_MAX))
    {
        StrCat (buffer, "gr");
        NUMCATI(buffer, lineData->src - NNSH_MACROOP_GR_OFFSET);
        StrCat (buffer, " ");
        return (NNSH_MACROOPCMD_DISABLE);
    }

    // Rl擾
    NUMCATI(buffer, lineData->MacroData.numData.operator);
    return (lineData->MacroData.numData.operator);
}

/*=========================================================================*/
/*   Function : setExecFuncDataDisplay                                     */
/*                                                        @\֐̎擾 */
/*=========================================================================*/
static void setExecFuncDataDisplay(Char *buffer, UInt16 command)
{
    Char        *ptr, **kw, buf[MAX_FUNCCHAR_BUF];
    MemHandle    memH;
    NNshWordList wordList;

    // obt@̃NA
    MemSet(buf, sizeof(buf), 0x00);
    MemSet(&wordList, sizeof(wordList), 0x00);
    
    // ꗗ@\Xg̎擾iXgO\[X擾j
    memH = DmGetResource('tSTR', MULTIBTN_FEATUREMSG_STRINGS);
    if (memH == 0)
    {
        return;
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        return;
    }

    // L[[h؂oāAꎞobt@ɃRs[
    SeparateWordList(ptr, &wordList);
    kw = MemHandleLock(wordList.wordmemH);
    StrNCopy(buf, kw[command], MAX_FUNCCHAR_BUF - 1);
    MemHandleUnlock(wordList.wordmemH);
    ReleaseWordList(&wordList);
    
    // Rs[
    StrCat(buffer, buf);

    MemHandleUnlock(memH);
    DmReleaseResource(memH);
    return;
}

/*=========================================================================*/
/*   Function : printMacroOpeR                                             */
/*                                              }Nf[^̃f[^ݒ蕔 */
/*=========================================================================*/
static void printMacroOpeR(Char *buf, NNshMacroRecord *data, Char *operator)
{
    // NNsiݒl̎擾/ݒ
    switch (data->MacroData.numData.subCommand)
    {
      case NNSH_MACROOPCMD_AUTOSTARTMACRO:
        // }Ns̒l擾
        StrCat(buf, " (autoMacro) ");
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_LINE:
        // VmFsɉؒf
        StrCat(buf, " (chkLINE) ");
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_DA:
        // VmFsDAN
        StrCat(buf, " (chkDA) ");
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_ROLOG:
        // QƐpO擾x
        StrCat(buf, " (ROlogLvl) ");
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_BEEP:
        // VmFIɃr[v
        StrCat(buf, " (chkBEEP) ");
        break;

      case NNSH_MACROOPCMD_COPY_AND_DELETE:
        // QƐpORs[ɍ폜{
        StrCat(buf, " (cp&rm) ");
        break;

      default:
        StrCat(buf, "nop ");
        break;
    }
    // f[^o
    if (operator != NULL)
    {
        StrCat(buf, operator);
    }
    return;
}

/*=========================================================================*/
/*   Function : printMacroOpeC                                             */
/*                                              }Nf[^̕(WJ) */
/*=========================================================================*/
static void printMacroOpeC(Char *buf, NNshMacroRecord *data, Char *operator)
{
    if (operator != NULL)
    {
        StrCat (buf, "IF gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, operator);
        StrCat (buf, " THEN ");
    }
    StrCat (buf, "GOTO ");
    setSourceDataDisplay(buf, data);

    return;
}

/*=========================================================================*/
/*   Function : printMacroDst                                              */
/*                                            }Nf[^̊i[ꏊ\ */
/*=========================================================================*/
static void printMacroDst(Char *buf, NNshMacroRecord *data, Char *operator)
{
    StrCat (buf, "gr");
    NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
    StrCat (buf, " := ");
    if (operator != NULL)
    {
        StrCat (buf, operator);
    }
    return;
}

/*=========================================================================*/
/*   Function : printMacroOpeA                                             */
/*                                          }Nf[^̎ZpZ(WJ) */
/*=========================================================================*/
static void printMacroOpeA(Char *buf, NNshMacroRecord *data, Char *operator)
{
    printMacroDst(buf, data, NULL);
    if (operator != NULL)
    {
        // Z
        StrCat (buf, "gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, operator);
    }
    setSourceDataDisplay(buf, data);

    return;
}

/*=========================================================================*/
/*   Function : PrintMacroLine                                             */
/*                                          }Nf[^(s)̃f[^ݒ */
/*=========================================================================*/
void PrintMacroLine(Char *buf, UInt16 size, UInt16 num, NNshMacroRecord *data)
{
    Char   logData[8];
    UInt16 command;

    // ̈̏
    MemSet(buf, size, 0x00);
 
    // sԍ\
    NUMCATI(buf, num);
    StrCat (buf, "  ");

    // opR[h̔
    switch (data->opCode)
    {
      case NNSH_MACROCMD_XOR:
        // l XOR 
        printMacroOpeA(buf, data, " XOR ");
        break;

      case NNSH_MACROCMD_AND:
        // l AND 
        printMacroOpeA(buf, data, " AND ");
        break;

      case NNSH_MACROCMD_OR:
        // l OR 
        printMacroOpeA(buf, data, " OR ");
        break;

      case NNSH_MACROCMD_ADD:
        // lZ
        printMacroOpeA(buf, data, " + ");
        break;

      case NNSH_MACROCMD_CMP:
      case NNSH_MACROCMD_SUB:
        // lZ
        printMacroOpeA(buf, data, " - ");
        break;

      case NNSH_MACROCMD_MOVE:
        // l
        printMacroOpeA(buf, data, NULL);
        break;

      case NNSH_MACROCMD_JNZ:
        // [łȂ番򂷂
        printMacroOpeC(buf, data, "<> 0");
        break;

      case NNSH_MACROCMD_JZ:
        // [番򂷂
        printMacroOpeC(buf, data, "= 0");
        break;

      case NNSH_MACROCMD_JMP:
        // ɕ򂷂
        printMacroOpeC(buf, data, NULL);
        break;

      case NNSH_MACROCMD_EXECUTE:
        // @\̎s
        StrCat (buf, "CALL (");
        command = setSourceDataDisplay(buf, data);
        if (command != NNSH_MACROOPCMD_DISABLE)
        {
            StrCat (buf, ":");
            setExecFuncDataDisplay(buf, command);
            StrCat (buf, " ");
        }
        StrCat (buf, ") ");
        break;

      case NNSH_MACROCMD_MESSAGE:
        // Oo
        StrCat (buf, "PRINT ");
        if ((data->src >= NNSH_MACROOP_GR_OFFSET)&&
            (data->src <= NNSH_MACROOP_GR_MAX))
        {
            // GRx \
            StrCat (buf, "(gr");
            NUMCATI(buf, data->src - NNSH_MACROOP_GR_OFFSET);
            StrCat (buf, ") ");
        }
        else
        {
            // \
            StrCat (buf, "\"");
            StrCat (buf, data->MacroData.strData.data);
            StrCat (buf, "\" ");
        }
        break;

      case NNSH_MACROCMD_BEEP:
        // r[v炷
        StrCat (buf, "BEEP ");
        setSourceDataDisplay(buf, data);
        StrCat (buf, "  ");
        break;

      case NNSH_MACROCMD_MACROEND:
        // }NI
        StrCat (buf, "END ");
        break;

      case NNSH_MACROCMD_SETTABNUM:
        // ^ui[
        printMacroDst(buf, data, "(tabNum)");
        break;

      case NNSH_MACROCMD_STRSTR:
        // w肵񂪃X^CgɊ܂܂邩
        printMacroDst(buf, data, "strstr(title, \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\")");
        break;            

      case NNSH_MACROCMD_STRCMP:
        // w肵񂪃X^Cgƈv邩
        printMacroDst(buf, data, "strcmp(title, \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\")");
        break;            

      case NNSH_MACROCMD_OPERATE:
        // NNsiݒl̐ݒ
        printMacroOpeR(buf, data, ":= ");
        setSourceDataDisplay(buf, data);
        StrCat(buf, ", save ");
        /** not break; **/

      case NNSH_MACROCMD_STATUS:
        // NNsiݒl̎擾
        printMacroDst(buf, data, NULL);
        printMacroOpeR(buf, data, NULL);
        break;

      case NNSH_MACROCMD_GETMESNUM:
        // X𔽉f
        printMacroDst(buf, data, "mesNum(title)");
        break;

      case NNSH_MACROCMD_MESSTATUS:
        // XԂ𔽉f
        printMacroDst(buf, data, "mesStatus(title)");
        break;

      case NNSH_MACROCMD_BBSTYPE:
        // XBBS^Cv𔽉f
        printMacroDst(buf, data, "bbsType(title)");
        break;

      case NNSH_MACROCMD_IMPORT:
        // NNsiݒC|[g
        StrCat (buf, "IMPORT '");
        StrCat (buf, FILE_XML_NNSISET);
        if (setSourceDataDisplay(buf, data) == 0)
        {
            StrCat (buf, "' from VFS");
        }
        else
        {
            StrCat (buf, "' from Palm");
        }
        break;

      case NNSH_MACROCMD_EXPORT:
        // NNsiݒGNX|[g
        StrCat (buf, "EXPORT '" FILE_XML_NNSISET "' ");
        break;

      case NNSH_MACROCMD_LAUNCHDA:
        // DAN
        StrCat (buf, "LAUNCH '");
        logData[0] = ((0xff00 & data->MacroData.numData.data1) >> 8); 
        logData[1] = ((0x00ff & data->MacroData.numData.data1));
        logData[2] = ((0xff00 & data->MacroData.numData.data2) >> 8);
        logData[3] = ((0x00ff & data->MacroData.numData.data2));
        logData[4] = '\0';
        StrCat (buf, logData);            
        StrCat (buf, "' as DA");
        break;

      case NNSH_MACROCMD_CLIPCOPY:
        // Nbv{[hɃRs[
        StrCat (buf, "COPY(clip, \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\") ");
        break;

      case NNSH_MACROCMD_CLIPADD:
        // Nbv{[hɒǉ
        StrCat (buf, "APPEND(clip, \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\") ");
        break;

      case NNSH_MACROCMD_CLIPINSTR:
        // Nbv{[h̕Ɋ܂܂邩mF
        StrCat (buf, "gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, " := strstr(clip, \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\") ");
        break;

      case NNSH_MACROCMD_TITLECLIP:
        // X^CgNbv{[hɃRs[
        StrCat(buf, "COPY(clip, title)");
        break;

      case NNSH_MACROCMD_SET_FINDBBSSTR:
        // Nbv{[hɃRs[
        StrCat(buf, "COPY(findBBS, clip)");
        break;

      case NNSH_MACROCMD_SET_FINDTHREADSTR:
        // Nbv{[hX^CɃRs[
        StrCat(buf, "COPY(findTHREAD, clip)");
        break;

      case NNSH_MACROCMD_UPDATE_RESNUM:
        // XXVĊi[
        StrCat (buf, "gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, " := updateMesNum(title) ");
        break;

      case NNSH_MACROCMD_JPL:
        // ̒lȂWv
        printMacroOpeC(buf, data, "> 0");
        break;

      case NNSH_MACROCMD_JMI:
        // ̒lȂWv
        printMacroOpeC(buf, data, "< 0");
        break;

      case NNSH_MACROCMD_OUTPUTTITLE:
        // X^Cg̃Oo
        StrCat(buf, "PRINT title");
        break;
        
      case NNSH_MACROCMD_OUTPUTCLIP:
        // Nbv{[h̃Oo
        StrCat(buf, "PRINT clip");
        break;

      case NNSH_MACROCMD_REMARK:
        // ߕ
        StrCat(buf, "' ");
        StrCat (buf,  data->MacroData.strData.data);
        break;

      case NNSH_MACROCMD_PUSH:
        // X^bNɃf[^PUSH
        StrCat (buf, "PUSH ");
        setSourceDataDisplay(buf, data);
        break;

      case NNSH_MACROCMD_POP:
        // X^bNf[^POP
        StrCat(buf, "POP gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        break;

      case NNSH_MACROCMD_GETRECNUM:
        // R[hԍ擾
        StrCat (buf, "gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, " := RecordIndex(title) ");
        break;

      case NNSH_MACROCMD_FINDTHREADSTRCOPY:
        // XNbv{[hɃRs[
        StrCat (buf, "COPY(clip, findTHREAD)");
        break;

      case NNSH_MACROCMD_INPUTDIALOG:
        // ͂ (1.05)
        StrCat (buf, "clip := INPUT \"");
        StrCat (buf, data->MacroData.strData.data);
        break;

      case NNSH_MACROCMD_OUTPUTDIALOG:
        // o͂ (1.05)
        StrCat (buf, "OUTPUT \"");
        StrCat (buf, data->MacroData.strData.data);
        StrCat (buf, "\"");
        break;

      case NNSH_MACROCMD_CONFIRMDIALOG:
        // Nbv{[h̕\mF (1.05)
        StrCat (buf, "gr");
        NUMCATI(buf, data->dst - NNSH_MACROOP_GR_OFFSET);
        StrCat (buf, " := CONFIRM (clip)");
        break;

      default:
        // R}hR[hُAȂɂsȂ
        StrCat (buf, "  ");
        break;
    }
    return;
}
