#ifndef URL_H
#define URL_H

#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

class CUrl {
private:
	WSClistData mStrName;
	WSClistData mStrUrl;
	WSClistData mFlagDownload;
	WSClistData mEncoding;
public:
	void CUrl::Init( void );
	void CUrl::Reset( void );

	bool CUrl::Add(
		WSCstring name,
		WSCstring url, bool flagDown, long encoding );
	bool CUrl::Update(
		WSCstring oldName, WSCstring name,
		WSCstring url, bool flagDown, long encoding );
	bool CUrl::Delete( WSCstring name );

	long CUrl::GetN( WSCstring name );
	long CUrl::GetMaxN( void ){
		return( mStrName.getNum() );
	}
	WSCstring CUrl::GetList( void );

	WSCstring CUrl::GetName( long n );
	WSCstring CUrl::SetName( long n, WSCstring name );

	WSCstring CUrl::GetUrl( WSCstring name );
	WSCstring CUrl::GetUrl( long n );
	WSCstring CUrl::SetUrl( WSCstring name, WSCstring url );
	WSCstring CUrl::SetUrl( long n, WSCstring url );

	bool CUrl::GetFlagDownload( WSCstring name );
	bool CUrl::GetFlagDownload( long n );
	bool CUrl::SetFlagDownload( WSCstring name, bool flag );
	bool CUrl::SetFlagDownload( long n, bool flag );

	long CUrl::GetEncoding( WSCstring name );
	long CUrl::GetEncoding( long n );
	long CUrl::SetEncoding( WSCstring name, long en );
	long CUrl::SetEncoding( long n, long en );
};

extern CUrl gUrl;

#endif /* URL_H */
