//------------------------------------------------
// Move.c Main֐Ƃ̃C^[tF[X
//------------------------------------------------

#include <stdlib.h>
#include <math.h>
#include "Move.h"

//t[̏
void InitFrame(Frame *Frm)
{
	//initialize frame
	Frm->line = (Line*)malloc(sizeof(Line)*5);
	Frm->size = 5;
	LineFromXY(&Frm->line[0], CenterX-280, CenterY+210, CenterX+280, CenterY+210);
	LineFromXY(&Frm->line[1], CenterX+280, CenterY+210, CenterX+280, CenterY-210);
	LineFromXY(&Frm->line[2], CenterX+280, CenterY-210, CenterX-280, CenterY-210);
	LineFromXY(&Frm->line[3], CenterX-280, CenterY-210, CenterX-280, CenterY+210);
	LineFromXY(&Frm->line[4], CenterX-140, CenterY+100, CenterX+140, CenterY+100);

	//initialize ball
	Frm->Ball.r = BALL_SIZE;
	Frm->Ball.xy.x = Frm->Ball.xy.y = 0;
	Frm->Ball.velocity.x = Frm->Ball.velocity.y = 0;
}

//t[̏I
void FinFrame(Frame *Frm)
{
	free(Frm->line);
}

void MoveBall(Frame *Frm, Surface *Scr)
{
	static float oldRad=0;
	Frm->Ball.velocity.y -= GRAVITY/FRAME_RATE;		//d͂͐̂
	
	oldRad -= Scr->Rad;
	if(fabs(oldRad) >= 0.00001){
		if(oldRad > M_PI)	oldRad= -ROTATE_RAD;
		LineArrayRotate(Frm->line, Frm->size, oldRad);
		CollisionRotate(&Frm->Ball, Frm->line, Frm->size, oldRad);
	}
	DrawBox(0,0,DISP_WIDTH,DISP_HEIGHT,0xFFFFFF,TRUE);
	DrawFormatString(0,0,0xFFCCCC,"dRad:%f",oldRad);	//WA\
	
	CollisionProcess(&Frm->Ball, Frm->line, Frm->size, COLLISION_MOVE);
	oldRad = Scr->Rad;
	
	//{[̍Wn𒼂
	VectorToXY(&Scr->BallX, &Scr->BallY, &Frm->Ball.xy);
	Scr->BallX -= BALL_SIZE, Scr->BallY -= BALL_SIZE;
}

void DrawVector(Frame *Frm)
{
	int i, x1, y1, x2, y2;
	// xNg]\
	for(i=0; i<Frm->size; i++){
		LineToXY(&x1, &y1, &x2, &y2, &Frm->line[i]);
		DrawLine( x1, y1, x2, y2, 0xFF00FF );
	}
	
	//{[̕`
	VectorToXY(&x1, &y1, &Frm->Ball.xy);
	DrawCircle( (int)x1, (int)y1, Frm->Ball.r, 0xFF00FF, FALSE );
	ScreenFlip();
}