//------------------------------------------------
// funcs.h ֐̐錾
//------------------------------------------------

#ifndef __funcs_h__
#define __funcs_h__
#include "defs.h"
#include "structs.h"

// Vector.c
Vector* VectorFromXY(Vector *v0, float x, float y);
void    VectorToXY(int *x, int *y, Vector *vector);
Vector* VectorFromUV(Vector *v0, float u, float v);
Vector* VectorAdd(Vector *v0, Vector *v1, Vector *v2);
Vector* VectorAddNum(Vector *v0, Vector *v1, float x, float y);
Vector* VectorSub(Vector *v0, Vector *v1, Vector *v2);
Vector* VectorMult(Vector *v0, Vector *v1, float n);
Vector* VectorInvert(Vector *v0, Vector *v1);
float   VectorLength(Vector *v1);
float   VectorLengthNoSquare(Vector *v1);
Vector* VectorNormalize(Vector *v0, Vector *v1);
Vector* VectorRotate(Vector *v0, Vector *v1, float rad);
Vector* VectorArrayRotate(Vector *vs, int num, float rad);
Vector* VectorRotate90(Vector *v0, Vector *v1, float type);
float   VectorDotProduct(Vector *v1, Vector *v2);
float   VectorCrossProduct(Vector *v1, Vector *v2);

// Line.c
Line*   LineFromVector(Line *L0, Vector *v1, Vector *v2);
Line*   LineFromXY(Line *L0, float x1, float y1, float x2, float y2);
Line*   LineFromUV(Line *L0, float u1, float v1, float u2, float v2);
void    LineToXY(int *x1, int *y1, int *x2, int *y2, Line *L1);
Line*   LineShift(Line *L0, Line *L1, Vector *v1);
Line*   LineRotate(Line *L0, Line *L1 , float rad);
Line*   LineArrayRotate(Line *lines, int num, float rad);
bool     LineCrossCheck(Line *L1, Line *L2);	//boolƂ܂RpCʂȂ̂intɂ܂
Vector* LineCrossGet(Vector *v0, Line *L1, Line *L2);
float   LineDotLength(Line *L1, Vector *v1, int *type);

// Collision.c
void CollisionProcess(MyObject *obj, Line *lines, int num);

#endif