﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NMeCab.Core
{
    public class PriorityQueue<T>
        where T : IComparable<T>
    {
        private List<T> list = new List<T>();

        public int Count
        {
            get { return this.list.Count; }
        }

        public void Clear()
        {
            this.list.Clear();
        }

        public void Push(T item)
        {
            int index = this.list.BinarySearch(item);
            if (index < 0) index = ~index;
            this.list.Insert(index, item);
        }

        public T Pop()
        {
            if (this.Count == 0) throw new InvalidOperationException("Empty");

            T item = this.list[0];
            this.list.RemoveAt(0);
            return item;
        }
    }
}
