using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public delegate int ActiveStateChangeCallBackFunction( int ActiveState , IntPtr UserData ) ;

	public delegate void UseASyncChangeWindowModeFunction( IntPtr Data ) ;

	public delegate IntPtr WndProc( IntPtr Wnd , int Msg , IntPtr WParam , IntPtr LParam ) ;

	public delegate void MenuItemSelectCallBackFunction( string ItemName , int ItemID ) ;


	public static partial class Window
	{


		/// <summary> Cu֐ </summary>
		public static void DxLib_Init()
		{
			lock( locker )
			{
				int result = dx_DxLib_Init() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				Graph.InitializeAll() ;
				BlendGraph.InitializeAll() ;
				Sound.InitializeAll() ;
				Movie.InitializeAll() ;
				MovieToOverlay.InitializeAll() ;
				Font.InitializeAll() ;
				Mask.InitializeAll() ;
				NetWork.InitializeAll() ;
				NetWorkUDP.InitializeAll() ;
				KeyInput.InitializeAll() ;
				Music.InitializeAll() ;
				Light.InitializeAll() ;
				Model.InitializeAll() ;
				SoftImage.InitializeAll() ;
				Shader.InitializeAll() ;
				SoftSound.InitializeAll() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxLib_Init() ;


		/// <summary> Cugp̏I֐ </summary>
		public static void DxLib_End()
		{
			lock( locker )
			{
				SoftSound.FinalizeAll() ;
				Shader.FinalizeAll() ;
				SoftImage.FinalizeAll() ;
				Model.FinalizeAll() ;
				Light.FinalizeAll() ;
				Music.FinalizeAll() ;
				KeyInput.FinalizeAll() ;
				NetWorkUDP.FinalizeAll() ;
				NetWork.FinalizeAll() ;
				Mask.FinalizeAll() ;
				Font.FinalizeAll() ;
				MovieToOverlay.FinalizeAll() ;
				Movie.FinalizeAll() ;
				Sound.FinalizeAll() ;
				BlendGraph.FinalizeAll() ;
				Graph.FinalizeAll() ;
				int result = dx_DxLib_End() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxLib_End() ;


		/// <summary> Cu̓ŎgpĂ\̂[āADxLib_Init ̑Oɍsݒ𖳌( DxLib_Init ̑Oł̂ݗL ) </summary>
		public static void DxLib_GlobalStructInitialize()
		{
			lock( locker )
			{
				int result = dx_DxLib_GlobalStructInitialize() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxLib_GlobalStructInitialize() ;


		/// <summary> CuĂ邩ǂ擾( ߂l: TRUE=Ă  FALSE=ĂȂ ) </summary>
		public static bool DxLib_IsInit()
		{
			lock( locker )
			{
				int result = dx_DxLib_IsInit() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxLib_IsInit() ;


		/// <summary> G[o </summary>
		public static void ErrorLogAdd( string ErrorStr )
		{
			lock( locker )
			{
				int result = dx_ErrorLogAdd( ErrorStr ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ErrorLogAdd( string ErrorStr ) ;


		/// <summary> ^u𑝂₷ </summary>
		public static void ErrorLogTabAdd()
		{
			lock( locker )
			{
				int result = dx_ErrorLogTabAdd() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ErrorLogTabAdd() ;


		/// <summary> ^u炷 </summary>
		public static void ErrorLogTabSub()
		{
			lock( locker )
			{
				int result = dx_ErrorLogTabSub() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ErrorLogTabSub() ;


		/// <summary> ^CX^v̗Lݒ肷 </summary>
		public static void SetUseTimeStampFlag( bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetUseTimeStampFlag( UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseTimeStampFlag( bool UseFlag ) ;


		/// <summary> tOo </summary>
		public static void AppLogAdd( string String )
		{
			lock( locker )
			{
				int result = dx_AppLogAdd( String.Replace( "%" , "%%" ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AppLogAdd( string String ) ;


		/// <summary> mۂ </summary>
		public static IntPtr DxAlloc( int AllocSize )
		{
			lock( locker )
			{
				IntPtr result = dx_DxAlloc( ( IntPtr )( AllocSize ) , null , -1 ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_DxAlloc( IntPtr AllocSize , string File , int Line ) ;


		/// <summary> mۂĂOŏ </summary>
		public static IntPtr DxCalloc( int AllocSize )
		{
			lock( locker )
			{
				IntPtr result = dx_DxCalloc( ( IntPtr )( AllocSize ) , null , -1 ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_DxCalloc( IntPtr AllocSize , string File , int Line ) ;


		/// <summary> ̍Ċmۂs </summary>
		public static IntPtr DxRealloc( IntPtr Memory , int AllocSize )
		{
			lock( locker )
			{
				IntPtr result = dx_DxRealloc( Memory , ( IntPtr )( AllocSize ) , null , -1 ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_DxRealloc( IntPtr Memory , IntPtr AllocSize , string File , int Line ) ;


		/// <summary>  </summary>
		public static void DxFree( IntPtr Memory )
		{
			lock( locker )
			{
				dx_DxFree( Memory ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern void dx_DxFree( IntPtr Memory ) ;


		/// <summary> 񋓑Ώۂɂ郁̊mۗeʂZbg </summary>
		public static void DxSetAllocSizeTrap( IntPtr Size )
		{
			lock( locker )
			{
				IntPtr result = dx_DxSetAllocSizeTrap( Size ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_DxSetAllocSizeTrap( IntPtr Size ) ;


		/// <summary> cwCuŃmۂs鎞ɏo͂邩ǂZbg </summary>
		public static void DxSetAllocPrintFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_DxSetAllocPrintFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxSetAllocPrintFlag( bool Flag ) ;


		/// <summary> DxAlloc  DxCalloc ŊmۂĂ郁TCY擾 </summary>
		public static int DxGetAllocSize()
		{
			lock( locker )
			{
				IntPtr result = dx_DxGetAllocSize() ;
				return ( int )( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_DxGetAllocSize() ;


		/// <summary> DxAlloc  DxCalloc ŊmۂĂ郁̐擾 </summary>
		public static int DxGetAllocNum()
		{
			lock( locker )
			{
				int result = dx_DxGetAllocNum() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxGetAllocNum() ;


		/// <summary> DxAlloc  DxCalloc ŊmۂĂ郁񋓂 </summary>
		public static void DxDumpAlloc()
		{
			lock( locker )
			{
				dx_DxDumpAlloc() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern void dx_DxDumpAlloc() ;


		/// <summary> mۂ񂪔j󂳂ĂȂׂ( -1:j󂠂  0:Ȃ ) </summary>
		public static bool DxErrorCheckAlloc()
		{
			lock( locker )
			{
				int result = dx_DxErrorCheckAlloc() ;
				return result == 0 ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxErrorCheckAlloc() ;


		/// <summary> mہAsxɊmۂĂ郁̗eʂo͂邩ǂ̃tOZbg </summary>
		public static void DxSetAllocSizeOutFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_DxSetAllocSizeOutFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxSetAllocSizeOutFlag( bool Flag ) ;


		/// <summary> ̊mہAsxɊmۂĂ郁mۏ񂪔jĂȂׂ邩ǂ̃tOZbg </summary>
		public static void DxSetAllocMemoryErrorCheckFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_DxSetAllocMemoryErrorCheckFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DxSetAllocMemoryErrorCheckFlag( bool Flag ) ;


		/// <summary> Oo̓tOZbg </summary>
		public static void SetLogDrawOutFlag( bool DrawFlag )
		{
			lock( locker )
			{
				int result = dx_SetLogDrawOutFlag( DrawFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLogDrawOutFlag( bool DrawFlag ) ;


		/// <summary> Oo͂邩tO̎擾 </summary>
		public static bool GetLogDrawFlag()
		{
			lock( locker )
			{
				int result = dx_GetLogDrawFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLogDrawFlag() ;


		/// <summary> ȈՉʏo </summary>
		public static void printfDx( string FormatString )
		{
			lock( locker )
			{
				int result = dx_printfDx( FormatString.Replace( "%" , "%%" ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_printfDx( string FormatString ) ;


		/// <summary> ȈՉʏo͂NA </summary>
		public static void clsDx()
		{
			lock( locker )
			{
				int result = dx_clsDx() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_clsDx() ;


		/// <summary> t@CJ </summary>
		public static FileStream FileRead_open( string FilePath )
		{
			return FileRead_open( FilePath , false ) ;
		}

		/// <summary> t@CJ </summary>
		public static FileStream FileRead_open( string FilePath , bool ASync )
		{
			lock( locker )
			{
				int result = dx_FileRead_open( FilePath , ASync ) ;
				if( !( result != 0 ) ) { throw new DxLibException() ; }
				return FileStream.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_open( string FilePath , bool ASync ) ;


		/// <summary> t@C̃TCY𓾂 </summary>
		public static int FileRead_size( string FilePath )
		{
			lock( locker )
			{
				int result = dx_FileRead_size( FilePath ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_size( string FilePath ) ;


		/// <summary> t@C|C^݈̌ʒu𓾂 </summary>
		public static int FileRead_tell( FileStream FileHandle )
		{
			lock( locker )
			{
				int result = dx_FileRead_tell( FileStream.ToHandle( FileHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_tell( int FileHandle ) ;


		/// <summary> t@C|C^̈ʒuύX </summary>
		public static int FileRead_seek( FileStream FileHandle , int Offset , STREAM_SEEKTYPE Origin )
		{
			lock( locker )
			{
				int result = dx_FileRead_seek( FileStream.ToHandle( FileHandle ) , Offset , Origin ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_seek( int FileHandle , int Offset , STREAM_SEEKTYPE Origin ) ;


		/// <summary> t@Cf[^ǂݍ </summary>
		public static int FileRead_read( IntPtr Buffer , int ReadSize , FileStream FileHandle )
		{
			lock( locker )
			{
				int result = dx_FileRead_read( Buffer , ReadSize , FileStream.ToHandle( FileHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_read( IntPtr Buffer , int ReadSize , int FileHandle ) ;


		/// <summary> t@Cǂݍ݂Ă邩ǂ擾 </summary>
		public static bool FileRead_idle_chk( FileStream FileHandle )
		{
			lock( locker )
			{
				int result = dx_FileRead_idle_chk( FileStream.ToHandle( FileHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_idle_chk( int FileHandle ) ;


		/// <summary> t@C̏I[ǂ𓾂 </summary>
		public static bool FileRead_eof( FileStream FileHandle )
		{
			lock( locker )
			{
				int result = dx_FileRead_eof( FileStream.ToHandle( FileHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_eof( int FileHandle ) ;


		/// <summary> t@C當ǂݏo </summary>
		public static int FileRead_gets( out string Buffer , int BufferSize , FileStream FileHandle )
		{
			lock( locker )
			{
				StringBuilder Buffer_ = new StringBuilder( BufferSize ) ;
				int result = dx_FileRead_gets( Buffer_ , BufferSize , FileStream.ToHandle( FileHandle ) ) ;
				Buffer = Buffer_.ToString() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_gets( [ Out ] StringBuilder Buffer , int BufferSize , int FileHandle ) ;


		/// <summary> t@Cꕶǂݏo </summary>
		public static char FileRead_getc( FileStream FileHandle )
		{
			lock( locker )
			{
				char result = dx_FileRead_getc( FileStream.ToHandle( FileHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern char dx_FileRead_getc( int FileHandle ) ;


		/// <summary> t@Cnh쐬( ߂l  -1:G[  -1ȊO:t@Cnh ) </summary>
		public static FILEINFO[] FileRead_createInfo( string ObjectPath )
		{
			lock( locker )
			{
				int FileInfoHandle = dx_FileRead_createInfo( ObjectPath ) ;
				if( !( FileInfoHandle != -1 ) ) { throw new DxLibException() ; }

				try
				{
					int FileInfoNum = dx_FileRead_getInfoNum( FileInfoHandle ) ;
					if( !( FileInfoNum >= 0 ) ) { throw new DxLibException() ; }
					FILEINFO[] fileInfos = new FILEINFO[ FileInfoNum ] ;

					for( int Index = 0 ; Index < fileInfos.Length ; Index ++ )
					{
						int result = dx_FileRead_getInfo( Index , out fileInfos[ Index ] , FileInfoHandle ) ;
						if( !( result == 0 ) ) { throw new DxLibException(); }
					}

					return fileInfos ;
				}
				finally
				{
					dx_FileRead_deleteInfo( FileInfoHandle ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_createInfo( string ObjectPath ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_getInfoNum( int FileInfoHandle ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_getInfo( int Index , out FILEINFO Buffer , int FileInfoHandle ) ;

		/// <summary> t@Cnh폜 </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_deleteInfo( int FileInfoHandle ) ;


		/// <summary> w̃t@C̓tH_̏擾At@Cnh쐬( ߂l: -1=G[  -1ȊO=t@Cnh ) </summary>
		public static FileFinder FileRead_findFirst( string FilePath , out FILEINFO Buffer )
		{
			lock( locker )
			{
				int result = dx_FileRead_findFirst( FilePath , out Buffer ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return FileFinder.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_findFirst( string FilePath , out FILEINFO Buffer ) ;


		/// <summary> ̍v鎟̃t@C̏擾( ߂l: -1=G[  0= ) </summary>
		public static bool FileRead_findNext( FileFinder FindHandle , out FILEINFO Buffer )
		{
			lock( locker )
			{
				int result = dx_FileRead_findNext( FileFinder.ToHandle( FindHandle ) , out Buffer ) ;
				return result == 0 ? true : false ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_findNext( int FindHandle , out FILEINFO Buffer ) ;


		/// <summary> w̃\[X擾( -1:s  0: ) </summary>
		public static void GetResourceInfo( string ResourceName , string ResourceType , out IntPtr DataPointerP , out int DataSizeP )
		{
			lock( locker )
			{
				int result = dx_GetResourceInfo( ResourceName , ResourceType , out DataPointerP , out DataSizeP ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetResourceInfo( string ResourceName , string ResourceType , out IntPtr DataPointerP , out int DataSizeP ) ;


		/// <summary> \[Xhc烊\[Xhc𓾂  </summary>
		public static string GetResourceIDString( int ResourceID )
		{
			lock( locker )
			{
				IntPtr result = dx_GetResourceIDString( ResourceID ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetResourceIDString( int ResourceID ) ;


		/// <summary> EChEỸbZ[W[vɑ鏈s </summary>
		public static bool ProcessMessage()
		{
			lock( locker )
			{
				int result = dx_ProcessMessage() ;
				return result != -1 ? true : false ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessMessage() ;


		/// <summary> EChẼNCAg̈擾 </summary>
		public static void GetWindowCRect( out RECT RectBuf )
		{
			lock( locker )
			{
				int result = dx_GetWindowCRect( out RectBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowCRect( out RECT RectBuf ) ;


		/// <summary> EChẼANeButO擾 </summary>
		public static bool GetWindowActiveFlag()
		{
			lock( locker )
			{
				int result = dx_GetWindowActiveFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowActiveFlag() ;


		/// <summary> CEChẼnh擾 </summary>
		/// <returns> HWND </returns>
		public static IntPtr GetMainWindowHandle()
		{
			lock( locker )
			{
				IntPtr result = dx_GetMainWindowHandle() ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetMainWindowHandle() ;


		/// <summary> EChE[hŋNĂ邩ÃtO擾 </summary>
		public static bool GetWindowModeFlag()
		{
			lock( locker )
			{
				int result = dx_GetWindowModeFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowModeFlag() ;


		/// <summary> ÑfXNgbv̉ʃ[h擾 </summary>
		public static void GetDefaultState( out int SizeX , out int SizeY , out int ColorBitDepth )
		{
			lock( locker )
			{
				int result = dx_GetDefaultState( out SizeX , out SizeY , out ColorBitDepth ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDefaultState( out int SizeX , out int SizeY , out int ColorBitDepth ) ;


		/// <summary> \tgANeBuǂ擾 </summary>
		public static bool GetActiveFlag()
		{
			lock( locker )
			{
				int result = dx_GetActiveFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetActiveFlag() ;


		/// <summary> ANeBuɂȂAꎞ~Ăǂ擾( ResetFlag=TRUE:ԂZbg FALSE:ԂZbgȂ	߂l: 0=ꎞ~͂ĂȂ  1=ꎞ~Ă ) </summary>
		public static bool GetNoActiveState( bool ResetFlag )
		{
			lock( locker )
			{
				int result = dx_GetNoActiveState( ResetFlag ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

		/// <summary> ANeBuɂȂAꎞ~Ăǂ擾( ResetFlag=TRUE:ԂZbg FALSE:ԂZbgȂ	߂l: 0=ꎞ~͂ĂȂ  1=ꎞ~Ă ) </summary>
		public static bool GetNoActiveState()
		{
			return GetNoActiveState( true ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNoActiveState( bool ResetFlag ) ;


		/// <summary> }EX\邩ǂ̃tO擾 </summary>
		public static bool GetMouseDispFlag()
		{
			lock( locker )
			{
				int result = dx_GetMouseDispFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMouseDispFlag() ;


		/// <summary> EChEANeBuł͂ȂԂł𑱍s邩AtO擾 </summary>
		public static bool GetAlwaysRunFlag()
		{
			lock( locker )
			{
				int result = dx_GetAlwaysRunFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetAlwaysRunFlag() ;


		/// <summary> cwCu DirectX ̃o[W Windows ̃o[W𓾂 </summary>
		public static void _GetSystemInfo( out int DxLibVer , out DX_DIRECTXVERSION DirectXVer , out DX_WINDOWSVERSION WindowsVer )
		{
			lock( locker )
			{
				int result = dx__GetSystemInfo( out DxLibVer , out DirectXVer , out WindowsVer ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx__GetSystemInfo( out int DxLibVer , out DX_DIRECTXVERSION DirectXVer , out DX_WINDOWSVERSION WindowsVer ) ;


		/// <summary> ob̏𓾂 </summary>
		/// <param name="CPUSpeed"> PMHz </param>
		/// <param name="FreeMemorySize"> PMByte </param>
		/// <param name="FreeVideoMemorySize"> PMByte </param>
		public static void GetPcInfo( out string OSString , out string DirectXString , out string CPUString , out int CPUSpeed , out double FreeMemorySize , out double TotalMemorySize , out string VideoDriverFileName , out string VideoDriverString , out double FreeVideoMemorySize , out double TotalVideoMemorySize )
		{
			lock( locker )
			{
				StringBuilder OSString_ = new StringBuilder( 0x200 ) ;
				StringBuilder DirectXString_ = new StringBuilder( 0x200 ) ;
				StringBuilder CPUString_ = new StringBuilder( 0x200 ) ;
				StringBuilder VideoDriverFileName_ = new StringBuilder( 0x200 ) ;
				StringBuilder VideoDriverString_ = new StringBuilder( 0x200 ) ;
				int result = dx_GetPcInfo( OSString_ , DirectXString_ , CPUString_ , out CPUSpeed , out FreeMemorySize , out TotalMemorySize , VideoDriverFileName_ , VideoDriverString_ , out FreeVideoMemorySize , out TotalVideoMemorySize ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				OSString = OSString_.ToString() ;
				DirectXString = DirectXString_.ToString() ;
				CPUString = CPUString_.ToString() ;
				VideoDriverFileName = VideoDriverFileName_.ToString() ;
				VideoDriverString = VideoDriverString_.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPcInfo( [ Out ] StringBuilder OSString , [ Out ] StringBuilder DirectXString , [ Out ] StringBuilder CPUString , out int CPUSpeed , out double FreeMemorySize , out double TotalMemorySize , [ Out ] StringBuilder VideoDriverFileName , [ Out ] StringBuilder VideoDriverString , out double FreeVideoMemorySize , out double TotalVideoMemorySize ) ;


		/// <summary> llwg邩ǂ̏𓾂 </summary>
		public static bool GetUseMMXFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseMMXFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseMMXFlag() ;


		/// <summary> rrdg邩ǂ̏𓾂 </summary>
		public static bool GetUseSSEFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseSSEFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseSSEFlag() ;


		/// <summary> rrdQg邩ǂ̏𓾂 </summary>
		public static bool GetUseSSE2Flag()
		{
			lock( locker )
			{
				int result = dx_GetUseSSE2Flag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseSSE2Flag() ;


		/// <summary> EChE悤ƂĂ邩̏𓾂 </summary>
		public static bool GetWindowCloseFlag()
		{
			lock( locker )
			{
				int result = dx_GetWindowCloseFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowCloseFlag() ;


		/// <summary> \tg̃CX^X擾 </summary>
		/// <returns> HINSTANCE </returns>
		public static IntPtr GetTaskInstance()
		{
			lock( locker )
			{
				IntPtr result = dx_GetTaskInstance() ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetTaskInstance() ;


		/// <summary> [WgĂ邩ǂ擾 </summary>
		public static bool GetUseWindowRgnFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseWindowRgnFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseWindowRgnFlag() ;


		/// <summary> EChẼTCYύXł邩ǂ̃tO擾 </summary>
		public static bool GetWindowSizeChangeEnableFlag( out bool FitScreen )
		{
			lock( locker )
			{
				int result = dx_GetWindowSizeChangeEnableFlag( out FitScreen ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

		/// <summary> EChẼTCYύXł邩ǂ̃tO擾 </summary>
		public static bool GetWindowSizeChangeEnableFlag()
		{
			bool FitScreen ;
			return GetWindowSizeChangeEnableFlag( out FitScreen ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowSizeChangeEnableFlag( out bool FitScreen ) ;


		/// <summary> `ʂ̃TCYɑ΂EChETCY̔䗦擾( ߂l ExRateX ɑlƓł ) </summary>
		public static void GetWindowSizeExtendRate( out double ExRateX , out double ExRateY )
		{
			lock( locker )
			{
				double result = dx_GetWindowSizeExtendRate( out ExRateX , out ExRateY ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern double dx_GetWindowSizeExtendRate( out double ExRateX , out double ExRateY ) ;


		/// <summary> EChE[h̃EChỄNCAg̈̃TCY擾 </summary>
		public static void GetWindowSize( out int Width , out int Height )
		{
			lock( locker )
			{
				int result = dx_GetWindowSize( out Width , out Height ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowSize( out int Width , out int Height ) ;


		/// <summary> EChE[h̃EChËʒu擾( g܂߂W ) </summary>
		public static void GetWindowPosition( out int x , out int y )
		{
			lock( locker )
			{
				int result = dx_GetWindowPosition( out x , out y ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowPosition( out int x , out int y ) ;


		/// <summary> EChE̕{^ꂽǂ擾 </summary>
		public static bool GetWindowUserCloseFlag( bool StateResetFlag )
		{
			lock( locker )
			{
				int result = dx_GetWindowUserCloseFlag( StateResetFlag ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

		/// <summary> EChE̕{^ꂽǂ擾 </summary>
		public static bool GetWindowUserCloseFlag()
		{
			return GetWindowUserCloseFlag( false ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWindowUserCloseFlag( bool StateResetFlag ) ;


		/// <summary> `@\gǂ̃tO擾 </summary>
		public static bool GetNotDrawFlag()
		{
			lock( locker )
			{
				int result = dx_GetNotDrawFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNotDrawFlag() ;


		/// <summary> WM_PAINT bZ[Wǂ擾(߂l  TRUE:WM_PAINTbZ[W(x擾ƈȌAĂ WM_PAINTbZ[W܂ false ԂĂ悤ɂȂ)  FALSE:WM_PAINT bZ[W͗ĂȂ) </summary>
		public static bool GetPaintMessageFlag()
		{
			lock( locker )
			{
				int result = dx_GetPaintMessageFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPaintMessageFlag() ;


		/// <summary> ptH[}XJE^Lǂ擾(߂l  TRUE:L  FALSE:) </summary>
		public static bool GetValidHiPerformanceCounter()
		{
			lock( locker )
			{
				int result = dx_GetValidHiPerformanceCounter() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetValidHiPerformanceCounter() ;


		/// <summary> EChE[hύX </summary>
		public static void ChangeWindowMode( bool Flag )
		{
			lock( locker )
			{
				int result = dx_ChangeWindowMode( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeWindowMode( bool Flag ) ;


		/// <summary> cwCu̕񏈗őOƂ镶Zbgݒ肷 </summary>
		/// <param name="CharSet"> = DX_CHARSET_SHFTJIS  </param>
		public static void SetUseCharSet( int CharSet )
		{
			lock( locker )
			{
				int result = dx_SetUseCharSet( CharSet ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseCharSet( int CharSet ) ;


		/// <summary> ANeBuEChẼ\tgɈڂĂۂɕ\摜̃[h(NULL ŉ) </summary>
		public static void LoadPauseGraph( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadPauseGraph( FileName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadPauseGraph( string FileName ) ;


		/// <summary> ANeBuEChẼ\tgɈڂĂۂɕ\摜̃[h(NULL ŉ) </summary>
		public static void LoadPauseGraphFromMem( IntPtr MemImage , int MemImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadPauseGraphFromMem( MemImage , MemImageSize ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadPauseGraphFromMem( IntPtr MemImage , int MemImageSize ) ;


		/// <summary> EChẼANeBuԂɕωƂɌĂ΂R[obN֐Zbg( NULL ZbgƌĂ΂ȂȂ ) </summary>
		public static void SetActiveStateChangeCallBackFunction( ActiveStateChangeCallBackFunction CallBackFunction , IntPtr UserData )
		{
			lock( locker )
			{
				ActiveStateChangeCallBackFunction = delegate( int ActiveState , IntPtr UserData_ )
				{
					return CallBackFunction( ActiveState , UserData_ ) ;
				} ;
				int result = dx_SetActiveStateChangeCallBackFunction( ActiveStateChangeCallBackFunction , UserData ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> EChẼANeBuԂɕωƂɌĂ΂R[obN֐Zbg( NULL ZbgƌĂ΂ȂȂ ) </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetActiveStateChangeCallBackFunction( [ MarshalAs( UnmanagedType.FunctionPtr ) ] ACTIVESTATECHANGECALLBACKFUNCTION CallBackFunction , IntPtr UserData ) ;

		private static ACTIVESTATECHANGECALLBACKFUNCTION ActiveStateChangeCallBackFunction ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate int ACTIVESTATECHANGECALLBACKFUNCTION( int ActiveState , IntPtr UserData ) ;


		/// <summary> CEChẼEChEeLXgύX </summary>
		public static void SetWindowText( string WindowText )
		{
			lock( locker )
			{
				int result = dx_SetWindowText( WindowText ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowText( string WindowText ) ;


		/// <summary> CEChẼEChEeLXgύX </summary>
		public static void SetMainWindowText( string WindowText )
		{
			lock( locker )
			{
				int result = dx_SetMainWindowText( WindowText ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMainWindowText( string WindowText ) ;


		/// <summary> CEChẼNXݒ肷 </summary>
		public static void SetMainWindowClassName( string ClassName )
		{
			lock( locker )
			{
				int result = dx_SetMainWindowClassName( ClassName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMainWindowClassName( string ClassName ) ;


		/// <summary> Oo͂sۂ̃Zbg </summary>
		public static void SetOutApplicationLogValidFlag( bool Flag )
		{
			lock( locker )
			{
				logOutFlag = Flag ;
				int result = dx_SetOutApplicationLogValidFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetOutApplicationLogValidFlag( bool Flag ) ;


		/// <summary> EChEANeBuł͂ȂԂł𑱍s邩AtOZbg </summary>
		public static void SetAlwaysRunFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetAlwaysRunFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetAlwaysRunFlag( bool Flag ) ;


		/// <summary> gpACR̂hcZbg </summary>
		public static void SetWindowIconID( int ID )
		{
			lock( locker )
			{
				int result = dx_SetWindowIconID( ID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowIconID( int ID ) ;


		/// <summary> ő剻{^ALT+ENTERL[ɂ񓯊ȃEChE[h̕ύX̋@\̐ݒs </summary>
		public static void SetUseASyncChangeWindowModeFunction( bool Flag , UseASyncChangeWindowModeFunction CallBackFunction , IntPtr Data )
		{
			lock( locker )
			{
				UseASyncChangeWindowModeFunction = delegate( IntPtr data )
				{
					CallBackFunction( data ) ;
				} ;
				int result = dx_SetUseASyncChangeWindowModeFunction( Flag , UseASyncChangeWindowModeFunction , Data ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> ő剻{^ALT+ENTERL[ɂ񓯊ȃEChE[h̕ύX̋@\̐ݒs </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseASyncChangeWindowModeFunction( bool Flag , [ MarshalAs( UnmanagedType.FunctionPtr ) ] USEASYNCCHANGEWINDOWMODEFUNCTION CallBackFunction , IntPtr Data ) ;

		private static USEASYNCCHANGEWINDOWMODEFUNCTION UseASyncChangeWindowModeFunction ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate void USEASYNCCHANGEWINDOWMODEFUNCTION( IntPtr Data ) ;


		/// <summary> EChẼX^CύX </summary>
		public static void SetWindowStyleMode( WS Mode )
		{
			lock( locker )
			{
				int result = dx_SetWindowStyleMode( Mode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowStyleMode( WS Mode ) ;


		/// <summary> EChẼTCYύXł邩ǂ̃tOZbg( NotFitScreen:EChẼNCAg̈ɉʂtBbg(g傳)ǂ  TRUE:tBbg  FALSE:tBbgȂ ) </summary>
		public static void SetWindowSizeChangeEnableFlag( bool Flag )
		{
			SetWindowSizeChangeEnableFlag( Flag , true ) ;
		}

		/// <summary> EChẼTCYύXł邩ǂ̃tOZbg( NotFitScreen:EChẼNCAg̈ɉʂtBbg(g傳)ǂ  TRUE:tBbg  FALSE:tBbgȂ ) </summary>
		public static void SetWindowSizeChangeEnableFlag( bool Flag , bool FitScreen )
		{
			lock( locker )
			{
				int result = dx_SetWindowSizeChangeEnableFlag( Flag , FitScreen ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowSizeChangeEnableFlag( bool Flag , bool FitScreen ) ;


		/// <summary> `ʂ̃TCYɑ΂EChETCY̔䗦ݒ肷( ExRateY }CiX̏ꍇ ExRateX ̒l ExRateY ɂgp܂ ) </summary>
		public static void SetWindowSizeExtendRate( double ExRate )
		{
			SetWindowSizeExtendRate( ExRate , ExRate ) ;
		}

		/// <summary> `ʂ̃TCYɑ΂EChETCY̔䗦ݒ肷( ExRateY }CiX̏ꍇ ExRateX ̒l ExRateY ɂgp܂ ) </summary>
		public static void SetWindowSizeExtendRate( double ExRateX , double ExRateY )
		{
			lock( locker )
			{
				int result = dx_SetWindowSizeExtendRate( ExRateX , ExRateY ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowSizeExtendRate( double ExRateX , double ExRateY ) ;


		/// <summary> EChE[h̃EChẼNCAg̈̃TCYݒ肷 </summary>
		public static void SetWindowSize( int Width , int Height )
		{
			lock( locker )
			{
				int result = dx_SetWindowSize( Width , Height ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowSize( int Width , int Height ) ;


		/// <summary> EChE[h̃EChËʒuݒ肷( g܂߂W ) </summary>
		public static void SetWindowPosition( int x , int y )
		{
			lock( locker )
			{
				int result = dx_SetWindowPosition( x , y ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowPosition( int x , int y ) ;


		/// <summary> ^XNXCb`Lɂ邩ǂݒ肷 </summary>
		public static void SetSysCommandOffFlag( bool Flag )
		{
			SetSysCommandOffFlag( Flag , null ) ;
		}

		/// <summary> ^XNXCb`Lɂ邩ǂݒ肷 </summary>
		public static void SetSysCommandOffFlag( bool Flag , string HookDllPath )
		{
			lock( locker )
			{
				int result = dx_SetSysCommandOffFlag( Flag , HookDllPath ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetSysCommandOffFlag( bool Flag , string HookDllPath ) ;


		/// <summary> bZ[WtbNEChEv[Wo^ </summary>
		public static void SetHookWinProc( WndProc WinProc )
		{
			lock( locker )
			{
				WndProc = delegate( IntPtr Wnd , int Msg , IntPtr WParam , IntPtr LParam)
				{
					return WinProc( Wnd , Msg , WParam , LParam ) ;
				} ;
				int result = dx_SetHookWinProc( WndProc ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetHookWinProc( WNDPROC WinProc ) ;

		private static WNDPROC WndProc ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.StdCall , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.StdCall , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate IntPtr WNDPROC( IntPtr Wnd , int Msg , IntPtr WParam , IntPtr LParam ) ;


		/// <summary> QdNǂ̃tOZbg </summary>
		public static void SetDoubleStartValidFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDoubleStartValidFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDoubleStartValidFlag( bool Flag ) ;


		/// <summary> bZ[WcwCuɌ肵Ă炤EChEǉ </summary>
		/// <param name="Window"> HWND </param>
		public static void AddMessageTakeOverWindow( IntPtr Window )
		{
			lock( locker )
			{
				int result = dx_AddMessageTakeOverWindow( Window ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMessageTakeOverWindow( IntPtr Window ) ;


		/// <summary> bZ[WcwCuɌ肵Ă炤EChE炷 </summary>
		/// <param name="Window"> HWND </param>
		public static void SubMessageTakeOverWindow( IntPtr Window )
		{
			lock( locker )
			{
				int result = dx_SubMessageTakeOverWindow( Window ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SubMessageTakeOverWindow( IntPtr Window ) ;


		/// <summary> EChȄʒuݒ肷 </summary>
		public static void SetWindowInitPosition( int x , int y )
		{
			lock( locker )
			{
				int result = dx_SetWindowInitPosition( x , y ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowInitPosition( int x , int y ) ;


		/// <summary> cwCũEChE֘A̋@\gpȂtO </summary>
		public static void SetNotWinFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetNotWinFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNotWinFlag( bool Flag ) ;


		/// <summary> `@\gǂ̃tOZbg </summary>
		public static void SetNotDrawFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetNotDrawFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNotDrawFlag( bool Flag ) ;


		/// <summary> TEh@\gǂ̃tOZbg </summary>
		public static void SetNotSoundFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetNotSoundFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNotSoundFlag( bool Flag ) ;


		/// <summary> ͏Ԃ̎擾@\gǂ̃tOZbg </summary>
		public static void SetNotInputFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetNotInputFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNotInputFlag( bool Flag ) ;


		/// <summary> cwCuŃbZ[Ws_CAO{bNXo^ </summary>
		/// <param name="Window"> HWND </param>
		public static void SetDialogBoxHandle( IntPtr Window )
		{
			lock( locker )
			{
				int result = dx_SetDialogBoxHandle( Window ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDialogBoxHandle( IntPtr Window ) ;


		/// <summary> CEChE\邩ǂ̃tOZbg </summary>
		public static void SetWindowVisibleFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetWindowVisibleFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowVisibleFlag( bool Flag ) ;


		/// <summary> CEChÉ~{^ɃCuIɃEChE邩ǂ̃tOZbg </summary>
		public static void SetWindowUserCloseEnableFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetWindowUserCloseEnableFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowUserCloseEnableFlag( bool Flag ) ;


		/// <summary> cwCuI PostQuitMessage ĂԂǂ̃tOZbg </summary>
		public static void SetDxLibEndPostQuitMessageFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDxLibEndPostQuitMessageFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDxLibEndPostQuitMessageFlag( bool Flag ) ;


		/// <summary> cwCuŗpEChẼnhZbg(DxLib_Init sȑOł̂ݗL) </summary>
		/// <param name="Window"> HWND </param>
		public static void SetUserWindow( IntPtr Window )
		{
			lock( locker )
			{
				int result = dx_SetUserWindow( Window ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUserWindow( IntPtr Window ) ;


		/// <summary> SetUseWindow Őݒ肵EChẼbZ[W[vcwCuōsǂAtOZbg </summary>
		public static void SetUserWindowMessageProcessDXLibFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUserWindowMessageProcessDXLibFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUserWindowMessageProcessDXLibFlag( bool Flag ) ;


		/// <summary> cwA[JCut@C̓ǂݍ݋@\gǂݒ肷( FALSE:gpȂ  TRUE:gp ) </summary>
		public static void SetUseDXArchiveFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseDXArchiveFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseDXArchiveFlag( bool Flag ) ;


		/// <summary> cwA[JCut@C̊gqύX </summary>
		public static void SetDXArchiveExtension()
		{
			SetDXArchiveExtension( null ) ;
		}

		/// <summary> cwA[JCut@C̊gqύX </summary>
		public static void SetDXArchiveExtension( string Extension )
		{
			lock( locker )
			{
				int result = dx_SetDXArchiveExtension( Extension ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDXArchiveExtension( string Extension ) ;


		/// <summary> cwA[JCut@Čݒ肷 </summary>
		public static void SetDXArchiveKeyString()
		{
			SetDXArchiveKeyString( null ) ;
		}

		/// <summary> cwA[JCut@Čݒ肷 </summary>
		public static void SetDXArchiveKeyString( string KeyString )
		{
			lock( locker )
			{
				int result = dx_SetDXArchiveKeyString( KeyString ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDXArchiveKeyString( string KeyString ) ;


		/// <summary> Ot@Cɓt邩ǂZbg </summary>
		public static void SetUseDateNameLogFile( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseDateNameLogFile( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseDateNameLogFile( bool Flag ) ;


		/// <summary> CEChẼobNOEhJ[ݒ肷 </summary>
		public static void SetBackgroundColor( int Red , int Green , int Blue )
		{
			lock( locker )
			{
				int result = dx_SetBackgroundColor( Red , Green , Blue ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetBackgroundColor( int Red , int Green , int Blue ) ;


		/// <summary> printfDx ŉʂɏo͂郍OtHg̃TCYύX </summary>
		public static void SetLogFontSize( int Size )
		{
			lock( locker )
			{
				int result = dx_SetLogFontSize( Size ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLogFontSize( int Size ) ;

		/// <summary>FPU̐x𗎂ƂȂݒgp邩ǂݒ肷ADxLib_Init ĂяoÔݗL( TRUE:gp(xȂ)  FALSE:gpȂ(x𗎂Ƃ(ftHg) ) </summary>
		public static void SetUseFPUPreserveFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseFPUPreserveFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseFPUPreserveFlag( bool Flag ) ;


		/// <summary> }EX|C^EChẼNCAgGÅOɂ邩ǂݒ肷( TRUE:( ftHgݒ )  FALSE:Ȃ ) </summary>
		public static void SetValidMousePointerWindowOutClientAreaMoveFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetValidMousePointerWindowOutClientAreaMoveFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetValidMousePointerWindowOutClientAreaMoveFlag( bool Flag ) ;


		/// <summary> obNobt@̓ߐF̕𓧉߂邩ǂݒ肷( TRUE:߂  FALSE:߂Ȃ ) </summary>
		public static void SetUseBackBufferTransColorFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseBackBufferTransColorFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseBackBufferTransColorFlag( bool Flag ) ;


		/// <summary> \[XǂݍލۂɎgp郂W[ݒ肷( NULL w肷ƏԂɖ߂܂AftHgł NULL ) </summary>
		/// <param name="ResourceModule"> HMODULE </param>
		public static void SetResourceModule( IntPtr ResourceModule )
		{
			lock( locker )
			{
				int result = dx_SetResourceModule( ResourceModule ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetResourceModule( IntPtr ResourceModule ) ;


		/// <summary> Nbv{[hɊi[ĂeLXgf[^ǂݏoA-1 ̏ꍇ̓Nbv{[hɃeLXgf[^͖Ƃ( DestBuffer  NULL nƊi[ɕKvȃf[^TCYԂĂ ) </summary>
		public static void GetClipboardText( out string DestBuffer )
		{
			lock( locker )
			{
				int capacity = dx_GetClipboardText( null ) ;

				if( capacity >= 0 )
				{
					StringBuilder DestBuffer_ = new StringBuilder( capacity ) ;
					int result = dx_GetClipboardText( DestBuffer_ ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
					DestBuffer = DestBuffer_.ToString() ;
				}
				else
				{
					DestBuffer = null ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetClipboardText( [ Out ] StringBuilder DestBuffer ) ;


		/// <summary> Nbv{[hɃeLXgf[^i[ </summary>
		public static void SetClipboardText( string Text )
		{
			lock( locker )
			{
				int result = dx_SetClipboardText( Text ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetClipboardText( string Text ) ;


		/// <summary> t@C̃hbOhbv@\Lɂ邩ǂ̃tOZbg </summary>
		public static void SetDragFileValidFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDragFileValidFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDragFileValidFlag( bool Flag ) ;


		/// <summary> hbOhbvꂽt@C̏ </summary>
		public static void DragFileInfoClear()
		{
			lock( locker )
			{
				int result = dx_DragFileInfoClear() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DragFileInfoClear() ;


		/// <summary> hbOhbvꂽt@C擾( -1:擾łȂ  0:擾ł ) </summary>
		public static void GetDragFilePath( out string FilePathBuffer )
		{
			lock( locker )
			{
				int capacity = dx_GetDragFilePath( null ) ;

				if( capacity >= 0 )
				{
					StringBuilder FilePathBuffer_ = new StringBuilder( capacity ) ;
					int result = dx_GetDragFilePath( FilePathBuffer_ ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
					FilePathBuffer = FilePathBuffer_.ToString() ;
				}
				else
				{
					FilePathBuffer = null ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDragFilePath( [ Out ] StringBuilder FilePathBuffer ) ;


		/// <summary> hbOhbvꂽt@C̐擾 </summary>
		public static int GetDragFileNum()
		{
			lock( locker )
			{
				int result = dx_GetDragFileNum() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDragFileNum() ;


		/// <summary> Cӂ̃OtBbNRGNnh쐬 </summary>
		/// <returns> HRGN </returns>
		public static IntPtr CreateRgnFromGraph( int Width , int Height , IntPtr MaskData , int Pitch , int Byte )
		{
			lock( locker )
			{
				IntPtr result = dx_CreateRgnFromGraph( Width , Height , MaskData , Pitch , Byte ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_CreateRgnFromGraph( int Width , int Height , IntPtr MaskData , int Pitch , int Byte ) ;


		/// <summary> Cӂ̊{C[Wf[^ƓߐFRGNnh쐬 </summary>
		/// <returns> HRGN </returns>
		public static IntPtr CreateRgnFromBaseImage( BaseImage BaseImage , int TransColorR , int TransColorG , int TransColorB )
		{
			lock( locker )
			{
				IntPtr result = dx_CreateRgnFromBaseImage( ref BaseImage.buffer , TransColorR , TransColorG , TransColorB ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_CreateRgnFromBaseImage( [ In ] ref BASEIMAGE BaseImage , int TransColorR , int TransColorG , int TransColorB ) ;


		/// <summary> Cӂ̃OtBbNqfmZbg </summary>
		public static void SetWindowRgnGraph( string FileName )
		{
			lock( locker )
			{
				int result = dx_SetWindowRgnGraph( FileName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowRgnGraph( string FileName ) ;


		/// <summary> `̉ʂ̓ߐF̕𓧉߂qfmZbg </summary>
		public static void UpdateTransColorWindowRgn()
		{
			lock( locker )
			{
				int result = dx_UpdateTransColorWindowRgn() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_UpdateTransColorWindowRgn() ;


		/// <summary> c[o[̏( NULL w肷ƃc[o[AResourceID  BitmapName  NULL ̍ۂɎgp ) </summary>
		public static void SetupToolBar( string BitmapName , int DivNum )
		{
			SetupToolBar( BitmapName , DivNum , -1 ) ;
		}

		/// <summary> c[o[̏( NULL w肷ƃc[o[AResourceID  BitmapName  NULL ̍ۂɎgp ) </summary>
		public static void SetupToolBar( string BitmapName , int DivNum , int ResourceID )
		{
			lock( locker )
			{
				int result = dx_SetupToolBar( BitmapName , DivNum , ResourceID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetupToolBar( string BitmapName , int DivNum , int ResourceID ) ;


		/// <summary> c[o[Ƀ{^ǉ </summary>
		/// <param name="Type"> TOOLBUTTON_TYPE_NORMAL  </param>
		/// <param name="State"> TOOLBUTTON_STATE_ENABLE  </param>
		public static void AddToolBarButton( TOOLBUTTON_TYPE Type , TOOLBUTTON_STATE State , int ImageIndex , int ID )
		{
			lock( locker )
			{
				int result = dx_AddToolBarButton( Type , State , ImageIndex , ID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddToolBarButton( TOOLBUTTON_TYPE Type , TOOLBUTTON_STATE State , int ImageIndex , int ID ) ;


		/// <summary> c[o[ɌԂǉ </summary>
		public static void AddToolBarSep()
		{
			lock( locker )
			{
				int result = dx_AddToolBarSep() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddToolBarSep() ;


		/// <summary> c[o[̃{^̏Ԃ擾( TRUE:Ă or ꂽ  FALSE:ĂȂ ) </summary>
		public static bool GetToolBarButtonState( int ID )
		{
			lock( locker )
			{
				int result = dx_GetToolBarButtonState( ID ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetToolBarButtonState( int ID ) ;


		/// <summary> c[o[̃{^̏Ԃݒ </summary>
		public static void SetToolBarButtonState( int ID , TOOLBUTTON_STATE State )
		{
			lock( locker )
			{
				int result = dx_SetToolBarButtonState( ID , State ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetToolBarButtonState( int ID , TOOLBUTTON_STATE State ) ;


		/// <summary> c[o[̃{^Sč폜 </summary>
		public static void DeleteAllToolBarButton()
		{
			lock( locker )
			{
				int result = dx_DeleteAllToolBarButton() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteAllToolBarButton() ;


		/// <summary> j[Lɂ邩ǂݒ肷 </summary>
		public static void SetUseMenuFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseMenuFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseMenuFlag( bool Flag ) ;


		/// <summary> L[{[hANZ[^[gp邩ǂݒ肷 </summary>
		public static void SetUseKeyAccelFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseKeyAccelFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseKeyAccelFlag( bool Flag ) ;


		/// <summary> V[gJbgL[ǉ </summary>
		public static void AddKeyAccel( string ItemName , int ItemID , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag )
		{
			lock( locker )
			{
				int result = dx_AddKeyAccel( ItemName , ItemID , KeyCode , CtrlFlag , AltFlag , ShiftFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddKeyAccel( string ItemName , int ItemID , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag ) ;


		/// <summary> V[gJbgL[ǉ </summary>
		public static void AddKeyAccel_Name( string ItemName , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag )
		{
			lock( locker )
			{
				int result = dx_AddKeyAccel_Name( ItemName , KeyCode , CtrlFlag , AltFlag , ShiftFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddKeyAccel_Name( string ItemName , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag ) ;


		/// <summary> V[gJbgL[ǉ </summary>
		public static void AddKeyAccel_ID( int ItemID , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag )
		{
			lock( locker )
			{
				int result = dx_AddKeyAccel_ID( ItemID , KeyCode , CtrlFlag , AltFlag , ShiftFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddKeyAccel_ID( int ItemID , KEY_INPUT KeyCode , bool CtrlFlag , bool AltFlag , bool ShiftFlag ) ;


		/// <summary> V[gJbgL[̏ </summary>
		public static void ClearKeyAccel()
		{
			lock( locker )
			{
				int result = dx_ClearKeyAccel() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearKeyAccel() ;


		/// <summary> j[ɍڂǉ </summary>
		public static void AddMenuItem( MENUITEM_ADD AddType , string ItemName , int ItemID , bool SeparatorFlag )
		{
			AddMenuItem( AddType , ItemName , ItemID , SeparatorFlag , null ) ;
		}

		/// <summary> j[ɍڂǉ </summary>
		public static void AddMenuItem( MENUITEM_ADD AddType , string ItemName , int ItemID , bool SeparatorFlag , string NewItemName )
		{
			AddMenuItem( AddType , ItemName , ItemID , SeparatorFlag , NewItemName , -1 ) ;
		}

		/// <summary> j[ɍڂǉ </summary>
		/// <param name="AddType"> MENUITEM_ADD_CHILD </param>
		public static void AddMenuItem( MENUITEM_ADD AddType , string ItemName , int ItemID , bool SeparatorFlag , string NewItemName , int NewItemID )
		{
			lock( locker )
			{
				int result = dx_AddMenuItem( AddType , ItemName , ItemID , SeparatorFlag , NewItemName , NewItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMenuItem( MENUITEM_ADD AddType , string ItemName , int ItemID , bool SeparatorFlag , string NewItemName , int NewItemID ) ;


		/// <summary> j[Iڂ폜 </summary>
		public static void DeleteMenuItem( string ItemName , int ItemID )
		{
			lock( locker )
			{
				int result = dx_DeleteMenuItem( ItemName , ItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMenuItem( string ItemName , int ItemID ) ;


		/// <summary> j[Iꂽǂ擾( 0:IĂȂ  1:Iꂽ ) </summary>
		public static bool CheckMenuItemSelect( string ItemName , int ItemID )
		{
			lock( locker )
			{
				int result = dx_CheckMenuItemSelect( ItemName , ItemID ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMenuItemSelect( string ItemName , int ItemID ) ;


		/// <summary> j[̍ڂIo邩ǂݒ肷 </summary>
		public static void SetMenuItemEnable( string ItemName , int ItemID , bool EnableFlag )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemEnable( ItemName , ItemID , EnableFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemEnable( string ItemName , int ItemID , bool EnableFlag ) ;


		/// <summary> j[̍ڂɃ`FbN}[N⃉WI{^\邩ǂݒ肷( MENUITEM_MARK_NONE  ) </summary>
		public static void SetMenuItemMark( string ItemName , int ItemID , MENUITEM_MARK Mark )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemMark( ItemName , ItemID , Mark ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemMark( string ItemName , int ItemID , MENUITEM_MARK Mark ) ;


		/// <summary> j[̍ڂǂꂩIꂽǂ擾( ߂l  TRUE:ǂꂩIꂽ  FALSE:IĂȂ ) </summary>
		public static bool CheckMenuItemSelectAll()
		{
			lock( locker )
			{
				int result = dx_CheckMenuItemSelectAll() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMenuItemSelectAll() ;


		/// <summary> j[ɑIڂǉ </summary>
		public static void AddMenuItem_Name( string ParentItemName , string NewItemName )
		{
			lock( locker )
			{
				int result = dx_AddMenuItem_Name( ParentItemName , NewItemName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMenuItem_Name( string ParentItemName , string NewItemName ) ;


		/// <summary> j[̃Xgɋ؂ǉ </summary>
		public static void AddMenuLine_Name( string ParentItemName )
		{
			lock( locker )
			{
				int result = dx_AddMenuLine_Name( ParentItemName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMenuLine_Name( string ParentItemName ) ;


		/// <summary> w̍ڂƁAw̍ڂ̈̍ڂƂ̊ԂɐVڂǉ </summary>
		public static void InsertMenuItem_Name( string ItemName , string NewItemName )
		{
			lock( locker )
			{
				int result = dx_InsertMenuItem_Name( ItemName , NewItemName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InsertMenuItem_Name( string ItemName , string NewItemName ) ;


		/// <summary> w̍ڂƁAw̍ڂ̈̍ڂƂ̊Ԃɋ؂ǉ </summary>
		public static void InsertMenuLine_Name( string ItemName )
		{
			lock( locker )
			{
				int result = dx_InsertMenuLine_Name( ItemName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InsertMenuLine_Name( string ItemName ) ;


		/// <summary> j[Iڂ폜 </summary>
		public static void DeleteMenuItem_Name( string ItemName )
		{
			lock( locker )
			{
				int result = dx_DeleteMenuItem_Name( ItemName ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMenuItem_Name( string ItemName ) ;


		/// <summary> j[Iꂽǂ擾( 0:IĂȂ  1:Iꂽ ) </summary>
		public static bool CheckMenuItemSelect_Name( string ItemName )
		{
			lock( locker )
			{
				int result = dx_CheckMenuItemSelect_Name( ItemName ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMenuItemSelect_Name( string ItemName ) ;


		/// <summary> j[̍ڂIo邩ǂݒ肷( 1:Ił  0:IłȂ ) </summary>
		public static void SetMenuItemEnable_Name( string ItemName , bool EnableFlag )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemEnable_Name( ItemName , EnableFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemEnable_Name( string ItemName , bool EnableFlag ) ;


		/// <summary> j[̍ڂɃ`FbN}[N⃉WI{^\邩ǂݒ肷( MENUITEM_MARK_NONE  ) </summary>
		public static void SetMenuItemMark_Name( string ItemName , MENUITEM_MARK Mark )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemMark_Name( ItemName , Mark ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemMark_Name( string ItemName , MENUITEM_MARK Mark ) ;


		/// <summary> j[ɑIڂǉ </summary>
		public static void AddMenuItem_ID( int ParentItemID , string NewItemName , int NewItemID )
		{
			lock( locker )
			{
				int result = dx_AddMenuItem_ID( ParentItemID , NewItemName , NewItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> j[ɑIڂǉ </summary>
		public static void AddMenuItem_ID( int ParentItemID , string NewItemName )
		{
			AddMenuItem_ID( ParentItemID , NewItemName , -1 ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMenuItem_ID( int ParentItemID , string NewItemName , int NewItemID ) ;


		/// <summary> j[̃Xgɋ؂ǉ </summary>
		public static void AddMenuLine_ID( int ParentItemID )
		{
			lock( locker )
			{
				int result = dx_AddMenuLine_ID( ParentItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMenuLine_ID( int ParentItemID ) ;


		/// <summary> w̍ڂƁAw̍ڂ̈̍ڂƂ̊ԂɐVڂǉ </summary>
		public static void InsertMenuItem_ID( int ItemID , int NewItemID )
		{
			lock( locker )
			{
				int result = dx_InsertMenuItem_ID( ItemID , NewItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InsertMenuItem_ID( int ItemID , int NewItemID ) ;


		/// <summary> w̍ڂƁAw̍ڂ̈̍ڂƂ̊Ԃɋ؂ǉ </summary>
		public static void InsertMenuLine_ID( int ItemID , int NewItemID )
		{
			lock( locker )
			{
				int result = dx_InsertMenuLine_ID( ItemID , NewItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InsertMenuLine_ID( int ItemID , int NewItemID ) ;


		/// <summary> j[Iڂ폜 </summary>
		public static void DeleteMenuItem_ID( int ItemID )
		{
			lock( locker )
			{
				int result = dx_DeleteMenuItem_ID( ItemID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMenuItem_ID( int ItemID ) ;


		/// <summary> j[Iꂽǂ擾( 0:IĂȂ  1:Iꂽ ) </summary>
		public static bool CheckMenuItemSelect_ID( int ItemID )
		{
			lock( locker )
			{
				int result = dx_CheckMenuItemSelect_ID( ItemID ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMenuItemSelect_ID( int ItemID ) ;


		/// <summary> j[̍ڂIo邩ǂݒ肷 </summary>
		public static void SetMenuItemEnable_ID( int ItemID , bool EnableFlag )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemEnable_ID( ItemID , EnableFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemEnable_ID( int ItemID , bool EnableFlag ) ;


		/// <summary> j[̍ڂɃ`FbN}[N⃉WI{^\邩ǂݒ肷( MENUITEM_MARK_NONE  ) </summary>
		public static void SetMenuItemMark_ID( int ItemID , MENUITEM_MARK Mark )
		{
			lock( locker )
			{
				int result = dx_SetMenuItemMark_ID( ItemID , Mark ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemMark_ID( int ItemID , MENUITEM_MARK Mark ) ;


		/// <summary> j[̑SĂ̑Iڂ폜 </summary>
		public static void DeleteMenuItemAll()
		{
			lock( locker )
			{
				int result = dx_DeleteMenuItemAll() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMenuItemAll() ;


		/// <summary> j[Iꂽǂ̏ </summary>
		public static void ClearMenuItemSelect()
		{
			lock( locker )
			{
				int result = dx_ClearMenuItemSelect() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearMenuItemSelect() ;


		/// <summary> j[̍ږhc擾 </summary>
		public static int GetMenuItemID( string ItemName )
		{
			lock( locker )
			{
				int result = dx_GetMenuItemID( ItemName ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMenuItemID( string ItemName ) ;


		/// <summary> j[̍ږhc擾 </summary>
		public static void GetMenuItemName( int ItemID , out string NameBuffer )
		{
			lock( locker )
			{
				StringBuilder NameBuffer_ = new StringBuilder( 0x200 ) ;
				int result = dx_GetMenuItemName( ItemID , NameBuffer_ ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				NameBuffer = NameBuffer_.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMenuItemName( int ItemID , [ Out ] StringBuilder NameBuffer ) ;


		/// <summary> j[\[Xǂݍ </summary>
		public static void LoadMenuResource( int MenuResourceID )
		{
			lock( locker )
			{
				int result = dx_LoadMenuResource( MenuResourceID ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadMenuResource( int MenuResourceID ) ;


		/// <summary> j[̑IڂIꂽƂɌĂ΂R[obN֐ݒ肷 </summary>
		public static void SetMenuItemSelectCallBackFunction( MenuItemSelectCallBackFunction CallBackFunction )
		{
			lock( locker )
			{
				MenuItemSelectCallBackFunction = delegate( string ItemName , int ItemID )
				{
					CallBackFunction( ItemName , ItemID ) ;
				} ;
				int result = dx_SetMenuItemSelectCallBackFunction( MenuItemSelectCallBackFunction ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMenuItemSelectCallBackFunction( [ MarshalAs( UnmanagedType.FunctionPtr ) ] MENUITEMSELECTCALLBACKFUNCTION CallBackFunction ) ;

		private static MENUITEMSELECTCALLBACKFUNCTION MenuItemSelectCallBackFunction ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate void MENUITEMSELECTCALLBACKFUNCTION( string ItemName , int ItemID ) ;


		/// <summary> j[\邩ǂZbg </summary>
		public static void SetDisplayMenuFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDisplayMenuFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDisplayMenuFlag( bool Flag ) ;


		/// <summary> j[\Ă邩ǂ擾 </summary>
		public static bool GetDisplayMenuFlag()
		{
			lock( locker )
			{
				int result = dx_GetDisplayMenuFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDisplayMenuFlag() ;


		/// <summary> j[gpĂ邩ǂ𓾂 </summary>
		public static bool GetUseMenuFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseMenuFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseMenuFlag() ;


		/// <summary> tXN[Ƀj[ŕ\\ɂ肷邩ǂ̃tOZbg </summary>
		public static void SetAutoMenuDisplayFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetAutoMenuDisplayFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetAutoMenuDisplayFlag( bool Flag ) ;


		/// <summary> }EX̕\tÕZbg </summary>
		public static void SetMouseDispFlag( bool DispFlag )
		{
			lock( locker )
			{
				int result = dx_SetMouseDispFlag( DispFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMouseDispFlag( bool DispFlag ) ;


		/// <summary> }EẌʒu擾 </summary>
		public static void GetMousePoint( out int XBuf , out int YBuf )
		{
			lock( locker )
			{
				int result = dx_GetMousePoint( out XBuf , out YBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMousePoint( out int XBuf , out int YBuf ) ;


		/// <summary> }EẌʒuZbg </summary>
		public static void SetMousePoint( int PointX , int PointY )
		{
			lock( locker )
			{
				int result = dx_SetMousePoint( PointX , PointY ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMousePoint( int PointX , int PointY ) ;


		/// <summary> }EX̃{^̏Ԃ𓾂  </summary>
		public static MOUSE_INPUT GetMouseInput()
		{
			lock( locker )
			{
				MOUSE_INPUT result = dx_GetMouseInput() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MOUSE_INPUT dx_GetMouseInput() ;


		/// <summary> }EXzC[̉]ʂ𓾂 </summary>
		public static int GetMouseWheelRotVol()
		{
			return GetMouseWheelRotVol( true ) ;
		}

		/// <summary> }EXzC[̉]ʂ𓾂 </summary>
		public static int GetMouseWheelRotVol( bool CounterReset )
		{
			lock( locker )
			{
				int result = dx_GetMouseWheelRotVol( CounterReset ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMouseWheelRotVol( bool CounterReset ) ;


		/// <summary> }EX̃NbN擾( ߂l  -1:O ) </summary>
		public static void GetMouseInputLog( out MOUSE_INPUT Button , out int ClickX , out int ClickY )
		{
			GetMouseInputLog( out Button , out ClickX , out ClickY , true ) ;
		}

		/// <summary> }EX̃NbN擾( ߂l  -1:O ) </summary>
		public static void GetMouseInputLog( out MOUSE_INPUT Button , out int ClickX , out int ClickY , bool LogDelete )
		{
			lock( locker )
			{
				int result = dx_GetMouseInputLog( out Button , out ClickX , out ClickY , LogDelete ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMouseInputLog( out MOUSE_INPUT Button , out int ClickX , out int ClickY , bool LogDelete ) ;


		/// <summary> w̎ԂƂ߂ </summary>
		public static void WaitTimer( int WaitTime )
		{
			lock( locker )
			{
				int result = dx_WaitTimer( WaitTime ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_WaitTimer( int WaitTime ) ;


		/// <summary> L[̓͑҂ </summary>
		public static void WaitKey()
		{
			lock( locker )
			{
				int result = dx_WaitKey() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_WaitKey() ;


		/// <summary> ~bPʂ̐xJE^̌ݒl𓾂 </summary>
		public static int GetNowCount()
		{
			return GetNowCount( false ) ;
		}

		/// <summary> ~bPʂ̐xJE^̌ݒl𓾂 </summary>
		public static int GetNowCount( bool UseRDTSCFlag )
		{
			lock( locker )
			{
				int result = dx_GetNowCount( UseRDTSCFlag ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNowCount( bool UseRDTSCFlag ) ;


		/// <summary> GetNowCount̍xo[W </summary>
		public static long GetNowHiPerformanceCount()
		{
			return GetNowHiPerformanceCount( false ) ;
		}

		/// <summary> GetNowCount̍xo[W </summary>
		public static long GetNowHiPerformanceCount( bool UseRDTSCFlag )
		{
			lock( locker )
			{
				long result = dx_GetNowHiPerformanceCount( UseRDTSCFlag ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern long dx_GetNowHiPerformanceCount( bool UseRDTSCFlag ) ;


		/// <summary> ݎ擾  </summary>
		public static void GetDateTime( out DATEDATA DateBuf )
		{
			lock( locker )
			{
				int result = dx_GetDateTime( out DateBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDateTime( out DATEDATA DateBuf ) ;


		/// <summary> 擾( RandMax : Ԃėl̍ől ) </summary>
		public static int GetRand( int RandMax )
		{
			lock( locker )
			{
				int result = dx_GetRand( RandMax ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetRand( int RandMax ) ;


		/// <summary> ̏lݒ肷 </summary>
		public static void SRand( int Seed )
		{
			lock( locker )
			{
				int result = dx_SRand( Seed ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SRand( int Seed ) ;


		/// <summary> ʐMbZ[W̏֐ </summary>
		public static void ProcessNetMessage()
		{
			ProcessNetMessage( false ) ;
		}

		/// <summary> ʐMbZ[W̏֐ </summary>
		public static void ProcessNetMessage( bool RunReleaseProcess )
		{
			lock( locker )
			{
				int result = dx_ProcessNetMessage( RunReleaseProcess ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessNetMessage( bool RunReleaseProcess ) ;


		/// <summary> cmrT[o[găzXghoAhX擾 </summary>
		public static void GetHostIPbyName( string HostName , out IPDATA IPDataBuf )
		{
			lock( locker )
			{
				int result = dx_GetHostIPbyName( HostName , out IPDataBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetHostIPbyName( string HostName , out IPDATA IPDataBuf ) ;


		/// <summary> }Vɐڑ </summary>
		public static NetWork ConnectNetWork( IPDATA IPData )
		{
			return ConnectNetWork( IPData , -1 ) ;
		}

		/// <summary> }Vɐڑ </summary>
		public static NetWork ConnectNetWork( IPDATA IPData , int Port )
		{
			lock( locker )
			{
				int result = dx_ConnectNetWork( IPData , Port ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return NetWork.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ConnectNetWork( IPDATA IPData , int Port ) ;


		/// <summary> ڑ󂯂Ԃɂ </summary>
		public static void PreparationListenNetWork()
		{
			PreparationListenNetWork( -1 ) ;
		}

		/// <summary> ڑ󂯂Ԃɂ </summary>
		public static void PreparationListenNetWork( int Port )
		{
			lock( locker )
			{
				int result = dx_PreparationListenNetWork( Port ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PreparationListenNetWork( int Port ) ;


		/// <summary> ڑ󂯂Ԃ̉ </summary>
		public static void StopListenNetWork()
		{
			lock( locker )
			{
				int result = dx_StopListenNetWork() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopListenNetWork() ;


		/// <summary> ڑԂ擾 </summary>
		public static bool GetNetWorkAcceptState( int NetHandle )
		{
			lock( locker )
			{
				int result = dx_GetNetWorkAcceptState( NetHandle ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNetWorkAcceptState( int NetHandle ) ;


		/// <summary> Mf[^̗ʂ𓾂 </summary>
		public static int GetNetWorkDataLength( NetWork NetHandle )
		{
			lock( locker )
			{
				int result = dx_GetNetWorkDataLength( NetWork.ToHandle( NetHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNetWorkDataLength( int NetHandle ) ;


		/// <summary> M̃f[^̗ʂ𓾂  </summary>
		public static int GetNetWorkSendDataLength( NetWork NetHandle )
		{
			lock( locker )
			{
				int result = dx_GetNetWorkSendDataLength( NetWork.ToHandle( NetHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNetWorkSendDataLength( int NetHandle ) ;


		/// <summary> VɐڑʐM𓾂 </summary>
		public static NetWork GetNewAcceptNetWork()
		{
			lock( locker )
			{
				int result = dx_GetNewAcceptNetWork() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return NetWork.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNewAcceptNetWork() ;


		/// <summary> ڑؒfꂽʐM𓾂 </summary>
		public static NetWork GetLostNetWork()
		{
			lock( locker )
			{
				int result = dx_GetLostNetWork() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return NetWork.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLostNetWork() ;


		/// <summary> ڑ̂ho𓾂 </summary>
		public static void GetNetWorkIP( NetWork NetHandle , out IPDATA IpBuf )
		{
			lock( locker )
			{
				int result = dx_GetNetWorkIP( NetWork.ToHandle( NetHandle ) , out IpBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNetWorkIP( int NetHandle , out IPDATA IpBuf ) ;


		/// <summary> ̂ho𓾂 </summary>
		public static void GetMyIPAddress( out IPDATA IpBuf )
		{
			lock( locker )
			{
				int result = dx_GetMyIPAddress( out IpBuf ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMyIPAddress( out IPDATA IpBuf ) ;


		/// <summary> ڑ̃^CAEg܂ł̎Ԃݒ肷 </summary>
		public static void SetConnectTimeOutWait( int Time )
		{
			lock( locker )
			{
				int result = dx_SetConnectTimeOutWait( Time ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetConnectTimeOutWait( int Time ) ;


		/// <summary> cwCu̒ʐM`ԂgǂZbg </summary>
		public static void SetUseDXNetWorkProtocol( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseDXNetWorkProtocol( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseDXNetWorkProtocol( bool Flag ) ;


		/// <summary> cwCu̒ʐM`Ԃgǂ擾 </summary>
		public static bool GetUseDXNetWorkProtocol()
		{
			lock( locker )
			{
				int result = dx_GetUseDXNetWorkProtocol() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseDXNetWorkProtocol() ;


		/// <summary> ڑؒfꂽɐڑnh邩ǂ̃tOZbg </summary>
		public static void SetNetWorkCloseAfterLostFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetNetWorkCloseAfterLostFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNetWorkCloseAfterLostFlag( bool Flag ) ;


		/// <summary> ڑؒfꂽɐڑnh邩ǂ̃tO擾 </summary>
		public static bool GetNetWorkCloseAfterLostFlag()
		{
			lock( locker )
			{
				int result = dx_GetNetWorkCloseAfterLostFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetNetWorkCloseAfterLostFlag() ;


		/// <summary> Mf[^ǂݍ </summary>
		public static void NetWorkRecv( NetWork NetHandle , IntPtr Buffer , int Length )
		{
			lock( locker )
			{
				int result = dx_NetWorkRecv( NetWork.ToHandle( NetHandle ) , Buffer , Length ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkRecv( int NetHandle , IntPtr Buffer , int Length ) ;


		/// <summary> Mf[^ǂݍށAǂݍ񂾃f[^̓obt@폜Ȃ </summary>
		public static void NetWorkRecvToPeek( NetWork NetHandle , IntPtr Buffer , int Length )
		{
			lock( locker )
			{
				int result = dx_NetWorkRecvToPeek( NetWork.ToHandle( NetHandle ) , Buffer , Length ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkRecvToPeek( int NetHandle , IntPtr Buffer , int Length ) ;


		/// <summary> Mf[^NA </summary>
		public static void NetWorkRecvBufferClear( NetWork NetHandle )
		{
			lock( locker )
			{
				int result = dx_NetWorkRecvBufferClear( NetWork.ToHandle( NetHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkRecvBufferClear( int NetHandle ) ;


		/// <summary> f[^𑗐M </summary>
		public static void NetWorkSend( NetWork NetHandle , IntPtr Buffer , int Length )
		{
			lock( locker )
			{
				int result = dx_NetWorkSend( NetWork.ToHandle( NetHandle ) , Buffer , Length ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkSend( int NetHandle , IntPtr Buffer , int Length ) ;


		/// <summary> UDPgpʐMs\Pbgnh쐬( RecvPort  -1 ɂƑMp̃\PbgnhɂȂ܂ ) </summary>
		public static NetWorkUDP MakeUDPSocket()
		{
			return MakeUDPSocket( -1 ) ;
		}

		/// <summary> UDPgpʐMs\Pbgnh쐬( RecvPort  -1 ɂƑMp̃\PbgnhɂȂ܂ ) </summary>
		public static NetWorkUDP MakeUDPSocket( int RecvPort )
		{
			lock( locker )
			{
				int result = dx_MakeUDPSocket( RecvPort ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return NetWorkUDP.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeUDPSocket( int RecvPort ) ;


		/// <summary> UDPgpʐMŎŵhoɃf[^𑗐MALength ͍ő65507ASendPort  -1 ɂ MakeUDPSocket  RecvPort œn|[ggp܂( ߂l  0ȏ;Młf[^TCY  -1:G[  -2:Mf[^傫  -3:MłĂȂ  ) </summary>
		public static int NetWorkSendUDP( NetWorkUDP NetUDPHandle , IPDATA SendIP , int SendPort , IntPtr Buffer , int Length )
		{
			lock( locker )
			{
				int result = dx_NetWorkSendUDP( NetWorkUDP.ToHandle( NetUDPHandle ) , SendIP , SendPort , Buffer , Length ) ;
				if( result >= 0 ) { return result ; }
				else if( result != -2 ) { throw new DxLibException( "Mf[^傫" ) ; }
				else if( result != -3 ) { throw new DxLibException( "MłĂȂ" ) ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkSendUDP( int NetUDPHandle , IPDATA SendIP , int SendPort , IntPtr Buffer , int Length ) ;


		/// <summary> UDPgpʐMŃf[^MAPeek  TRUE nƎMɐĂf[^ML[폜܂( ߂l  0ȏ:Mf[^̃TCY  -1:G[  -2:obt@̃TCYȂ  -3:Mf[^Ȃ ) </summary>
		public static int NetWorkRecvUDP( int NetUDPHandle , out IPDATA RecvIP , out int RecvPort , IntPtr Buffer , int Length , int Peek )
		{
			lock( locker )
			{
				int result = dx_NetWorkRecvUDP( NetUDPHandle , out RecvIP , out RecvPort , Buffer , Length , Peek ) ;
				if( result >= 0 ) { return result ; }
				else if( result != -2 ) { throw new DxLibException( "obt@̃TCYȂ" ) ; }
				else if( result != -3 ) { throw new DxLibException( "Mf[^Ȃ" ) ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_NetWorkRecvUDP( int NetUDPHandle , out IPDATA RecvIP , out int RecvPort , IntPtr Buffer , int Length , int Peek ) ;


		/// <summary> UDPgpʐMŐVȎMf[^݂邩ǂ𒲂ׂ( ߂l  -1:G[  TRUE:Mf[^  FALSE:Mf[^Ȃ ) </summary>
		public static bool CheckNetWorkRecvUDP( NetWorkUDP NetUDPHandle )
		{
			lock( locker )
			{
				int result = dx_CheckNetWorkRecvUDP( NetWorkUDP.ToHandle( NetUDPHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckNetWorkRecvUDP( int NetUDPHandle ) ;


		/// <summary> obt@ɃR[hXgbN </summary>
		public static void StockInputChar( char CharCode )
		{
			lock( locker )
			{
				int result = dx_StockInputChar( CharCode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StockInputChar( char CharCode ) ;


		/// <summary> R[hobt@NA </summary>
		public static void ClearInputCharBuf()
		{
			lock( locker )
			{
				int result = dx_ClearInputCharBuf() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearInputCharBuf() ;


		/// <summary> R[hobt@ɗ܂f[^當R[h擾 </summary>
		public static char GetInputChar( bool DeleteFlag )
		{
			lock( locker )
			{
				char result = dx_GetInputChar( DeleteFlag ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern char dx_GetInputChar( bool DeleteFlag ) ;


		/// <summary> R[hobt@ɗ܂f[^PoCg擾Aobt@ɂȂɂR[hȂꍇ̓L[܂ő҂ </summary>
		public static char GetInputCharWait( bool DeleteFlag )
		{
			lock( locker )
			{
				char result = dx_GetInputCharWait( DeleteFlag ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern char dx_GetInputCharWait( bool DeleteFlag ) ;


		/// <summary> R[hobt@ɗ܂f[^P擾 </summary>
		public static void GetOneChar( out char CharBuffer , bool DeleteFlag )
		{
			lock( locker )
			{
				IntPtr CharBuffer_ = IntPtr.Zero ;

				try
				{
				#if UNICODE
					CharBuffer_ = Marshal.AllocHGlobal( 2 * 2 ) ;
				#else
					CharBuffer_ = Marshal.AllocHGlobal( 2 * 1 ) ;
				#endif
					int result = dx_GetOneChar( CharBuffer_ , DeleteFlag ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
				#if UNICODE
					CharBuffer = Marshal.PtrToStringUni( CharBuffer_ , 2 )[ 0 ] ;
				#else
					CharBuffer = Marshal.PtrToStringAnsi( CharBuffer_ , 2 )[ 0 ] ;
				#endif
				}
				finally
				{
					Marshal.FreeHGlobal( CharBuffer_ ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetOneChar( IntPtr CharBuffer , bool DeleteFlag ) ;


		/// <summary> R[hobt@ɗ܂f[^P擾Aobt@ɉR[hȂꍇ̓L[܂ő҂ </summary>
		public static void GetOneCharWait( out char CharBuffer , bool DeleteFlag )
		{
			lock( locker )
			{
				IntPtr CharBuffer_ = IntPtr.Zero ;

				try
				{
				#if UNICODE
					CharBuffer_ = Marshal.AllocHGlobal( 2 * 2 ) ;
				#else
					CharBuffer_ = Marshal.AllocHGlobal( 2 * 1 ) ;
				#endif
					int result = dx_GetOneCharWait( CharBuffer_ , DeleteFlag ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
				#if UNICODE
					CharBuffer = Marshal.PtrToStringUni( CharBuffer_ , 2 )[ 0 ] ;
				#else
					CharBuffer = Marshal.PtrToStringAnsi( CharBuffer_ , 2 )[ 0 ] ;
				#endif
				}
				finally
				{
					Marshal.FreeHGlobal( CharBuffer_ ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetOneCharWait( IntPtr CharBuffer , bool DeleteFlag ) ;


		/// <summary> AXL[Rg[R[hׂ </summary>
		public static bool GetCtrlCodeCmp( char Char )
		{
			lock( locker )
			{
				int result = dx_GetCtrlCodeCmp( Char ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetCtrlCodeCmp( char Char ) ;


		/// <summary> ʏɓ͒̕`悷 </summary>
		public static void DrawIMEInputString( int x , int y , int SelectStringNum )
		{
			lock( locker )
			{
				int result = dx_DrawIMEInputString( x , y , SelectStringNum ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawIMEInputString( int x , int y , int SelectStringNum ) ;


		/// <summary> hldgp邩ǂZbg </summary>
		public static void SetUseIMEFlag( bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetUseIMEFlag( UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseIMEFlag( bool UseFlag ) ;


		/// <summary> hldœ͂łő啶 MakeKeyInput ̐ݒɍ킹邩ǂZbg( TRUE:킹  FALSE:킹Ȃ(ftHg) ) </summary>
		public static void SetInputStringMaxLengthIMESync( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetInputStringMaxLengthIMESync( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetInputStringMaxLengthIMESync( bool Flag ) ;


		/// <summary> hldňxɓ͂łő啶ݒ肷( 0:Ȃ  1ȏ:w̕Ő ) </summary>
		public static void SetIMEInputStringMaxLength( int Length )
		{
			lock( locker )
			{
				int result = dx_SetIMEInputStringMaxLength( Length ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetIMEInputStringMaxLength( int Length ) ;


		/// <summary> SpAp藐钆w̕ł̔p𓾂 </summary>
		public static int GetStringPoint( string String , int Point )
		{
			lock( locker )
			{
				int result = dx_GetStringPoint( String , Point ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetStringPoint( string String , int Point ) ;


		/// <summary> SpAp藐钆w̕ł̑Sp𓾂 </summary>
		public static int GetStringPoint2( string String , int Point )
		{
			lock( locker )
			{
				int result = dx_GetStringPoint2( String , Point ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetStringPoint2( string String , int Point ) ;


		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , COLOR_U8.Empty ) ;
		}

		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , null ) ;
		}

		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , new COLOR_U8( -1 ) ) ;
		}

		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle , COLOR_U8 SelectBackColor )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , new COLOR_U8( 0 ) ) ;
		}

		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle , COLOR_U8 SelectBackColor , COLOR_U8 SelectStrColor )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , new COLOR_U8( -1 ) ) ;
		}
		
		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle , COLOR_U8 SelectBackColor , COLOR_U8 SelectStrColor , COLOR_U8 SelectStrEdgeColor )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , -1 ) ;
		}
		
		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle , COLOR_U8 SelectBackColor , COLOR_U8 SelectStrColor , COLOR_U8 SelectStrEdgeColor , int SelectStart )
		{
			DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , FontHandle , SelectBackColor , SelectStrColor , SelectStrEdgeColor , SelectStart , -1 ) ;
		}

		/// <summary> K̈Ɏ߂ŕ` </summary>
		public static void DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , Font FontHandle , COLOR_U8 SelectBackColor , COLOR_U8 SelectStrColor , COLOR_U8 SelectStrEdgeColor , int SelectStart , int SelectEnd )
		{
			lock( locker )
			{
				int result = dx_DrawObtainsString( x , y , AddY , String , StrColor , StrEdgeColor , Font.ToHandle( FontHandle ) , SelectBackColor.ToInt() , SelectStrColor.ToInt() , SelectStrEdgeColor.ToInt() , SelectStart , SelectEnd ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawObtainsString( int x , int y , int AddY , string String , COLOR_U8 StrColor , COLOR_U8 StrEdgeColor , int FontHandle , int SelectBackColor , int SelectStrColor , int SelectStrEdgeColor , int SelectStart , int SelectEnd ) ;


		/// <summary> K̈Ɏ߂ŋ``  </summary>
		public static void DrawObtainsBox( int x1 , int y1 , int x2 , int y2 , int AddY , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawObtainsBox( x1 , y1 , x2 , y2 , AddY , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawObtainsBox( int x1 , int y1 , int x2 , int y2 , int AddY , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> ͎̓擾 </summary>
		public static void InputStringToCustom( int x , int y , int BufLength , out string StrBuffer , bool CancelValidFlag , bool SingleCharOnlyFlag , bool NumCharOnlyFlag )
		{
			lock( locker )
			{
				StringBuilder StrBuffer_ = new StringBuilder( BufLength ) ;
				int result = dx_InputStringToCustom( x , y , BufLength , StrBuffer_ , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				StrBuffer = StrBuffer_.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InputStringToCustom( int x , int y , int BufLength , [ Out ] StringBuilder StrBuffer , bool CancelValidFlag , bool SingleCharOnlyFlag , bool NumCharOnlyFlag ) ;


		/// <summary> ͎̓擾 </summary>
		public static void KeyInputString( int x , int y , int CharMaxLength , out string StrBuffer , bool CancelValidFlag )
		{
			lock( locker )
			{
				StringBuilder strBuffer = new StringBuilder( CharMaxLength ) ;
				int result = dx_KeyInputString( x , y , CharMaxLength , strBuffer , CancelValidFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				StrBuffer = strBuffer.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_KeyInputString( int x , int y , int CharMaxLength , [ Out ] StringBuilder StrBuffer , bool CancelValidFlag ) ;


		/// <summary> p݂͎̂̓擾 </summary>
		public static void KeyInputSingleCharString( int x , int y , int CharMaxLength , out string StrBuffer , bool CancelValidFlag )
		{
			lock( locker )
			{
				StringBuilder strBuffer = new StringBuilder( CharMaxLength ) ;
				int result = dx_KeyInputSingleCharString( x , y , CharMaxLength , strBuffer , CancelValidFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				StrBuffer = strBuffer.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_KeyInputSingleCharString( int x , int y , int CharMaxLength , [ Out ] StringBuilder StrBuffer , bool CancelValidFlag ) ;


		/// <summary> l̓ </summary>
		public static void KeyInputNumber( int x , int y , int MaxNum , int MinNum , bool CancelValidFlag )
		{
			lock( locker )
			{
				int result = dx_KeyInputNumber( x , y , MaxNum , MinNum , CancelValidFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_KeyInputNumber( int x , int y , int MaxNum , int MinNum , bool CancelValidFlag ) ;


		/// <summary> IME̓̓[h̎擾 </summary>
		public static void GetIMEInputModeStr( out string GetBuffer )
		{
			lock( locker )
			{
				StringBuilder getBuffer = new StringBuilder( 0x200 ) ;
				int result = dx_GetIMEInputModeStr( getBuffer ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				GetBuffer = getBuffer.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetIMEInputModeStr( [ Out ] StringBuilder GetBuffer ) ;


		/// <summary> IMEœ͒̏̕擾 </summary>
		public static DxLib.IMEINPUTDATA GetIMEInputData()
		{
			lock( locker )
			{
				IMEINPUTDATA source = ( IMEINPUTDATA )( Marshal.PtrToStructure( dx_GetIMEInputData() , typeof( IMEINPUTDATA ) ) ) ;
				DxLib.IMEINPUTDATA target = new DxLib.IMEINPUTDATA() ;
				target.InputString = source.InputString ;
				target.CursorPosition = source.CursorPosition ;
				target.ClauseData = new IMEINPUTCLAUSEDATA[ source.ClauseNum ] ;
				target.SelectClause = source.SelectClause ;
				target.CandidateList = new string[ source.CandidateNum ] ;
				target.SelectCandidate = source.SelectCandidate ;

				for( int i = 0 ; i < target.ClauseData.Length ; i ++ )
				{
					unsafe
					{
						target.ClauseData[ i ] = source.ClauseData[ i ] ;
					}
				}

				for( int i = 0 ; i < target.CandidateList.Length ; i ++ )
				{
					unsafe
					{
					#if UNICODE
						target.CandidateList[ i ] = Marshal.PtrToStringUni( source.CandidateList[ i ] ) ;
					#else
						target.CandidateList[ i ] = Marshal.PtrToStringAnsi( source.CandidateList[ i ] ) ;
					#endif
					}
				}

				return target ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetIMEInputData() ;

	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		internal unsafe struct IMEINPUTDATA
		{

			[ MarshalAs( UnmanagedType.LPTStr ) ]
			public string InputString ;

			public int CursorPosition ;

			public IMEINPUTCLAUSEDATA *ClauseData ;

			public int ClauseNum ;

			public int SelectClause ;

			public int CandidateNum ;

			public IntPtr *CandidateList ;

			public int SelectCandidate ;
		}

		
		/// <summary> InputString֐gp̊̕eFύX </summary>
		public static void SetKeyInputStringColor( COLOR_U8 NmlStr , COLOR_U8 NmlCur , COLOR_U8 IMEStr , COLOR_U8 IMECur , COLOR_U8 IMELine , COLOR_U8 IMESelectStr , COLOR_U8 IMEModeStr )
		{
			SetKeyInputStringColor( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , COLOR_U8.Empty ) ;
		}
		
		/// <summary> InputString֐gp̊̕eFύX </summary>
		public static void SetKeyInputStringColor( COLOR_U8 NmlStr , COLOR_U8 NmlCur , COLOR_U8 IMEStr , COLOR_U8 IMECur , COLOR_U8 IMELine , COLOR_U8 IMESelectStr , COLOR_U8 IMEModeStr , COLOR_U8 NmlStrE )
		{
			SetKeyInputStringColor( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , COLOR_U8.Empty ) ;
		}
		
		/// <summary> InputString֐gp̊̕eFύX </summary>
		public static void SetKeyInputStringColor( COLOR_U8 NmlStr , COLOR_U8 NmlCur , COLOR_U8 IMEStr , COLOR_U8 IMECur , COLOR_U8 IMELine , COLOR_U8 IMESelectStr , COLOR_U8 IMEModeStr , COLOR_U8 NmlStrE , COLOR_U8 IMESelectStrE )
		{
			SetKeyInputStringColor( NmlStr , NmlCur , IMEStr , IMECur , IMELine , IMESelectStr , IMEModeStr , NmlStrE , IMESelectStrE , COLOR_U8.Empty ) ;
		}
		
		/// <summary> InputString֐gp̊̕eFύX </summary>
		public static void SetKeyInputStringColor( COLOR_U8 NmlStr , COLOR_U8 NmlCur , COLOR_U8 IMEStr , COLOR_U8 IMECur , COLOR_U8 IMELine , COLOR_U8 IMESelectStr , COLOR_U8 IMEModeStr , COLOR_U8 NmlStrE , COLOR_U8 IMESelectStrE , COLOR_U8 IMEModeStrE )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputStringColor( unchecked( ( uint )( NmlStr.ToInt() ) ) , unchecked( ( uint )( NmlCur.ToInt() ) ) , unchecked( ( uint )( IMEStr.ToInt() ) ) , unchecked( ( uint )( IMECur.ToInt() ) ) , unchecked( ( uint )( IMELine.ToInt() ) ) , unchecked( ( uint )( IMESelectStr.ToInt() ) ) , unchecked( ( uint )( IMEModeStr.ToInt() ) ) , unchecked( ( uint )( NmlStrE.ToInt() ) ) , unchecked( ( uint )( IMESelectStrE.ToInt() ) ) , unchecked( ( uint )( IMEModeStrE.ToInt() ) ) , -1 , -1 , -1 , -1 , -1 ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> InputString֐gp̊̕eFύX </summary>
		public static void SetKeyInputStringColor( COLOR_U8 NmlStr , COLOR_U8 NmlCur , COLOR_U8 IMEStr , COLOR_U8 IMECur , COLOR_U8 IMELine , COLOR_U8 IMESelectStr , COLOR_U8 IMEModeStr , COLOR_U8 NmlStrE , COLOR_U8 IMESelectStrE , COLOR_U8 IMEModeStrE , COLOR_U8 IMESelectWinE , COLOR_U8 IMESelectWinF , COLOR_U8 SelectStrBackColor , COLOR_U8 SelectStrColor , COLOR_U8 SelectStrEdgeColor )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputStringColor( unchecked( ( uint )( NmlStr.ToInt() ) ) , unchecked( ( uint )( NmlCur.ToInt() ) ) , unchecked( ( uint )( IMEStr.ToInt() ) ) , unchecked( ( uint )( IMECur.ToInt() ) ) , unchecked( ( uint )( IMELine.ToInt() ) ) , unchecked( ( uint )( IMESelectStr.ToInt() ) ) , unchecked( ( uint )( IMEModeStr.ToInt() ) ) , unchecked( ( uint )( NmlStrE.ToInt() ) ) , unchecked( ( uint )( IMESelectStrE.ToInt() ) ) , unchecked( ( uint )( IMEModeStrE.ToInt() ) ) , unchecked( ( uint )( IMESelectWinE.ToInt() ) ) , unchecked( ( uint )( IMESelectWinF.ToInt() ) ) , unchecked( ( uint )( SelectStrBackColor.ToInt() ) ) , unchecked( ( uint )( SelectStrColor.ToInt() ) ) , unchecked( ( uint )( SelectStrEdgeColor.ToInt() ) ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputStringColor( long NmlStr , long NmlCur , long IMEStr , long IMECur , long IMELine , long IMESelectStr , long IMEModeStr , long NmlStrE , long IMESelectStrE , long IMEModeStrE , long IMESelectWinE , long IMESelectWinF , long SelectStrBackColor , long SelectStrColor , long SelectStrEdgeColor ) ;


		/// <summary> L[͕`֘AŎgptHg̃nhύX(-1ŃftHg̃tHgnh) </summary>
		public static void SetKeyInputStringFont( Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputStringFont( Font.ToHandle( FontHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputStringFont( int FontHandle ) ;


		/// <summary> ̓[h`悷 </summary>
		public static void DrawKeyInputModeString( int x , int y )
		{
			lock( locker )
			{
				int result = dx_DrawKeyInputModeString( x , y ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawKeyInputModeString( int x , int y ) ;


		/// <summary> VL[̓f[^̍쐬 </summary>
		public static KeyInput MakeKeyInput( int MaxStrLength , bool CancelValidFlag , bool SingleCharOnlyFlag , bool NumCharOnlyFlag )
		{
			lock( locker )
			{
				int result = dx_MakeKeyInput( MaxStrLength , CancelValidFlag , SingleCharOnlyFlag , NumCharOnlyFlag ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return KeyInput.FromHandle( result , MaxStrLength ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeKeyInput( int MaxStrLength , bool CancelValidFlag , bool SingleCharOnlyFlag , bool NumCharOnlyFlag ) ;


		/// <summary> w̃L[͂ANeBuɂ( -1 w肷ƃANeBuȃL[̓nhԂɂȂ܂ ) </summary>
		public static void SetActiveKeyInput( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetActiveKeyInput( KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetActiveKeyInput( int InputHandle ) ;


		/// <summary> ݃ANeBuɂȂĂL[̓nh擾 </summary>
		public static KeyInput GetActiveKeyInput()
		{
			lock( locker )
			{
				int result = dx_GetActiveKeyInput() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return KeyInput.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetActiveKeyInput() ;


		/// <summary> ͂IĂ邩擾 </summary>
		public static bool CheckKeyInput( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_CheckKeyInput( KeyInput.ToHandle( InputHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckKeyInput( int InputHandle ) ;


		/// <summary> ͂L[͂ēxҏWԂɖ߂ </summary>
		public static void ReStartKeyInput( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_ReStartKeyInput( KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReStartKeyInput( int InputHandle ) ;


		/// <summary> L[͏֐ </summary>
		public static void ProcessActKeyInput()
		{
			lock( locker )
			{
				int result = dx_ProcessActKeyInput() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessActKeyInput() ;


		/// <summary> L[͒f[^̕` </summary>
		public static void DrawKeyInputString( int x , int y , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_DrawKeyInputString( x , y , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawKeyInputString( int x , int y , int InputHandle ) ;


		/// <summary> L[̓f[^̎ẅ̗IԂɂ( SelectStart  SelectEnd  -1 w肷ƑIԂ܂ ) </summary>
		public static void SetKeyInputSelectArea( int SelectStart , int SelectEnd , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputSelectArea( SelectStart , SelectEnd , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputSelectArea( int SelectStart , int SelectEnd , int InputHandle ) ;


		/// <summary> L[̓f[^̑Ï擾 </summary>
		public static void GetKeyInputSelectArea( out int SelectStart , out int SelectEnd , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_GetKeyInputSelectArea( out SelectStart , out SelectEnd , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetKeyInputSelectArea( out int SelectStart , out int SelectEnd , int InputHandle ) ;


		/// <summary> L[͂̕`Jnʒuݒ肷 </summary>
		public static void SetKeyInputDrawStartPos( int DrawStartPos , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputDrawStartPos( DrawStartPos , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputDrawStartPos( int DrawStartPos , int InputHandle ) ;


		/// <summary> L[͂̕`Jnʒu擾 </summary>
		public static int GetKeyInputDrawStartPos( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_GetKeyInputDrawStartPos( KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetKeyInputDrawStartPos( int InputHandle ) ;


		/// <summary> L[͎̃J[\̓_ł鑁Zbg </summary>
		public static void SetKeyInputCursorBrinkTime( int Time )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputCursorBrinkTime( Time ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputCursorBrinkTime( int Time ) ;


		/// <summary> L[͎̃J[\_ł邩ǂZbg </summary>
		public static void SetKeyInputCursorBrinkFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputCursorBrinkFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputCursorBrinkFlag( bool Flag ) ;


		/// <summary> L[̓f[^Ɏw̕Zbg </summary>
		public static void SetKeyInputString( string String , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputString( String , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputString( string String , int InputHandle ) ;


		/// <summary> L[̓f[^Ɏw̐l𕶎ɒuăZbg </summary>
		public static void SetKeyInputNumber( int Number , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputNumber( Number , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputNumber( int Number , int InputHandle ) ;


		/// <summary> L[̓f[^Ɏw̕_l𕶎ɒuăZbg </summary>
		public static void SetKeyInputNumberToFloat( float Number , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputNumberToFloat( Number , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputNumberToFloat( float Number , int InputHandle ) ;


		/// <summary> ̓f[^̕擾 </summary>
		public static void GetKeyInputString( out string StrBuffer , KeyInput InputHandle )
		{
			lock( locker )
			{
				StringBuilder StrBuffer_ = new StringBuilder( InputHandle.length ) ;
				int result = dx_GetKeyInputString( StrBuffer_ , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				StrBuffer = StrBuffer_.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetKeyInputString( [ Out ] StringBuilder StrBuffer , int InputHandle ) ;


		/// <summary> ̓f[^̕𐮐lƂĎ擾 </summary>
		public static int GetKeyInputNumber( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_GetKeyInputNumber( KeyInput.ToHandle( InputHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetKeyInputNumber( int InputHandle ) ;


		/// <summary> ̓f[^̕𕂓_lƂĎ擾 </summary>
		public static float GetKeyInputNumberToFloat( KeyInput InputHandle )
		{
			lock( locker )
			{
				float result = dx_GetKeyInputNumberToFloat( KeyInput.ToHandle( InputHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetKeyInputNumberToFloat( int InputHandle ) ;


		/// <summary> L[݂͂̌̃J[\ʒuݒ肷 </summary>
		public static void SetKeyInputCursorPosition( int Position , KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_SetKeyInputCursorPosition( Position , KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetKeyInputCursorPosition( int Position , int InputHandle ) ;


		/// <summary> L[݂͂̌̃J[\ʒu擾 </summary>
		public static int GetKeyInputCursorPosition( KeyInput InputHandle )
		{
			lock( locker )
			{
				int result = dx_GetKeyInputCursorPosition( KeyInput.ToHandle( InputHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetKeyInputCursorPosition( int InputHandle ) ;
	}
}
