using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public static partial class Window
	{


		/// <summary> VTEhf[^̈mۂ </summary>
		public static Sound AddSoundData()
		{
			lock( locker )
			{
				int result = dx_AddSoundData( -1 ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

		/// <summary> VTEhf[^̈mۂ </summary>
		public static void AddSoundData( Sound SoundHandle )
		{
			lock( locker )
			{
				if( SoundHandle == null ) { throw new ArgumentException() ; }
				int result = dx_AddSoundData( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddSoundData( int Handle ) ;


		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMem( IStream Stream , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType , out bool CanStreamCloseFlag )
		{
			AddStreamSoundMem( Stream , LoopNum , SoundHandle , StreamDataType , out CanStreamCloseFlag , null ) ;
		}

		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMem( IStream Stream , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType , out bool CanStreamCloseFlag , Sound UnionHandle )
		{
			lock( locker )
			{
				STREAMDATA Stream_ = new STREAMDATA( Stream ) ;
				int result = dx_AddStreamSoundMem( ref Stream_ , LoopNum , Sound.ToHandle( SoundHandle ) , StreamDataType , out CanStreamCloseFlag , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddStreamSoundMem( [ In ] ref STREAMDATA Stream , int LoopNum , int SoundHandle , DX_SOUNDDATATYPE StreamDataType , out bool CanStreamCloseFlag , int UnionHandle ) ;


		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMemToMem( IntPtr FileImageBuffer , int ImageSize , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType )
		{
			AddStreamSoundMemToMem( FileImageBuffer , ImageSize , LoopNum , SoundHandle , StreamDataType , null ) ;
		}

		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMemToMem( IntPtr FileImageBuffer , int ImageSize , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_AddStreamSoundMemToMem( FileImageBuffer , ImageSize , LoopNum , Sound.ToHandle( SoundHandle ) , StreamDataType , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddStreamSoundMemToMem( IntPtr FileImageBuffer , int ImageSize , int LoopNum , int SoundHandle , DX_SOUNDDATATYPE StreamDataType , int UnionHandle ) ;


		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMemToFile( string WaveFile , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType )
		{
			AddStreamSoundMemToFile( WaveFile , LoopNum , SoundHandle , StreamDataType , null ) ;
		}

		/// <summary> Xg[TEhf[^ɃTEhf[^ǉ </summary>
		public static void AddStreamSoundMemToFile( string WaveFile , int LoopNum , Sound SoundHandle , DX_SOUNDDATATYPE StreamDataType , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_AddStreamSoundMemToFile( WaveFile , LoopNum , Sound.ToHandle( SoundHandle ) , StreamDataType , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddStreamSoundMemToFile( string WaveFile , int LoopNum , int SoundHandle , DX_SOUNDDATATYPE StreamDataType , int UnionHandle ) ;


		/// <summary> Xg[TEhf[^̍Đs </summary>
		public static void SetupStreamSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetupStreamSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetupStreamSoundMem( int SoundHandle ) ;


		/// <summary> Xg[TEhf[^̍ĐJn </summary>
		public static void PlayStreamSoundMem( Sound SoundHandle , DX_PLAYTYPE PlayType )
		{
			PlayStreamSoundMem( SoundHandle , PlayType , true ) ;
		}

		/// <summary> Xg[TEhf[^̍ĐJn </summary>
		public static void PlayStreamSoundMem( Sound SoundHandle )
		{
			PlayStreamSoundMem( SoundHandle , DX_PLAYTYPE.LOOP ) ;
		}

		/// <summary> Xg[TEhf[^̍ĐJn </summary>
		public static void PlayStreamSoundMem( Sound SoundHandle , DX_PLAYTYPE PlayType , bool TopPositionFlag )
		{
			lock( locker )
			{
				int result = dx_PlayStreamSoundMem( Sound.ToHandle( SoundHandle ) , PlayType , TopPositionFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayStreamSoundMem( int SoundHandle , DX_PLAYTYPE PlayType , bool TopPositionFlag ) ;


		/// <summary> Xg[TEhf[^̍ĐԂ𓾂 </summary>
		public static bool CheckStreamSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_CheckStreamSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckStreamSoundMem( int SoundHandle ) ;


		/// <summary> Xg[TEhf[^̍ĐI </summary>
		public static void StopStreamSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_StopStreamSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopStreamSoundMem( int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuoCgPʂŕύX(Đ~܂Ă鎞̂ݗL) </summary>
		public static void SetStreamSoundCurrentPosition( int Byte , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetStreamSoundCurrentPosition( Byte , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetStreamSoundCurrentPosition( int Byte , int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuoCgPʂŎ擾 </summary>
		public static int GetStreamSoundCurrentPosition( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetStreamSoundCurrentPosition( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetStreamSoundCurrentPosition( int SoundHandle ) ;


		/// <summary> TEhnh̍Đʒu~bPʂŐݒ肷(k`̏ꍇ͐ݒ肳Ȃꍇ) </summary>
		public static void SetStreamSoundCurrentTime( int Time , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetStreamSoundCurrentTime( Time , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetStreamSoundCurrentTime( int Time , int SoundHandle ) ;


		/// <summary> TEhnh̍Đʒu~bPʂŎ擾(k`̏ꍇ͐lԂĂȂꍇ) </summary>
		public static int GetStreamSoundCurrentTime( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetStreamSoundCurrentTime( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetStreamSoundCurrentTime( int SoundHandle ) ;


		/// <summary> Xg[TEh̍Đ֐ </summary>
		public static void ProcessStreamSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_ProcessStreamSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessStreamSoundMem( int SoundHandle ) ;


		/// <summary> LȃXg[TEĥׂčĐ֐ɂ </summary>
		public static void ProcessStreamSoundMemAll()
		{
			lock( locker )
			{
				int result = dx_ProcessStreamSoundMemAll() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessStreamSoundMemAll() ;


		/// <summary> Otƃ[vɕꂽTEhf[^̍쐬 </summary>
		public static Sound LoadSoundMem2( string WaveName1 , string WaveName2 )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMem2( WaveName1 , WaveName2 ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMem2( string WaveName1 , string WaveName2 ) ;


		/// <summary> ɂaflǂݍނ̂ɓK֐ </summary>
		public static Sound LoadBGM( string WaveName )
		{
			lock( locker )
			{
				int result = dx_LoadBGM( WaveName ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadBGM( string WaveName ) ;


		/// <summary> TEhf[^ǉ </summary>
		public static Sound LoadSoundMemBase( string WaveName , int BufferNum )
		{
			return LoadSoundMemBase( WaveName , BufferNum , null ) ;
		}

		/// <summary> TEhf[^ǉ </summary>
		public static Sound LoadSoundMemBase( string WaveName , int BufferNum , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemBase( WaveName , BufferNum , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemBase( string WaveName , int BufferNum , int UnionHandle ) ;


		/// <summary> TEhf[^ǉ </summary>
		public static Sound LoadSoundMem( string WaveName )
		{
			return LoadSoundMem( WaveName , 3 ) ;
		}

		/// <summary> TEhf[^ǉ </summary>
		public static Sound LoadSoundMem( string WaveName , int BufferNum )
		{
			return LoadSoundMem( WaveName , BufferNum , null ) ;
		}

		/// <summary> TEhf[^ǉ </summary>
		public static Sound LoadSoundMem( string WaveName , int BufferNum , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMem( WaveName , BufferNum , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMem( string WaveName , int BufferNum , int UnionHandle ) ;


		/// <summary> Đw^TEhǉ֐ </summary>
		public static Sound LoadSoundMemToBufNumSitei( string WaveName , int BufferNum )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemToBufNumSitei( WaveName , BufferNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemToBufNumSitei( string WaveName , int BufferNum ) ;


		/// <summary> TEh\[Xǂݍ </summary>
		public static Sound LoadSoundMemByResource( string ResourceName , string ResourceType )
		{
			return LoadSoundMemByResource( ResourceName , ResourceType , 1 ) ;
		}

		/// <summary> TEh\[Xǂݍ </summary>
		public static Sound LoadSoundMemByResource( string ResourceName , string ResourceType , int BufferNum )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemByResource( ResourceName , ResourceType , BufferNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemByResource( string ResourceName , string ResourceType , int BufferNum ) ;


		/// <summary> TEhf[^gpTEhnh쐬( DX_SOUNDDATATYPE_MEMNOPRESS ^Cv̂ ) </summary>
		public static Sound DuplicateSoundMem( Sound SrcSoundHandle )
		{
			return DuplicateSoundMem( SrcSoundHandle , 3 ) ;
		}

		/// <summary> TEhf[^gpTEhnh쐬( DX_SOUNDDATATYPE_MEMNOPRESS ^Cv̂ ) </summary>
		public static Sound DuplicateSoundMem( Sound SrcSoundHandle , int BufferNum )
		{
			lock( locker )
			{
				int result = dx_DuplicateSoundMem( Sound.ToHandle( SrcSoundHandle ) , BufferNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DuplicateSoundMem( int SrcSoundHandle , int BufferNum ) ;


		/// <summary> ɓWJꂽt@CC[Wnh쐬(x[X֐) </summary>
		public static Sound LoadSoundMemByMemImageBase( IntPtr FileImageBuffer , int ImageSize , int BufferNum )
		{
			return LoadSoundMemByMemImageBase( FileImageBuffer , ImageSize , BufferNum , null ) ;
		}

		/// <summary> ɓWJꂽt@CC[Wnh쐬(x[X֐) </summary>
		public static Sound LoadSoundMemByMemImageBase( IntPtr FileImageBuffer , int ImageSize , int BufferNum , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemByMemImageBase( FileImageBuffer , ImageSize , BufferNum , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemByMemImageBase( IntPtr FileImageBuffer , int ImageSize , int BufferNum , int UnionHandle ) ;


		/// <summary> ɓWJꂽt@CC[Wnh쐬(obt@w肠)  </summary>
		public static Sound LoadSoundMemByMemImage( IntPtr FileImageBuffer , int ImageSize )
		{
			return LoadSoundMemByMemImage( FileImageBuffer , ImageSize , null ) ;
		}

		/// <summary> ɓWJꂽt@CC[Wnh쐬(obt@w肠)  </summary>
		public static Sound LoadSoundMemByMemImage( IntPtr FileImageBuffer , int ImageSize , Sound UnionHandle )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemByMemImage( FileImageBuffer , ImageSize , Sound.ToHandle( UnionHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemByMemImage( IntPtr FileImageBuffer , int ImageSize , int UnionHandle ) ;


		/// <summary> ɓWJꂽt@CC[Wnh쐬2 </summary>
		/// <param name="UFormat"> WAVEFORMATEX * </param>
		public static Sound LoadSoundMemByMemImage2( IntPtr UData , int UDataSize , IntPtr UFormat , int UHeaderSize )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemByMemImage2( UData , UDataSize , ref UFormat , UHeaderSize ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemByMemImage2( IntPtr UData , int UDataSize , [ In ] ref IntPtr UFormat , int UHeaderSize ) ;


		/// <summary> ɓWJꂽt@CC[Wnh쐬 </summary>
		public static Sound LoadSoundMemByMemImageToBufNumSitei( IntPtr FileImageBuffer , int ImageSize , int BufferNum )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemByMemImageToBufNumSitei( FileImageBuffer , ImageSize , BufferNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemByMemImageToBufNumSitei( IntPtr FileImageBuffer , int ImageSize , int BufferNum ) ;


		/// <summary> ɓWJꂽt@CC[WOtƃ[vɕꂽnh쐬 </summary>
		public static Sound LoadSoundMem2ByMemImage( IntPtr FileImageBuffer1 , int ImageSize1 , IntPtr FileImageBuffer2 , int ImageSize2 )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMem2ByMemImage( FileImageBuffer1 , ImageSize1 , FileImageBuffer2 , ImageSize2 ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMem2ByMemImage( IntPtr FileImageBuffer1 , int ImageSize1 , IntPtr FileImageBuffer2 , int ImageSize2 ) ;


		/// <summary> \tgEGAŔg`𐧌䂷TEhf[^TEhnh쐬 </summary>
		public static Sound LoadSoundMemFromSoftSound( SoftSound SoftSoundHandle )
		{
			return LoadSoundMemFromSoftSound( SoftSoundHandle , 3 ) ;
		}

		/// <summary> \tgEGAŔg`𐧌䂷TEhf[^TEhnh쐬 </summary>
		public static Sound LoadSoundMemFromSoftSound( SoftSound SoftSoundHandle , int BufferNum )
		{
			lock( locker )
			{
				int result = dx_LoadSoundMemFromSoftSound( SoftSound.ToHandle( SoftSoundHandle ) , BufferNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Sound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoundMemFromSoftSound( int SoftSoundHandle , int BufferNum ) ;


		/// <summary> ɓǂ݂WAVEf[^Đ </summary>
		public static void PlaySoundMem( Sound SoundHandle , DX_PLAYTYPE PlayType )
		{
			PlaySoundMem( SoundHandle , PlayType , true ) ;
		}

		/// <summary> ɓǂ݂WAVEf[^Đ </summary>
		public static void PlaySoundMem( Sound SoundHandle , DX_PLAYTYPE PlayType , bool TopPositionFlag )
		{
			lock( locker )
			{
				int result = dx_PlaySoundMem( Sound.ToHandle( SoundHandle ) , PlayType , TopPositionFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlaySoundMem( int SoundHandle , DX_PLAYTYPE PlayType , bool TopPositionFlag ) ;


		/// <summary> ɓǂݍWAVEf[^̍Đ~߂ </summary>
		public static void StopSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_StopSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopSoundMem( int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^Đׂ </summary>
		public static bool CheckSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_CheckSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckSoundMem( int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̍ĐɃpݒ肷 </summary>
		public static void SetPanSoundMem( int PanPal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetPanSoundMem( PanPal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPanSoundMem( int PanPal , int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̍ĐɃ{[ݒ肷( 1001fVxP ) </summary>
		public static void SetVolumeSoundMem( int VolumePal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetVolumeSoundMem( VolumePal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVolumeSoundMem( int VolumePal , int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̍ĐɃ{[ݒ肷( p[Zgw ) </summary>
		public static void ChangeVolumeSoundMem( int VolumePal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_ChangeVolumeSoundMem( VolumePal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeVolumeSoundMem( int VolumePal , int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̍Đ̃{[擾 </summary>
		public static int GetVolumeSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetVolumeSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetVolumeSoundMem( int SoundHandle ) ;


		/// <summary> ɓǂݍWAVEf[^̍Đgݒ肷 </summary>
		public static void SetFrequencySoundMem( int FrequencyPal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetFrequencySoundMem( FrequencyPal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFrequencySoundMem( int FrequencyPal , int SoundHandle ) ;


		/// <summary> ɓǂݍWAVEf[^̍Đg擾 </summary>
		public static int GetFrequencySoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetFrequencySoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFrequencySoundMem( int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̎̍Đɂ̂ݎgppݒ肷 </summary>
		public static void SetNextPlayPanSoundMem( int PanPal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetNextPlayPanSoundMem( PanPal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNextPlayPanSoundMem( int PanPal , int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̎̍Đɂ̂ݎgp{[ݒ肷( 1001fVxP ) </summary>
		public static void SetNextPlayVolumeSoundMem( int VolumePal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetNextPlayVolumeSoundMem( VolumePal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNextPlayVolumeSoundMem( int VolumePal , int SoundHandle ) ;


		/// <summary> ɓǂ݂WAVEf[^̎̍Đɂ̂ݎgp{[ݒ肷( p[Zgw ) </summary>
		public static void ChangeNextPlayVolumeSoundMem( int VolumePal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_ChangeNextPlayVolumeSoundMem( VolumePal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeNextPlayVolumeSoundMem( int VolumePal , int SoundHandle ) ;


		/// <summary> ɓǂݍWAVEf[^̎̍Đɂ̂ݎgpĐgݒ肷 </summary>
		public static void SetNextPlayFrequencySoundMem( int FrequencyPal , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetNextPlayFrequencySoundMem( FrequencyPal , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetNextPlayFrequencySoundMem( int FrequencyPal , int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuTvPʂŕύX(Đ~܂Ă鎞̂ݗL) </summary>
		public static void SetCurrentPositionSoundMem( int SamplePosition , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetCurrentPositionSoundMem( SamplePosition , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCurrentPositionSoundMem( int SamplePosition , int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuTvPʂŎ擾 </summary>
		public static void GetCurrentPositionSoundMem( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetCurrentPositionSoundMem( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetCurrentPositionSoundMem( int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuoCgPʂŕύX(Đ~܂Ă鎞̂ݗL) </summary>
		public static void SetSoundCurrentPosition( int Byte , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetSoundCurrentPosition( Byte , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetSoundCurrentPosition( int Byte , int SoundHandle ) ;


		/// <summary> TEhnh̍ĐʒuoCgPʂŎ擾 </summary>
		public static int GetSoundCurrentPosition( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetSoundCurrentPosition( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoundCurrentPosition( int SoundHandle ) ;


		/// <summary> TEhnh̍Đʒu~bPʂŐݒ肷(k`̏ꍇ͐ݒ肳Ȃꍇ) </summary>
		public static void SetSoundCurrentTime( int Time , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetSoundCurrentTime( Time , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetSoundCurrentTime( int Time , int SoundHandle ) ;


		/// <summary> TEhnh̍Đʒu~bPʂŎ擾(k`̏ꍇ͐lԂĂȂꍇ) </summary>
		public static int GetSoundCurrentTime( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetSoundCurrentTime( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoundCurrentTime( int SoundHandle ) ;


		/// <summary> TEhnh̉̑Ԃ擾(Pʂ̓Tv) </summary>
		public static int GetSoundTotalSample( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetSoundTotalSample( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoundTotalSample( int SoundHandle ) ;


		/// <summary> TEhnh̉̑Ԃ擾(Pʂ̓~b) </summary>
		public static int GetSoundTotalTime( Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetSoundTotalTime( Sound.ToHandle( SoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoundTotalTime( int SoundHandle ) ;


		/// <summary> TEhnhɃ[vʒuݒ肷 </summary>
		public static void SetLoopPosSoundMem( int LoopTime , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetLoopPosSoundMem( LoopTime , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLoopPosSoundMem( int LoopTime , int SoundHandle ) ;


		/// <summary> TEhnhɃ[vʒuݒ肷 </summary>
		public static void SetLoopTimePosSoundMem( int LoopTime , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetLoopTimePosSoundMem( LoopTime , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLoopTimePosSoundMem( int LoopTime , int SoundHandle ) ;


		/// <summary> TEhnhɃ[vʒuݒ肷 </summary>
		public static void SetLoopSamplePosSoundMem( int LoopSamplePosition , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetLoopSamplePosSoundMem( LoopSamplePosition , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLoopSamplePosSoundMem( int LoopSamplePosition , int SoundHandle ) ;


		/// <summary> TEhnhɃ[vJnʒuݒ肷 </summary>
		public static void SetLoopStartTimePosSoundMem( int LoopStartTime , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetLoopStartTimePosSoundMem( LoopStartTime , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLoopStartTimePosSoundMem( int LoopStartTime , int SoundHandle ) ;


		/// <summary> TEhnhɃ[vJnʒuݒ肷 </summary>
		public static void SetLoopStartSamplePosSoundMem( int LoopStartSamplePosition , Sound SoundHandle )
		{
			lock( locker )
			{
				int result = dx_SetLoopStartSamplePosSoundMem( LoopStartSamplePosition , Sound.ToHandle( SoundHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLoopStartSamplePosSoundMem( int LoopStartSamplePosition , int SoundHandle ) ;


		/// <summary> 쐬TEh̃f[^`ݒ肷( DX_SOUNDDATATYPE_MEMNOPRESS  ) </summary>
		public static void SetCreateSoundDataType( DX_SOUNDDATATYPE SoundDataType )
		{
			lock( locker )
			{
				int result = dx_SetCreateSoundDataType( SoundDataType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCreateSoundDataType( DX_SOUNDDATATYPE SoundDataType ) ;


		/// <summary> 쐬TEh̃f[^`擾( DX_SOUNDDATATYPE_MEMNOPRESS  ) </summary>
		public static DX_SOUNDDATATYPE GetCreateSoundDataType()
		{
			lock( locker )
			{
				DX_SOUNDDATATYPE result = dx_GetCreateSoundDataType() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_SOUNDDATATYPE dx_GetCreateSoundDataType() ;


		/// <summary> TEhLv`OƂ邩ǂݒ肷 </summary>
		public static void SetEnableSoundCaptureFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetEnableSoundCaptureFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetEnableSoundCaptureFlag( bool Flag ) ;


		/// <summary> TEh̏\tgEGAōsǂݒ肷( TRUE:\tgEGA  FALSE:n[hEGA( ftHg ) ) </summary>
		public static void SetUseSoftwareMixingSoundFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseSoftwareMixingSoundFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseSoftwareMixingSoundFlag( bool Flag ) ;


		/// <summary> cwCugpĂ DirectSound IuWFNg擾 </summary>
		/// <returns> ߂l IDirectSound * ɃLXgĉ </returns>
		public static IntPtr GetDSoundObj()
		{
			lock( locker )
			{
				IntPtr result = dx_GetDSoundObj() ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetDSoundObj() ;


		/// <summary> r[vgݒ֐ </summary>
		public static void SetBeepFrequency( int Freq )
		{
			lock( locker )
			{
				int result = dx_SetBeepFrequency( Freq ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetBeepFrequency( int Freq ) ;


		/// <summary> r[vĐ </summary>
		public static void PlayBeep()
		{
			lock( locker )
			{
				int result = dx_PlayBeep() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayBeep() ;


		/// <summary> r[v~߂ </summary>
		public static void StopBeep()
		{
			lock( locker )
			{
				int result = dx_StopBeep() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopBeep() ;


		/// <summary> WAVEt@CĐ </summary>
		public static void PlaySoundFile( string FileName , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlaySoundFile( FileName , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlaySoundFile( string FileName , DX_PLAYTYPE PlayType ) ;


		/// <summary> PlaySoundFile ̋ </summary>
		public static void PlaySound( string FileName , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlaySound( FileName , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlaySound( string FileName , DX_PLAYTYPE PlayType ) ;


		/// <summary> WAVEt@C̍Đׂ </summary>
		public static bool CheckSoundFile()
		{
			lock( locker )
			{
				int result = dx_CheckSoundFile() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckSoundFile() ;


		/// <summary> CheckSoundFile ̋ </summary>
		public static bool CheckSound()
		{
			lock( locker )
			{
				int result = dx_CheckSound() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckSound() ;


		/// <summary> WAVEt@C̍Đ~߂ </summary>
		public static void StopSoundFile()
		{
			lock( locker )
			{
				int result = dx_StopSoundFile() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopSoundFile() ;


		/// <summary> StopSoundFile ̋ </summary>
		public static void StopSound()
		{
			lock( locker )
			{
				int result = dx_StopSound() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopSound() ;


		/// <summary> WAVEt@C̉ʂZbg </summary>
		public static void SetVolumeSoundFile( int VolumePal )
		{
			lock( locker )
			{
				int result = dx_SetVolumeSoundFile( VolumePal ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVolumeSoundFile( int VolumePal ) ;


		/// <summary> SetVolumeSound ̋ </summary>
		public static void SetVolumeSound( int VolumePal )
		{
			lock( locker )
			{
				int result = dx_SetVolumeSound( VolumePal ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVolumeSound( int VolumePal ) ;


		/// <summary> \tgEGAňg`f[^ׂĉ </summary>
		public static void InitSoftSound()
		{
			lock( locker )
			{
				int result = dx_InitSoftSound() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InitSoftSound() ;


		/// <summary> \tgEGAňg`f[^t@C쐬 </summary>
		public static SoftSound LoadSoftSound( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadSoftSound( FileName ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoftSound( string FileName ) ;


		/// <summary> \tgEGAňg`f[^ɓWJꂽt@CC[W쐬 </summary>
		public static SoftSound LoadSoftSoundFromMemImage( IntPtr FileImageBuffer , int FileImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadSoftSoundFromMemImage( FileImageBuffer , FileImageSize ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoftSoundFromMemImage( IntPtr FileImageBuffer , int FileImageSize ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( tH[}bg͈̃\tgEGATEhnhƓ̂ɂ ) </summary>
		public static SoftSound MakeSoftSound( SoftSound UseFormat_SoftSoundHandle , int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound( SoftSound.ToHandle( UseFormat_SoftSoundHandle ) , SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound( int UseFormat_SoftSoundHandle , int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:2 ʎqrbg:16bit TvOg:44KHz ) </summary>
		public static SoftSound MakeSoftSound2Ch16Bit44KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound2Ch16Bit44KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound2Ch16Bit44KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:2 ʎqrbg:16bit TvOg:22KHz ) </summary>
		public static SoftSound MakeSoftSound2Ch16Bit22KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound2Ch16Bit22KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound2Ch16Bit22KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:2 ʎqrbg:8bit TvOg:44KHz ) </summary>
		public static SoftSound MakeSoftSound2Ch8Bit44KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound2Ch8Bit44KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound2Ch8Bit44KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:2 ʎqrbg:8bit TvOg:22KHz ) </summary>
		public static SoftSound MakeSoftSound2Ch8Bit22KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound2Ch8Bit22KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound2Ch8Bit22KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:1 ʎqrbg:16bit TvOg:44KHz ) </summary>
		public static SoftSound MakeSoftSound1Ch16Bit44KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound1Ch16Bit44KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound1Ch16Bit44KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:1 ʎqrbg:16bit TvOg:22KHz ) </summary>
		public static SoftSound MakeSoftSound1Ch16Bit22KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound1Ch16Bit22KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound1Ch16Bit22KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:1 ʎqrbg:8bit TvOg:44KHz ) </summary>

		public static SoftSound MakeSoftSound1Ch8Bit44KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound1Ch8Bit44KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound1Ch8Bit44KHz( int SampleNum ) ;


		/// <summary> \tgEGAň̔g`f[^쐬( `l:1 ʎqrbg:8bit TvOg:22KHz ) </summary>
		public static SoftSound MakeSoftSound1Ch8Bit22KHz( int SampleNum )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSound1Ch8Bit22KHz( SampleNum ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSound.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSound1Ch8Bit22KHz( int SampleNum ) ;


		/// <summary> \tgEGAňg`f[^̃Tv擾 </summary>
		public static int GetSoftSoundSampleNum( SoftSound SoftSoundHandle )
		{
			lock( locker )
			{
				int result = dx_GetSoftSoundSampleNum( SoftSound.ToHandle( SoftSoundHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoftSoundSampleNum( int SoftSoundHandle ) ;


		/// <summary> \tgEGAňg`f[^̃tH[}bg擾 </summary>
		public static void GetSoftSoundFormat( SoftSound SoftSoundHandle , out int Channels , out int BitsPerSample , out int SamplesPerSec )
		{
			lock( locker )
			{
				int result = dx_GetSoftSoundFormat( SoftSound.ToHandle( SoftSoundHandle ) , out Channels , out BitsPerSample , out SamplesPerSec ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoftSoundFormat( int SoftSoundHandle , out int Channels , out int BitsPerSample , out int SamplesPerSec ) ;


		/// <summary> \tgEGAňg`f[^̃Tvǂݎ </summary>
		public static void ReadSoftSoundData( SoftSound SoftSoundHandle , int SamplePosition , out int Channel1 , out int Channel2 )
		{
			lock( locker )
			{
				int result = dx_ReadSoftSoundData( SoftSound.ToHandle( SoftSoundHandle ) , SamplePosition , out Channel1 , out Channel2 ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReadSoftSoundData( int SoftSoundHandle , int SamplePosition , out int Channel1 , out int Channel2 ) ;


		/// <summary> \tgEGAňg`f[^̃Tv </summary>
		public static void WriteSoftSoundData( SoftSound SoftSoundHandle , int SamplePosition , int Channel1 , int Channel2 )
		{
			lock( locker )
			{
				int result = dx_WriteSoftSoundData( SoftSound.ToHandle( SoftSoundHandle ) , SamplePosition , Channel1 , Channel2 ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_WriteSoftSoundData( int SoftSoundHandle , int SamplePosition , int Channel1 , int Channel2 ) ;


		/// <summary> \tgEGAňg`f[^̔g`C[Wi[Ă郁AhX擾 </summary>
		public static IntPtr GetSoftSoundDataImage( SoftSound SoftSoundHandle )
		{
			lock( locker )
			{
				IntPtr result = dx_GetSoftSoundDataImage( SoftSound.ToHandle( SoftSoundHandle ) ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetSoftSoundDataImage( int SoftSoundHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[ׂĉ </summary>
		public static void InitSoftSoundPlayer()
		{
			lock( locker )
			{
				int result = dx_InitSoftSoundPlayer() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InitSoftSoundPlayer() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( tH[}bg͈̃\tgEGATEhnhƓ̂ɂ ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer( SoftSound UseFormat_SoftSoundHandle )
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer( SoftSound.ToHandle( UseFormat_SoftSoundHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer( int UseFormat_SoftSoundHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:2 ʎqrbg:16bit TvOg:44KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer2Ch16Bit44KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer2Ch16Bit44KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer2Ch16Bit44KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:2 ʎqrbg:16bit TvOg:22KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer2Ch16Bit22KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer2Ch16Bit22KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer2Ch16Bit22KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:2 ʎqrbg:8bit TvOg:44KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer2Ch8Bit44KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer2Ch8Bit44KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer2Ch8Bit44KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:2 ʎqrbg:8bit TvOg:22KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer2Ch8Bit22KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer2Ch8Bit22KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer2Ch8Bit22KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:1 ʎqrbg:16bit TvOg:44KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer1Ch16Bit44KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer1Ch16Bit44KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer1Ch16Bit44KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:1 ʎqrbg:16bit TvOg:22KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer1Ch16Bit22KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer1Ch16Bit22KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer1Ch16Bit22KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:1 ʎqrbg:8bit TvOg:44KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer1Ch8Bit44KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer1Ch8Bit44KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer1Ch8Bit44KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[쐬( `l:1 ʎqrbg:8bit TvOg:22KHz ) </summary>
		public static SoftSoundPlayer MakeSoftSoundPlayer1Ch8Bit22KHz()
		{
			lock( locker )
			{
				int result = dx_MakeSoftSoundPlayer1Ch8Bit22KHz() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return SoftSoundPlayer.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftSoundPlayer1Ch8Bit22KHz() ;


		/// <summary> \tgEGAňg`f[^̃vC[ɔg`f[^ǉ( tH[}bgł͂Ȃꍇ̓G[ ) </summary>
		public static void AddDataSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle , SoftSound SoftSoundHandle , int AddSamplePosition , int AddSampleNum )
		{
			lock( locker )
			{
				int result = dx_AddDataSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) , SoftSound.ToHandle( SoftSoundHandle ) , AddSamplePosition , AddSampleNum ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddDataSoftSoundPlayer( int SSoundPlayerHandle , int SoftSoundHandle , int AddSamplePosition , int AddSampleNum ) ;


		/// <summary> \tgEGAňg`f[^̃vC[ɃvC[ΉtH[}bg̐g`f[^ǉ </summary>
		public static void AddDirectDataSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle , IntPtr SoundData , int AddSampleNum )
		{
			lock( locker )
			{
				int result = dx_AddDirectDataSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) , SoundData , AddSampleNum ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddDirectDataSoftSoundPlayer( int SSoundPlayerHandle , IntPtr SoundData , int AddSampleNum ) ;


		/// <summary> \tgEGAňg`f[^̃vC[ɔg`f[^ǉ </summary>
		public static void AddOneDataSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle , int Channel1 , int Channel2 )
		{
			lock( locker )
			{
				int result = dx_AddOneDataSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) , Channel1 , Channel2 ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddOneDataSoftSoundPlayer( int SSoundPlayerHandle , int Channel1 , int Channel2 ) ;


		/// <summary> \tgEGAňg`f[^̃vC[f[^tH[}bg擾 </summary>
		public static void GetSoftSoundPlayerFormat( SoftSoundPlayer SSoundPlayerHandle , out int Channels , out int BitsPerSample , out int SamplesPerSec )
		{
			lock( locker )
			{
				int result = dx_GetSoftSoundPlayerFormat( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) , out Channels , out BitsPerSample , out SamplesPerSec ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoftSoundPlayerFormat( int SSoundPlayerHandle , out int Channels , out int BitsPerSample , out int SamplesPerSec ) ;


		/// <summary> \tgEGAňg`f[^̃vC[̍ĐJn </summary>
		public static void StartSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle )
		{
			lock( locker )
			{
				int result = dx_StartSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StartSoftSoundPlayer( int SSoundPlayerHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[̍ĐJnĂ邩擾( TRUE:JnĂ  FALSE:~Ă ) </summary>
		public static bool CheckStartSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle )
		{
			lock( locker )
			{
				int result = dx_CheckStartSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckStartSoftSoundPlayer( int SSoundPlayerHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[̍Đ~ </summary>
		public static void StopSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle )
		{
			lock( locker )
			{
				int result = dx_StopSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopSoftSoundPlayer( int SSoundPlayerHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[ɒǉg`f[^ł܂ĐpTEhobt@ɓ]ĂȂg`f[^̃Tv擾 </summary>
		public static int GetStockDataLengthSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle )
		{
			lock( locker )
			{
				int result = dx_GetStockDataLengthSoftSoundPlayer( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetStockDataLengthSoftSoundPlayer( int SSoundPlayerHandle ) ;


		/// <summary> \tgEGAňg`f[^̃vC[ɍĐpTEhobt@ɓ]ĂȂg`f[^AĐpTEhobt@ɂf[^ȊOǂ擾( TRUE:f[^ȊO  FALSE:Lf[^ ) </summary>
		public static bool CheckSoftSoundPlayerNoneData( SoftSoundPlayer SSoundPlayerHandle )
		{
			lock( locker )
			{
				int result = dx_CheckSoftSoundPlayerNoneData( SoftSoundPlayer.ToHandle( SSoundPlayerHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckSoftSoundPlayerNoneData( int SSoundPlayerHandle ) ;


		/// <summary> Vlhchnh擾 </summary>
		public static Music AddMusicData()
		{
			lock( locker )
			{
				int result = dx_AddMusicData() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Music.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMusicData() ;


		/// <summary> lhcht@Cǂݍ </summary>
		public static Music LoadMusicMem( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadMusicMem( FileName ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Music.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadMusicMem( string FileName ) ;


		/// <summary> ɓWJꂽlhcht@Cǂݍ </summary>
		public static Music LoadMusicMemByMemImage( IntPtr FileImageBuffer , int FileImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadMusicMemByMemImage( FileImageBuffer , FileImageSize ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Music.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadMusicMemByMemImage( IntPtr FileImageBuffer , int FileImageSize ) ;


		/// <summary> \[X̂lhcht@Cǂݍ </summary>
		public static Music LoadMusicMemByResource( string ResourceName , string ResourceType )
		{
			lock( locker )
			{
				int result = dx_LoadMusicMemByResource( ResourceName , ResourceType ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Music.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadMusicMemByResource( string ResourceName , string ResourceType ) ;


		/// <summary> ǂݍ񂾂lhchf[^̉tJn </summary>
		public static void PlayMusicMem( Music MusicHandle , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlayMusicMem( Music.ToHandle( MusicHandle ) , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMusicMem( int MusicHandle , DX_PLAYTYPE PlayType ) ;


		/// <summary> lhchf[^̉t~ </summary>
		public static void StopMusicMem( Music MusicHandle )
		{
			lock( locker )
			{
				int result = dx_StopMusicMem( Music.ToHandle( MusicHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopMusicMem( int MusicHandle ) ;


		/// <summary> lhchf[^tǂ擾( TRUE:t  FALSE:~ ) </summary>
		public static bool CheckMusicMem( Music MusicHandle )
		{
			lock( locker )
			{
				int result = dx_CheckMusicMem( Music.ToHandle( MusicHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMusicMem( int MusicHandle ) ;


		/// <summary> lhchf[^݂̌̍Đʒu擾 </summary>
		public static int GetMusicMemPosition( Music MusicHandle )
		{
			lock( locker )
			{
				int result = dx_GetMusicMemPosition( Music.ToHandle( MusicHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMusicMemPosition( int MusicHandle ) ;


		/// <summary> lhchf[^̎I </summary>
		public static void ProcessMusicMem()
		{
			lock( locker )
			{
				int result = dx_ProcessMusicMem() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ProcessMusicMem() ;


		/// <summary> lhcht@Ct </summary>
		public static void PlayMusic( string FileName , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlayMusic( FileName , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMusic( string FileName , DX_PLAYTYPE PlayType ) ;


		/// <summary> ɓWJĂlhcht@Ct </summary>
		public static void PlayMusicByMemImage( IntPtr FileImageBuffer , int FileImageSize , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlayMusicByMemImage( FileImageBuffer , FileImageSize , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMusicByMemImage( IntPtr FileImageBuffer , int FileImageSize , DX_PLAYTYPE PlayType ) ;


		/// <summary> \[Xlhcht@Cǂݍŉt </summary>
		public static void PlayMusicByResource( string ResourceName , string ResourceType , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlayMusicByResource( ResourceName , ResourceType , PlayType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMusicByResource( string ResourceName , string ResourceType , DX_PLAYTYPE PlayType ) ;


		/// <summary> lhch̍ĐʂZbg </summary>
		public static void SetVolumeMusic( int Volume )
		{
			lock( locker )
			{
				int result = dx_SetVolumeMusic( Volume ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVolumeMusic( int Volume ) ;


		/// <summary> lhcht@C̉t~ </summary>
		public static void StopMusic()
		{
			lock( locker )
			{
				int result = dx_StopMusic() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_StopMusic() ;


		/// <summary> lhcht@Ctۂ擾 </summary>
		public static bool CheckMusic()
		{
			lock( locker )
			{
				int result = dx_CheckMusic() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckMusic() ;


		/// <summary> lhcȟ݂̍Đʒu擾 </summary>
		public static int GetMusicPosition()
		{
			lock( locker )
			{
				int result = dx_GetMusicPosition() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMusicPosition() ;


		/// <summary> lhch̍Đ`Zbg </summary>
		public static void SelectMidiMode( DX_MIDIMODE Mode )
		{
			lock( locker )
			{
				int result = dx_SelectMidiMode( Mode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SelectMidiMode( DX_MIDIMODE Mode ) ;
	}
}
