using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public static partial class Window
	{


		/// <summary> f̓ǂݍ( -1:G[  0ȏ:fnh ) </summary>
		public static Model MV1LoadModel( string FileName )
		{
			lock( locker )
			{
				int result = dx_MV1LoadModel( FileName ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Model.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1LoadModel( string FileName ) ;


		/// <summary> w̃fƓf{f[^gpăf쐬( -1:G[  0ȏ:fnh ) </summary>
		public static Model MV1DuplicateModel( Model SrcMHandle )
		{
			lock( locker )
			{
				int result = dx_MV1DuplicateModel( Model.ToHandle( SrcMHandle ) ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Model.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DuplicateModel( int SrcMHandle ) ;


		/// <summary> fǂݍލۂɖ@̍ČvZsǂݒ肷( TRUE:s  FALSE:sȂ ) </summary>
		public static void MV1SetLoadModelReMakeNormal( bool Flag )
		{
			lock( locker )
			{
				int result = dx_MV1SetLoadModelReMakeNormal( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetLoadModelReMakeNormal( bool Flag ) ;


		/// <summary> fǂݍލۂɍs@̍ČvZŎgpX[WOpxݒ肷( Pʂ̓WA ) </summary>
		public static void MV1SetLoadModelReMakeNormalSmoothingAngle()
		{
			MV1SetLoadModelReMakeNormalSmoothingAngle( ( float )( Math.PI / 2 ) ) ;
		}

		/// <summary> fǂݍލۂɍs@̍ČvZŎgpX[WOpxݒ肷( Pʂ̓WA ) </summary>
		public static void MV1SetLoadModelReMakeNormalSmoothingAngle( float SmoothingAngle )
		{
			lock( locker )
			{
				int result = dx_MV1SetLoadModelReMakeNormalSmoothingAngle( SmoothingAngle ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetLoadModelReMakeNormalSmoothingAngle( float SmoothingAngle ) ;


		/// <summary> fǂݍލۂɍWf[^̍œKsǂݒ肷( TRUE:s  FALSE:sȂ ) </summary>
		public static void MV1SetLoadModelPositionOptimize( bool Flag )
		{
			lock( locker )
			{
				int result = dx_MV1SetLoadModelPositionOptimize( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetLoadModelPositionOptimize( bool Flag ) ;


		/// <summary> f`悷 </summary>
		public static void MV1DrawModel( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1DrawModel( Model.ToHandle( MHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DrawModel( int MHandle ) ;


		/// <summary> f̎w̃t[`悷 </summary>
		public static void MV1DrawFrame( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1DrawFrame( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DrawFrame( int MHandle , int FrameIndex ) ;


		/// <summary> f̎w̃bV`悷 </summary>
		public static void MV1DrawMesh( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1DrawMesh( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DrawMesh( int MHandle , int MeshIndex ) ;


		/// <summary> f̃fobO` </summary>
		public static void MV1DrawModelDebug( Model MHandle , COLOR_U8 Color , bool IsNormalLine , float NormalLineLength , bool IsPolyLine , bool IsCollisionBox )
		{
			lock( locker )
			{
				int result = dx_MV1DrawModelDebug( Model.ToHandle( MHandle ) , Color , IsNormalLine , NormalLineLength , IsPolyLine , IsCollisionBox ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DrawModelDebug( int MHandle , COLOR_U8 Color , bool IsNormalLine , float NormalLineLength , bool IsPolyLine , bool IsCollisionBox ) ;


		/// <summary> f̃[JW烏[hWɕϊs𓾂 </summary>
		public static MATRIX MV1GetLocalWorldMatrix( Model MHandle )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetLocalWorldMatrix( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetLocalWorldMatrix( int MHandle ) ;


		/// <summary> f̍WZbg </summary>
		public static void MV1SetPosition( Model MHandle , VECTOR Position )
		{
			lock( locker )
			{
				int result = dx_MV1SetPosition( Model.ToHandle( MHandle ) , Position ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetPosition( int MHandle , VECTOR Position ) ;


		/// <summary> f̍W擾 </summary>
		public static VECTOR MV1GetPosition( Model MHandle )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetPosition( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetPosition( int MHandle ) ;


		/// <summary> f̊glZbg </summary>
		public static void MV1SetScale( Model MHandle , VECTOR Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetScale( Model.ToHandle( MHandle ) , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetScale( int MHandle , VECTOR Scale ) ;


		/// <summary> f̊gl擾 </summary>
		public static VECTOR MV1GetScale( Model MHandle )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetScale( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetScale( int MHandle ) ;


		/// <summary> f̉]lZbg( w]x]y] ) </summary>
		public static void MV1SetRotationXYZ( Model MHandle , VECTOR Rotate )
		{
			lock( locker )
			{
				int result = dx_MV1SetRotationXYZ( Model.ToHandle( MHandle ) , Rotate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetRotationXYZ( int MHandle , VECTOR Rotate ) ;


		/// <summary> f̉]l擾( w]x]y] ) </summary>
		public static VECTOR MV1GetRotationXYZ( Model MHandle )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetRotationXYZ( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetRotationXYZ( int MHandle ) ;


		/// <summary> f̂yƂx̌Zbg </summary>
		public static void MV1SetRotationZYAxis( Model MHandle , VECTOR ZAxisDirection , VECTOR YAxisDirection , float ZAxisTwistRotate )
		{
			lock( locker )
			{
				int result = dx_MV1SetRotationZYAxis( Model.ToHandle( MHandle ) , ZAxisDirection , YAxisDirection , ZAxisTwistRotate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetRotationZYAxis( int MHandle , VECTOR ZAxisDirection , VECTOR YAxisDirection , float ZAxisTwistRotate ) ;


		/// <summary> f̉]psZbg </summary>
		public static void MV1SetRotationMatrix( Model MHandle , MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_MV1SetRotationMatrix( Model.ToHandle( MHandle ) , Matrix ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetRotationMatrix( int MHandle , MATRIX Matrix ) ;


		/// <summary> f̉]ps擾 </summary>
		public static MATRIX MV1GetRotationMatrix( Model MHandle )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetRotationMatrix( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetRotationMatrix( int MHandle ) ;


		/// <summary> f̕ό`psZbg </summary>
		public static void MV1SetMatrix( Model MHandle , MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_MV1SetMatrix( Model.ToHandle( MHandle ) , Matrix ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMatrix( int MHandle , MATRIX Matrix ) ;


		/// <summary> f̕ό`ps擾 </summary>
		public static MATRIX MV1GetMatrix( Model MHandle )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetMatrix( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetMatrix( int MHandle ) ;


		/// <summary> f̕\A\ԂύX( TRUE:\  FALSE:\ ) </summary>
		public static void MV1SetVisible( Model MHandle , bool VisibleFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetVisible( Model.ToHandle( MHandle ) , VisibleFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetVisible( int MHandle , bool VisibleFlag ) ;


		/// <summary> f̕\A\Ԃ擾( TRUE:\  FALSE:\ ) </summary>
		public static bool MV1GetVisible( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetVisible( Model.ToHandle( MHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetVisible( int MHandle ) ;


		/// <summary> f̃fBt[YJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetDifColorScale( Model MHandle , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetDifColorScale( Model.ToHandle( MHandle ) , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetDifColorScale( int MHandle , COLOR_F Scale ) ;


		/// <summary> f̃fBt[YJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetDifColorScale( Model MHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetDifColorScale( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetDifColorScale( int MHandle ) ;


		/// <summary> f̃XyLJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetSpcColorScale( Model MHandle , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetSpcColorScale( Model.ToHandle( MHandle ) , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetSpcColorScale( int MHandle , COLOR_F Scale ) ;


		/// <summary> f̃XyLJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetSpcColorScale( Model MHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetSpcColorScale( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetSpcColorScale( int MHandle ) ;


		/// <summary> f̃G~bVuJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetEmiColorScale( Model MHandle , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetEmiColorScale( Model.ToHandle( MHandle ) , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetEmiColorScale( int MHandle , COLOR_F Scale ) ;


		/// <summary> f̃G~bVuJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetEmiColorScale( Model MHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetEmiColorScale( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetEmiColorScale( int MHandle ) ;


		/// <summary> f̃ArGgJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetAmbColorScale( Model MHandle , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetAmbColorScale( Model.ToHandle( MHandle ) , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetAmbColorScale( int MHandle , COLOR_F Scale ) ;


		/// <summary> f̃ArGgJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetAmbColorScale( Model MHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetAmbColorScale( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetAmbColorScale( int MHandle ) ;


		/// <summary> fɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ ) </summary>
		public static bool MV1GetSemiTransState( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetSemiTransState( Model.ToHandle( MHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetSemiTransState( int MHandle ) ;


		/// <summary> f̕sxݒ肷( s 1.0f `  0.0f ) </summary>
		public static void MV1SetOpacityRate( Model MHandle , float Rate )
		{
			lock( locker )
			{
				int result = dx_MV1SetOpacityRate( Model.ToHandle( MHandle ) , Rate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetOpacityRate( int MHandle , float Rate ) ;


		/// <summary> f̕sx擾( s 1.0f `  0.0f ) </summary>
		public static float MV1GetOpacityRate( Model MHandle )
		{
			lock( locker )
			{
				float result = dx_MV1GetOpacityRate( Model.ToHandle( MHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetOpacityRate( int MHandle ) ;


		/// <summary> f`悷ۂɂyobt@gp邩ǂݒ肷 </summary>
		public static void MV1SetUseZBuffer( Model MHandle , bool Flag )
		{
			lock( locker )
			{
				int result = dx_MV1SetUseZBuffer( Model.ToHandle( MHandle ) , Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetUseZBuffer( int MHandle , bool Flag ) ;


		/// <summary> f`悷ۂɂyobt@ɏ݂sǂݒ肷 </summary>
		public static void MV1SetWriteZBuffer( Model MHandle , bool Flag )
		{
			lock( locker )
			{
				int result = dx_MV1SetWriteZBuffer( Model.ToHandle( MHandle ) , Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetWriteZBuffer( int MHandle , bool Flag ) ;


		/// <summary> f̕`掞̂yl̔r[hݒ肷 </summary>
		/// <param name="CmpType">  DX_CMP_NEVER  </param>
		public static void MV1SetZBufferCmpType( Model MHandle , DX_CMP CmpType )
		{
			lock( locker )
			{
				int result = dx_MV1SetZBufferCmpType( Model.ToHandle( MHandle ) , CmpType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetZBufferCmpType( int MHandle , DX_CMP CmpType ) ;


		/// <summary> f̕`掞̏ނyl̃oCAXݒ肷 </summary>
		public static void MV1SetZBias( Model MHandle , int Bias )
		{
			lock( locker )
			{
				int result = dx_MV1SetZBias( Model.ToHandle( MHandle ) , Bias ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetZBias( int MHandle , int Bias ) ;


		/// <summary> f̊܂܂郁bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static void MV1SetUseVertDifColor( Model MHandle , bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetUseVertDifColor( Model.ToHandle( MHandle ) , UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetUseVertDifColor( int MHandle , bool UseFlag ) ;


		/// <summary> fɊ܂܂郁bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static void MV1SetUseVertSpcColor( Model MHandle , bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetUseVertSpcColor( Model.ToHandle( MHandle ) , UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetUseVertSpcColor( int MHandle , bool UseFlag ) ;


		/// <summary> f̃eNX`̃TvtB^[[hύX( FilterMode  DX_DRAWMODE_NEAREST  ) </summary>
		public static void MV1SetSampleFilterMode( Model MHandle , DX_DRAWMODE FilterMode )
		{
			lock( locker )
			{
				int result = dx_MV1SetSampleFilterMode( Model.ToHandle( MHandle ) , FilterMode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetSampleFilterMode( int MHandle , DX_DRAWMODE FilterMode ) ;


		/// <summary> fٕ̈tB^O̍ő原ݒ肷 </summary>
		public static void MV1SetMaxAnisotropy( Model MHandle , int MaxAnisotropy )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaxAnisotropy( Model.ToHandle( MHandle ) , MaxAnisotropy ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaxAnisotropy( int MHandle , int MaxAnisotropy ) ;


		/// <summary> Aj[VA^b`( ߂l  -1:G[  0ȏ:A^b`CfbNX ) </summary>
		public static int MV1AttachAnim( Model MHandle , int AnimIndex )
		{
			return MV1AttachAnim( MHandle , AnimIndex , null , true ) ;
		}

		/// <summary> Aj[VA^b`( ߂l  -1:G[  0ȏ:A^b`CfbNX ) </summary>
		public static int MV1AttachAnim( Model MHandle , int AnimIndex , Model AnimSrcMHandle )
		{
			return MV1AttachAnim( MHandle , AnimIndex , AnimSrcMHandle , true ) ;
		}

		/// <summary> Aj[VA^b`( ߂l  -1:G[  0ȏ:A^b`CfbNX ) </summary>
		public static int MV1AttachAnim( Model MHandle , int AnimIndex , Model AnimSrcMHandle , bool NameCheck )
		{
			lock( locker )
			{
				int result = dx_MV1AttachAnim( Model.ToHandle( MHandle ) , AnimIndex , Model.ToHandle( AnimSrcMHandle ) , NameCheck ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1AttachAnim( int MHandle , int AnimIndex , int AnimSrcMHandle , bool NameCheck ) ;


		/// <summary> Aj[Vf^b` </summary>
		public static void MV1DetachAnim( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				int result = dx_MV1DetachAnim( Model.ToHandle( MHandle ) , AttachIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1DetachAnim( int MHandle , int AttachIndex ) ;


		/// <summary> A^b`ĂAj[V̍ĐԂݒ肷 </summary>
		public static void MV1SetAttachAnimTime( Model MHandle , int AttachIndex , float Time )
		{
			lock( locker )
			{
				int result = dx_MV1SetAttachAnimTime( Model.ToHandle( MHandle ) , AttachIndex , Time ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetAttachAnimTime( int MHandle , int AttachIndex , float Time ) ;


		/// <summary> A^b`ĂAj[V̍ĐԂ擾 </summary>
		public static float MV1GetAttachAnimTime( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetAttachAnimTime( Model.ToHandle( MHandle ) , AttachIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAttachAnimTime( int MHandle , int AttachIndex ) ;


		/// <summary> A^b`ĂAj[V̑Ԃ𓾂 </summary>
		public static float MV1GetAttachAnimTotalTime( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetAttachAnimTotalTime( Model.ToHandle( MHandle ) , AttachIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAttachAnimTotalTime( int MHandle , int AttachIndex ) ;


		/// <summary> A^b`ĂAj[Ṽuhݒ肷 </summary>
		public static void MV1SetAttachAnimBlendRate( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				MV1SetAttachAnimBlendRate( MHandle , AttachIndex , 1.0f ) ;
			}
		}

		/// <summary> A^b`ĂAj[Ṽuhݒ肷 </summary>
		public static void MV1SetAttachAnimBlendRate( Model MHandle , int AttachIndex , float Rate )
		{
			lock( locker )
			{
				int result = dx_MV1SetAttachAnimBlendRate( Model.ToHandle( MHandle ) , AttachIndex , Rate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetAttachAnimBlendRate( int MHandle , int AttachIndex , float Rate ) ;


		/// <summary> A^b`ĂAj[Ṽuh擾 </summary>
		public static float MV1GetAttachAnimBlendRate( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetAttachAnimBlendRate( Model.ToHandle( MHandle ) , AttachIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAttachAnimBlendRate( int MHandle , int AttachIndex ) ;


		/// <summary> A^b`ĂAj[Ṽuhݒ肷( t[P ) </summary>
		public static void MV1SetAttachAnimBlendRateToFrame( Model MHandle , int AttachIndex , int FrameIndex , float Rate , bool SetChild )
		{
			lock( locker )
			{
				int result = dx_MV1SetAttachAnimBlendRateToFrame( Model.ToHandle( MHandle ) , AttachIndex , FrameIndex , Rate , SetChild ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> A^b`ĂAj[Ṽuhݒ肷( t[P ) </summary>
		public static void MV1SetAttachAnimBlendRateToFrame( Model MHandle , int AttachIndex , int FrameIndex , float Rate )
		{
			MV1SetAttachAnimBlendRateToFrame( MHandle , AttachIndex , FrameIndex , Rate , true ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetAttachAnimBlendRateToFrame( int MHandle , int AttachIndex , int FrameIndex , float Rate , bool SetChild ) ;


		/// <summary> A^b`ĂAj[Ṽuhݒ肷( t[P ) </summary>
		public static float MV1GetAttachAnimBlendRateToFrame( Model MHandle , int AttachIndex , int FrameIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetAttachAnimBlendRateToFrame( Model.ToHandle( MHandle ) , AttachIndex , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAttachAnimBlendRateToFrame( int MHandle , int AttachIndex , int FrameIndex ) ;


		/// <summary> A^b`ĂAj[ṼAj[VCfbNX擾 </summary>
		public static int MV1GetAttachAnim( Model MHandle , int AttachIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetAttachAnim( Model.ToHandle( MHandle ) , AttachIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAttachAnim( int MHandle , int AttachIndex ) ;


		/// <summary> Aj[V̐擾 </summary>
		public static int MV1GetAnimNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimNum( int MHandle ) ;


		/// <summary> wԍ̃Aj[V擾( NULL:G[ ) </summary>
		public static string MV1GetAnimName( Model MHandle , int AnimIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetAnimName( Model.ToHandle( MHandle ) , AnimIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetAnimName( int MHandle , int AnimIndex ) ;


		/// <summary> w薼̃Aj[Vԍ擾( -1:G[ ) </summary>
		public static int MV1GetAnimIndex( Model MHandle , string AnimName )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimIndex( Model.ToHandle( MHandle ) , AnimName ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimIndex( int MHandle , string AnimName ) ;


		/// <summary> wԍ̃Aj[V̑Ԃ𓾂 </summary>
		public static float MV1GetAnimTotalTime( Model MHandle , int AnimIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetAnimTotalTime( Model.ToHandle( MHandle ) , AnimIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAnimTotalTime( int MHandle , int AnimIndex ) ;


		/// <summary> w̃Aj[V^[QbgƂt[̐擾 </summary>
		public static int MV1GetAnimTargetFrameNum( Model MHandle , int AnimIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimTargetFrameNum( Model.ToHandle( MHandle ) , AnimIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimTargetFrameNum( int MHandle , int AnimIndex ) ;


		/// <summary> w̃Aj[V^[QbgƂt[̖O擾 </summary>
		public static string MV1GetAnimTargetFrameName( Model MHandle , int AnimIndex , int AnimFrameIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetAnimTargetFrameName( Model.ToHandle( MHandle ) , AnimIndex , AnimFrameIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetAnimTargetFrameName( int MHandle , int AnimIndex , int AnimFrameIndex ) ;


		/// <summary> w̃Aj[V^[QbgƂt[̔ԍ擾 </summary>
		public static int MV1GetAnimTargetFrame( Model MHandle , int AnimIndex , int AnimFrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimTargetFrame( Model.ToHandle( MHandle ) , AnimIndex , AnimFrameIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimTargetFrame( int MHandle , int AnimIndex , int AnimFrameIndex ) ;


		/// <summary> w̃Aj[V^[QbgƂt[p̃Aj[VL[Zbg̐擾 </summary>
		public static int MV1GetAnimTargetFrameKeySetNum( Model MHandle , int AnimIndex , int AnimFrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimTargetFrameKeySetNum( Model.ToHandle( MHandle ) , AnimIndex , AnimFrameIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimTargetFrameKeySetNum( int MHandle , int AnimIndex , int AnimFrameIndex ) ;


		/// <summary> w̃Aj[V^[QbgƂt[p̃Aj[VL[ZbgL[ZbgCfbNX擾 </summary>
		public static int MV1GetAnimTargetFrameKeySet( Model MHandle , int AnimIndex , int AnimFrameIndex , int Index )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimTargetFrameKeySet( Model.ToHandle( MHandle ) , AnimIndex , AnimFrameIndex , Index ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimTargetFrameKeySet( int MHandle , int AnimIndex , int AnimFrameIndex , int Index ) ;


		/// <summary> fɊ܂܂Aj[VL[Zbg̑𓾂 </summary>
		public static int MV1GetAnimKeySetNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimKeySetNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimKeySetNum( int MHandle ) ;


		/// <summary> w̃Aj[VL[Zbg̃^Cv擾( MV1_ANIMKEY_TYPE_QUATERNION  ) </summary>
		public static MV1_ANIMKEY_TYPE MV1GetAnimKeySetType( Model MHandle , int AnimKeySetIndex )
		{
			lock( locker )
			{
				MV1_ANIMKEY_TYPE result = dx_MV1GetAnimKeySetType( Model.ToHandle( MHandle ) , AnimKeySetIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_ANIMKEY_TYPE dx_MV1GetAnimKeySetType( int MHandle , int AnimKeySetIndex ) ;


		/// <summary> w̃Aj[VL[Zbg̃f[^^Cv擾( MV1_ANIMKEY_DATATYPE_ROTATE  ) </summary>
		public static MV1_ANIMKEY_DATATYPE MV1GetAnimKeySetDataType( int MHandle , int AnimKeySetIndex )
		{
			lock( locker )
			{
				MV1_ANIMKEY_DATATYPE result = dx_MV1GetAnimKeySetDataType( MHandle , AnimKeySetIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_ANIMKEY_DATATYPE dx_MV1GetAnimKeySetDataType( int MHandle , int AnimKeySetIndex ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[̎ԃf[^^Cv擾( MV1_ANIMKEY_TIME_TYPE_ONE  ) </summary>
		public static MV1_ANIMKEY_TIME_TYPE MV1GetAnimKeySetTimeType( Model MHandle , int AnimKeySetIndex )
		{
			lock( locker )
			{
				MV1_ANIMKEY_TIME_TYPE result = dx_MV1GetAnimKeySetTimeType( Model.ToHandle( MHandle ) , AnimKeySetIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_ANIMKEY_TIME_TYPE dx_MV1GetAnimKeySetTimeType( int MHandle , int AnimKeySetIndex ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[̐擾 </summary>
		public static int MV1GetAnimKeySetDataNum( Model MHandle , int AnimKeySetIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetAnimKeySetDataNum( Model.ToHandle( MHandle ) , AnimKeySetIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetAnimKeySetDataNum( int MHandle , int AnimKeySetIndex ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[̎Ԃ擾 </summary>
		public static float MV1GetAnimKeyDataTime( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				float result = dx_MV1GetAnimKeyDataTime( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAnimKeyDataTime( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_QUATERNION ł͖ꍇ͎s </summary>
		public static FLOAT4 MV1GetAnimKeyDataToQuaternion( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				FLOAT4 result = dx_MV1GetAnimKeyDataToQuaternion( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern FLOAT4 dx_MV1GetAnimKeyDataToQuaternion( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_VECTOR ł͖ꍇ͎s </summary>
		public static VECTOR MV1GetAnimKeyDataToVector( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetAnimKeyDataToVector( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetAnimKeyDataToVector( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_MATRIX4X4C  MV1_ANIMKEY_TYPE_MATRIX3X3 ł͖ꍇ͎s </summary>
		public static MATRIX MV1GetAnimKeyDataToMatrix( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetAnimKeyDataToMatrix( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetAnimKeyDataToMatrix( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_FLAT ł͖ꍇ͎s </summary>
		public static float MV1GetAnimKeyDataToFlat( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				float result = dx_MV1GetAnimKeyDataToFlat( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAnimKeyDataToFlat( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> w̃Aj[VL[Zbg̃L[擾AL[^Cv MV1_ANIMKEY_TYPE_LINEAR ł͖ꍇ͎s </summary>
		public static float MV1GetAnimKeyDataToLinear( Model MHandle , int AnimKeySetIndex , int Index )
		{
			lock( locker )
			{
				float result = dx_MV1GetAnimKeyDataToLinear( Model.ToHandle( MHandle ) , AnimKeySetIndex , Index ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetAnimKeyDataToLinear( int MHandle , int AnimKeySetIndex , int Index ) ;


		/// <summary> fŎgpĂ}eA̐擾 </summary>
		public static int MV1GetMaterialNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialNum( int MHandle ) ;


		/// <summary> w̃}eA̖O擾 </summary>
		public static string MV1GetMaterialName( int MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetMaterialName( MHandle , MaterialIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetMaterialName( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃ^CvύX( Type : DX_MATERIAL_TYPE_NORMAL Ȃ ) </summary>
		public static void MV1SetMaterialType( Model MHandle , int MaterialIndex , DX_MATERIAL_TYPE Type )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialType( Model.ToHandle( MHandle ) , MaterialIndex , Type ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialType( int MHandle , int MaterialIndex , DX_MATERIAL_TYPE Type ) ;


		/// <summary> w̃}eÃ^Cv擾( ߂l : DX_MATERIAL_TYPE_NORMAL Ȃ ) </summary>
		public static DX_MATERIAL_TYPE MV1GetMaterialType( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				DX_MATERIAL_TYPE result = dx_MV1GetMaterialType( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_MATERIAL_TYPE dx_MV1GetMaterialType( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃfBt[YJ[ݒ肷 </summary>
		public static void MV1SetMaterialDifColor( Model MHandle , int MaterialIndex , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDifColor( Model.ToHandle( MHandle ) , MaterialIndex , Color ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDifColor( int MHandle , int MaterialIndex , COLOR_F Color ) ;


		/// <summary> w̃}eÃfBt[YJ[擾 </summary>
		public static COLOR_F MV1GetMaterialDifColor( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMaterialDifColor( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMaterialDifColor( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃXyLJ[ݒ肷 </summary>
		public static void MV1SetMaterialSpcColor( Model MHandle , int MaterialIndex , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialSpcColor( Model.ToHandle( MHandle ) , MaterialIndex , Color ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialSpcColor( int MHandle , int MaterialIndex , COLOR_F Color ) ;


		/// <summary> w̃}eÃXyLJ[擾 </summary>
		public static COLOR_F MV1GetMaterialSpcColor( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMaterialSpcColor( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMaterialSpcColor( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃG~bVuJ[ݒ肷 </summary>
		public static void MV1SetMaterialEmiColor( Model MHandle , int MaterialIndex , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialEmiColor( Model.ToHandle( MHandle ) , MaterialIndex , Color ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialEmiColor( int MHandle , int MaterialIndex , COLOR_F Color ) ;


		/// <summary> w̃}eÃG~bVuJ[擾 </summary>
		public static COLOR_F MV1GetMaterialEmiColor( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMaterialEmiColor( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMaterialEmiColor( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃArGgJ[ݒ肷 </summary>
		public static void MV1SetMaterialAmbColor( Model MHandle , int MaterialIndex , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialAmbColor( Model.ToHandle( MHandle ) , MaterialIndex , Color ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialAmbColor( int MHandle , int MaterialIndex , COLOR_F Color ) ;


		/// <summary> w̃}eÃArGgJ[擾 </summary>
		public static COLOR_F MV1GetMaterialAmbColor( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMaterialAmbColor( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMaterialAmbColor( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃXyL̋ݒ肷 </summary>
		public static void MV1SetMaterialSpcPower( Model MHandle , int MaterialIndex , float Power )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialSpcPower( Model.ToHandle( MHandle ) , MaterialIndex , Power ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialSpcPower( int MHandle , int MaterialIndex , float Power ) ;


		/// <summary> w̃}eÃXyL̋擾 </summary>
		public static float MV1GetMaterialSpcPower( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetMaterialSpcPower( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetMaterialSpcPower( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eAŃfBt[Y}bvƂĎgpeNX`w肷 </summary>
		public static void MV1SetMaterialDifMapTexture( Model MHandle , int MaterialIndex , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDifMapTexture( Model.ToHandle( MHandle ) , MaterialIndex , TexIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDifMapTexture( int MHandle , int MaterialIndex , int TexIndex ) ;


		/// <summary> w̃}eAŃfBt[Y}bvƂĎgpĂeNX`̃CfbNX擾 </summary>
		public static int MV1GetMaterialDifMapTexture( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialDifMapTexture( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialDifMapTexture( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eAŃXyL}bvƂĎgpeNX`w肷 </summary>
		public static void MV1SetMaterialSpcMapTexture( Model MHandle , int MaterialIndex , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialSpcMapTexture( Model.ToHandle( MHandle ) , MaterialIndex , TexIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialSpcMapTexture( int MHandle , int MaterialIndex , int TexIndex ) ;


		/// <summary> w̃}eAŃXyL}bvƂĎgpĂeNX`̃CfbNX擾 </summary>
		public static int MV1GetMaterialSpcMapTexture( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialSpcMapTexture( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialSpcMapTexture( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eAŖ@}bvƂĎgpĂeNX`̃CfbNX擾 </summary>
		public static int MV1GetMaterialNormalMapTexture( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialNormalMapTexture( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialNormalMapTexture( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eAŃgD[_ÕfBt[YOf[V}bvƂĎgpeNX`ݒ肷 </summary>
		public static void MV1SetMaterialDifGradTexture( Model MHandle , int MaterialIndex , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDifGradTexture( Model.ToHandle( MHandle ) , MaterialIndex , TexIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDifGradTexture( int MHandle , int MaterialIndex , int TexIndex ) ;


		/// <summary> w̃}eAŃgD[_ÕfBt[YOf[V}bvƂĎgpeNX`擾 </summary>
		public static int MV1GetMaterialDifGradTexture( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialDifGradTexture( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialDifGradTexture( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eAŃgD[_ÕXyLOf[V}bvƂĎgpeNX`ݒ肷 </summary>
		public static void MV1SetMaterialSpcGradTexture( Model MHandle , int MaterialIndex , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialSpcGradTexture( Model.ToHandle( MHandle ) , MaterialIndex , TexIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialSpcGradTexture( int MHandle , int MaterialIndex , int TexIndex ) ;


		/// <summary> w̃}eAŃgD[_ÕXyLOf[V}bvƂĎgpeNX`擾 </summary>
		public static int MV1GetMaterialSpcGradTexture( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialSpcGradTexture( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialSpcGradTexture( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃgD[_OŎgpfBt[YOf[V}bvƃfBt[YJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ ) </summary>
		public static void MV1SetMaterialDifGradBlendType( Model MHandle , int MaterialIndex , DX_MATERIAL_BLENDTYPE BlendType )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDifGradBlendType( Model.ToHandle( MHandle ) , MaterialIndex , BlendType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDifGradBlendType( int MHandle , int MaterialIndex , DX_MATERIAL_BLENDTYPE BlendType ) ;


		/// <summary> w̃}eÃgD[_OŎgpfBt[YOf[V}bvƃfBt[YJ[̍@擾( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ ) </summary>
		public static DX_MATERIAL_BLENDTYPE MV1GetMaterialDifGradBlendType( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				DX_MATERIAL_BLENDTYPE result = dx_MV1GetMaterialDifGradBlendType( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_MATERIAL_BLENDTYPE dx_MV1GetMaterialDifGradBlendType( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃgD[_OŎgpXyLOf[V}bvƃXyLJ[̍@ݒ肷( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ ) </summary>
		public static void MV1SetMaterialSpcGradBlendType( Model MHandle , int MaterialIndex , DX_MATERIAL_BLENDTYPE BlendType )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialSpcGradBlendType( Model.ToHandle( MHandle ) , MaterialIndex , BlendType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialSpcGradBlendType( int MHandle , int MaterialIndex , DX_MATERIAL_BLENDTYPE BlendType ) ;


		/// <summary> w̃}eÃgD[_OŎgpXyLOf[V}bvƃXyLJ[̍@擾( DX_MATERIAL_BLENDTYPE_ADDITIVE Ȃ ) </summary>
		public static DX_MATERIAL_BLENDTYPE MV1GetMaterialSpcGradBlendType( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				DX_MATERIAL_BLENDTYPE result = dx_MV1GetMaterialSpcGradBlendType( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_MATERIAL_BLENDTYPE dx_MV1GetMaterialSpcGradBlendType( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃgD[_OŎgp֊s̑ݒ肷( 0.0f ` 1.0f ) </summary>
		public static void MV1SetMaterialOutLineWidth( Model MHandle , int MaterialIndex , float Width )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialOutLineWidth( Model.ToHandle( MHandle ) , MaterialIndex , Width ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialOutLineWidth( int MHandle , int MaterialIndex , float Width ) ;


		/// <summary> w̃}eÃgD[_OŎgp֊s̑擾( 0.0f ` 1.0f ) </summary>
		public static float MV1GetMaterialOutLineWidth( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetMaterialOutLineWidth( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetMaterialOutLineWidth( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eÃgD[_OŎgp֊s̐Fݒ肷 </summary>
		public static void MV1SetMaterialOutLineColor( Model MHandle , int MaterialIndex , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialOutLineColor( Model.ToHandle( MHandle ) , MaterialIndex , Color ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialOutLineColor( int MHandle , int MaterialIndex , COLOR_F Color ) ;


		/// <summary> w̃}eÃgD[_OŎgp֊s̐F擾 </summary>
		public static COLOR_F MV1GetMaterialOutLineColor( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMaterialOutLineColor( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMaterialOutLineColor( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eA̕`uh[hݒ肷( DX_BLENDMODE_ALPHA  ) </summary>
		public static void MV1SetMaterialDrawBlendMode( Model MHandle , int MaterialIndex , DX_BLENDMODE BlendMode )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDrawBlendMode( Model.ToHandle( MHandle ) , MaterialIndex , BlendMode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDrawBlendMode( int MHandle , int MaterialIndex , DX_BLENDMODE BlendMode ) ;


		/// <summary> w̃}eA̕`uh[h擾( DX_BLENDMODE_ALPHA  ) </summary>
		public static DX_BLENDMODE MV1GetMaterialDrawBlendMode( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				DX_BLENDMODE result = dx_MV1GetMaterialDrawBlendMode( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_BLENDMODE dx_MV1GetMaterialDrawBlendMode( int MHandle , int MaterialIndex ) ;


		/// <summary> w̃}eA̕`uhp[^ݒ肷 </summary>
		public static void MV1SetMaterialDrawBlendParam( Model MHandle , int MaterialIndex , int BlendParam )
		{
			lock( locker )
			{
				int result = dx_MV1SetMaterialDrawBlendParam( Model.ToHandle( MHandle ) , MaterialIndex , BlendParam ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMaterialDrawBlendParam( int MHandle , int MaterialIndex , int BlendParam ) ;


		/// <summary> w̃}eA̕`uhp[^ݒ肷 </summary>
		public static int MV1GetMaterialDrawBlendParam( Model MHandle , int MaterialIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMaterialDrawBlendParam( Model.ToHandle( MHandle ) , MaterialIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMaterialDrawBlendParam( int MHandle , int MaterialIndex ) ;


		/// <summary> eNX`̐擾 </summary>
		public static int MV1GetTextureNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureNum( int MHandle ) ;


		/// <summary> eNX`̖O擾 </summary>
		public static string MV1GetTextureName( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetTextureName( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetTextureName( int MHandle , int TexIndex ) ;


		/// <summary> J[eNX`̃t@CpXύX </summary>
		public static void MV1SetTextureColorFilePath( Model MHandle , int TexIndex , string FilePath )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureColorFilePath( Model.ToHandle( MHandle ) , TexIndex , FilePath ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureColorFilePath( int MHandle , int TexIndex , string FilePath ) ;


		/// <summary> J[eNX`̃t@CpX擾 </summary>
		public static string MV1GetTextureColorFilePath( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetTextureColorFilePath( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetTextureColorFilePath( int MHandle , int TexIndex ) ;


		/// <summary> At@eNX`̃t@CpXύX </summary>
		public static void MV1SetTextureAlphaFilePath( Model MHandle , int TexIndex , string FilePath )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureAlphaFilePath( Model.ToHandle( MHandle ) , TexIndex , FilePath ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureAlphaFilePath( int MHandle , int TexIndex , string FilePath ) ;


		/// <summary> At@eNX`̃t@CpX擾 </summary>
		public static string MV1GetTextureAlphaFilePath( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetTextureAlphaFilePath( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetTextureAlphaFilePath( int MHandle , int TexIndex ) ;


		/// <summary> eNX`ŎgpOtBbNnhύX( GrHandle  -1 ɂƉ ) </summary>
		public static void MV1SetTextureGraphHandle( Model MHandle , int TexIndex , Graph GrHandle , bool SemiTransFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureGraphHandle( Model.ToHandle( MHandle ) , TexIndex , Graph.ToHandle( GrHandle ) , SemiTransFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureGraphHandle( int MHandle , int TexIndex , int GrHandle , bool SemiTransFlag ) ;


		/// <summary> eNX`̃OtBbNnh擾 </summary>
		public static Graph MV1GetTextureGraphHandle( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureGraphHandle( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureGraphHandle( int MHandle , int TexIndex ) ;


		/// <summary> eNX`̃AhX[hݒ肷( AddUMode ̒l DX_TEXADDRESS_WRAP  ) </summary>
		public static void MV1SetTextureAddressMode( Model MHandle , int TexIndex , DX_TEXADDRESS AddrUMode , DX_TEXADDRESS AddrVMode )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureAddressMode( Model.ToHandle( MHandle ) , TexIndex , AddrUMode , AddrVMode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureAddressMode( int MHandle , int TexIndex , DX_TEXADDRESS AddrUMode , DX_TEXADDRESS AddrVMode ) ;


		/// <summary> eNX`̂tl̃AhX[h擾( ߂l:DX_TEXADDRESS_WRAP  ) </summary>
		public static DX_TEXADDRESS MV1GetTextureAddressModeU( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				DX_TEXADDRESS result = dx_MV1GetTextureAddressModeU( Model.ToHandle( MHandle ) , TexIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_TEXADDRESS dx_MV1GetTextureAddressModeU( int MHandle , int TexIndex ) ;


		/// <summary> eNX`̂ul̃AhX[h擾( ߂l:DX_TEXADDRESS_WRAP  ) </summary>
		public static DX_TEXADDRESS MV1GetTextureAddressModeV( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				DX_TEXADDRESS result = dx_MV1GetTextureAddressModeV( Model.ToHandle( MHandle ) , TexIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_TEXADDRESS dx_MV1GetTextureAddressModeV( int MHandle , int TexIndex ) ;


		/// <summary> eNX`̕擾 </summary>
		public static int MV1GetTextureWidth( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureWidth( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureWidth( int MHandle , int TexIndex ) ;


		/// <summary> eNX`̍擾 </summary>
		public static int MV1GetTextureHeight( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureHeight( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureHeight( int MHandle , int TexIndex ) ;


		/// <summary> eNX`ɔvf邩ǂ擾( ߂l  TRUE:  FALSE:Ȃ ) </summary>
		public static bool MV1GetTextureSemiTransState( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureSemiTransState( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureSemiTransState( int MHandle , int TexIndex ) ;


		/// <summary> eNX`ŎgpĂ摜ov}bvǂݒ肷 </summary>
		public static void MV1SetTextureBumpImageFlag( Model MHandle , int TexIndex , bool Flag )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureBumpImageFlag( Model.ToHandle( MHandle ) , TexIndex , Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureBumpImageFlag( int MHandle , int TexIndex , bool Flag ) ;


		/// <summary> eNX`ov}bvǂ擾( ߂l  TRUE:ov}bv  FALSE:Ⴄ ) </summary>
		public static bool MV1GetTextureBumpImageFlag( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTextureBumpImageFlag( Model.ToHandle( MHandle ) , TexIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTextureBumpImageFlag( int MHandle , int TexIndex ) ;


		/// <summary> ov}bv摜̏ꍇׂ̗̃sNZƂ̋ݒ肷 </summary>
		public static void MV1SetTextureBumpImageNextPixelLength( Model MHandle , int TexIndex , float Length )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureBumpImageNextPixelLength( Model.ToHandle( MHandle ) , TexIndex , Length ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureBumpImageNextPixelLength( int MHandle , int TexIndex , float Length ) ;


		/// <summary> ov}bv摜̏ꍇׂ̗̃sNZƂ̋擾 </summary>
		public static float MV1GetTextureBumpImageNextPixelLength( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetTextureBumpImageNextPixelLength( Model.ToHandle( MHandle ) , TexIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetTextureBumpImageNextPixelLength( int MHandle , int TexIndex ) ;


		/// <summary> eNX`̃tB^O[hݒ肷 </summary>
		public static void MV1SetTextureSampleFilterMode( Model MHandle , int TexIndex , DX_DRAWMODE FilterMode )
		{
			lock( locker )
			{
				int result = dx_MV1SetTextureSampleFilterMode( Model.ToHandle( MHandle ) , TexIndex , FilterMode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetTextureSampleFilterMode( int MHandle , int TexIndex , DX_DRAWMODE FilterMode ) ;


		/// <summary> eNX`̃tB^O[h擾( ߂l  DX_DRAWMODE_BILINEAR ) </summary>
		public static DX_DRAWMODE MV1GetTextureSampleFilterMode( Model MHandle , int TexIndex )
		{
			lock( locker )
			{
				DX_DRAWMODE result = dx_MV1GetTextureSampleFilterMode( Model.ToHandle( MHandle ) , TexIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_DRAWMODE dx_MV1GetTextureSampleFilterMode( int MHandle , int TexIndex ) ;


		/// <summary> t[̐擾 </summary>
		public static int MV1GetFrameNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameNum( int MHandle ) ;


		/// <summary> t[̖O烂f̃t[̃t[CfbNX擾( ꍇ͖߂l-1 ) </summary>
		public static int MV1SearchFrame( Model MHandle , string FrameName )
		{
			lock( locker )
			{
				int result = dx_MV1SearchFrame( Model.ToHandle( MHandle ) , FrameName ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SearchFrame( int MHandle , string FrameName ) ;


		/// <summary> t[̖Ow̃t[̎qt[̃t[CfbNX擾( Ow )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( ꍇ͖߂l-1 ) </summary>
		public static int MV1SearchFrameChild( Model MHandle )
		{
			return MV1SearchFrameChild( MHandle , -1 ) ;
		}

		/// <summary> t[̖Ow̃t[̎qt[̃t[CfbNX擾( Ow )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( ꍇ͖߂l-1 ) </summary>
		public static int MV1SearchFrameChild( Model MHandle , int FrameIndex )
		{
			return MV1SearchFrameChild( MHandle , FrameIndex , null ) ;
		}

		/// <summary> t[̖Ow̃t[̎qt[̃t[CfbNX擾( Ow )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( ꍇ͖߂l-1 ) </summary>
		public static int MV1SearchFrameChild( Model MHandle , int FrameIndex , string ChildName )
		{
			lock( locker )
			{
				int result = dx_MV1SearchFrameChild( Model.ToHandle( MHandle ) , FrameIndex , ChildName ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SearchFrameChild( int MHandle , int FrameIndex , string ChildName ) ;


		/// <summary> w̃t[̖O擾( G[̏ꍇ͖߂l NULL ) </summary>
		public static string MV1GetFrameName( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_MV1GetFrameName( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DxLibException(); }
			#if UNICODE
				return Marshal.PtrToStringUni( result ) ;
			#else
				return Marshal.PtrToStringAnsi( result ) ;
			#endif
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_MV1GetFrameName( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̐et[̃CfbNX𓾂( eȂꍇ -2 Ԃ ) </summary>
		public static int MV1GetFrameParent( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameParent( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameParent( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̎qt[̐擾( FrameIndex  -1 ɂƐeȂt[̐ԂĂ ) </summary>
		public static int MV1GetFrameChildNum( Model MHandle )
		{
			return MV1GetFrameChildNum( MHandle , -1 ) ;
		}

		/// <summary> w̃t[̎qt[̐擾( FrameIndex  -1 ɂƐeȂt[̐ԂĂ ) </summary>
		public static int MV1GetFrameChildNum( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameChildNum( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameChildNum( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̎qt[̃t[CfbNX擾( ԍw )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( G[̏ꍇ͖߂l-1 ) </summary>
		public static int MV1GetFrameChild( Model MHandle )
		{
			return MV1GetFrameChild( MHandle , -1 ) ;
		}

		/// <summary> w̃t[̎qt[̃t[CfbNX擾( ԍw )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( G[̏ꍇ͖߂l-1 ) </summary>
		public static int MV1GetFrameChild( Model MHandle , int FrameIndex )
		{
			return MV1GetFrameChild( MHandle , FrameIndex , 0 ) ;
		}

		/// <summary> w̃t[̎qt[̃t[CfbNX擾( ԍw )( FrameIndex  -1 ɂƐeȂt[ ChildIndex Ŏw肷 )( G[̏ꍇ͖߂l-1 ) </summary>
		public static int MV1GetFrameChild( Model MHandle , int FrameIndex , int ChildIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameChild( Model.ToHandle( MHandle ) , FrameIndex , ChildIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameChild( int MHandle , int FrameIndex , int ChildIndex ) ;


		/// <summary> w̃t[̍W擾 </summary>
		public static VECTOR MV1GetFramePosition( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetFramePosition( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetFramePosition( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̏Ԃł̍Wϊs擾 </summary>
		public static MATRIX MV1GetFrameBaseLocalMatrix( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetFrameBaseLocalMatrix( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetFrameBaseLocalMatrix( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̍Wϊs擾 </summary>
		public static MATRIX MV1GetFrameLocalMatrix( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetFrameLocalMatrix( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetFrameLocalMatrix( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃[JW烏[hWɕϊs𓾂 </summary>
		public static MATRIX MV1GetFrameLocalWorldMatrix( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				MATRIX result = dx_MV1GetFrameLocalWorldMatrix( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MV1GetFrameLocalWorldMatrix( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̍Wϊsݒ肷 </summary>
		public static void MV1SetFrameUserLocalMatrix( Model MHandle , int FrameIndex , MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameUserLocalMatrix( Model.ToHandle( MHandle ) , FrameIndex , Matrix ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameUserLocalMatrix( int MHandle , int FrameIndex , MATRIX Matrix ) ;


		/// <summary> w̃t[̍WϊsftHgɖ߂ </summary>
		public static void MV1ResetFrameUserLocalMatrix( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1ResetFrameUserLocalMatrix( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1ResetFrameUserLocalMatrix( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[bV_̃[JWł̍ől𓾂 </summary>
		public static VECTOR MV1GetFrameMaxVertexLocalPosition( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetFrameMaxVertexLocalPosition( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetFrameMaxVertexLocalPosition( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[bV_̃[JWł̍ŏl𓾂 </summary>
		public static VECTOR MV1GetFrameMinVertexLocalPosition( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetFrameMinVertexLocalPosition( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetFrameMinVertexLocalPosition( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[bV_̃[JWł̕ϒl𓾂 </summary>
		public static VECTOR MV1GetFrameAvgVertexLocalPosition( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetFrameAvgVertexLocalPosition( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetFrameAvgVertexLocalPosition( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[Ɋ܂܂|S̐擾 </summary>
		public static int MV1GetFrameTriangleNum( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameTriangleNum( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameTriangleNum( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[bV̐擾 </summary>
		public static int MV1GetFrameMeshNum( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameMeshNum( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameMeshNum( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[bṼbVCfbNX擾 </summary>
		public static int MV1GetFrameMesh( Model MHandle , int FrameIndex , int Index )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameMesh( Model.ToHandle( MHandle ) , FrameIndex , Index ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameMesh( int MHandle , int FrameIndex , int Index ) ;


		/// <summary> w̃t[̕\A\ԂύX( TRUE:\  FALSE:\ ) </summary>
		public static void MV1SetFrameVisible( Model MHandle , int FrameIndex , bool VisibleFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameVisible( Model.ToHandle( MHandle ) , FrameIndex , VisibleFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameVisible( int MHandle , int FrameIndex , bool VisibleFlag ) ;


		/// <summary> w̃t[̕\A\Ԃ擾( TRUE:\  FALSE:\ ) </summary>
		public static bool MV1GetFrameVisible( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameVisible( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameVisible( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃fBt[YJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetFrameDifColorScale( Model MHandle , int FrameIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameDifColorScale( Model.ToHandle( MHandle ) , FrameIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameDifColorScale( int MHandle , int FrameIndex , COLOR_F Scale ) ;


		/// <summary> w̃t[̃XyLJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetFrameSpcColorScale( Model MHandle , int FrameIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameSpcColorScale( Model.ToHandle( MHandle ) , FrameIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameSpcColorScale( int MHandle , int FrameIndex , COLOR_F Scale ) ;


		/// <summary> w̃t[̃G~bVuJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetFrameEmiColorScale( Model MHandle , int FrameIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameEmiColorScale( Model.ToHandle( MHandle ) , FrameIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameEmiColorScale( int MHandle , int FrameIndex , COLOR_F Scale ) ;


		/// <summary> w̃t[̃ArGgJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetFrameAmbColorScale( Model MHandle , int FrameIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameAmbColorScale( Model.ToHandle( MHandle ) , FrameIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameAmbColorScale( int MHandle , int FrameIndex , COLOR_F Scale ) ;


		/// <summary> w̃t[̃fBt[YJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetFrameDifColorScale( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetFrameDifColorScale( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetFrameDifColorScale( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃XyLJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetFrameSpcColorScale( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetFrameSpcColorScale( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetFrameSpcColorScale( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃G~bVuJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetFrameEmiColorScale( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetFrameEmiColorScale( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetFrameEmiColorScale( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃ArGgJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetFrameAmbColorScale( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetFrameAmbColorScale( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetFrameAmbColorScale( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[ɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ ) </summary>
		public static bool MV1GetFrameSemiTransState( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameSemiTransState( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameSemiTransState( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̕sxݒ肷( s 1.0f `  0.0f ) </summary>
		public static void MV1SetFrameOpacityRate( Model MHandle , int FrameIndex , float Rate )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameOpacityRate( Model.ToHandle( MHandle ) , FrameIndex , Rate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameOpacityRate( int MHandle , int FrameIndex , float Rate ) ;


		/// <summary> w̃t[̕sx擾( s 1.0f `  0.0f ) </summary>
		public static float MV1GetFrameOpacityRate( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetFrameOpacityRate( Model.ToHandle( MHandle ) , FrameIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetFrameOpacityRate( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̏\Ԃݒ肷( TRUE:\  FALSE:\ ) </summary>
		public static void MV1SetFrameBaseVisible( Model MHandle , int FrameIndex , bool VisibleFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameBaseVisible( Model.ToHandle( MHandle ) , FrameIndex , VisibleFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameBaseVisible( int MHandle , int FrameIndex , bool VisibleFlag ) ;


		/// <summary> w̃t[̏\Ԃ擾( TRUE:\  FALSE:\ ) </summary>
		public static bool MV1GetFrameBaseVisible( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetFrameBaseVisible( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetFrameBaseVisible( int MHandle , int FrameIndex ) ;


		/// <summary> w̃t[̃eNX`Wϊp[^ݒ肷 </summary>
		public static void MV1SetFrameTextureAddressTransform( Model MHandle , int FrameIndex , float TransU , float TransV , float ScaleU , float ScaleV , float RotCenterU , float RotCenterV , float Rotate )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameTextureAddressTransform( Model.ToHandle( MHandle ) , FrameIndex , TransU , TransV , ScaleU , ScaleV , RotCenterU , RotCenterV , Rotate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameTextureAddressTransform( int MHandle , int FrameIndex , float TransU , float TransV , float ScaleU , float ScaleV , float RotCenterU , float RotCenterV , float Rotate ) ;


		/// <summary> w̃t[̃eNX`WϊsZbg </summary>
		public static void MV1SetFrameTextureAddressTransformMatrix( Model MHandle , int FrameIndex , MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_MV1SetFrameTextureAddressTransformMatrix( Model.ToHandle( MHandle ) , FrameIndex , Matrix ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetFrameTextureAddressTransformMatrix( int MHandle , int FrameIndex , MATRIX Matrix ) ;


		/// <summary> w̃t[̃eNX`Wϊp[^Zbg </summary>
		public static void MV1ResetFrameTextureAddressTransform( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1ResetFrameTextureAddressTransform( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1ResetFrameTextureAddressTransform( int MHandle , int FrameIndex ) ;


		/// <summary> fɊ܂܂郁bV̐擾 </summary>
		public static int MV1GetMeshNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshNum( int MHandle ) ;


		/// <summary> w胁bVgpĂ}eÃCfbNX擾 </summary>
		public static int MV1GetMeshMaterial( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshMaterial( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshMaterial( int MHandle , int MeshIndex ) ;


		/// <summary> w胁bVɊ܂܂Op`|S̐擾 </summary>
		public static int MV1GetMeshTriangleNum( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshTriangleNum( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshTriangleNum( int MHandle , int MeshIndex ) ;


		/// <summary> w胁bV̕\A\ԂύX( TRUE:\  FALSE:\ ) </summary>
		public static void MV1SetMeshVisible( Model MHandle , int MeshIndex , bool VisibleFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshVisible( Model.ToHandle( MHandle ) , MeshIndex , VisibleFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshVisible( int MHandle , int MeshIndex , bool VisibleFlag ) ;


		/// <summary> w胁bV̕\A\Ԃ擾( TRUE:\  FALSE:\ ) </summary>
		public static bool MV1GetMeshVisible( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshVisible( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshVisible( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bṼfBt[YJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetMeshDifColorScale( Model MHandle , int MeshIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshDifColorScale( Model.ToHandle( MHandle ) , MeshIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshDifColorScale( int MHandle , int MeshIndex , COLOR_F Scale ) ;


		/// <summary> w̃bṼXyLJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetMeshSpcColorScale( Model MHandle , int MeshIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshSpcColorScale( Model.ToHandle( MHandle ) , MeshIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshSpcColorScale( int MHandle , int MeshIndex , COLOR_F Scale ) ;


		/// <summary> w̃bṼG~bVuJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetMeshEmiColorScale( Model MHandle , int MeshIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshEmiColorScale( Model.ToHandle( MHandle ) , MeshIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshEmiColorScale( int MHandle , int MeshIndex , COLOR_F Scale ) ;


		/// <summary> w̃bṼArGgJ[̃XP[lݒ肷( ftHgl 1.0f ) </summary>
		public static void MV1SetMeshAmbColorScale( Model MHandle , int MeshIndex , COLOR_F Scale )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshAmbColorScale( Model.ToHandle( MHandle ) , MeshIndex , Scale ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshAmbColorScale( int MHandle , int MeshIndex , COLOR_F Scale ) ;


		/// <summary> w̃bṼfBt[YJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetMeshDifColorScale( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMeshDifColorScale( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMeshDifColorScale( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bṼXyLJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetMeshSpcColorScale( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMeshSpcColorScale( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMeshSpcColorScale( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bṼG~bVuJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetMeshEmiColorScale( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMeshEmiColorScale( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMeshEmiColorScale( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bṼArGgJ[̃XP[l擾( ftHgl 1.0f ) </summary>
		public static COLOR_F MV1GetMeshAmbColorScale( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				COLOR_F result = dx_MV1GetMeshAmbColorScale( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_MV1GetMeshAmbColorScale( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̕sxݒ肷( s 1.0f `  0.0f ) </summary>
		public static void MV1SetMeshOpacityRate( Model MHandle , int MeshIndex , float Rate )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshOpacityRate( Model.ToHandle( MHandle ) , MeshIndex , Rate ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshOpacityRate( int MHandle , int MeshIndex , float Rate ) ;


		/// <summary> w̃bV̕sx擾( s 1.0f `  0.0f ) </summary>
		public static float MV1GetMeshOpacityRate( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				float result = dx_MV1GetMeshOpacityRate( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_MV1GetMeshOpacityRate( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̕`uh[hݒ肷( DX_BLENDMODE_ALPHA  ) </summary>
		public static void MV1SetMeshDrawBlendMode( Model MHandle , int MeshIndex , DX_BLENDMODE BlendMode )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshDrawBlendMode( Model.ToHandle( MHandle ) , MeshIndex , BlendMode ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshDrawBlendMode( int MHandle , int MeshIndex , DX_BLENDMODE BlendMode ) ;


		/// <summary> w̃bV̕`uhp[^ݒ肷 </summary>
		public static void MV1SetMeshDrawBlendParam( Model MHandle , int MeshIndex , int BlendParam )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshDrawBlendParam( Model.ToHandle( MHandle ) , MeshIndex , BlendParam ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshDrawBlendParam( int MHandle , int MeshIndex , int BlendParam ) ;


		/// <summary> w̃bV̕`uh[h擾( DX_BLENDMODE_ALPHA  ) </summary>
		public static DX_BLENDMODE MV1GetMeshDrawBlendMode( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				DX_BLENDMODE result = dx_MV1GetMeshDrawBlendMode( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_BLENDMODE dx_MV1GetMeshDrawBlendMode( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̕`uhp[^ݒ肷 </summary>
		public static int MV1GetMeshDrawBlendParam( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshDrawBlendParam( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshDrawBlendParam( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̏\Ԃݒ肷( TRUE:\  FALSE:\ ) </summary>
		public static void MV1SetMeshBaseVisible( Model MHandle , int MeshIndex , bool VisibleFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshBaseVisible( Model.ToHandle( MHandle ) , MeshIndex , VisibleFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshBaseVisible( int MHandle , int MeshIndex , bool VisibleFlag ) ;


		/// <summary> w̃bV̏\Ԃ擾( TRUE:\  FALSE:\ ) </summary>
		public static bool MV1GetMeshBaseVisible( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshBaseVisible( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshBaseVisible( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bṼobNJOsǂݒ肷( TRUE:  FALSE:Ȃ ) </summary>
		public static void MV1SetMeshBackCulling( Model MHandle , int MeshIndex , bool CullingFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshBackCulling( Model.ToHandle( MHandle ) , MeshIndex , CullingFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshBackCulling( int MHandle , int MeshIndex , bool CullingFlag ) ;


		/// <summary> w̃bṼobNJOsǂ擾( TRUE:  FALSE:Ȃ ) </summary>
		public static bool MV1GetMeshBackCulling( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshBackCulling( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshBackCulling( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bVɊ܂܂|S̍ő働[JW擾 </summary>
		public static VECTOR MV1GetMeshMaxPosition( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetMeshMaxPosition( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetMeshMaxPosition( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bVɊ܂܂|S̍ŏ[JW擾 </summary>
		public static VECTOR MV1GetMeshMinPosition( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				VECTOR result = dx_MV1GetMeshMinPosition( Model.ToHandle( MHandle ) , MeshIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_MV1GetMeshMinPosition( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bVɊ܂܂gCAOXg̐擾 </summary>
		public static int MV1GetMeshTListNum( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshTListNum( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshTListNum( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bVɊ܂܂gCAOXg̃CfbNX擾 </summary>
		public static int MV1GetMeshTList( Model MHandle , int MeshIndex , int Index )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshTList( Model.ToHandle( MHandle ) , MeshIndex , Index ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshTList( int MHandle , int MeshIndex , int Index ) ;


		/// <summary> w̃bVɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ ) </summary>
		public static bool MV1GetMeshSemiTransState( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshSemiTransState( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshSemiTransState( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static void MV1SetMeshUseVertDifColor( Model MHandle , int MeshIndex , bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshUseVertDifColor( Model.ToHandle( MHandle ) , MeshIndex , UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshUseVertDifColor( int MHandle , int MeshIndex , bool UseFlag ) ;


		/// <summary> w̃bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static void MV1SetMeshUseVertSpcColor( Model MHandle , int MeshIndex , bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_MV1SetMeshUseVertSpcColor( Model.ToHandle( MHandle ) , MeshIndex , UseFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetMeshUseVertSpcColor( int MHandle , int MeshIndex , bool UseFlag ) ;


		/// <summary> w̃bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂ̐ݒ擾( ߂l  TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static bool MV1GetMeshUseVertDifColor( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshUseVertDifColor( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshUseVertDifColor( int MHandle , int MeshIndex ) ;


		/// <summary> w̃bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂ̐ݒ擾( ߂l  TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp ) </summary>
		public static bool MV1GetMeshUseVertSpcColor( Model MHandle , int MeshIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetMeshUseVertSpcColor( Model.ToHandle( MHandle ) , MeshIndex ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetMeshUseVertSpcColor( int MHandle , int MeshIndex ) ;


		/// <summary> gCAOXg̐擾 </summary>
		public static int MV1GetTriangleListNum( Model MHandle )
		{
			lock( locker )
			{
				int result = dx_MV1GetTriangleListNum( Model.ToHandle( MHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTriangleListNum( int MHandle ) ;


		/// <summary> w̃gCAOXg̒_f[^^Cv擾( MV1_VERTEX_TYPE_NORMAL  ) </summary>
		public static MV1_VERTEX_TYPE MV1GetTriangleListVertexType( Model MHandle , int TListIndex )
		{
			lock( locker )
			{
				MV1_VERTEX_TYPE result = dx_MV1GetTriangleListVertexType( Model.ToHandle( MHandle ) , TListIndex ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_VERTEX_TYPE dx_MV1GetTriangleListVertexType( int MHandle , int TListIndex ) ;


		/// <summary> w̃gCAOXgɊ܂܂|S̐擾 </summary>
		public static int MV1GetTriangleListPolygonNum( Model MHandle , int TListIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTriangleListPolygonNum( Model.ToHandle( MHandle ) , TListIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTriangleListPolygonNum( int MHandle , int TListIndex ) ;


		/// <summary> w̃gCAOXgɊ܂܂钸_f[^̐擾 </summary>
		public static int MV1GetTriangleListVertexNum( Model MHandle , int TListIndex )
		{
			lock( locker )
			{
				int result = dx_MV1GetTriangleListVertexNum( Model.ToHandle( MHandle ) , TListIndex ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1GetTriangleListVertexNum( int MHandle , int TListIndex ) ;


		/// <summary> RW\z </summary>
		public static void MV1SetupCollInfo( Model MHandle )
		{
			MV1SetupCollInfo( MHandle , -1 ) ;
		}

		/// <summary> RW\z </summary>
		public static void MV1SetupCollInfo( Model MHandle , int FrameIndex )
		{
			MV1SetupCollInfo( MHandle , FrameIndex , 32 ) ;
		}

		/// <summary> RW\z </summary>
		public static void MV1SetupCollInfo( Model MHandle , int FrameIndex , int XDivNum )
		{
			MV1SetupCollInfo( MHandle , FrameIndex , XDivNum , 8 ) ;
		}

		/// <summary> RW\z </summary>
		public static void MV1SetupCollInfo( Model MHandle , int FrameIndex , int XDivNum , int YDivNum )
		{
			MV1SetupCollInfo( MHandle , FrameIndex , XDivNum , YDivNum , 32 ) ;
		}

		/// <summary> RW\z </summary>
		public static void MV1SetupCollInfo( Model MHandle , int FrameIndex , int XDivNum , int YDivNum , int ZDivNum )
		{
			lock( locker )
			{
				int result = dx_MV1SetupCollInfo( Model.ToHandle( MHandle ) , FrameIndex , XDivNum , YDivNum , ZDivNum ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetupCollInfo( int MHandle , int FrameIndex , int XDivNum , int YDivNum , int ZDivNum ) ;


		/// <summary> RW̌n </summary>
		public static void MV1TerminateCollInfo( Model MHandle )
		{
			MV1TerminateCollInfo( MHandle , -1 ) ;
		}

		/// <summary> RW̌n </summary>
		public static void MV1TerminateCollInfo( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1TerminateCollInfo( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1TerminateCollInfo( int MHandle , int FrameIndex ) ;


		/// <summary> RWXV </summary>
		public static void MV1RefreshCollInfo( Model MHandle )
		{
			MV1RefreshCollInfo( MHandle , -1 ) ;
		}

		/// <summary> RWXV </summary>
		public static void MV1RefreshCollInfo( Model MHandle , int FrameIndex )
		{
			lock( locker )
			{
				int result = dx_MV1RefreshCollInfo( Model.ToHandle( MHandle ) , FrameIndex ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1RefreshCollInfo( int MHandle , int FrameIndex ) ;


		/// <summary> ƃf̓蔻 </summary>
		public static MV1_COLL_RESULT_POLY MV1CollCheck_Line( Model MHandle , int FrameIndex , VECTOR PosStart , VECTOR PosEnd )
		{
			lock( locker )
			{
				MV1_COLL_RESULT_POLY result = dx_MV1CollCheck_Line( Model.ToHandle( MHandle ) , FrameIndex , PosStart , PosEnd ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_COLL_RESULT_POLY dx_MV1CollCheck_Line( int MHandle , int FrameIndex , VECTOR PosStart , VECTOR PosEnd ) ;


		/// <summary> ƃf̓蔻( ߂l MV1_COLL_RESULT_POLY_DIM ) </summary>
		public static MV1_COLL_RESULT_POLY[] MV1CollCheck_LineDim( Model MHandle , int FrameIndex , VECTOR PosStart , VECTOR PosEnd )
		{
			lock( locker )
			{
				MV1_COLL_RESULT_POLY_DIM source = dx_MV1CollCheck_LineDim( Model.ToHandle( MHandle ) , FrameIndex , PosStart , PosEnd ) ;

				try
				{
					MV1_COLL_RESULT_POLY[] target = new MV1_COLL_RESULT_POLY[ source.HitNum ] ;

					for( int i = 0 ; i < target.Length ; i ++ )
					{
						unsafe
						{
							target[ i ] = source.Dim[ i ] ;
						}
					}

					return target ;
				}
				finally
				{
					dx_MV1CollResultPolyDimTerminate( source ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_COLL_RESULT_POLY_DIM dx_MV1CollCheck_LineDim( int MHandle , int FrameIndex , VECTOR PosStart , VECTOR PosEnd ) ;


		/// <summary> ƃf̓蔻 </summary>
		public static MV1_COLL_RESULT_POLY[] MV1CollCheck_Sphere( Model MHandle , int FrameIndex , VECTOR CenterPos , float r )
		{
			lock( locker )
			{
				MV1_COLL_RESULT_POLY_DIM source = dx_MV1CollCheck_Sphere( Model.ToHandle( MHandle ) , FrameIndex , CenterPos , r ) ;

				try
				{
					MV1_COLL_RESULT_POLY[] target = new MV1_COLL_RESULT_POLY[ source.HitNum ] ;

					for( int i = 0 ; i < target.Length ; i ++ )
					{
						unsafe
						{
							target[ i ] = source.Dim[ i ] ;
						}
					}

					return target ;
				}
				finally
				{
					dx_MV1CollResultPolyDimTerminate( source ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_COLL_RESULT_POLY_DIM dx_MV1CollCheck_Sphere( int MHandle , int FrameIndex , VECTOR CenterPos , float r ) ;


		/// <summary> JvZƃf̓蔻 </summary>
		public static MV1_COLL_RESULT_POLY[] MV1CollCheck_Capsule( Model MHandle , int FrameIndex , VECTOR Pos1 , VECTOR Pos2 , float r )
		{
			lock( locker )
			{
				MV1_COLL_RESULT_POLY_DIM source = dx_MV1CollCheck_Capsule( Model.ToHandle( MHandle ) , FrameIndex , Pos1 , Pos2 , r ) ;

				try
				{
					MV1_COLL_RESULT_POLY[] target = new MV1_COLL_RESULT_POLY[ source.HitNum ] ;

					for( int i = 0 ; i < target.Length ; i ++ )
					{
						unsafe
						{
							target[ i ] = source.Dim[ i ] ;
						}
					}

					return target ;
				}
				finally
				{
					dx_MV1CollResultPolyDimTerminate( source ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_COLL_RESULT_POLY_DIM dx_MV1CollCheck_Capsule( int MHandle , int FrameIndex , VECTOR Pos1 , VECTOR Pos2 , float r ) ;


	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_COLL_RESULT_POLY dx_MV1CollCheck_GetResultPoly( MV1_COLL_RESULT_POLY_DIM ResultPolyDim , int PolyNo ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1CollResultPolyDimTerminate( MV1_COLL_RESULT_POLY_DIM ResultPolyDim ) ;

	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		private unsafe struct MV1_COLL_RESULT_POLY_DIM
		{

			public int HitNum ;

			public MV1_COLL_RESULT_POLY *Dim ;
		}


		/// <summary> QƗpbV擾 </summary>
		public static DxLib.MV1_REF_POLYGONLIST MV1GetReferenceMesh( Model MHandle , int FrameIndex , bool IsTransform )
		{
			lock( locker )
			{
				int result = dx_MV1SetupReferenceMesh( Model.ToHandle( MHandle ) , FrameIndex , IsTransform ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }

				try
				{
					MV1_REF_POLYGONLIST source = dx_MV1GetReferenceMesh( Model.ToHandle( MHandle ) , FrameIndex , IsTransform ) ;
					DxLib.MV1_REF_POLYGONLIST target = new DxLib.MV1_REF_POLYGONLIST() ;
					target.MinPosition = source.MinPosition ;
					target.MaxPosition = source.MaxPosition ;
					target.Polygons = new MV1_REF_POLYGON[ source.PolygonNum ] ;
					target.Vertexs = new MV1_REF_VERTEX[ source.VertexNum ] ;

					for( int i = 0 ; i < target.Polygons.Length ; i ++ )
					{
						unsafe
						{
							target.Polygons[ i ] = source.Polygons[ i ] ;
						}
					}

					for( int i = 0 ; i < target.Vertexs.Length ; i ++ )
					{
						unsafe
						{
							target.Vertexs[ i ] = source.Vertexs[ i ] ;
						}
					}

					return target ;
				}
				finally
				{
					dx_MV1TerminateReferenceMesh( Model.ToHandle( MHandle ) , FrameIndex , IsTransform ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1SetupReferenceMesh( int MHandle , int FrameIndex , bool IsTransform ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1TerminateReferenceMesh( int MHandle , int FrameIndex , bool IsTransform ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MV1RefreshReferenceMesh( int MHandle , int FrameIndex , bool IsTransform ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MV1_REF_POLYGONLIST dx_MV1GetReferenceMesh( int MHandle , int FrameIndex , bool IsTransform ) ;

	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		private unsafe struct MV1_REF_POLYGONLIST
		{

			public int PolygonNum ;

			public int VertexNum ;

			public VECTOR MinPosition ;

			public VECTOR MaxPosition ;

			public MV1_REF_POLYGON *Polygons ;

			public MV1_REF_VERTEX *Vertexs ;
		}
	}
}
