using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public static partial class Window
	{


		/// <summary> Pʍs쐬 </summary>
		public static void CreateIdentityMatrix( out MATRIX Out )
		{
			int result = dx_CreateIdentityMatrix( out Out ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateIdentityMatrix( out MATRIX Out ) ;


		/// <summary> r[s쐬 </summary>
		public static void CreateLookAtMatrix( out MATRIX Out , VECTOR Eye , VECTOR At , VECTOR Up )
		{
			int result = dx_CreateLookAtMatrix( out Out , ref Eye , ref At , ref Up ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateLookAtMatrix( out MATRIX Out , [ In ] ref VECTOR Eye , [ In ] ref VECTOR At , [ In ] ref VECTOR Up ) ;


		/// <summary> r[s쐬 </summary>
		public static void CreateLookAtMatrix2( out MATRIX Out , VECTOR Eye , double XZAngle , double Oira )
		{
			int result = dx_CreateLookAtMatrix2( out Out , ref Eye , XZAngle , Oira ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateLookAtMatrix2( out MATRIX Out , [ In ] ref VECTOR Eye , double XZAngle , double Oira ) ;


		/// <summary> r[s쐬(EWnp) </summary>
		public static void CreateLookAtMatrixRH( out MATRIX Out , VECTOR Eye , VECTOR At , VECTOR Up )
		{
			int result = dx_CreateLookAtMatrixRH( out Out , ref Eye , ref At , ref Up ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateLookAtMatrixRH( out MATRIX Out , [ In ] ref VECTOR Eye , [ In ] ref VECTOR At , [ In ] ref VECTOR Up ) ;


		/// <summary> s̐ς߂ </summary>
		public static void CreateMultiplyMatrix( out MATRIX Out , MATRIX In1 , MATRIX In2 )
		{
			int result = dx_CreateMultiplyMatrix( out Out , ref In1 , ref In2 ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateMultiplyMatrix( out MATRIX Out , [ In ] ref MATRIX In1 , [ In ] ref MATRIX In2 ) ;


		/// <summary> ˉes쐬 </summary>
		public static void CreatePerspectiveFovMatrix( out MATRIX Out , float fov , float zn , float zf )
		{
			CreatePerspectiveFovMatrix( out Out , fov , zn , zf , 1.0f ) ;
		}

		/// <summary> ˉes쐬 </summary>
		public static void CreatePerspectiveFovMatrix( out MATRIX Out , float fov , float zn , float zf , float aspect )
		{
			int result = dx_CreatePerspectiveFovMatrix( out Out , fov , zn , zf , aspect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePerspectiveFovMatrix( out MATRIX Out , float fov , float zn , float zf , float aspect ) ;


		/// <summary> ˉes쐬(EWnp) </summary>
		public static void CreatePerspectiveFovMatrixRH( out MATRIX Out , float fov , float zn , float zf )
		{
			CreatePerspectiveFovMatrixRH( out Out , fov , zn , zf , 1.0f ) ;
		}

		/// <summary> ˉes쐬(EWnp) </summary>
		public static void CreatePerspectiveFovMatrixRH( out MATRIX Out , float fov , float zn , float zf , float aspect )
		{
			int result = dx_CreatePerspectiveFovMatrixRH( out Out , fov , zn , zf , aspect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePerspectiveFovMatrixRH( out MATRIX Out , float fov , float zn , float zf , float aspect ) ;



		/// <summary> ˉes쐬 </summary>
		public static void CreateOrthoMatrix( out MATRIX Out , float size , float zn , float zf )
		{
			CreateOrthoMatrix( out Out , size , zn , zf , 1.0f ) ;
		}

		/// <summary> ˉes쐬 </summary>
		public static void CreateOrthoMatrix( out MATRIX Out , float size , float zn , float zf , float aspect )
		{
			int result = dx_CreateOrthoMatrix( out Out , size , zn , zf , aspect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateOrthoMatrix( out MATRIX Out , float size , float zn , float zf , float aspect ) ;


		/// <summary> ˉes쐬(EWnp) </summary>
		public static void CreateOrthoMatrixRH( out MATRIX Out , float size , float zn , float zf )
		{
			CreateOrthoMatrixRH( out Out , size , zn , zf , 1.0f ) ;
		}

		/// <summary> ˉes쐬(EWnp) </summary>
		public static void CreateOrthoMatrixRH( out MATRIX Out , float size , float zn , float zf , float aspect )
		{
			int result = dx_CreateOrthoMatrixRH( out Out , size , zn , zf , aspect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateOrthoMatrixRH( out MATRIX Out , float size , float zn , float zf , float aspect ) ;


		/// <summary> XP[Os쐬 </summary>
		public static void CreateScalingMatrix( out MATRIX Out , float sx , float sy , float sz )
		{
			int result = dx_CreateScalingMatrix( out Out , sx , sy , sz ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateScalingMatrix( out MATRIX Out , float sx , float sy , float sz ) ;


		/// <summary> w𒆐SƂ]s쐬 </summary>
		public static void CreateRotationXMatrix( out MATRIX Out , float Angle )
		{
			int result = dx_CreateRotationXMatrix( out Out , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationXMatrix( out MATRIX Out , float Angle ) ;


		/// <summary> x𒆐SƂ]s쐬 </summary>
		public static void CreateRotationYMatrix( out MATRIX Out , float Angle )
		{
			int result = dx_CreateRotationYMatrix( out Out , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationYMatrix( out MATRIX Out , float Angle ) ;


		/// <summary> y𒆐SƂ]s쐬 </summary>
		public static void CreateRotationZMatrix( out MATRIX Out , float Angle )
		{
			int result = dx_CreateRotationZMatrix( out Out , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationZMatrix( out MATRIX Out , float Angle ) ;


		/// <summary> sړs쐬 </summary>
		public static void CreateTranslationMatrix( out MATRIX Out , float x , float y , float z )
		{
			int result = dx_CreateTranslationMatrix( out Out , x , y , z ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateTranslationMatrix( out MATRIX Out , float x , float y , float z ) ;


		/// <summary> ]us쐬 </summary>
		public static void CreateTransposeMatrix( out MATRIX Out , MATRIX In )
		{
			int result = dx_CreateTransposeMatrix( out Out , ref In ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateTransposeMatrix( out MATRIX Out , [ In ] ref MATRIX In ) ;


		/// <summary> ts쐬 </summary>
		public static void CreateInverseMatrix( out MATRIX Out , MATRIX In )
		{
			int result = dx_CreateInverseMatrix( out Out , ref In ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateInverseMatrix( out MATRIX Out , [ In ] ref MATRIX In ) ;


		/// <summary> r[|[gs쐬 </summary>
		public static void CreateViewportMatrix( out MATRIX Out , float CenterX , float CenterY , float Width , float Height )
		{
			int result = dx_CreateViewportMatrix( out Out , CenterX , CenterY , Width , Height ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateViewportMatrix( out MATRIX Out , float CenterX , float CenterY , float Width , float Height ) ;


		/// <summary> w]x]y]s쐬 </summary>
		public static void CreateRotationXYZMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationXYZMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationXYZMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> w]y]x]s쐬 </summary>
		public static void CreateRotationXZYMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationXZYMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationXZYMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> x]w]y]s쐬 </summary>
		public static void CreateRotationYXZMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationYXZMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationYXZMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> x]y]w]s쐬 </summary>
		public static void CreateRotationYZXMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationYZXMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationYZXMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> y]w]x]s쐬 </summary>
		public static void CreateRotationZXYMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationZXYMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationZXYMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> y]x]w]s쐬 </summary>
		public static void CreateRotationZYXMatrix( out MATRIX Out , float XRot , float YRot , float ZRot )
		{
			int result = dx_CreateRotationZYXMatrix( out Out , XRot , YRot , ZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRotationZYXMatrix( out MATRIX Out , float XRot , float YRot , float ZRot ) ;


		/// <summary> s񂩂wxy]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixXYZRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixXYZRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixXYZRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> s񂩂wyx]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixXZYRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixXZYRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixXZYRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> s񂩂xwy]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixYXZRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixYXZRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixYXZRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> s񂩂xyw]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixYZXRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixYZXRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixYZXRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> s񂩂ywx]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixZXYRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixZXYRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixZXYRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> s񂩂yxw]̒l擾( ߂l@-1:WobN  0: ) </summary>
		public static void GetMatrixZYXRotation( MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot )
		{
			int result = dx_GetMatrixZYXRotation( ref In , out OutXRot , out OutYRot , out OutZRot ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMatrixZYXRotation( [ In ] ref MATRIX In , out float OutXRot , out float OutYRot , out float OutZRot ) ;


		/// <summary> xNg𐳋K </summary>
		public static void VectorNormalize( out VECTOR Out , VECTOR In )
		{
			int result = dx_VectorNormalize( out Out , ref In ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorNormalize( out VECTOR Out , [ In ] ref VECTOR In ) ;


		/// <summary> xNgXJ[{ </summary>
		public static void VectorScale( out VECTOR Out , VECTOR In , float Scale )
		{
			int result = dx_VectorScale( out Out , ref In , Scale ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorScale( out VECTOR Out , [ In ] ref VECTOR In , float Scale ) ;


		/// <summary> xNg̊|Z </summary>
		public static void VectorMultiply( out VECTOR Out , VECTOR In1 , VECTOR In2 )
		{
			int result = dx_VectorMultiply( out Out , ref In1 , ref In2 ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorMultiply( out VECTOR Out , [ In ] ref VECTOR In1 , [ In ] ref VECTOR In2 ) ;


		/// <summary> Out = In1 - In2 ̃xNgvZ  </summary>
		public static void VectorSub( out VECTOR Out , VECTOR In1 , VECTOR In2 )
		{
			int result = dx_VectorSub( out Out , ref In1 , ref In2 ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorSub( out VECTOR Out , [ In ] ref VECTOR In1 , [ In ] ref VECTOR In2 ) ;


		/// <summary> Out = In1 + In2 ̃xNgvZ  </summary>
		public static void VectorAdd( out VECTOR Out , VECTOR In1 , VECTOR In2 )
		{
			int result = dx_VectorAdd( out Out , ref In1 , ref In2 ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorAdd( out VECTOR Out , [ In ] ref VECTOR In1 , [ In ] ref VECTOR In2 ) ;


		/// <summary> In1In2̊OςvZ </summary>
		public static void VectorOuterProduct( out VECTOR Out , VECTOR In1 , VECTOR In2 )
		{
			int result = dx_VectorOuterProduct( out Out , ref In1 , ref In2 ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorOuterProduct( out VECTOR Out , [ In ] ref VECTOR In1 , [ In ] ref VECTOR In2 ) ;


		/// <summary> In1In2̓ςvZ </summary>
		public static float VectorInnerProduct( VECTOR In1 , VECTOR In2 )
		{
			float result = dx_VectorInnerProduct( ref In1 , ref In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VectorInnerProduct( [ In ] ref VECTOR In1 , [ In ] ref VECTOR In2 ) ;


		/// <summary> xNĝwɂ]s </summary>
		public static void VectorRotationX( out VECTOR Out , VECTOR In , double Angle )
		{
			int result = dx_VectorRotationX( out Out , ref In , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorRotationX( out VECTOR Out , [ In ] ref VECTOR In , double Angle ) ;


		/// <summary> xNĝxɂ]s </summary>
		public static void VectorRotationY( out VECTOR Out , VECTOR In , double Angle )
		{
			int result = dx_VectorRotationY( out Out , ref In , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorRotationY( out VECTOR Out , [ In ] ref VECTOR In , double Angle ) ;


		/// <summary> xNĝyɂ]s </summary>
		public static void VectorRotationZ( out VECTOR Out , VECTOR In , double Angle )
		{
			int result = dx_VectorRotationZ( out Out , ref In , Angle ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorRotationZ( out VECTOR Out , [ In ] ref VECTOR In , double Angle ) ;


		/// <summary> xNgs4x4sZ( w  1 Ɖ ) </summary>
		public static void VectorTransform( out VECTOR Out , VECTOR InVec , MATRIX InMatrix )
		{
			int result = dx_VectorTransform( out Out , ref InVec , ref InMatrix ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorTransform( out VECTOR Out , [ In ] ref VECTOR InVec , [ In ] ref MATRIX InMatrix ) ;


		/// <summary> xNgs4x4sZ( w ̗vfn ) </summary>
		public static void VectorTransform4( out VECTOR Out , out float V4Out , VECTOR InVec , float V4In , MATRIX InMatrix )
		{
			int result = dx_VectorTransform4( out Out , out V4Out , ref InVec , ref V4In , ref InMatrix ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_VectorTransform4( out VECTOR Out , out float V4Out , [ In ] ref VECTOR InVec , [ In ] ref float V4In , [ In ] ref MATRIX InMatrix ) ;


		/// <summary> w̍WOp`̏dS߂ </summary>
		public static void TriangleBarycenter( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR Position , out float U , out float V , out float w )
		{
			dx_TriangleBarycenter( TrianglePos1 , TrianglePos2 , TrianglePos3 , Position , out U , out V , out w ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern void dx_TriangleBarycenter( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR Position , out float U , out float V , out float w ) ;


		/// <summary> ̐̍ŋߓ_Ԃ̋𓾂 </summary>
		public static float Segment_Segment_MinLength( VECTOR SegmentAPos1 , VECTOR SegmentAPos2 , VECTOR SegmentBPos1 , VECTOR SegmentBPos2 )
		{
			float result = dx_Segment_Segment_MinLength( SegmentAPos1 , SegmentAPos2 , SegmentBPos1 , SegmentBPos2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Segment_MinLength( VECTOR SegmentAPos1 , VECTOR SegmentAPos2 , VECTOR SegmentBPos1 , VECTOR SegmentBPos2 ) ;


		/// <summary> ̐̍ŋߓ_Ԃ̋̓𓾂 </summary>
		public static float Segment_Segment_MinLength_Square( VECTOR SegmentAPos1 , VECTOR SegmentAPos2 , VECTOR SegmentBPos1 , VECTOR SegmentBPos2 )
		{
			float result = dx_Segment_Segment_MinLength_Square( SegmentAPos1 , SegmentAPos2 , SegmentBPos1 , SegmentBPos2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Segment_MinLength_Square( VECTOR SegmentAPos1 , VECTOR SegmentAPos2 , VECTOR SegmentBPos1 , VECTOR SegmentBPos2 ) ;


		/// <summary> ƎOp`̍ŋߓ_Ԃ̋𓾂  </summary>
		public static float Segment_Triangle_MinLength( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 )
		{
			float result = dx_Segment_Triangle_MinLength( SegmentPos1 , SegmentPos2 , TrianglePos1 , TrianglePos2 , TrianglePos3 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Triangle_MinLength( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 ) ;


		/// <summary> ƎOp`̍ŋߓ_Ԃ̋̓𓾂  </summary>
		public static float Segment_Triangle_MinLength_Square( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 )
		{
			float result = dx_Segment_Triangle_MinLength_Square( SegmentPos1 , SegmentPos2 , TrianglePos1 , TrianglePos2 , TrianglePos3 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Triangle_MinLength_Square( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 ) ;


		/// <summary> Ɠ_̈ԋ߂𓾂 </summary>
		public static float Segment_Point_MinLength( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR PointPos )
		{
			float result = dx_Segment_Point_MinLength( SegmentPos1 , SegmentPos2 , PointPos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Point_MinLength( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR PointPos ) ;


		/// <summary> Ɠ_̈ԋ߂̓𓾂 </summary>
		public static float Segment_Point_MinLength_Square( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR PointPos )
		{
			float result = dx_Segment_Point_MinLength_Square( SegmentPos1 , SegmentPos2 , PointPos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Segment_Point_MinLength_Square( VECTOR SegmentPos1 , VECTOR SegmentPos2 , VECTOR PointPos ) ;


		/// <summary> Op`Ɠ_̈ԋ߂𓾂 </summary>
		public static float Triangle_Point_MinLength( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR PointPos )
		{
			float result = dx_Triangle_Point_MinLength( TrianglePos1 , TrianglePos2 , TrianglePos3 , PointPos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Triangle_Point_MinLength( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR PointPos ) ;


		/// <summary> Op`Ɠ_̈ԋ߂̓𓾂 </summary>
		public static float Triangle_Point_MinLength_Square( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR PointPos )
		{
			float result = dx_Triangle_Point_MinLength_Square( TrianglePos1 , TrianglePos2 , TrianglePos3 , PointPos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_Triangle_Point_MinLength_Square( VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 , VECTOR PointPos ) ;


		/// <summary> Op`Ɛ̓蔻 </summary>
		public static HITRESULT_LINE HitCheck_Line_Triangle( VECTOR LinePos1 , VECTOR LinePos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 )
		{
			HITRESULT_LINE result = dx_HitCheck_Line_Triangle( LinePos1 , LinePos2 , TrianglePos1 , TrianglePos2 , TrianglePos3 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern HITRESULT_LINE dx_HitCheck_Line_Triangle( VECTOR LinePos1 , VECTOR LinePos2 , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 ) ;


		/// <summary> Op`ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Triangle_Triangle( VECTOR Triangle1Pos1 , VECTOR Triangle1Pos2 , VECTOR Triangle1Pos3 , VECTOR Triangle2Pos1 , VECTOR Triangle2Pos2 , VECTOR Triangle2Pos3 )
		{
			int result = dx_HitCheck_Triangle_Triangle( Triangle1Pos1 , Triangle1Pos2 , Triangle1Pos3 , Triangle2Pos1 , Triangle2Pos2 , Triangle2Pos3 ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Triangle_Triangle( VECTOR Triangle1Pos1 , VECTOR Triangle1Pos2 , VECTOR Triangle1Pos3 , VECTOR Triangle2Pos1 , VECTOR Triangle2Pos2 , VECTOR Triangle2Pos3 ) ;


		/// <summary> Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Line_Sphere( VECTOR LinePos1 , VECTOR LinePos2 , VECTOR SphereCenterPos , float SphereR )
		{
			int result = dx_HitCheck_Line_Sphere( LinePos1 , LinePos2 , SphereCenterPos , SphereR ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Line_Sphere( VECTOR LinePos1 , VECTOR LinePos2 , VECTOR SphereCenterPos , float SphereR ) ;


		/// <summary> Ƌ̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Sphere_Sphere( VECTOR Sphere1CenterPos , float Sphere1R , VECTOR Sphere2CenterPos , float Sphere2R )
		{
			int result = dx_HitCheck_Sphere_Sphere( Sphere1CenterPos , Sphere1R , Sphere2CenterPos , Sphere2R ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Sphere_Sphere( VECTOR Sphere1CenterPos , float Sphere1R , VECTOR Sphere2CenterPos , float Sphere2R ) ;


		/// <summary> ƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Sphere_Triangle( VECTOR SphereCenterPos , float SphereR , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 )
		{
			int result = dx_HitCheck_Sphere_Triangle( SphereCenterPos , SphereR , TrianglePos1 , TrianglePos2 , TrianglePos3 ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Sphere_Triangle( VECTOR SphereCenterPos , float SphereR , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 ) ;


		/// <summary> JvZm̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Capsule_Capsule( VECTOR Cap1Pos1 , VECTOR Cap1Pos2 , float Cap1R , VECTOR Cap2Pos1 , VECTOR Cap2Pos2 , float Cap2R )
		{
			int result = dx_HitCheck_Capsule_Capsule( Cap1Pos1 , Cap1Pos2 , Cap1R , Cap2Pos1 , Cap2Pos2 , Cap2R ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Capsule_Capsule( VECTOR Cap1Pos1 , VECTOR Cap1Pos2 , float Cap1R , VECTOR Cap2Pos1 , VECTOR Cap2Pos2 , float Cap2R ) ;


		/// <summary> JvZƎOp`̓蔻( TRUE:Ă  FALSE:ĂȂ ) </summary>
		public static bool HitCheck_Capsule_Triangle( VECTOR CapPos1 , VECTOR CapPos2 , float CapR , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 )
		{
			int result = dx_HitCheck_Capsule_Triangle( CapPos1 , CapPos2 , CapR , TrianglePos1 , TrianglePos2 , TrianglePos3 ) ;
			if( result == 0 ) { return false ; }
			else if( result == 1 ) { return true ; }
			else { throw new DxLibException() ; }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_HitCheck_Capsule_Triangle( VECTOR CapPos1 , VECTOR CapPos2 , float CapR , VECTOR TrianglePos1 , VECTOR TrianglePos2 , VECTOR TrianglePos3 ) ;


		/// <summary> `̃NbsO </summary>
		public static void RectClipping( out RECT MotoRect , RECT ClipRect )
		{
			int result = dx_RectClipping( out MotoRect , ref ClipRect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_RectClipping( out RECT MotoRect , [ In ] ref RECT ClipRect ) ;


		/// <summary> ` Left  Right l傫ꍇȂǂ̌␳ </summary>
		public static void RectAdjust( ref RECT Rect )
		{
			int result = dx_RectAdjust( ref Rect ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_RectAdjust( [ In , Out ] ref RECT Rect ) ;


		/// <summary> `̕ƍ߂ </summary>
		public static void GetRectSize( RECT Rect , out int Width , out int Height )
		{
			int result = dx_GetRectSize( ref Rect , out Width , out Height ) ;
			if( !( result == 0 ) ) { throw new DxLibException(); }
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetRectSize( [ In ] ref RECT Rect , out int Width , out int Height ) ;


		/// <summary> Pʍs𓾂 </summary>
		public static MATRIX MGetIdent()
		{
			MATRIX result = dx_MGetIdent() ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetIdent() ;


		/// <summary> s̏Zs </summary>
		public static MATRIX MMult( MATRIX In1 , MATRIX In2 )
		{
			MATRIX result = dx_MMult( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MMult( MATRIX In1 , MATRIX In2 ) ;


		/// <summary> s̃XP[Os </summary>
		public static MATRIX MScale( MATRIX InM , float Scale )
		{
			MATRIX result = dx_MScale( InM , Scale ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MScale( MATRIX InM , float Scale ) ;


		/// <summary> s̑Zs </summary>
		public static MATRIX MAdd( MATRIX In1 , MATRIX In2 )
		{
			MATRIX result = dx_MAdd( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MAdd( MATRIX In1 , MATRIX In2 ) ;


		/// <summary> gs𓾂 </summary>
		public static MATRIX MGetScale( VECTOR Scale )
		{
			MATRIX result = dx_MGetScale( Scale ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetScale( VECTOR Scale ) ;


		/// <summary> w]s𓾂 </summary>
		public static MATRIX MGetRotX( float XAxisRotate )
		{
			MATRIX result = dx_MGetRotX( XAxisRotate ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetRotX( float XAxisRotate ) ;


		/// <summary> x]s𓾂 </summary>
		public static MATRIX MGetRotY( float YAxisRotate )
		{
			MATRIX result = dx_MGetRotY( YAxisRotate ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetRotY( float YAxisRotate ) ;


		/// <summary> y]s𓾂 </summary>
		public static MATRIX MGetRotZ( float ZAxisRotate )
		{
			MATRIX result = dx_MGetRotZ( ZAxisRotate ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetRotZ( float ZAxisRotate ) ;


		/// <summary> w莲Ŏwpx]s𓾂 </summary>
		public static MATRIX MGetRotAxis( VECTOR RotateAxis , float Rotate )
		{
			MATRIX result = dx_MGetRotAxis( RotateAxis , Rotate ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetRotAxis( VECTOR RotateAxis , float Rotate ) ;


		/// <summary> In1 ̌ In2 ̌֕ϊ]s𓾂( In2  In1 ^t̃xNg̏ꍇ͉]͕s ) </summary>
		public static MATRIX MGetRotVec2( VECTOR In1 , VECTOR In2 )
		{
			MATRIX result = dx_MGetRotVec2( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetRotVec2( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> sړs𓾂 </summary>
		public static MATRIX MGetTranslate( VECTOR Trans )
		{
			MATRIX result = dx_MGetTranslate( Trans ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetTranslate( VECTOR Trans ) ;


		/// <summary> ŵR[J̃xNg{̃xNgɕϊs𓾂( x' = XAxis.x * x + YAixs.x * y + ZAxis.z * z + Pos.x   y' = XAxis.y * x + YAixs.y * y + ZAxis.y * z + Pos.y	  z' = XAxis.z * x + YAixs.z * y + ZAxis.z * z + Pos.z ) </summary>
		public static MATRIX MGetAxis1( VECTOR XAxis , VECTOR YAxis , VECTOR ZAxis , VECTOR Pos )
		{
			MATRIX result = dx_MGetAxis1( XAxis , YAxis , ZAxis , Pos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetAxis1( VECTOR XAxis , VECTOR YAxis , VECTOR ZAxis , VECTOR Pos ) ;


		/// <summary> {̃xNgŵRɓexNgɕϊs𓾂( x' = XAxis.x * ( x - Pos.x ) + XAxis.y * ( x - Pos.x ) + XAxis.z * ( x - Pos.x )	y' = YAxis.x * ( x - Pos.x ) + YAxis.y * ( x - Pos.x ) + YAxis.z * ( x - Pos.x )	z' = ZAxis.x * ( x - Pos.x ) + ZAxis.y * ( x - Pos.x ) + ZAxis.z * ( x - Pos.x ) ) </summary>
		public static MATRIX MGetAxis2( VECTOR XAxis , VECTOR YAxis , VECTOR ZAxis , VECTOR Pos )
		{
			MATRIX result = dx_MGetAxis2( XAxis , YAxis , ZAxis , Pos ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MGetAxis2( VECTOR XAxis , VECTOR YAxis , VECTOR ZAxis , VECTOR Pos ) ;


		/// <summary> ]us𓾂 </summary>
		public static MATRIX MTranspose( MATRIX InM )
		{
			MATRIX result = dx_MTranspose( InM ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MTranspose( MATRIX InM ) ;


		/// <summary> ts𓾂 </summary>
		public static MATRIX MInverse( MATRIX InM )
		{
			MATRIX result = dx_MInverse( InM ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_MInverse( MATRIX InM ) ;


		/// <summary> xNgl̐ </summary>
		public static VECTOR VGet( float x , float y , float z )
		{
			VECTOR result = dx_VGet( x , y , z ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VGet( float x , float y , float z ) ;


		/// <summary> xNg̉Z </summary>
		public static VECTOR VAdd( VECTOR In1 , VECTOR In2 )
		{
			VECTOR result = dx_VAdd( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VAdd( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> xNǧZ </summary>
		public static VECTOR VSub( VECTOR In1 , VECTOR In2 )
		{
			VECTOR result = dx_VSub( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VSub( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> xNg̓ </summary>
		public static float VDot( VECTOR In1 , VECTOR In2 )
		{
			float result = dx_VDot( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VDot( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> xNg̊O </summary>
		public static VECTOR VCross( VECTOR In1 , VECTOR In2 )
		{
			VECTOR result = dx_VCross( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VCross( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> xNg̃XP[O </summary>
		public static VECTOR VScale( VECTOR In , float Scale )
		{
			VECTOR result = dx_VScale( In , Scale ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VScale( VECTOR In , float Scale ) ;


		/// <summary> xNg̐K </summary>
		public static VECTOR VNorm( VECTOR In )
		{
			VECTOR result = dx_VNorm( In ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VNorm( VECTOR In ) ;


		/// <summary> xNg̃TCY </summary>
		public static float VSize( VECTOR In )
		{
			float result = dx_VSize( In ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VSize( VECTOR In ) ;


		/// <summary> xNg̃TCŶQ </summary>
		public static float VSquareSize( VECTOR In )
		{
			float result = dx_VSquareSize( In ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VSquareSize( VECTOR In ) ;


		/// <summary> sgWϊ </summary>
		public static VECTOR VTransform( VECTOR InV , MATRIX InM )
		{
			VECTOR result = dx_VTransform( InV , InM ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VTransform( VECTOR InV , MATRIX InM ) ;


		/// <summary> sgWϊ( XP[O{]̂ ) </summary>
		public static VECTOR VTransformSR( VECTOR InV , MATRIX InM )
		{
			VECTOR result = dx_VTransformSR( InV , InM ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_VTransformSR( VECTOR InV , MATRIX InM ) ;


		/// <summary> ̃xNgp̃RTCl𓾂 </summary>
		public static float VCos( VECTOR In1 , VECTOR In2 )
		{
			float result = dx_VCos( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VCos( VECTOR In1 , VECTOR In2 ) ;


		/// <summary> ̃xNgp̊px𓾂( PʁFWA ) </summary>
		public static float VRad( VECTOR In1 , VECTOR In2 )
		{
			float result = dx_VRad( In1 , In2 ) ;
			return result ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_VRad( VECTOR In1 , VECTOR In2 ) ;
	}
}
