using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public static partial class Window
	{


		/// <summary> gp\ȃtHg̖Oׂė񋓂( NameBuffer  64oCg؂ŖOi[܂ ) </summary>
		public static void EnumFontName( out string[] NameBuffer )
		{
			EnumFontName( out NameBuffer , true ) ;
		}

		/// <summary> gp\ȃtHg̖Oׂė񋓂( NameBuffer  64oCg؂ŖOi[܂ ) </summary>
		public static void EnumFontName( out string[] NameBuffer , bool JapanOnlyFlag )
		{
			lock( locker )
			{
				int NameBufferNum_ = dx_EnumFontName( IntPtr.Zero , 0 , JapanOnlyFlag ) ;
				if( !( NameBufferNum_ >= 0 ) ) { throw new DxLibException() ; }
				IntPtr NameBuffer_ = IntPtr.Zero;

				try
				{
				#if UNICODE
					NameBuffer_ = Marshal.AllocHGlobal( NameBufferNum_ * 64 * 2 ) ;
				#else
					NameBuffer_ = Marshal.AllocHGlobal( NameBufferNum_ * 64 * 1 ) ;
				#endif
					int result = dx_EnumFontName( NameBuffer_ , NameBufferNum_ , JapanOnlyFlag ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
					NameBuffer = new string[ NameBufferNum_ ] ;

					for( int i = 0 ; i < NameBufferNum_ ; i ++ )
					{
						unsafe
						{
						#if UNICODE
							NameBuffer[ i ] = Marshal.PtrToStringUni( ( IntPtr )( ( ushort *)( NameBuffer_ ) + i * 64 ) , 64 ) ;
						#else
							NameBuffer[ i ] = Marshal.PtrToStringAnsi( ( IntPtr )( ( byte *)( NameBuffer_ ) + i * 64 ) , 64 ) ;
						#endif
						}
					}
				}
				finally
				{
					Marshal.FreeHGlobal( NameBuffer_ ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_EnumFontName( IntPtr NameBuffer , int NameBufferNum , bool JapanOnlyFlag ) ;


		/// <summary> gp\ȃtHg̖Oׂė񋓂( NameBuffer  64oCg؂ŖOi[܂ ) </summary>
		public static void EnumFontNameEx( out string[] NameBuffer )
		{
			EnumFontNameEx( out NameBuffer , ( DX_CHARSET )( -1 ) ) ;
		}

		/// <summary> gp\ȃtHg̖Oׂė񋓂( NameBuffer  64oCg؂ŖOi[܂ ) </summary>
		/// <param name="CharSet"> DX_CHARSET_DEFAULT  </param>
		public static void EnumFontNameEx( out string[] NameBuffer , DX_CHARSET CharSet )
		{
			lock( locker )
			{
				int NameBufferNum_ = dx_EnumFontNameEx( IntPtr.Zero , 0 , CharSet ) ;
				if( !( NameBufferNum_ >= 0 ) ) { throw new DxLibException() ; }
				IntPtr NameBuffer_ = IntPtr.Zero;

				try
				{
				#if UNICODE
					NameBuffer_ = Marshal.AllocHGlobal( NameBufferNum_ * 64 * 2 ) ;
				#else
					NameBuffer_ = Marshal.AllocHGlobal( NameBufferNum_ * 64 * 1 ) ;
				#endif
					int result = dx_EnumFontNameEx( NameBuffer_ , NameBufferNum_ , CharSet ) ;
					if( !( result == 0 ) ) { throw new DxLibException(); }
					NameBuffer = new string[ NameBufferNum_ ] ;

					for( int i = 0 ; i < NameBufferNum_ ; i ++ )
					{
						unsafe
						{
						#if UNICODE
							NameBuffer[ i ] = Marshal.PtrToStringUni( ( IntPtr )( ( ushort *)( NameBuffer_ ) + i * 64 ) , 64 ) ;
						#else
							NameBuffer[ i ] = Marshal.PtrToStringAnsi( ( IntPtr )( ( byte *)( NameBuffer_ ) + i * 64 ) , 64 ) ;
						#endif
						}
					}
				}
				finally
				{
					Marshal.FreeHGlobal( NameBuffer_ ) ;
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_EnumFontNameEx( IntPtr NameBuffer , int NameBufferNum , DX_CHARSET CharSet ) ;


		/// <summary> tHg̃Xe[^XftHgɖ߂ </summary>
		public static void InitFontToHandle()
		{
			lock( locker )
			{
				int result = dx_InitFontToHandle() ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_InitFontToHandle() ;


		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick )
		{
			return CreateFontToHandle( FontName , Size , Thick , ( DX_FONTTYPE )( -1 ) ) ;
		}
		
		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType )
		{
			return CreateFontToHandle( FontName , Size , Thick , FontType , ( DX_CHARSET )( -1 ) ) ;
		}
		
		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet )
		{
			return CreateFontToHandle( FontName , Size , Thick , FontType , CharSet , -1 ) ;
		}
		
		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet , int EdgeSize )
		{
			return CreateFontToHandle( FontName , Size , Thick , FontType , CharSet , EdgeSize , false ) ;
		}

		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet , int EdgeSize , bool Italic )
		{
			return CreateFontToHandle( FontName , Size , Thick , FontType , CharSet , EdgeSize , Italic , -1 ) ;
		}

		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet , int EdgeSize , bool Italic , int DataIndex )
		{
			return CreateFontToHandle( FontName , Size , Thick , FontType , CharSet , EdgeSize , Italic , DataIndex , -1 ) ;
		}

		/// <summary> VtHgf[^쐬 </summary>
		public static Font CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet , int EdgeSize , bool Italic , int DataIndex , int ID )
		{
			lock( locker )
			{
				int result = dx_CreateFontToHandle( FontName , Size , Thick , FontType , CharSet , EdgeSize , Italic , DataIndex , ID ) ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Font.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateFontToHandle( string FontName , int Size , int Thick , DX_FONTTYPE FontType , DX_CHARSET CharSet , int EdgeSize , bool Italic , int DataIndex , int ID ) ;


		/// <summary> ԂύX </summary>
		public static void SetFontSpaceToHandle( int Point , Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_SetFontSpaceToHandle( Point , Font.ToHandle( FontHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontSpaceToHandle( int Point , int FontHandle ) ;


		/// <summary> ftHgtHg̃Xe[^Xꊇݒ肷 </summary>
		public static void SetDefaultFontState( string FontName , int Size , int Thick )
		{
			lock( locker )
			{
				int result = dx_SetDefaultFontState( FontName , Size , Thick ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDefaultFontState( string FontName , int Size , int Thick ) ;


		/// <summary>  TRUE ɂtOւ̃|C^ݒ肷 </summary>
		/// <param name="LostFlag"> int * </param>
		public static void SetFontLostFlag( Font FontHandle , IntPtr LostFlag )
		{
			lock( locker )
			{
				int result = dx_SetFontLostFlag( Font.ToHandle( FontHandle ) , LostFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontLostFlag( int FontHandle , IntPtr LostFlag ) ;


		/// <summary> `悷tHg̃TCYZbg </summary>
		public static void SetFontSize( int FontSize )
		{
			lock( locker )
			{
				int result = dx_SetFontSize( FontSize ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontSize( int FontSize ) ;


		/// <summary> tHg̑Zbg </summary>
		public static void SetFontThickness( int ThickPal )
		{
			lock( locker )
			{
				int result = dx_SetFontThickness( ThickPal ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontThickness( int ThickPal ) ;


		/// <summary> ԂύX </summary>
		public static void SetFontSpace( int Point )
		{
			lock( locker )
			{
				int result = dx_SetFontSpace( Point ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontSpace( int Point ) ;


		/// <summary> tHg̃LbVɃeNX`gp邩AtOZbg </summary>
		public static void SetFontCacheToTextureFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetFontCacheToTextureFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontCacheToTextureFlag( bool Flag ) ;


		/// <summary> tHgLbVŃLbVł镶w肷 </summary>
		public static void SetFontCacheCharNum( int CharNum )
		{
			lock( locker )
			{
				int result = dx_SetFontCacheCharNum( CharNum ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFontCacheCharNum( int CharNum ) ;


		/// <summary> tHgύX </summary>
		public static void ChangeFont( string FontName )
		{
			ChangeFont( FontName , ( DX_CHARSET )( -1 ) ) ;
		}

		/// <summary> tHgύX </summary>
		/// <param name="CharSet"> DX_CHARSET_SHFTJIS  </param>
		public static void ChangeFont( string FontName , DX_CHARSET CharSet )
		{
			lock( locker )
			{
				int result = dx_ChangeFont( FontName , CharSet ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeFont( string FontName , DX_CHARSET CharSet ) ;


		/// <summary> tHg^Cv̕ύX </summary>
		public static void ChangeFontType( DX_FONTTYPE FontType )
		{
			lock( locker )
			{
				int result = dx_ChangeFontType( FontType ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeFontType( DX_FONTTYPE FontType ) ;


		/// <summary> FontCacheStringDraw  DrawString gĂ </summary>
		/// <param name="ClipRect"> NULL  </param>
		public static void FontCacheStringDrawToHandle( int x , int y , string StrData , COLOR_U8 Color , COLOR_U8 EdgeColor , BaseImage DestImage , RECT ClipRect , Font FontHandle )
		{
			FontCacheStringDrawToHandle( x , y , StrData , Color , EdgeColor , DestImage , ClipRect , FontHandle , false ) ;
		}

		/// <summary> FontCacheStringDraw  DrawString gĂ </summary>
		/// <param name="ClipRect"> NULL  </param>
		public static void FontCacheStringDrawToHandle( int x , int y , string StrData , COLOR_U8 Color , COLOR_U8 EdgeColor , BaseImage DestImage , RECT ClipRect , Font FontHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_FontCacheStringDrawToHandle( x , y , StrData , Color , EdgeColor , ref DestImage.buffer , ref ClipRect , Font.ToHandle( FontHandle ) , VerticalFlag , IntPtr.Zero ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

		/// <summary> FontCacheStringDraw  DrawString gĂ </summary>
		/// <param name="ClipRect"> NULL  </param>
		public static void FontCacheStringDrawToHandle( int x , int y , string StrData , COLOR_U8 Color , COLOR_U8 EdgeColor , BaseImage DestImage , RECT ClipRect , Font FontHandle , bool VerticalFlag , SIZE DrawSizeP )
		{
			lock( locker )
			{
				int result = dx_FontCacheStringDrawToHandle( x , y , StrData , Color , EdgeColor , ref DestImage.buffer , ref ClipRect , Font.ToHandle( FontHandle ) , VerticalFlag , ref DrawSizeP ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FontCacheStringDrawToHandle( int x , int y , string StrData , COLOR_U8 Color , COLOR_U8 EdgeColor , [ In ] ref BASEIMAGE DestImage , [ In ] ref RECT ClipRect , int FontHandle , bool VerticalFlag , IntPtr DrawSizeP ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FontCacheStringDrawToHandle( int x , int y , string StrData , COLOR_U8 Color , COLOR_U8 EdgeColor , [ In ] ref BASEIMAGE DestImage , [ In ] ref RECT ClipRect , int FontHandle , bool VerticalFlag , [ In ] ref SIZE DrawSizeP ) ;


		/// <summary> {C[WɕC[W] </summary>
		public static void FontBaseImageBlt( int x , int y , string StrData , BaseImage DestImage , BaseImage DestEdgeImage )
		{
			FontBaseImageBlt( x , y , StrData , DestImage , DestEdgeImage , false ) ;
		}

		/// <summary> {C[WɕC[W] </summary>
		public static void FontBaseImageBlt( int x , int y , string StrData , BaseImage DestImage , BaseImage DestEdgeImage , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_FontBaseImageBlt( x , y , StrData , ref DestImage.buffer , ref DestEdgeImage.buffer , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FontBaseImageBlt( int x , int y , string StrData , [ In , Out ] ref BASEIMAGE DestImage , [ In , Out ] ref BASEIMAGE DestEdgeImage , bool VerticalFlag ) ;


		/// <summary> {C[WɕC[W] </summary>
		public static void FontBaseImageBltToHandle( int x , int y , string StrData , BaseImage DestImage , BaseImage DestEdgeImage , Font FontHandle )
		{
			FontBaseImageBltToHandle( x , y , StrData , DestImage , DestEdgeImage , FontHandle , false ) ;
		}

		/// <summary> {C[WɕC[W] </summary>
		public static void FontBaseImageBltToHandle( int x , int y , string StrData , BaseImage DestImage , BaseImage DestEdgeImage , Font FontHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_FontBaseImageBltToHandle( x , y , StrData , ref DestImage.buffer , ref DestEdgeImage.buffer , Font.ToHandle( FontHandle ) , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FontBaseImageBltToHandle( int x , int y , string StrData , [ In , Out ] ref BASEIMAGE DestImage , [ In , Out ] ref BASEIMAGE DestEdgeImage , int FontHandle , bool VerticalFlag ) ;


		/// <summary> ̍ő啝𓾂 </summary>
		public static int GetFontMaxWidth()
		{
			lock( locker )
			{
				int result = dx_GetFontMaxWidth() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontMaxWidth() ;


		/// <summary> ̍ő啝𓾂 </summary>
		public static int GetFontMaxWidthToHandle( Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_GetFontMaxWidthToHandle( Font.ToHandle( FontHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontMaxWidthToHandle( int FontHandle ) ;


		/// <summary> ̕𓾂 </summary>
		public static int GetDrawStringWidth( string String )
		{
			return GetDrawStringWidth( String , false ) ;
		}

		/// <summary> ̕𓾂 </summary>
		public static int GetDrawStringWidth( string String , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_GetDrawStringWidth( String , String.Length , VerticalFlag ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawStringWidth( string String , int StrLen , bool VerticalFlag ) ;


		/// <summary> ̕𓾂 </summary>
		public static int GetDrawStringWidthToHandle( string String , Font FontHandle )
		{
			return GetDrawStringWidthToHandle( String , FontHandle , false ) ;
		}

		/// <summary> ̕𓾂 </summary>
		public static int GetDrawStringWidthToHandle( string String , Font FontHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_GetDrawStringWidthToHandle( String , String.Length , Font.ToHandle( FontHandle ) , VerticalFlag ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

		/// <summary> ̕𓾂 </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawStringWidthToHandle( string String , int StrLen , int FontHandle , bool VerticalFlag ) ;


		/// <summary> ̕𓾂 </summary>
		public static int GetDrawExtendStringWidth( double ExRateX , string String )
		{
			return GetDrawExtendStringWidth( ExRateX , String , false ) ;
		}

		/// <summary> ̕𓾂 </summary>
		public static int GetDrawExtendStringWidth( double ExRateX , string String , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_GetDrawExtendStringWidth( ExRateX , String , String.Length , VerticalFlag ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawExtendStringWidth( double ExRateX , string String , int StrLen , bool VerticalFlag ) ;


		/// <summary> ̕𓾂 </summary>
		public static int GetDrawExtendStringWidthToHandle( double ExRateX , string String , Font FontHandle )
		{
			return GetDrawExtendStringWidthToHandle( ExRateX , String , FontHandle , false ) ;
		}

		/// <summary> ̕𓾂 </summary>
		public static int GetDrawExtendStringWidthToHandle( double ExRateX , string String , Font FontHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_GetDrawExtendStringWidthToHandle( ExRateX , String , String.Length , Font.ToHandle( FontHandle ) , VerticalFlag ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawExtendStringWidthToHandle( double ExRateX , string String , int StrLen , int FontHandle , bool VerticalFlag ) ;


		/// <summary> tHg̏𓾂 </summary>
		public static void GetFontStateToHandle( out string FontName , out int Size , out int Thick , Font FontHandle )
		{
			lock( locker )
			{
				StringBuilder FontName_ = new StringBuilder( 0x200 ) ;
				int result = dx_GetFontStateToHandle( FontName_ , out Size , out Thick , Font.ToHandle( FontHandle ) ) ;
				if( !( result == 0 ) ) { throw new DxLibException(); }
				FontName = FontName_.ToString() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontStateToHandle( [ Out ] StringBuilder FontName , out int Size , out int Thick , int FontHandle ) ;


		/// <summary> ftHg̃tHg̃nh𓾂 </summary>
		public static Font GetDefaultFontHandle()
		{
			lock( locker )
			{
				int result = dx_GetDefaultFontHandle() ;
				if( !( result != -1 ) ) { throw new DxLibException(); }
				return Font.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDefaultFontHandle() ;


		/// <summary> tHgɃeNX`LbVgp邩ǂ擾 </summary>
		public static bool GetFontCacheToTextureFlag()
		{
			lock( locker )
			{
				int result = dx_GetFontChacheToTextureFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontChacheToTextureFlag() ;


		/// <summary> w̃tHgeNX`LbVgpĂ邩ǂ𓾂 </summary>
		public static bool CheckFontCacheToTextureFlag( Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_CheckFontChacheToTextureFlag( Font.ToHandle( FontHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckFontChacheToTextureFlag( int FontHandle ) ;


		/// <summary> w̃tHgnhLۂׂ </summary>
		public static bool CheckFontHandleValid( Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_CheckFontHandleValid( Font.ToHandle( FontHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckFontHandleValid( int FontHandle ) ;


		/// <summary> QoCgׂ( TRUE:QoCg  FALSE:PoCg ) </summary>
		/// <param name="CharSet"> DX_CHARSET_SHFTJIS </param>
		public static bool MultiByteCharCheck( byte Buf , DX_CHARSET CharSet )
		{
			lock( locker )
			{
				int result = dx_MultiByteCharCheck( ref Buf , CharSet ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DxLibException() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MultiByteCharCheck( [ In ] ref byte Buf , DX_CHARSET CharSet ) ;


		/// <summary> tHgLbVŃLbVł镶擾( ߂l  0:ftHg  1ȏ:w蕶 ) </summary>
		public static int GetFontCacheCharNum()
		{
			lock( locker )
			{
				int result = dx_GetFontCacheCharNum() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontCacheCharNum() ;


		/// <summary> tHg̃TCY𓾂 </summary>
		public static int GetFontSize()
		{
			lock( locker )
			{
				int result = dx_GetFontSize() ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontSize() ;


		/// <summary> tHg̃TCY𓾂 </summary>
		public static int GetFontSizeToHandle( Font FontHandle )
		{
			lock( locker )
			{
				int result = dx_GetFontSizeToHandle( Font.ToHandle( FontHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DxLibException(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetFontSizeToHandle( int FontHandle ) ;
	}
}
