using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class Sound : Handler< Sound >
	{

		internal static Sound FromHandle( int handle )
		{
			Sound handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new Sound( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private Sound( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteSoundMem( handle , Window.LogOutFlag ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteSoundMem( int SoundHandle , bool LogOutFlag ) ;
	}


	public static partial class Window
	{

		/// <summary> ɓǂݍWAVEf[^폜 </summary>
		public static void DeleteSoundMem( SoftSound SoundHandle )
		{
			Disposable.Dispose( SoundHandle ) ;
		}
	}
}
