using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class SoftSoundPlayer : Handler< SoftSoundPlayer >
	{

		internal static SoftSoundPlayer FromHandle( int handle )
		{
			SoftSoundPlayer handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new SoftSoundPlayer( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private SoftSoundPlayer( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteSoftSoundPlayer( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteSoftSoundPlayer( int SSoundPlayerHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> \tgEGAňg`f[^̃vC[폜 </summary>
		public static void DeleteSoftSoundPlayer( SoftSoundPlayer SSoundPlayerHandle )
		{
			Disposable.Dispose( SSoundPlayerHandle ) ;
		}
	}
}
