using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class SoftSound : Handler< SoftSound >
	{

		internal static SoftSound FromHandle( int handle )
		{
			SoftSound handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new SoftSound( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private SoftSound( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteSoftSound( handle ) ;
			}
		}

		/// <summary> \tgEGAňg`f[^ </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteSoftSound( int SoftSoundHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> \tgEGAňg`f[^ </summary>
		public static void DeleteSoftSound( SoftSound SoftSoundHandle )
		{
			Disposable.Dispose( SoftSoundHandle ) ;
		}
	}
}
