using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class SoftImage : Handler< SoftImage >
	{

		internal static SoftImage FromHandle( int handle )
		{
			SoftImage handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new SoftImage( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private SoftImage( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteSoftImage( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteSoftImage( int SIHandle ) ;
	}


	public static partial class Window
	{


		/// <summary> \tgEGAňC[W̉ </summary>
		public static void DeleteSoftImage( SoftImage SIHandle )
		{
			SoftImage.Dispose( SIHandle ) ;
		}
	}
}
