using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class Shader : Handler< Shader >
	{

		internal static Shader FromHandle( int handle )
		{
			Shader handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new Shader( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private Shader( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteShader( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteShader( int ShaderHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> VF[_[nh̍폜 </summary>
		public static void DeleteShader( Shader ShaderHandle )
		{
			Disposable.Dispose( ShaderHandle ) ;
		}
	}
}
