﻿using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


#if UNICODE
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
#else
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
#endif
	public struct RECT
	{

		public int left ;

		public int top ;

		public int right ;

		public int bottom ;

		public int x
		{
			get { return this.left ; }
		}

		public int y
		{
			get { return this.top ; }
		}

		public int cx
		{
			get { return this.right - this.left ; }
		}

		public int cy
		{
			get { return this.bottom - this.top ; }
		}

		public RECT( int left , int top , int right , int bottom )
		{
			this.left = left ;
			this.top = top ;
			this.right = right ;
			this.bottom = bottom ;
		}

		public RECT( POINT leftTop , POINT rightBottom )
		{
			this.left = leftTop.x ;
			this.top = leftTop.y ;
			this.right = rightBottom.x ;
			this.bottom = rightBottom.y ;
		}

		public RECT( POINT point , SIZE size )
		{
			this.left = point.x ;
			this.top = point.y ;
			this.right = size.cx ;
			this.bottom = size.cy ;
		}
	}
}
