using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class NetWorkUDP : Handler< NetWorkUDP >
	{

		internal static NetWorkUDP FromHandle( int handle )
		{
			NetWorkUDP handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new NetWorkUDP( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private NetWorkUDP( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteUDPSocket( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteUDPSocket( int NetUDPHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> UDPgpʐMs\Pbgnh폜 </summary>
		public static void DeleteUDPSocket( NetWorkUDP NetUDPHandle )
		{
			Disposable.Dispose( NetUDPHandle ) ;
		}
	}
}
