using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class MovieToOverlay : Handler< MovieToOverlay >
	{

		internal static MovieToOverlay FromHandle( int handle )
		{
			MovieToOverlay handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new MovieToOverlay( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private MovieToOverlay( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_CloseMovieToOverlay( handle ) ;
			}
		}

		/// <summary> I[o[CT[tFXgp[r[t@C </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CloseMovieToOverlay( int MovieHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> I[o[CT[tFXgp[r[t@C </summary>
		public static void CloseMovieToOverlay( MovieToOverlay MovieHandle )
		{
			Disposable.Dispose( MovieHandle ) ;
		}
	}
}
