using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class Movie : Handler< Movie >
	{

		internal static Movie FromHandle( int handle )
		{
			Movie handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new Movie( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
;
		}

		private Movie( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteGraph( handle , Window.LogOutFlag ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		internal static extern int dx_DeleteGraph( int GrHandle , bool LogOutFlag ) ;
	}


	public static partial class Window
	{

		/// <summary> w̃OtBbNnh폜 </summary>
		public static void DeleteGraph( Movie GrHandle )
		{
			Disposable.Dispose( GrHandle ) ;
		}
	}
}
