using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class Mask : Handler< Mask >
	{

		internal static Mask FromHandle( int handle )
		{
			Mask handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new Mask( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		internal static Mask[] FromHandleArray( int[] handles )
		{
			if( handles != null )
			{
				Mask[] handlers = new Mask[ handles.Length ] ;

				for( int i = 0 ; i < handlers.Length ; i ++ )
				{
					handlers[ i ] = Mask.FromHandle( handles[ i ] ) ;
				}

				return handlers ;
			}
			else
			{
				return null ;
			}
		}

		private Mask( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteMask( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMask( int MaskHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> }XNf[^폜 </summary>
		public static void DeleteMask( Mask MaskHandle )
		{
			Disposable.Dispose( MaskHandle ) ;
		}
	}
}
