using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class Light : Handler< Light >
	{

		internal static Light FromHandle( int handle )
		{
			Light handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new Light( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private Light( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteLightHandle( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteLightHandle( int LHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> Cgnh폜 </summary>
		public static void DeleteLightHandle( Light LHandle )
		{
			Disposable.Dispose( LHandle ) ;
		}
	}
}
