using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	public sealed class KeyInput : Handler< KeyInput >
	{

		internal static KeyInput FromHandle( int handle , int length )
		{
			KeyInput handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new KeyInput( handle, length ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		internal static KeyInput FromHandle( int handle )
		{
			return FindHandler( handle ) ;
		}

		private KeyInput( int handle , int length ) : base( handle )
		{
			this.length = length ;
		}

		internal readonly int length ;

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_DeleteKeyInput( handle ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteKeyInput( int InputHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> L[̓f[^̍폜 </summary>
		public static void DeleteKeyInput( KeyInput InputHandle )
		{
			KeyInput.Dispose( InputHandle ) ;
		}
	}
}
