using System ;
using System.Diagnostics ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{
	public sealed class FileStream : Handler< FileStream >
	{

		internal static FileStream FromHandle( int handle )
		{
			FileStream handler = FindHandler( handle ) ;

			if( handler != null )
			{
				return handler ;
			}
			else
			{
				handler = new FileStream( handle ) ;
				AddHandler( handle, handler ) ;
				return handler ;
			}
		}

		private FileStream( int handle ) : base( handle )
		{
		}

		internal protected override sealed void DestructHandler( int handle )
		{
			lock( Window.locker )
			{
				int result = dx_FileRead_close( handle ) ;
			}
		}

		/// <summary> t@C </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FileRead_close( int FileHandle ) ;
	}


	public static partial class Window
	{

		/// <summary> t@C </summary>
		public static void FileRead_close( FileStream FileHandle )
		{
			Disposable.Dispose( FileHandle ) ;
		}
	}
}
