﻿using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	/// <summary> unsigned char 型のカラー値 </summary>
#if UNICODE
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
#else
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
#endif
	public struct COLOR_U8
	{

		public byte b ;

		public byte g ;

		public byte r ;

		public byte a ;

		public static readonly COLOR_U8 Empty = new COLOR_U8( 0x00 , 0x00 , 0x00 , 0x00 ) ;

		public COLOR_U8( int argb )
		{
			this.b = ( byte )( ( argb >> 0 ) & 0xFF ) ;
			this.g = ( byte )( ( argb >> 8 ) & 0xFF ) ;
			this.r = ( byte )( ( argb >> 16 ) & 0xFF ) ;
			this.a = ( byte )( ( argb >> 24 ) & 0xFF ) ;
		}

		public COLOR_U8( int r , int g , int b )
		{
			this.b = ( byte )( b ) ;
			this.g = ( byte )( g ) ;
			this.r = ( byte )( r ) ;
			this.a = 0 ;
		}

		public COLOR_U8( int r , int g , int b , int a )
		{
			this.b = ( byte )( b ) ;
			this.g = ( byte )( g ) ;
			this.r = ( byte )( r ) ;
			this.a = ( byte )( a ) ;
		}

		public int ToInt()
		{
			return ( ( int )( this.a ) << 24 ) | ( ( int )( this.r ) << 16 ) | ( ( int )( this.g ) << 8 ) | ( ( int )( this.b ) << 0 ) ;
		}
	}
}
