using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace Importing.DxLib
{


	/// <summary> {C[Wf[^\ </summary>
	public sealed class BaseImage : Disposable
	{

		/// <summary> F </summary>
		public COLORDATA ColorData
		{
			get { return buffer.ColorData ; }
		}

		/// <summary> AAsb` </summary>
		public int Width
		{
			get { return buffer.Width ; }
		}

		/// <summary> AAsb` </summary>
		public int Height
		{
			get { return buffer.Height ; }
		}

		/// <summary> AAsb` </summary>
		public int Pitch
		{
			get { return buffer.Pitch ; }
		}

		/// <summary> OtBbNC[W </summary>
		public IntPtr GraphData
		{
			get { return buffer.GraphData ; }
		}

		/// <summary> ~bv}bv̐ </summary>
		public int MipMapCount
		{
			get { return buffer.MipMapCount ; }
		}

		internal BaseImage( BASEIMAGE buffer )
		{
			this.buffer = buffer ;
		}

		internal protected sealed override void Construct()
		{
			buffer = new BASEIMAGE() ;
		}

		internal protected override sealed void Destruct()
		{
			lock( Window.locker )
			{
				int result = dx_ReleaseBaseImage( ref buffer ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReleaseBaseImage( [ In , Out ] ref BASEIMAGE BaseImage ) ;

		internal BASEIMAGE buffer ;
	}


	public static partial class Window
	{

		/// <summary> {C[Wf[^̌ns </summary>
		public static void ReleaseBaseImage( BaseImage BaseImage )
		{
			Disposable.Dispose( BaseImage ) ;
		}

		/// <summary> ReleaseBaseImage ̋ </summary>
		public static void ReleaseGraphImage( BaseImage GraphImage )
		{
			Disposable.Dispose( GraphImage ) ;
		}
	}


	/// <summary> {C[Wf[^\ </summary>
#if UNICODE
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
#else
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
#endif
	public struct BASEIMAGE
	{

		/// <summary> F </summary>
		public COLORDATA ColorData ;

		/// <summary> AAsb` </summary>
		public int Width ;

		/// <summary> AAsb` </summary>
		public int Height ;

		/// <summary> AAsb` </summary>
		public int Pitch ;

		/// <summary> OtBbNC[W </summary>
		public IntPtr GraphData ;

		/// <summary> ~bv}bv̐ </summary>
		public int MipMapCount ;
	}


	/// <summary> J[\\ </summary>
#if UNICODE
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
#else
	[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
#endif
	public struct COLORDATA
	{

		/// <summary> rbg[x( ̒lȌꍇ Format LɂȂ ) </summary>
		public int ColorBitDepth
		{
			get { return this.ColorBitDepth_ ; }
			set { this.ColorBitDepth_ = value ; }
		}

		private int ColorBitDepth_ ;

		/// <summary> PsNZ̃oCg </summary>
		public int PixelByte
		{
			get { return this.PixelByte_ ; }
			set { this.PixelByte_ = value ; }
		}

		private int PixelByte_ ;

		/// <summary> eF̃rbg </summary>
		public int RedWidth
		{
			get { return this.RedWidth_ ; }
			set { this.RedWidth_ = value ; }
		}

		private int RedWidth_ ;

		/// <summary> eF̃rbg </summary>
		public int GreenWidth
		{
			get { return this.GreenWidth_ ; }
			set { this.GreenWidth_ = value ; }
		}

		private int GreenWidth_ ;

		/// <summary> eF̃rbg </summary>
		public int BlueWidth
		{
			get { return this.BlueWidth_ ; }
			set { this.BlueWidth_ = value ; }
		}

		private int BlueWidth_ ;

		/// <summary> eF̃rbg </summary>
		public int AlphaWidth
		{
			get { return this.AlphaWidth_ ; }
			set { this.AlphaWidth_ = value ; }
		}

		private int AlphaWidth_ ;

		/// <summary> eF̔zuĂrbgAhX </summary>
		public int RedLoc
		{
			get { return this.RedLoc_ ; }
			set { this.RedLoc_ = value ; }
		}

		private int RedLoc_ ;

		/// <summary> eF̔zuĂrbgAhX </summary>
		public int GreenLoc
		{
			get { return this.GreenLoc_ ; }
			set { this.GreenLoc_ = value ; }
		}

		private int GreenLoc_ ;

		/// <summary> eF̔zuĂrbgAhX </summary>
		public int BlueLoc
		{
			get { return this.BlueLoc_ ; }
			set { this.BlueLoc_ = value ; }
		}

		private int BlueLoc_ ;

		/// <summary> eF̔zuĂrbgAhX </summary>
		public int AlphaLoc
		{
			get { return this.AlphaLoc_ ; }
			set { this.AlphaLoc_ = value ; }
		}

		private int AlphaLoc_ ;

		/// <summary> eF̃rbg}XN </summary>
		public int RedMask
		{
			get { return this.RedMask_ ; }
			set { this.RedMask_ = value ; }
		}

		private int RedMask_ ;

		/// <summary> eF̃rbg}XN </summary>
		public int GreenMask
		{
			get { return this.GreenMask_ ; }
			set { this.GreenMask_ = value ; }
		}

		private int GreenMask_ ;

		/// <summary> eF̃rbg}XN </summary>
		public int BlueMask
		{
			get { return this.BlueMask_ ; }
			set { this.BlueMask_ = value ; }
		}

		private int BlueMask_ ;

		/// <summary> eF̃rbg}XN </summary>
		public int AlphaMask
		{
			get { return this.AlphaMask_ ; }
			set { this.AlphaMask_ = value ; }
		}

		private int AlphaMask_ ;

		/// <summary> gĂȂrbg̃}XN </summary>
		public int NoneMask
		{
			get { return this.NoneMask_ ; }
			set { this.NoneMask_ = value ; }
		}

		private int NoneMask_ ;

		/// <summary> pbg(rbg[xWȉ̏ꍇ̂ݗL) </summary>
		public COLOR_U8[] Palette
		{
			get { return this.Palette_ != null ? ( COLOR_U8[] )( this.Palette_.Clone() ) : null ; }
			set { this.Palette_ = value ; }
		}

 		[ MarshalAs( UnmanagedType.ByValArray , SizeConst = 256 ) ]
		private COLOR_U8[] Palette_ ;

		/// <summary> gĂȂrbg̃AhXƕ </summary>
		public int NoneLoc
		{
			get { return this.NoneLoc_ ; }
			set { this.NoneLoc_ = value ; }
		}

		private int NoneLoc_ ;

		/// <summary> gĂȂrbg̃AhXƕ </summary>
		public int NoneWidth
		{
			get { return this.NoneWidth_ ; }
			set { this.NoneWidth_ = value ; }
		}

		private int NoneWidth_ ;

		/// <summary> tH[}bg( DX_BASEIMAGE_FORMAT_NORMAL  ) </summary>
		public DX_BASEIMAGE_FORMAT Format
		{
			get { return this.Format_ ; }
			set { this.Format_ = value ; }
		}

		private DX_BASEIMAGE_FORMAT Format_ ;
	}
}
