/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

import java.util.HashMap;
import java.util.Map;

public class CpreSymbol extends CpreToken {

	private String name;

	private static Map<String, CpreSymbol> vars =
		new HashMap<String, CpreSymbol>();

	private CpreSymbol(String name) {
		super("variable: " + name);
		this.name = name;
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public static CpreSymbol getInstance(String name) {
		CpreSymbol v;

		if((v = vars.get(name)) == null) {
			vars.put(name, v = new CpreSymbol(name));
		}
		return v;
	}

	public String getString() {
		return name;
	}

}
