/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/10
 */
public interface NinaLanguageOption {

	/**
	 * 
	 * @return
	 */
	public String getLookahead();

	/**
	 * 
	 * @return
	 */
	public String getLookaheadCommit();

	/**
	 * 
	 * @return
	 */
	public String getLookaheadMark();

	/**
	 * 
	 * @return
	 */
	public String getLookaheadMarkInit();

	/**
	 * 
	 * @return
	 */
	public String getUnget();

	/**
	 * 
	 * @param k
	 * @return
	 */
	public String getAssignArray(String s, int k);

	/**
	 * 
	 * @return
	 */
	public String getInitBuffer(String s);

	/**
	 * 
	 * @param k
	 * @return
	 */
	public String getAppendBuffer(String s);

	/**
	 * 
	 * @param s
	 * @param ch
	 * @return
	 */
	public String getAppendBuffer(String s, int ch);

	/**
	 * 
	 * @param s
	 * @param bufferVariable
	 * @param radix
	 * @return
	 */
	public String getAppendBuffer(String s, String bufferVariable,
			int radix);

	/**
	 * 
	 * @return
	 */
	public String getInitList();

	/**
	 * 
	 * @return
	 */
	public String getAddList();

	/**
	 * 
	 * @return
	 */
	public String getSeparator();

	/**
	 * 
	 * @return
	 */
	public String getSequenceBufferName();

	/**
	 * 
	 * @param suffix
	 * @return
	 */
	public String getSequenceBufferName(String suffix);

	/**
	 * 
	 * @param radix
	 * @return
	 */
	public String getBufferToInteger(int radix);

	/**
	 * 
	 * @param bufferVariable
	 * @param radix
	 * @return
	 */
	public String getBufferToInteger(String bufferVariable, int radix);

	/**
	 * 
	 * @param radix
	 * @return
	 */
	public String getBufferToBigInteger(int radix);

	/**
	 * 
	 * @return
	 */
	public String getBufferToNumberInteger();

	/**
	 * 
	 * @return
	 */
	public String getBufferToNumberDouble();

	/**
	 * 
	 * @param cmp
	 * @param off
	 * @return
	 */
	public String getIndent(String cmp, int off);

}
