/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/16
 */
public class CpreIntegerToken extends CpreToken {

	private long value;

	public CpreIntegerToken(String x, int radix) {
		super(x);
		value = Long.parseLong(x);
	}

	public CpreIntegerToken(long x) {
		super(Long.toString(x));
		value = x;
	}

	public long getInteger() {
		return value;
	}

	public int hashCode() {
		return (int)value;
	}

	public boolean equals(Object o) {
		if(o instanceof CpreIntegerToken) {
			return value == ((CpreIntegerToken)o).value;
		}
		return false;
	}

}
