/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LRAction;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantTerminal;
import net.morilib.deculture.misc.DecultureException;
import net.morilib.deculture.misc.PrecedenceTerminal;
import net.morilib.deculture.misc.SubautomatonTerminal;
import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.nina.LRObject;
import net.morilib.nina.Quadro;
import net.morilib.nina.translate.LRActionConverter;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class LRTranslatorJavaScript
extends LRTranslator {
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");
    private static final Pattern E_STR = Pattern.compile("\"(.*)\"");

    LRTranslatorJavaScript(Quadro q) {
        super(q);
    }

    private void _put0(LRObject lr, GrammarSymbol g, String f, PrintStream out) {
        if (g instanceof CharacterTerminal) {
            int c = ((CharacterTerminal)g).getCharacter();
            out.printf("\t\t%sif(this.__eq(__t, %d)) {\n", f, c);
        } else if (g instanceof ConstantTerminal) {
            String x = lr.getDefinition().getType(((ConstantTerminal)g).getConstant());
            if (x.equalsIgnoreCase("Number") || x.equalsIgnoreCase("String") || x.equalsIgnoreCase("Boolean")) {
                out.printf("\t\t%sif(typeof __t == '%s') {\n", f, x.toLowerCase());
            } else if (E_CONST.matcher(x).matches()) {
                out.printf("\t\t%sif(this.__eq(__t, %s)) {\n", f, x);
            } else if (E_STR.matcher(x).matches()) {
                out.printf("\t\t%sif(__eq(__t, %s)) {\n", f, x);
            } else {
                out.printf("\t\t%sif(__t instanceof %s) {\n", f, x);
            }
        } else if (g instanceof PrecedenceTerminal) {
            this._put0(lr, ((PrecedenceTerminal)g).getWrapee(), f, out);
        }
    }

    private SubautomatonTerminal _put(LRObject lr, Puts p, int st, GrammarSymbol g, String f, PrintStream out) {
        if (g instanceof CharacterTerminal) {
            this._put0(lr, g, f, out);
            p.put(out, lr, f, st, g);
        } else if (g instanceof ConstantTerminal) {
            this._put0(lr, g, f, out);
            p.put(out, lr, f, st, g);
        } else if (g instanceof PrecedenceTerminal) {
            this._put0(lr, g, f, out);
            p.put(out, lr, f, st, g);
        } else if (g != ContextFreeGrammar.ENDMARKER) {
            throw new DecultureException(g.toString());
        }
        return null;
    }

    @Override
    public String getReturn() {
        return "__b__";
    }

    @Override
    public void translateVariable(StringBuffer buf, DecultureDefinition def, Object g, int z, boolean bury) {
        if (g instanceof ConstantTerminal) {
            Matcher m;
            String s = ((ConstantTerminal)g).getConstant();
            if ((s = def.getType(s)) != null && (m = E_STR.matcher(s)).matches()) {
                buf.append(bury ? m.group(1) : s);
            } else {
                buf.append(String.format("(this._refv(%d))", z));
            }
        } else if (g instanceof PrecedenceTerminal) {
            this.translateVariable(buf, def, ((PrecedenceTerminal)g).getWrapee(), z, bury);
        } else {
            buf.append(String.format("(this._refv(%d))", z));
        }
    }

    @Override
    public void setCommands(ShNinatBuiltInCommands c) {
        c.putCommand("put_shift", new PutShift());
        c.putCommand("put_reduce", new PutReduce());
        c.putCommand("put_accept", new PutAccept());
        c.putCommand("put_goto", new PutGoto());
        c.putCommand("put_grammar_initial", new PutGrammarInitial());
        c.putCommand("cat_definition", new LRTranslator.CatDefinitionPart(this));
        c.putCommand("echo_lexer", new LRTranslator.EchoLexer(this));
    }

    private class PutAccept
    extends Puts {
        private PutAccept() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isAccept();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (a.isAccept()) {
                out.printf("\t\t\treturn true;\n", new Object[0]);
            }
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            out.printf("\t\t\treturn false;\n", new Object[0]);
        }
    }

    private class PutGoto
    implements ShProcess {
        private PutGoto() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream out, PrintStream stderr, String ... args) throws IOException {
            LRObject lr = LRTranslatorJavaScript.this.getlr(args);
            int k = 0;
            while (k < lr.getTable().getSizeOfStates()) {
                out.printf("\tcase %d:\n", k);
                Set<Map.Entry<Nonterminal, Integer>> s = lr.getTable().goTos(k).entrySet();
                String f = "";
                for (Map.Entry<Nonterminal, Integer> e : s) {
                    int n = lr.getNonterminalNumber(e.getKey());
                    out.printf("\t\t%sif(__n == %d) {\n", f, n);
                    out.printf("\t\t\treturn %d;\n", e.getValue());
                    f = "} else ";
                }
                if (!f.equals("")) {
                    out.printf("\t\t}\n", new Object[0]);
                }
                out.printf("\t\tthrow \"RuntimeException\";\n", new Object[0]);
                ++k;
            }
            return 0;
        }
    }

    private class PutGrammarInitial
    implements ShProcess {
        private PutGrammarInitial() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
            LRObject lr = LRTranslatorJavaScript.this.getlr(args);
            int s = lr.getStartNumber();
            out.printf("\t\t$this.__state = %d << LRSTATESHIFT;\n", s);
            out.printf("\t\tthis.__synarray[0] = %d << LRSTATESHIFT;\n", s);
            return 0;
        }
    }

    private class PutReduce
    extends Puts {
        private PutReduce() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isReduce();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (!a.isReduce()) {
                return;
            }
            ContextFreeRule r = a.getReduceRule();
            int l = r.getDerivedSymbolLength();
            Object o = lr.getActionMap().get(a.getReduceRule());
            if (o != null) {
                out.printf("\t\t\t__b__ = null;\n", l);
                String s = LRActionConverter.translate(r, lr.getDefinition(), o.toString(), LRTranslatorJavaScript.this);
                out.printf("\t\t\t%s\n", s);
            } else if (l > 0) {
                String s = LRActionConverter.translate(r, lr.getDefinition(), "$$ = $1;", LRTranslatorJavaScript.this);
                out.printf("\t\t\t%s\n", s);
            } else {
                out.printf("\t\t\t__b__ = null;\n", l);
            }
            out.printf("\t\t\tthis._pop(%d);\n", l);
            out.printf("\t\t\t__k = this.getGoto(this._refsyn(), %d);\n", lr.getNonterminalNumber(r.getLeftSymbol()));
            out.printf("\t\t\tthis._push(__k, __b__);\n", new Object[0]);
            out.printf("\t\t\treturn __k;\n", new Object[0]);
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            out.printf("\t\t\treturn -1;\n", new Object[0]);
        }
    }

    private class PutShift
    extends Puts {
        private PutShift() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isShift();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (a.isShift()) {
                out.printf("\t\t\treturn %d;\n", a.getNextStateID());
            }
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            if (g == null) {
                out.printf("\t\treturn -1;\n", new Object[0]);
            } else {
                LRAction a = lr.getTable().action(st, g);
                if (a.isShift()) {
                    out.printf("\t\t$this.__stkpush(%d, $this.ENGINE_%s);\n", a.getNextStateID(), g.getSubautomaton());
                    out.printf("\t\treturn %d;\n", -(a.getNextStateID() + 2));
                } else {
                    out.printf("\t\treturn -1;\n", new Object[0]);
                }
            }
        }
    }

    private abstract class Puts
    implements ShProcess {
        private Puts() {
        }

        abstract boolean isput(LRObject var1, int var2, GrammarSymbol var3);

        abstract void put(PrintStream var1, LRObject var2, String var3, int var4, GrammarSymbol var5);

        abstract void end(PrintStream var1, LRObject var2, int var3, SubautomatonTerminal var4);

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
            LRObject lr = LRTranslatorJavaScript.this.getlr(args);
            int k = 0;
            while (k < lr.getTable().getSizeOfStates()) {
                stdout.printf("\tcase %d:\n", k);
                Set<Map.Entry<GrammarSymbol, LRAction>> s = lr.getTable().actions(k).entrySet();
                String f = "";
                SubautomatonTerminal g = null;
                GrammarSymbol l = null;
                for (Map.Entry<GrammarSymbol, LRAction> e : s) {
                    if (!this.isput(lr, k, e.getKey())) continue;
                    if (e.getKey() == ContextFreeGrammar.ENDMARKER) {
                        l = e.getKey();
                        continue;
                    }
                    SubautomatonTerminal h = LRTranslatorJavaScript.this._put(lr, this, k, e.getKey(), f, stdout);
                    f = h != null ? f : "} else ";
                    SubautomatonTerminal subautomatonTerminal = g = h != null ? h : g;
                }
                if (l != null) {
                    stdout.printf("\t\t%s{\n", f);
                    this.put(stdout, lr, f, k, l);
                    stdout.printf("\t\t}\n", new Object[0]);
                } else {
                    if (!f.equals("")) {
                        stdout.printf("\t\t}\n", new Object[0]);
                    }
                    this.end(stdout, lr, k, g);
                }
                ++k;
            }
            return 0;
        }
    }
}

