/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Subr;

public abstract class StringCompare
extends Subr {
    protected abstract boolean compare(LispString var1, LispString var2);

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.argument", this.symbolName);
        }
        if (!(lst.get(0) instanceof LispString)) {
            throw mesg.getError("err.require.string", lst.get(0));
        }
        LispString prev = (LispString)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispString) {
                if (!this.compare(prev, (LispString)d)) {
                    return LispBoolean.FALSE;
                }
            } else {
                throw mesg.getError("err.require.string", d);
            }
            prev = (LispString)d;
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

