/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispIOException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.Undef;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/10/01
 */
public class TranscriptOn extends UnaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Environment env,
			LispMessage mesg) {
		String s = SubrUtils.getString(c1a, mesg);
		PrintWriter pw = null;

		try {
			pw = new PrintWriter(new FileWriter(s));
			Scheme.setTranscript(pw);
			return Undef.UNDEF;
		} catch (IOException e) {
			throw new LispIOException(e);
		}
	}

}
