/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano;

import java.util.List;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class SynSetS extends Syntax {

	//
	private Datum getSetval(Datum bcdr, LispMessage mesg) {
		if(bcdr instanceof Cons) {
			Cons c1 = (Cons)bcdr;

			if(c1.getCdr() != Nil.NIL) {
				throw mesg.getError("err.set.malform");
			}
			return c1.getCar();
		} else {
			throw mesg.getError("err.set.malform");
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Syntax#compile(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispCompiler, net.morilib.lisp.CompiledCode.Builder, boolean, net.morilib.lisp.Cons, boolean, net.morilib.lisp.LispMessage, java.util.List, net.morilib.lisp.CodeExecutor, net.morilib.lisp.IntStack, net.morilib.lisp.LispCompiler.MiscInfo)
	 */
	void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist,
			CodeExecutor exec,
			IntStack memento) {
		if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();

			if(bcar instanceof SymbolName) {
				// constant definition
				// create a temporary Closure
				CompiledCode.Builder mbuild = new CompiledCode.Builder();
				Environment  menv = new Environment(env);

				comp.compile(getSetval(bcdr, mesg), menv, mbuild,
						callsym, false, symlist, exec, memento);
				mbuild.addReturnOp();

				// create a temporary Closure
				ClosureClass cl = new ClosureClass(
						Nil.NIL, mbuild.getCodeRef());

				// call the temporary Closure
				build.addPush(cl);
				build.addBeginList();
				build.addEndList();
				build.addCall();

				build.addSet(bcar);
				build.addPop();
				build.addPush(Undef.UNDEF);
			} else {
				throw mesg.getError("err.set.name");
			}
		} else {
			throw mesg.getError("err.set.malform");
		}
	}

}
