/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.math.BigInteger;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.subr.SubrUtils;
import net.morilib.lisp.nano.subr.UnaryArgs;

public class Round
extends UnaryArgs {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispInteger) {
            return c1a;
        }
        if (c1a instanceof LispRational) {
            LispRational q = (LispRational)c1a;
            BigInteger c = SubrUtils.ceil(q.getNumerator(), q.getDenominator());
            BigInteger f = SubrUtils.floor(q.getNumerator(), q.getDenominator());
            BigInteger v = q.getNumerator();
            if ((v = v.mod(q.getDenominator()).multiply(TWO)).compareTo(q.getDenominator()) > 0) {
                return LispInteger.valueOf(c);
            }
            if (v.compareTo(q.getDenominator()) < 0) {
                return LispInteger.valueOf(f);
            }
            if (c.mod(TWO).equals(BigInteger.ZERO)) {
                return LispInteger.valueOf(c);
            }
            return LispInteger.valueOf(f);
        }
        if (c1a instanceof LispDouble) {
            double d = ((LispDouble)c1a).doubleValue();
            return new LispDouble(Math.rint(d));
        }
        throw mesg.getError("err.require.real", c1a);
    }
}

