/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAs;

public final class GenericNFAMatcher<T, A> {
    private NFA<T, A, ?> nfa;
    private Set<A> result = null;
    private List<T> matched = null;

    public GenericNFAMatcher(NFA<T, A, ?> nfa) {
        this.nfa = nfa;
    }

    private Set<NFAState> getInitialStates() {
        return NFAs.getEpsilonReachable(this.nfa, this.nfa.getInitialStates());
    }

    public boolean match(Iterator<T> ts) {
        Set<NFAState> s;
        ArrayList<T> matches = new ArrayList<T>();
        Set<NFAState> t = s = this.getInitialStates();
        while (ts.hasNext()) {
            T a = ts.next();
            matches.add(a);
            t = NFAs.getStates(this.nfa, s, a);
            s = NFAs.getEpsilonReachable(this.nfa, t);
            if (!s.isEmpty()) continue;
            return false;
        }
        if (this.nfa.isFinalAny(s)) {
            this.matched = matches;
            this.result = NFAs.getAccept(this.nfa, s);
            return true;
        }
        this.matched = null;
        this.result = null;
        return false;
    }

    public boolean match(Iterable<T> ts) {
        return this.match(ts.iterator());
    }

    public boolean match(final String s) {
        return this.match(new Iterator<T>(){
            private int l = 0;

            @Override
            public boolean hasNext() {
                return this.l < s.length();
            }

            @Override
            public T next() {
                if (this.l >= s.length()) {
                    throw new NoSuchElementException();
                }
                return Integer.valueOf(s.charAt(this.l++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public Set<A> getResult() {
        return this.result;
    }

    public List<T> getMatched() {
        return this.matched != null ? new ArrayList<T>(this.matched) : null;
    }
}

