/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

import java.io.IOException;

/**
 * sedコマンドをあらわすインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public interface SedCommand {

	/**
	 * 入力行について処理します。
	 * 
	 * @param s  sedスペース
	 * @param rd 入力
	 * @throws IOException
	 */
	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException;

	/**
	 * コマンド文字を得ます。
	 * 
	 * @return コマンド文字
	 */
	public char getName();

	/**
	 * コマンドの説明を得ます。
	 * 
	 * @return コマンドの説明
	 */
	public String getLongDescription();

}
