/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.pattern;

import java.util.regex.Pattern;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;

/**
 * 正規表現のパターン中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkRegexPattern implements AwkPattern {

	private Pattern regex;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param regex 正規表現パターン
	 */
	public AwkRegexPattern(Pattern regex) {
		this.regex = regex;
	}

	/**
	 * 中間表現を生成します。
	 * 
	 * @param regex 正規表現パターン
	 */
	public AwkRegexPattern(String regex) {
		this.regex = Pattern.compile(regex);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isBegin()
	 */
	public boolean isBegin() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isEnd()
	 */
	public boolean isEnd() {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#match(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles, java.lang.String, net.morilib.awk.pattern.AwkMatchState)
	 */
	public AwkMatchState match(AwkNamespace ns, AwkFiles fs,
			String s, AwkMatchState stat) {
		if(s.equals("")) {
			return regex.matcher(s).matches() ?
					AwkMatchState.MATCHED : AwkMatchState.NO_MATCH;
		} else {
			// fixed the bug #32149
//			for(int i = 0; i < s.length(); i++) {
//				if(regex.matcher(s.substring(i)).lookingAt()) {
//					return AwkMatchState.MATCHED;
//				}
//			}
			if(regex.matcher(s).find()) {
				return AwkMatchState.MATCHED;
			}
			return AwkMatchState.NO_MATCH;
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.pattern.AwkPattern#isRanged()
	 */
	public boolean isRanged() {
		return false;
	}

}
