/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.cmd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.nina.NinaException;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.regec.NinaRegexCompiler;
import net.morilib.nina.regec.RegexCompilerException;

public final class Regec {
    private static final Pattern CLSN = Pattern.compile("[^\\.]+");

    private static String getClassname(String name) {
        Matcher m = CLSN.matcher(name);
        if (m.lookingAt()) {
            return m.group();
        }
        throw new RegexCompilerException("invalid filename");
    }

    private static String getLanguageFromSuffix(String s) {
        if (s.endsWith(".java")) {
            return "Java";
        }
        return null;
    }

    public static void main(String[] args) {
        try (PrintStream p = null;){
            try {
                if (args.length < 3) {
                    System.err.println("arguments too few");
                    System.exit(2);
                } else {
                    String l = Regec.getLanguageFromSuffix(args[2]);
                    if (l == null) {
                        System.err.println("unknown language suffix");
                        System.exit(2);
                    } else {
                        String n;
                        NinatOptions o = new NinatOptions();
                        o.filename = n = Regec.getClassname(args[2]);
                        p = new PrintStream(new FileOutputStream(args[2]));
                        NinaRegexCompiler.createTargetSource(n, args[0], l, args[1], o, p);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (NinaException e) {
                System.err.println(e.getMessage());
                System.exit(2);
                if (p != null) {
                    p.close();
                }
            }
            catch (RegexCompilerException e) {
                System.err.println(e.getMessage());
                System.exit(2);
                if (p != null) {
                    p.close();
                }
            }
        }
    }
}

